#ifndef DATA_QUEUE_H
#define DATA_QUEUE_H

#if (NOS_OF_RBUFS > NOS_OF_WBUFS)
#define DATA_QUEUE_LEN NOS_OF_RBUFS
#else
#define DATA_QUEUE_LEN NOS_OF_WBUFS
#endif

struct data_buf_queue {
    int queue[DATA_QUEUE_LEN];
    int head;
    int tail;
    mutex_t mutex;
    cond_t wait_for_data;
};

void queue_diagnostic(struct data_buf_queue *);
void add_to_queue(struct data_buf_queue *, int);
int take_from_queue(struct data_buf_queue *, timestruc_t *);
int queue_init(struct data_buf_queue *);
int queue_flush(struct data_buf_queue *);
int queue_destroy(struct data_buf_queue *);

#endif
