/* dbufLib.h - Double-chain buffers handling */

/*
 * Copyright 1991,1992 Universite Catholique de Louvain
 *
 * $Id: dbufLib.h,v 1.2 1995/12/07 09:38:15 nina Exp $
 *
 * $Log: dbufLib.h,v $
 * Revision 1.2  1995/12/07  09:38:15  nina
 * Included VxWorks types for unix systems.
 *
 * Revision 1.1  1992/07/28  09:46:03  nina
 * From 03a,01sep91,an (written 01a,20mar91,an)
 *
 */

#ifndef INCdbufLibh
#define INCdbufLibh

/* We don't need these */

#if 0

/* dbufLib STATUS codes */

#include    "../h/localModNum.h"

#define S_dbufLib_FREE_INCONSISTENCY          (M_dbufLib   |  1)
#define S_dbufLib_VALID_INCONSISTENCY         (M_dbufLib   |  2)
#define S_dbufLib_CHECKBUF_OVERFLOW           (M_dbufLib   |  3)
#define S_dbufLib_FREE_HEAD_CORRUPTION        (M_dbufLib   |  4)
#define S_dbufLib_VALID_HEAD_CORRUPTION       (M_dbufLib   |  5)

#endif

/* types definition */

#ifdef unix
#define IMPORT extern
typedef unsigned int UINT;
typedef int STATUS;
typedef void VOID;
#endif /* unix */

typedef struct dbuf
        {   
            /* Doubly-linked list pointers */

            struct dbuf *pBackFree;        /* Free list  */
            struct dbuf *pForwFree;
            struct dbuf *pBackValid;       /* Valid list */
            struct dbuf *pForwValid;

            /* Pointers to the head of free and valid lists */

            struct dbuf *pFree;
            struct dbuf *pValid;

            /* Counters */

            UINT ordNum;    /* Assigned in order at initialization */
            UINT seqNum;    /* Assigned in order by dbufGet */

            UINT size;      /* Number of remaining buffers in list */

            UINT freeRem;   /* Incremented when removed from the free list */
            UINT freeAdd;   /*   "    "    when returned to the free list  */
            UINT validRem;  /* Incremented when removed from the valid list */
            UINT validAdd;  /* Incremented when installed in the valid list */

            char dumAlign[12];

        } DBUF;
    
/* functions declarations */

IMPORT STATUS dbufCheck();
IMPORT VOID   dbufDebug();
IMPORT DBUF*  dbufGet();
IMPORT STATUS dbufLnkInit();
IMPORT DBUF*  dbufPutFree();
IMPORT DBUF*  dbufPutValid();
IMPORT DBUF*  dbufRemValid();

#endif /* INCdbufLibh */
