/* values possibly found in EGerrno following EGlib calls */
/* DB, September 1991 */

#ifndef EG_h
#define EG_h

#define EG_MY_DATA_OFFSET 768

typedef struct eg_data_array {
	 int layout;
	 int type;
	 char reserved[8];
	 int pointer;
   } DATA_ARRAY;

typedef
struct eg_spectrum_header {
   int magic;
   int version;
   char spec_name[32];
   int dim;
   char creation[20];
   char modification[20];
   int bases[8];
   int ranges[8];
   int information[32];
   int annotation[8];
   int calibration[8];
   int efficiency[8];
   DATA_ARRAY data_array1;
   DATA_ARRAY data_array2;
   int str_base_addr;
   int str_free_addr;
   int str_top_addr;
   int count_base_addr;
   int count_free_addr;
   int count_top_addr;
   char buf[332];
   } SPECTRUM_HDR;

#ifdef EG_ENVIR

extern int EGerrno;

#define EGERR 1
#define EG_not_yet_implemented				((EGERR<<16)+1)
#define EG_no_suitable_resource_claimed 		((EGERR<<16)+2)
#define EG_name_or_pattern_too_long 			((EGERR<<16)+3)
#define EG_register_not_known 				((EGERR<<16)+4)
#define EG_experiment_already_connected 		((EGERR<<16)+5)
#define EG_cant_open_experiment_file 			((EGERR<<16)+6)
#define EG_cant_memorymap_experiment_file 		((EGERR<<16)+7)
#define EG_no_experiment_connected 			((EGERR<<16)+8)
#define EG_apparatus_already_attached 			((EGERR<<16)+9)
#define EG_cant_open_apparatus_file 			((EGERR<<16)+10)
#define EG_error_parsing_apparatus_file 		((EGERR<<16)+11)
#define EG_some_resources_still_claimed 		((EGERR<<16)+12)
#define EG_cant_claim_all_resources 			((EGERR<<16)+13)
#define EG_cant_free_all_resources 			((EGERR<<16)+14)
#define EG_apparatus_file_punctuation_expected 		((EGERR<<16)+15)
#define EG_apparatus_file_number_expected 		((EGERR<<16)+16)
#define EG_apparatus_file_string_expected 		((EGERR<<16)+17)
#define EG_apparatus_file_keyword_expected 		((EGERR<<16)+18)
#define EG_apparatus_file_invalid_character 		((EGERR<<16)+19)
#define EG_apparatus_file_premature_EOF 		((EGERR<<16)+20)
#define EG_cant_create_RPC_client 			((EGERR<<16)+21)
#define EG_too_many_resources 				((EGERR<<16)+22)
#define EG_capability_file_already_exists               ((EGERR<<16)+23)
#define EG_cant_open_capability_file                    ((EGERR<<16)+24)
#define EG_cant_initialise_capability_file              ((EGERR<<16)+25)
#define EG_cant_access_experiment_directory             ((EGERR<<16)+26)
#define EG_cant_delete_capability_file                  ((EGERR<<16)+27)
#define EG_max_errno 27

#define ERSERR 2
#define ERS_resource_not_known                          ((ERSERR<<16)+1)
#define ERS_resource_already_in_use                     ((ERSERR<<16)+2)
#define ERS_capability_invalid                          ((ERSERR<<16)+3)
#define ERS_register_not_known                          ((ERSERR<<16)+4)
#define ERS_types_incompatible                          ((ERSERR<<16)+5)
#define ERS_register_already_defined                    ((ERSERR<<16)+6)
#define ERS_class_not_known                             ((ERSERR<<16)+7)
#define ERS_application_not_responding                  ((ERSERR<<16)+8)
#define ERS_invalid_cookie                              ((ERSERR<<16)+9)
#define ERS_application_detected_failure                ((ERSERR<<16)+10)
#define ERS_illegal_register_name                       ((ERSERR<<16)+11)
#define ERS_out_of_memory                               ((ERSERR<<16)+12)
#define ERS_count_too_small                             ((ERSERR<<16)+13)
#define ERS_bad_request                                 ((ERSERR<<16)+14)
#define ERS_invalid_file_name                           ((ERSERR<<16)+15)

#define ESSERR 3
#define ESSERRNO    	        	                ((ESSERR<<16)+(unsigned short)(errno))
#define ESS_cannot_locate_spectrum                      ((ESSERR<<16)+1)

#define ETSERR 4
#define ETSERRNO    	        	                ((ETSERR<<16)+(unsigned short)(errno))

extern int EGsetRegisterPath P((char *));
extern int EGinquireRegisters P((char * pattern, char *));
extern int EGinquireRegistersMore P((char *));
extern int EGreadRegister P((char *, char *));
extern int EGwriteRegister P((char *, char *));
extern int EGinitialiseRegister P((char *));
extern int EGreadRegisters P((char * pattern, char *, char *));
extern int EGreadRegistersMore P((char *, char *));
extern int EGwriteRegisters P((char *, char *));
extern int EGinitialiseRegisters P((char *));
extern int EGcreateRegister P((char *, char *));
extern int EGdestroyRegister P((char *));
extern int EGdestroyRegisters P((char *));
extern int EGgetObject P((char *, char *));
extern int EGsetObject P((char *, char *));
extern int EGgetObjects P((char * pattern, char *, char *));
extern int EGgetObjectsMore P((char *, char *));
extern int EGsetObjects P((char *, char *));
extern int EGsetExperimentPath P((char *));
extern int EGcreateExperiment P((char *));
extern int EGdeleteExperiment P((char *));
extern int EGconnectExperiment P((char *));
extern int EGdisconnectExperiment P(());
extern int EGsetApparatusPath P((char *));
extern int EGattachApparatus P((char *));
extern int EGdetachApparatus P((char *));
extern int EGclaimApparatus P((char *));
extern int EGfreeApparatus P((char *));
extern int EGdisplayResources P((FILE *));
extern char *EGerrorMessage P((int));
extern int EGauthorise P((char *, char *));
extern int EGsetSpectrumPath P((char *));
extern int EGsetDefaultArray P((int));
extern int EGcreate1dSpectrum P((char *, int, int, int, int));
extern int EGcreate2dSpectrum P((char *, int, int, int, int, int, int));
extern int EGcreateSpectrum P((char *, int, int *, int *, int, int));
extern int EGdeleteSpectrum P((char *));
extern int EGzeroSpectrum P((char *));
extern int EGreadInformation P((char *, int, char *));
extern int EGwriteInformation P((char *, int, char *));
extern int EGreadAnnotation P((char *, int, char *));
extern int EGwriteAnnotation P((char *, int, char *));
extern int EGreadCalibration P((char *, int, char *));
extern int EGwriteCalibration P((char *, int, char *));
extern int EGreadEfficiency P((char *, int, char *));
extern int EGwriteEfficiency P((char *, int, char *));
extern int EGinquireSpectrum P((char *, int *, int *, int *, int *, int *));
extern int EGsetSpectrumArray P((char *, int, int, int));
extern int EGinquireAddress P((char *, int *));
extern int EGsetDefaultCompression P((int *));
extern int EGinquireDirectory P((char * name, char *));
extern int EGinquireDirectoryMore P((char *));
extern int EGread1dSpectrum P((char *, int, int, int *, int));
extern int EGwrite1dSpectrum P((char *, int, int, int *, int));
extern int EGread2dSpectrum P((char *, int, int, int, int, int *, int));
extern int EGwrite2dSpectrum P((char *, int, int, int, int, int *, int));
extern int EGreadSpectrum P((char *, int, int *, int *, int *, int));
extern int EGwriteSpectrum P((char *, int, int *, int *, int *, int));
extern int EGspectrumErrorReport P((char *, char *));
extern int EGTSsetPath P((char *));
extern int EGTSclaimDrive P((char *, char *, char *));
extern int EGTSfreeDrive P((char *));
extern int EGTSmountVolume P((char *, char *));
extern int EGTSdismountVolume P((char *));
extern int EGTSinquireFileStatus P((char *, int *, int *, char *, char *, char *,
				  char *, char *, int *, int *, int *, int *,
				  int *, int *, int *, int *, int *, int *,
				  int *));
extern int EGTSopenFile P((char *, int, int, int, int, char *));
extern int EGTScloseFile P((char *));
extern int EGTSsetState P((char *, long));
extern int EGTSgetState P((char *, long *));
extern int EGTSsetStream P((char *, int, int, int, char **));
extern int EGTSgetStream P((char *, int, int *, int *, char **));
extern int EGTSinquireStreamState P((char *, int,  int *, int *, int *, int *));
extern int EGTSinquireDriveStatus P((char *, char *, int *, int *, int *, int *,
				  int *, char *));
extern int EGTSidentifyVolume P((char *));
extern int EGTSresetDrive P((char *));
extern int EGTSinitialiseVolume P((char *, char *, int, int, char *));
extern int EGTSinquireDrives P((char *, int *, int *, char **, char **));
extern int EGTSmoveTape P((char *, int, int));
extern int EGTSpositionChanger P((char *, int));
extern int EGTSinquireElementStatus P((char *, int, int *, int *, int *));

#else

extern int SMEGinquireSpectrum P((char *, int *, int *, int *, int *, int *));
extern int SMEGcreate1dSpectrum P((char *, int, int, int, int));
extern int SMEGcreate2dSpectrum P((char *, int, int, int, int, int, int));
extern int SMEGread1dSpectrum P((char *, int, int, int *, int));
extern int SMEGwrite1dSpectrum P((char *, int, int, int *, int));
extern int SMEGread2dSpectrum P((char *, int, int, int, int, int *, int));
extern int SMEGwrite2dSpectrum P((char *, int, int, int, int, int *, int));

#endif /* EG_ENVIR */

int edef P((int *, int, int, int, int, int , char *, int));
void eexpt P((int *));
int einq P((int, int *, int *, int *, int *, int *));
int ename P((int *, char * name, int));
int eread P((int, int, int, int, int, int *, int));
int ewrit P((int, int, int, int, int, int *, int));
int *map_spectrum P((int, char *, int, int));
int *remap_1d_spectrum P((spec_1d_t *, int));
int *remap_2d_spectrum P((spec_2d_t *, int));
int rm_spectrum_file P((int, int));
int unmap_spectrum P((int *, int));

#endif /* ! EG_h */

/*
discsubs read_spec sort_notify
*/


