/*
 *	sunsort header file for shared memory facility
 */

#ifndef SUNSORT_MEM_h
#define SUNSORT_MEM_h

#include <sys/types.h>

/* max size of (int) data array in shared memory */
#define SHM_ARRAY_SIZE 262144

struct sm_data_buf {
	char com_str[NAME_SIZE];
	char name[NAME_SIZE];
	int size;
	int win2d;
	int more;
	pid_t pid_1d;
	pid_t pid_2d;
	int array[SHM_ARRAY_SIZE];
};

extern struct sm_data_buf *pshm;

/* modification to get around absence of ipcs */
extern int write_to_pipe P((char *, int));
extern int read_from_pipe P((char *));

#define SHM_ERR (struct sm_data_buf *)-1

#endif /* ! SUNSORT_MEM_h */
