#include <stdio.h>
#include "inttypes.h" /* From here or from /usr/include */
#include "megha.h"

uint32_t readbits(int numbits)
{
    static uint32_t buffer[4096], *bp = buffer;
    static uint32_t *be = buffer + sizeof(buffer)/sizeof(uint32_t);
    static unsigned int c = 32;
    uint32_t data;

    if (numbits < 0)
    {
	c = 32;
	return 0;
    }

    if (c == 32)
    {
	if (errread(0, (char *) buffer, sizeof(buffer)))
	    return (uint32_t) -1;
	bp = buffer;
	c = 0;
    }
    
    if (c + numbits > 32)
    {
	data = *bp++ >> c;
	if (bp == be)
	{
	    if (errread(0, (char *) buffer, sizeof(buffer)))
		return (uint32_t) -1;
	    bp = buffer;
	}
	data |= *bp << (32 - c);
	c = numbits + c - 32;
    }
    else
    {
	data = *bp >> c;
	c += numbits;
	if (c == 32)
	{
	    bp++;
	    if (bp == be)
	    {
		if (errread(0, (char *) buffer, sizeof(buffer)))
		    return (uint32_t) -1;
		bp = buffer;
	    }
	    c = 0;
	}
    }

    return data & ((1<<numbits) - 1);
}

int readin(uint32_t *channel, uint32_t *time, uint32_t *energy)
{
    uint32_t ch, ti, en;

    static uint32_t channelbits = 0, timingbits, energybits;

    if (channelbits == 0)
    {
	if ((channelbits = readbits(4)) == (uint32_t) -1)
	    return -1;
	if ((timingbits = readbits(4)) == (uint32_t) -1)
	    return -1;
	if ((energybits = readbits(4)) == (uint32_t) -1)
	    return -1;
    }

    for(;;)
    {
	if ((ch = readbits(channelbits)) == (uint32_t) -1)
	    return -1;
	if (ch == (1<<channelbits)-1)
	{
	    if ((ti = readbits(CONTROLBITS)) == (uint32_t) -1)
		return -1;
	    if (ti == CONTROLEXTENDED)
	    {
		if ((en = readbits(EXTENDEDBITS)) == (uint32_t) -1)
		    return -1;
		switch(en)
		{
		case EXTENDEDEOB:
		    (void) readbits(-1);
		    channelbits = 0;
		    break;
		case EXTENDEDCBITS:
		    if ((channelbits = readbits(4)) == (uint32_t) -1)
			return -1;
		    fprintf(stderr, "Channel range extended to %d (%d "
			    "bits).\n", (1<<channelbits)-2, channelbits);
		    break;
		case EXTENDEDTBITS:
		    if ((timingbits = readbits(4)) == (uint32_t) -1)
			return -1;
		    fprintf(stderr, "Time range extended to %d (%d bits).\n",
			    (1<<timingbits)-1, timingbits);
		    break;
		case EXTENDEDEBITS:
		    if ((energybits = readbits(4)) == (uint32_t) -1)
			return -1;
		    fprintf(stderr, "Energy range extended to %d (%d bits).\n",
			    (1<<energybits)-1, energybits);
		    break;
		}
	    }
	    else
	    {
		*channel = CONTROLCHANNEL;
		*time = ti;
		break;
	    }
	}
	else
	{
	    if ((*time = readbits(timingbits)) == (uint32_t) -1)
		return -1;
	    if ((*energy = readbits(energybits)) == (uint32_t) -1)
		return -1;
	    *channel = ch;
	    break;
	}
    }
    
    return 0;
}

int main(void)
{
    unsigned int buffer[4096], *ep, *sp, *hwm = buffer+4093;
    uint32_t channel, time, energy;

    ep = buffer;
  
    for(;;)
    {
	sp = ep++;
	if (sp >= hwm)
	{
	    *sp = 0xffff0000;
	    if (errwrite(1, (char *) buffer, sizeof(buffer)))
		return -1;
	    sp = buffer;
	    ep = buffer+1;
	}
	for(;;)
	{
	    if (readin(&channel, &time, &energy))
		goto READ_EOF;

	    if (channel == CONTROLCHANNEL && time == CONTROLEOE)
		break;
	    if (ep >= hwm)
	    {
		*sp = 0xffff0000;
		if (errwrite(1, (char *) buffer, sizeof(buffer)))
		    return -1;
		if (ep != sp + 1)
		    memcpy(buffer+1, sp + 1, ((ep - sp) - 1)*sizeof(int));
		ep = (ep - sp) + buffer;
		sp = buffer;
	    }
	    *ep++ = 0x20008000 | (channel << 17) | time;
	    *ep++ = 0x20018000 | (channel << 17) | energy;
	}
	*sp = 0xffff0000 | ((ep - sp) << 1);
    }

 READ_EOF:
    if (ep != sp + 1)
    {
	fprintf(stderr, "End of file occurred in the middle of an event. "
		"Junking the event.\n");
    }

    *sp = 0xffff0000;

    if (sp != buffer)
    {
	errwrite(1, (char *) buffer, sizeof(buffer));
    }
    
    errstatus();

    return 0;
}

    

		

	
    
