#include <stdio.h>
#include <errno.h>
#include "megha.h"

static unsigned long blocks_in = 0, bytes_in = 0;
static unsigned long blocks_out = 0, bytes_out = 0;

int errwrite(int fd, char *buffer, int n)
{
    int c;

    for( ; n > 0; n -= c, buffer += c, bytes_out += c)
    {
	switch(c = write(fd, buffer, n))
	{
	case 0:
	    fprintf(stderr, "Unexpected end of file on write.\n");
	    return -1;
	case -1:
	    if (errno == EINTR)
	    {
		c = 0;
		continue;
	    }
	    perror("write");
	    return -1;
	}
    }

    blocks_out++;

    return 0;
}

int errread(int fd, char *buffer, int n)
{
    int c;

    for( ; n > 0; n -= c, buffer += c, bytes_in += c)
    {
	switch(c = read(fd, buffer, n))
	{
	case 0:
	    fprintf(stderr, "Read EOF\n");
	    return -1;
	case -1:
	    if (errno == EINTR)
	    {
		c = 0;
		continue;
	    }
	    perror("write");
	    return -1;
	}
    }

    blocks_in++;

    return 0;
}

void errstatus(void)
{
    fprintf(stderr, "Data in: %lu blocks = %lu bytes\n"
	    "Data out: %lu blocks = %lu bytes.\n", blocks_in, bytes_in,
	    blocks_out, bytes_out);
}
