/* header file for ansitp ... includes useful definitions */

#ifndef ANSITP_h
#define ANSITP_h

#define LABELSIZE 80
#define DISKBLK 8192    /* size of disc block for physical write/read   */
#define TAPEBLK	8192	/* number of bytes/tape block, for writing */
#define FLAG short

/*
 * VOLUME 1 Describes the owner of and access to the volume. 
 */
typedef struct ansi_vol1 {
    char            header[4];	/* VOL1 */
    char            label[6];	/* volume name, A-Z0-9 */
    char            access;	/* access code */
    char            __ignored1[20];	/* reserved, space fill */
    char            __ignored2[6];	/* reserved, space fill */
    char            owner[14];	/* user name */
    char            __ignored3[28];	/* reserved, space fill */
    char            ansi_level;	/* ansi standard level, always 3 */
}ansi_vol1_t;

/*
 * HEADER 1 Begins basic description of a tape file. 
 */
typedef struct ansi_hdr1 {
    char            header[4];	    /* HDR1 */
    char            name[17];       /* rightmost 17 characters of filename */
    char            fileset[6];	    /* should be same as volume id of 1st
                               	     * tape */
    char            volume_num[4];  /* number of volume in set */
    char            file_num[4];    /* number of file on tape */
    char            gen[4];	    /* generation number */
    char            genver[2];	    /* generation version number */
    char            created[6];	    /* date of creation, "bYYDDD" */
    char            expires[6];	    /* expiration date "bYYDDD" */
    char            access;	    /* protection, space = unprotected */
    char            blockcount[6];  /* zero in header */
    char            tapesys[13];    /* name of software creating tape */
    char            __ignored[7];   /* reserved, space fill */
} ansi_hdr1_t;

/*
 * HEADER 2 Record format, record size, block size. 
 */
typedef struct ansi_hdr2 {
    char            header[4];	        /* HDR2 */
    char            recfmt;		/* record format */
    char            blocklen[5];	/* file tape block length */
    char            reclen[5];	        /* file logical record length */
    char            density;		/* density/recording mode. Should be 2
                            		 * for 800 bpi, 3 for 1600 bpi. */
    char            vol_switch;	        /* 0, or 1 if this file was continued */
    char            job[17];		/* job name (8), /, job step (8) of
                            		 * creator */
    char            recording[2];	/* parity/conversion, space
                                 	 * fill */
    char            carriage_control;
    char            alignment;	        /* reserved, space fill */
    char            blocked_records;    /* 'B' if records are blocked */
    char            __ignored2[11];
    char            block_offset[2];    /* ignore 1st n char of each
                                         * block */
    char            __ignored3[28];
} ansi_hdr2_t;

/* HEADER 3 - ignore */
typedef struct ansi_hdr3 {
    char            header[4];	        /* HDR3 */
    char            os_reserved[76];	/* reserved to OS, space fill */
} ansi_hdr3_t;

/* HEADER 4 - the rest of the filename if its longer than 17 characters. */
typedef struct ansi_hdr4 {
    char            header[4];	       /* HDR4 */
    char            name2[63];	       /* leftmost char, if name is more than
				        * 17 characters long. */
    char            unknown[2];	       /* fill with 00 */
    char            __ignored[11];
} ansi_hdr4_t ;

typedef struct ansitp_info_struc {
      char *device;             /* unix device name for tape */
      int fd;                   /* filedes for open tape drive */
      int open;                 /* non zero if tape drive open */
      char volname[7];	        /* current tape volume name */
      char unixfile[50];	/* current UNIX filename */
      char tapefile[18];	/* filename from tape */
      char filevol[7];	        /* volume id of first volume in set */
      char recd_fmt;		/* record format of tape */
      int  volseq;		/* sequence of this volume in set */
      int  filepos;		/* position of this file in set */
      int  create_yy;		/* create date year */
      int  create_ddd;	        /* create date day of year */
      int  expire_yy;		/* expire date year */
      int  expire_ddd;	        /* expire date day of year */
      int  block_len;		/* max block len from label */
      int  recd_len;		/* max recd len from label */
      int  block_cnt;		/* block count */
      int  recd_cnt;		/* record count */
      int  lblcnt;              /* number of labels on tape */
      ansi_hdr1_t label1;       /* store current file labels */
      ansi_hdr2_t label2;
      ansi_hdr3_t label3;
      ansi_hdr4_t label4;
} ansitp_info_t;

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif


#endif /* ifndef ANSITP_h */
