CC
C
***********************************************************************
c
CC     *************************************************************
C
C
      DOUBLE PRECISION FUNCTION DERF(X)                                         
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)                                        
C
C     CALCULATES THE ERROR INTEGRAL
C
C     ERF(Z) =  2/SQRT(PI) * INTEGRAL FROM 0 TO Z [ EXP(-T**2) .DT]
C
      DATA P/0.327591100D0/                                                    
      DATA A/0.254829592D0/                                                     
      DATA B/-0.284496736D0/                                                    
      DATA C/+1.421413741D0/                                                    
      DATA D/-1.453152027D0/                                                    
      DATA E/1.061405429D0/                                                     
      XX=ABS(X)
      T=1.0D0/(1.0D0+P*XX)                                                      
      DERF=1.0D0-(T*(A+T*(B+T*(C+T*(D+T*E)))))*DEXP(-XX*XX)                     
      IF(X.LT.0.0D0)DERF=-DERF
      RETURN                                                                    
      END                                                                       
