C
C
c
*********************************************************
C
      SUBROUTINE florz( x,a,y,dyda,peaks,bkgrd,zp,zb,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,ixmax)
C
C
c     Vs 4.0 calculates the spectrum function as a sum
c     of lorentzians whose shape is specified by 3 parameters
c     and a background chosen by ibkshape.
c
c     The array index is previously filled in subroutine pakgauss
c      with pointers to the elements in the array A;
c      if the pointer is .le. nfit then this indicates that 
c      the parameter is to be searched upon; 
c      if .gt. nfit but .lt. na, then the parameter is 
c      to be fixed during the search, so the derivative=0
c      if the pointer is negative, then the parameter is constrained
c      for all peaks and the derivative is summed.
c      This function can thus be used for all possible 
c      gaussian shapes with different widths, constraints etc
c      since each peak, and each parameter of each peak
c      has an individual pointer. 
c     
C
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)  
      dimension A(NA),DYDA(NA),peaks(nchan),bkgrd(nchan),
     >ZP(NP),ZB(NB)
      dimension index(ixmax)
*
      y = 0.0
      ix=0
c
c     set all dyda to zero
c
      do 10 i=1,na
 10   dyda(i)=0.0d0
c
c     loop over number of peaks
c
      do  100  i = 1, npeak
c
c     get index of height of peak i
c
c
       ix=ix+1
        ish=index(ix)
          ih=abs(ish)
c

c     get index of centroid of peak i
c
c
       ix=ix+1
         isc=index(ix)
          ic=abs(isc)

c
c      get index of width of peak i
c
c
       ix=ix+1
         isw=index(ix)
           iw=abs(isw)
c
c
c
c      get parameters of lorentzian function for peak i
c
c      centroid,c, height, h, width, w
c
      c=a(ic)
        h=a(ih)
          gam= a(iw)
c

c     get argument of lorentzian function
c
        arg=(x-c)
         argsq=arg**2
          gamsq= gam**2
        
        IF( (argsq+gamsq) .LT. 1.0d-20 ) THEN
          EX =1.0d20
        ELSE
          EX = 1.0d0/ (argsq+gamsq)
        ENDIF
c
c      add value of lorentzian [ = h*gamsq/(argsq+gamsq) ] to y
c
        fac=gamsq*ex
      y=y+ h*fac
c
c     get derivatives of parameters
c      -if index is .gt. nfit then parameter is fixed
c      and derivative is not used in search
c      if index is negative then parameter is constrained
c
c
c     derivative of centroid
c
      if(isc.lt.0) then
       dyda(ic)= dyda(ic)+h*fac*2.0d0*arg*ex
      else
       dyda(ic)= h*fac*2.0d0*arg*ex
      endif
c
c      derivative of height
c
      if(ish.lt.0)then
       dyda(ih)=dyda(ih)+fac
      else
       dyda(ih)=fac
      endif
c
c      derivative of width
c
      if(isw.lt.0) then
       dyda(iw)= dyda(iw)+2.0d0*h*gam*ex*(1.0d0-fac)
      else
       dyda(iw)=2.0d0*h*gam*ex*(1.0d0-fac)
      endif
c
100   CONTINUE
c
c
c     call background generating function
c

       call fback( x,a,y,dyda,peaks,bkgrd,zp,zb,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,ixmax,ix)
c
c
      return        
      END
