C
*************************************************************************
C
C
C     ****************************************************************
C
      SUBROUTINE  MRQMIN( x,y,peaks,bkgrd,zp,zb,sig,
     > a,covar,alpha,
     > lista,index,
     > funcs,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback, npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,
     > chisq,alamda,ierr)
c
C
C
C
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)  
C
C
* Levenberg-Marquardt nonlinear chisq fit
* H.Press et al - NUMERICAL RECEPIES, Cambridge UP 86, page 526
* IERR added - set to 1 if LISTA contains improper permutation
*                     2 if covariance matrix is cannot be converted
*
      PARAMETER ( MMAX=150 )
      dimension X(NDATA), Y(NDATA), SIG(NDATA)
      dimension peaks(nchan),bkgrd(nchan),zp(np),zb(nb)
      dimension A(na),index(ixmax)
      dimension COVAR(NCA,NCA), ALPHA(NCA,NCA)
      dimension ATRY(MMAX), BETA(MMAX), DA(MMAX)
       dimension lista(na)
        external funcs
*
*
*   Initialization
c
c      write(6,101)(i,index(i),a(abs(index(i))),i=1,ixmax)
c 101  format(i3,i6,f14.4)
c
c
c     following check section is redundant in buffit 4.0 onwards
c     - may be used where array lista is used to map onto search array a
c
      IERR = 0
c
c
c
       IF( ALAMDA .LT. 0 ) THEN
c
c      check that array lista contains correct pointers to array a
c      - not used in buffit 4.0 onwards as array index is used
c
c        KK = nfit + 1
c        DO  12  J=1,na
c          IHIT = 0
c          DO  11  K = 1, nfit
c            IF( LISTA(K) .EQ. J ) IHIT = IHIT + 1
c11        CONTINUE
c          IF( IHIT .EQ. 0 ) THEN
c            LISTA(KK) = J
c            KK = KK + 1
c          ELSE IF( IHIT .GT. 1 ) THEN
c            IERR = 1
c            RETURN
c          ENDIF
c12      CONTINUE
c        IF( KK .NE. (na+1) ) THEN
c          IERR = 1
c          RETURN
c        ENDIF
c
        ALAMDA = 0.001
      CALL MRQCOF( x,y,peaks,bkgrd,zp,zb,sig,
     > a,alpha,beta,
     > lista,index,
     > funcs,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback, npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,
     > chisq,alamda,ierr)
c
        OCHISQ = CHISQ
        DO  13  J=1,na
          ATRY(J) = A(J)
13      CONTINUE
      ENDIF
*
      DO  15  J=1,nfit
        DO  14  K = 1, nfit
          COVAR(K,J) = ALPHA(K,J)
14      CONTINUE
        COVAR(J,J) = ALPHA(J,J)*(1.0+ALAMDA)
        DA(J) = BETA(J)
15    CONTINUE
*
*   Matrix solution
      CALL GAUSSJ(COVAR,nfit,nca,DA,1,1,IERR)
      IF( IERR .NE. 0 ) THEN
        IERR = 2
        RETURN
      ENDIF
*
c
c

*  If converged, evaluate covariance matrix
c
      IF( ALAMDA .EQ. 0.0 ) THEN
        CALL COVSRT(COVAR,nca,na,LISTA,nfit)
        RETURN
      ENDIF
*
      DO  16  J=1,nfit
c
c        ATRY(LISTA(J)) = A(LISTA(J))+DA(J)
c
         atry( j ) = a( j ) + da ( j )
c
c       write(6,6016) a(lista(j)),da(j),atry(lista(j))
c 6016  format(3(e14.4,1x))
c
16    CONTINUE
c
      CALL MRQCOF( x,y,peaks,bkgrd,zp,zb,sig,
     > atry,covar,da,
     > lista,index,
     > funcs,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback, npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,
     > chisq,alamda,ierr)
c
c
      IF( CHISQ .LT. OCHISQ ) THEN
* accept new solution
        ALAMDA = 0.1*ALAMDA
        OCHISQ = CHISQ
        DO  18  J=1,nfit
          DO  17  K = 1, nfit
            ALPHA(K,J) = COVAR(K,J)
17        CONTINUE
          BETA(J) = DA(J)
c
c          A(LISTA(J)) = ATRY(LISTA(J))
           a( j )  = atry ( j )
c
18      CONTINUE
      ELSE
* failure - increase ALAMDA  and return
        ALAMDA = 10.0*ALAMDA
        CHISQ = OCHISQ
      ENDIF
      END
