CC
C
***********************************************************************
c
c
*************************************************************************
c
c      unpacks array A & constructs the background parameters & errors,
c      areas and errors 
c

       subroutine  unpakbak(bkgrd,zp,zb,
     > a,covar,
     > index,
     > nchan,ndata,ichan,jchan,np,nb,
     > npeak,nback,npkparm,nbkparm,ipkshape,ibkshape,
     > na,nfit,npfit,nbfit,nca,ixmax,ix, 
     > BKAREA,BAKFIT,bknorm,
     > BKAERR,BAKERR,bknerr,
     > bkplot,dxplot,nplot)
c
c
c
       implicit double precision (a-h,o-z)
c
       dimension bkgrd(nchan),bakfit(nbkparm),bakerr(nbkparm)
        dimension a(nca),covar(nca,nca),zp(np),zb(nb)
       dimension index(ixmax)
c
       dimension bkplot(nplot)
c
        dimension iscstrt(5),iscstp(5)
         data iscstrt/2,2,2,1,1/
          data iscstp/1,2,3,1,1/
c
c
c
       datn=real(ndata)
       ixbk=ix
c
c
       goto ( 10,20,30,40,50),ibkshape
c
 10    continue
c
c      constant + polynomial background
c
       if(nbkparm.gt.0 ) then
c
        bkarea=0.0d0
         bkaerr=0.0d0
c       store value of ibkshape
c
        ibkmem=ibkshape
c
       do  14 j=1,nbkparm
c
       ibj=abs(index(ixbk +j))
       bakfit(j)=a(ibj)
        bakerr(j)=sqrt(covar(ibj,ibj))
c
c
c
       term= BAKFIT(J) *(DATN-1.0)**J/REAL(J)
        bkarea=bkarea+term
c
c
c
       DO 12 JK=1,J
       ibjk=abs(index(ixbk +jk))

       TERM=COVAR(ibj,ibjk)*(DATN-1.0)**(J+JK-1)/             
     > REAL(J+JK-1)
       IF(JK.NE.J)TERM=2.0*TERM
       BKAERR=BKAERR+TERM
   12  CONTINUE
  14   CONTINUE
       BKAERR=SQRT(BKAERR)
c
c
c       fill array bkgrd
c
       do 16 i=ichan,jchan
        sum=0.0d0
         x=real(i-ichan)
      do 15 j=1,nbkparm
         sum=sum+bakfit(j)*x**(j-1)
 15   continue
      bkgrd(i)=sum
c
 16   continue
c
c      fill array bkplot
c
c
       ndx=nint(1.0d0/dxplot)
       dxplot = 1.0d0/real(ndx)
       iplot=ichan*ndx
        jplot=jchan*ndx
      do 18 i=iplot,jplot
       sum=0.0d0
       x= (i-iplot)*dxplot
      do 17 j=1,nbkparm
         sum=sum+bakfit(j)*x**(j-1)
 17   continue
       bkplot(i)= sum
 18   continue
c
      
c
c
c     writeout background function
c
      write(6,1001)
 1001 format(/' Background function',
     > ' b(i) = a(1)+a(2)X +...a(nback)X**nback-1'/
     > 20x,'        X=i-ichan, i=ichan,jchan'/)
c
      endif
c
      goto 100
c
c
 20    continue
c
c      constant + exponential background
c
      if(nbkparm.gt.0 ) then
c
c
       ibkmem=ibkshape
c
       do 21  j=1,nbkparm
c
         ibj=abs(index(ixbk +j))
           bakfit(j)=a(ibj)
            bakerr(j)=sqrt(covar(ibj,ibj))
 21    continue
c
c
c
c       fill array bkgrd
c
         bkarea=0.0d0
          bkaerr=0.0d0
      do 23 i=ichan,jchan
        sum=0.0d0
         x=real(i-ichan)
         if(nbkparm.gt.0 ) then
             term= bakfit(1)
              sum=sum+term
               bkaerr=bkaerr+term*covar(1,1)
           if(nbkparm.ge.2) then
c
        do 22 j=2,nbkparm,2
c
          term=bakfit(j) *( x**((j-2)/2) * exp(-bakfit(j+1)*x))
           sum=sum+ term
            bkaerr=bkaerr+term* bakerr(j)

 22   continue
        endif
         endif
c
        bkarea=bkarea+sum
 23     bkgrd(i)=sum
        bkaerr=sqrt(bkaerr)
c
c
c      fill array bkplot
c
c
       ndx=nint(1.0d0/dxplot)
       dxplot = 1.0d0/real(ndx)
       iplot=ichan*ndx
        jplot=jchan*ndx
      do 25 i=iplot,jplot
            sum=0.0d0
             x= (i-iplot)*dxplot
       if(nbkparm.gt.0) then
              term=bakfit(1)
              sum=sum+term
         if(nbkparm.gt.2) then

      do 24 j=2,nbkparm,2
         sum=sum+bakfit(j)*(x**((j-2)/2)*exp(-bakfit(j+1)*x))
 24   continue
      endif
      endif
       bkplot(i)= sum
 25   continue
c

c
      write(6,1002)
 1002 format(/' Background function',
     > ' b(i) = a(1)+a(2)exp(-a(3)X) +a(4)X exp(-a(5)X)+..'/
     > 20x,'        X=i-ichan, i=ichan,jchan'/)
c
c
      endif
c
       goto 100
c
c
 30    continue
c
c      constant + woods-saxon background
c
       if(nbkparm.gt.0 ) then
c
c
       ibkmem=ibkshape
c
       do 31  j=1,nbkparm
c
         ibj=abs(index(ixbk +j))
           bakfit(j)=a(ibj)
            bakerr(j)=sqrt(covar(ibj,ibj))
 31    continue
c
c
c
c       fill array bkgrd
c
         bkarea=0.0d0
          bkaerr=0.0d0
      do 32 i=ichan,jchan
        sum=0.0d0
         x=real(i-ichan)
c
             term= bakfit(1)
              sum=sum+term
               bkaerr=bkaerr+term*covar(1,1)
       if(nbkparm.gt.1) then
c
c
       argx= ( x - bakfit(3))/bakfit(4)
c
          term=bakfit(2)/ (1.0d0 + exp(argx))
           sum=sum+ term
            bkaerr=bkaerr+term* bakerr(2)
       endif
c
        if(nbkparm.gt.4) then
c
         argx= (x- bakfit(6))/bakfit(7)
          ex= exp(argx)
            term=bakfit(5) * ex/ ( 1.0d0+ex)**2
          sum=sum+term
            bkaerr=bkaerr+term*bakerr(5)
         endif
c
        bkarea=bkarea+sum
 32     bkgrd(i)=sum
        bkaerr=sqrt(bkaerr)
c
c
c
c      fill array bkplot
c
c
       ndx=nint(1.0d0/dxplot)
       dxplot = 1.0d0/real(ndx)
       iplot=ichan*ndx
        jplot=jchan*ndx
      do 34 i=iplot,jplot
       sum=0.0d0
       x= (i-iplot)*dxplot
          term=bakfit(1)
          sum=sum+term
       if(nbkparm.gt.1) then
          argx=(x-bakfit(3))/bakfit(4)
          term= bakfit(2)/(1.0d0+exp(argx))
          sum=sum+term
        endif
        if(nbkparm.gt.4) then
         argx= (x-bakfit(6))/bakfit(7)
          ex=exp(argx)
          term=bakfit(5) *ex/(1.0d0+ex)**2
          sum=sum+term
         endif
c
        bkplot(i)= sum
 34   continue
c
c
c
      write(6,1003)
 1003 format(/' Background function',
     > ' b(i) = a(1)+a(2)/[1+exp((X-a(3))/a(4)]'/
     >28x,'+a(5)exp((X-a(6))/a(7))/[1+exp((X-a(6))/a(7)]**2'/
     >28x,'X=i-ichan, i=ichan,jchan'/)
c
      endif
c
      goto 100
c
c
 40    continue
c
c      previous   background* factor(searched)
c
c       bknorm has been searched on
c       so reset value to that stored in array a
c
      if(nbkparm.gt.0) then
c
c
        ibjk =index(ixbk+1)
       bknorm=a(ibjk)
c
        bknerr = covar(ibjk,ibjk)
       endif
c
        bkarea=bknorm*bkarea
          bkaerr=bknorm*bkaerr
c
c       renormalise bkgrd spectrum
c
        do 41 i=ichan,jchan
         bkgrd(i)= bknorm*bkgrd(i)
  41    continue
c
c
c      rescale background coeffs
c
c
c
        bakfit(1)=bknorm*bakfit(1)
        term1= bknorm*bakerr(1)
         term2= bakfit(1)*bknerr
         bakerr(1) =sqrt(term1**2 +term2**2)
c
      do 42 j=iscstrt(ibkmem),nback,iscstp(ibkmem)
        bakfit(j)=bknorm*bakfit(j)
        term1 = bknorm* bakerr(j)
          term2= bknerr*bakfit(j)
        bakerr(j)=sqrt( term1**2 +term2**2)
  42    continue
     
c
c
c
c      fill array bkplot
c
c
       ndx=nint(1.0d0/dxplot)
       dxplot = 1.0d0/real(ndx)
       iplot=ichan*ndx
        jplot=jchan*ndx
      do 44 j=iplot,jplot
       sum=0.0d0
       xj= (j-iplot)*dxplot
c
c      calculate original channels values on either side of xj 
c      then interpolate to find value at xj
c
        xi= xj+ichan
c
c       i is channel no, corresponding to xi
c
        i= nint(xi)
c
c        i1 is  i+1 channel
c
        i1= i+1
c
c       if i1> jchan then set i1=jchan
c
         if(i1.ge.jchan) i1=jchan
c
        frac= xi-real(i)
c
c       so xj corresponds to a point at xi, which lies between 
c       channels  i and i+1
c       now simple interpolation to get value at xj
c
       bkplot(j)= bkgrd(i) +frac*(bkgrd(i+1)-bkgrd(i))
 44   continue
c

      write(6,1004)bknorm,bknerr
 1004 format(/' Background function',
     > ' b(i) = Previous [bkgrd] * [bknorm]'/
     >        '                 [bknorm] ='
     > ,1pe12.4,' +/-',e12.4/)

c
c
c
c
      goto 100
c
c
 50     continue
c
c       previous background*factor(fixed)
c
c
c
      write(6,1005)bknorm
 1005 format(/' Background function',
     > ' b(i) = Previous [bkgrd] * [bknorm]'/
     > '                 [bknorm] =',1pe12.4/)
c
c       rescale area
c
      bkarea=bknorm*bkarea
          bkaerr=bknorm*bkaerr
c
c       renormalise bkgrd spectrum
c
        do 51 i=ichan,jchan
         bkgrd(i)= bknorm*bkgrd(i)
  51    continue
c
c
c
c      rescale background coeffs
c
c
        bakfit(1)=bknorm*bakfit(1)
        term1= bknorm*bakerr(1)
         term2= bakfit(1)*bknerr
         bakerr(1) =sqrt(term1**2 +term2**2)
c
      do 52 j=iscstrt(ibkmem),nback,iscstp(ibkmem)
        bakfit(j)=bknorm*bakfit(j)
        term1 = bknorm* bakerr(j)
          term2= bknerr*bakfit(j)
        bakerr(j)=sqrt( term1**2 +term2**2)
  52  continue
c
c
c      fill array bkplot
c
c
       ndx=nint(1.0d0/dxplot)
       dxplot = 1.0d0/real(ndx)
       iplot=ichan*ndx
        jplot=jchan*ndx
      do 54 j=iplot,jplot
       sum=0.0d0
       xj= (j-iplot)*dxplot
c
c      calculate original channels values on either side of xj 
c      then interpolate to find value at xj
c
        xi= xj+ichan
c
c       i is channel no, corresponding to xi
c
        i= nint(xi)
c
c        i1 is  i+1 channel
c
        i1= i+1
c
c       if i1> jchan then set i1=jchan
c
         if(i1.ge.jchan) i1=jchan
c
        frac= xi-real(i)
c
c       so xj corresponds to a point at xi, which lies between 
c       channels  i and i+1
c       now simple interpolation to get value at xj
c
       bkplot(j)= bkgrd(i) +frac*(bkgrd(i+1)-bkgrd(i))
 54   continue
c

c
c

c
  100   continue
c
c      writeout background coefficients
c
      if(ibkshape.ge.4) then
       write(6,'('' Re-normalised values:-'')/')
       endif
c
       write(6,'( 2x,''j    Coeff. a(j)   Error a(j)'')')
       do  200 j=1,nback
       write(6,2001) j, bakfit(j),bakerr(j)
 2001  format( i3,1x, 1pE13.5,1x,e13.5)
 200   continue
c
c      writeout background area + error
c
       WRITE(6,'(/ 3X,''Background Area'',   
     >           3X,F14.2,'' +/-'',F11.2/)')BKAREA,BKAERR
c
c
c
      return
       end
