/* 
 * transformations, curve fitting, etc.
 *
 * formerly, this was all one big popup, now it is several.
 * All are created as needed
 *
 * TODO change to style of setops for popups
 *
 */

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <unistd.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/font.h>
#include "globals.h"
#include "alerts.h"
#include "compwin1.h"
#include "compwin2.h"
#include "events.h"
#include "main.h"
#include "plotone.h"
#include "setutils.h"
#include "utils.h"

#define CALC_EVAL    1
#define CALC_LOAD    2
#define CALC_HISTO   3
#define CALC_FOURIER 4
#define CALC_RUNA    5
#define CALC_REG     6
#define CALC_DIFF    7
#define CALC_XCOR    8
#define CALC_SPLINE  9
#define CALC_SAMP    10
#define CALC_DIGF    11
#define CALC_LCONV   12
#define CALC_LEVAL   13
#define CALC_NONL    14


void drawgraph2();		/* calls plotone(), called any time the graph
				 * needs to be re-drawn */
void clear_graph_viewport();
void create_eval_frame();
void create_load_frame();
void create_histo_frame();
void create_fourier_frame();
void create_run_frame();
void create_reg_frame();
void create_diff_frame();
void create_xcor_frame();
void create_spline_frame();
void create_samp_frame();
void create_digf_frame();
void create_lconv_frame();
void create_leval_frame();
void do_fourier_proc();

#define FRAME_KEY        101
#define TAGS_KEY         102

extern Panel_item  *limits_ptr;
extern int         range_tags[2];

static char *my_argv[] =
          {"sort_calc_xvgr", "-spectrum", (char *)0, (char *)0};

static void        apply_calc_results();

/*
 * generic tags proc for all of the frames defined below
 */
/*ARGSUSED*/
void do_generic_tags(item, event)
    Panel_item item;
    Event *event;
{
    limits_ptr = (Panel_item *) xv_get(item, XV_KEY_DATA, TAGS_KEY);
    set_cfit_tags(2,range_tags,update_range_tags);
    return;
}


/*
 * allow a carriage return to activate formula
 * interpreter
 */
static Frame eval_frame = (Frame) 0;
static Panel eval_panel;
static Panel_item compute_formula_item;
static Panel_item compute_set_item;
static Panel_item compute_load_item;
static Panel_item compute_loadgraph_item;
static Panel_item computeval_limit_item[2];
static void do_compute_proc();
static Notify_client  eval_nclient = (Notify_client) 117;

static Panel_setting eotproc_compose(item, event)
    Panel_item item;
    Event *event;
{
    switch (event_id(event)) {
    case '\r':
    case '\n':
	do_compute_proc(item, event);
	return PANEL_NONE;
    default:
	return (panel_text_notify(item, event));
    }
}

void create_eval_frame()
{
    if (eval_frame) {
	xv_set(eval_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    eval_frame = (Frame) xv_create(main_frame, FRAME,
				   FRAME_LABEL, "Evaluate",
				   NULL);
    eval_panel = (Panel) xv_create(eval_frame, PANEL,
				   XV_HELP_DATA, "xvgr:eval_panel",
				   PANEL_LAYOUT, PANEL_VERTICAL,
				   NULL);
    define_select_set_panel2(eval_panel, compute_set_item,"Select set:");
    xv_set(compute_set_item, PANEL_VALUE_X, xv_col(eval_panel, 15), NULL);
    compute_load_item = xv_create(eval_panel, PANEL_CYCLE,
				  XV_HELP_DATA, "xvgr:eval_resulttoset",
				  PANEL_LABEL_STRING, "Result To:",
				  PANEL_CHOICE_STRINGS,
				  "New set",
				  "Same set", NULL,
				  PANEL_VALUE_X, xv_col(eval_panel, 15),
				  NULL);
    compute_loadgraph_item = (Panel_item) xv_create(eval_panel, PANEL_CHOICE_STACK,
				    XV_HELP_DATA, "xvgr:eval_resulttograph",
					    PANEL_LABEL_STRING, "In graph:",
						    PANEL_CHOICE_STRINGS,
						    "Current",
			   "0", "1", "2", "3", "4", "5", "6", "7", "8",
						    NULL,
				      PANEL_VALUE_X, xv_col(eval_panel, 15),
						    NULL);

    computeval_limit_item[0] = xv_create(eval_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:eval_start",
				 PANEL_LABEL_STRING, "Start:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(eval_panel, 15),
				 NULL);
    computeval_limit_item[1] = xv_create(eval_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:eval_stop",
				 PANEL_LABEL_STRING, "Stop:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(eval_panel, 15),
				 NULL);
    compute_formula_item = xv_create(eval_panel, PANEL_TEXT,
				     XV_HELP_DATA, "xvgr:eval_formula",
				     PANEL_LABEL_STRING, "Formula:",
				     PANEL_NOTIFY_STRING, "\n\r",
				     PANEL_NOTIFY_PROC, eotproc_compose,
				     PANEL_VALUE_DISPLAY_LENGTH, 30,
				     XV_X, xv_col(eval_panel, 1),
				     XV_Y, xv_row(eval_panel, 5),
				     0);
    xv_create(eval_panel, PANEL_BUTTON,
	      XV_HELP_DATA, "xvgr:eval_apply",
	      PANEL_LABEL_STRING, "Apply",
	      PANEL_NOTIFY_PROC, do_compute_proc,
	      XV_X, xv_col(eval_panel, 5),
	      XV_Y, xv_row(eval_panel, 7),
	      0);
    (void) xv_create(eval_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:eval_done",
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, eval_frame,
		     XV_X, xv_col(eval_panel, 15),
		     XV_Y, xv_row(eval_panel, 7),
		     NULL);
     (void) xv_create(eval_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:eval_tags",
		     PANEL_LABEL_STRING, "Tags",
		     PANEL_NOTIFY_PROC, do_generic_tags,
		     XV_KEY_DATA, TAGS_KEY, computeval_limit_item,
		     XV_X, xv_col(eval_panel, 25),
		     XV_Y, xv_row(eval_panel, 7),
		     NULL);
    window_fit(eval_panel);
    window_fit(eval_frame);
    xv_set(eval_frame, WIN_SHOW, TRUE, NULL);
}
/*
 * evaluate a formula
 */
/* ARGSUSED */
static void do_compute_proc(item, event)
    Panel_item item;
    Event *event;
{
    int set, loadto, graphto, setlen;
    char fstr[256];
    double start, stop, *xdata, *ydata;
    char *out_file, command[BUFSIZ];
    char *c_ptr = command;

    set = (int) xv_get(compute_set_item, PANEL_VALUE);
    loadto = (int) xv_get(compute_load_item, PANEL_VALUE);
    graphto = (int) xv_get(compute_loadgraph_item, PANEL_VALUE) - 1;
    strcpy(fstr, (char *) xv_get(compute_formula_item, PANEL_VALUE));

    if ( (setlen = check_set_len(set,3)) < 0)
	  return;
    if (graphto < 0) {
	graphto = cg;
    }
    if (strlen(fstr) == 0) {
	errwin("Define formula first");
	return;
    }
    if (loadto)   /* load to same set */
	  loadto = set;
    else
	  loadto = -1;
    
    if ( check_set_parameters(set, computeval_limit_item, &start, &stop) < 0)
	  return;
    
/* get pointers to data fields */
    xdata = getx(cg, set);
    ydata = gety(cg, set);

/* fill argument vector my_argv with name of dat file*/
    my_argv[2] = (out_file = tempnam(NULL,"SORT_"));

/* setup command string */
    (void) memset(command,0,sizeof(command));
    sprintf(command,"%d %d %d %g %g %c",CALC_EVAL,setlen,0,start,stop,'\0');
    c_ptr += strlen(c_ptr)+1;
    sprintf(c_ptr,"%d %d %c",graphto,loadto,'\0');
    c_ptr += strlen(c_ptr)+1;
    sprintf(c_ptr,"%s",fstr);

/* write out relevant data */
    compwin2_outdat(out_file,command,sizeof(command),xdata,ydata,setlen);
    
/* start peak find process */
    do_process("sort_calc_xvgr", my_argv, eval_nclient, sigchldcatcher_compwin2);
    if (out_file != NULL) free(out_file);
    return;
}


/* load a set */
static Frame load_frame = (Frame) 0;
static Panel load_panel;
static Panel_item load_set_item;
static Panel_item load_start_item;
static Panel_item load_step_item;
static Panel_item load_to_item;

void create_load_frame()
{
    static void do_load_proc();

    if (load_frame) {
	xv_set(load_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    load_frame = (Frame) xv_create(main_frame, FRAME,
				   FRAME_LABEL, "Load",
				   NULL);
    load_panel = (Panel) xv_create(load_frame, PANEL,
				   XV_HELP_DATA, "xvgr:load_panel",
				   PANEL_LAYOUT, PANEL_VERTICAL,
				   NULL);
    define_select_set_panel3(load_panel, load_set_item);
    xv_set(load_set_item, PANEL_VALUE_X, xv_col(load_panel, 14), NULL);
    load_to_item = xv_create(load_panel, PANEL_CYCLE,
			     XV_HELP_DATA, "xvgr:load_to",
			     PANEL_LABEL_STRING, "To:",
			     PANEL_CHOICE_STRINGS,
			     "X",
			     "Y",
			     "Scratch array A",
			     "Scratch array B",
			     "Scratch array C",
			     "Scratch array D", NULL,
			     PANEL_VALUE_X, xv_col(load_panel, 14),
			     NULL);
    load_start_item = xv_create(load_panel, PANEL_TEXT,
				XV_HELP_DATA, "xvgr:load_start",
				PANEL_LAYOUT, PANEL_HORIZONTAL,
				PANEL_LABEL_STRING, "Start:",
				PANEL_VALUE_DISPLAY_LENGTH, 15,
				PANEL_VALUE_X, xv_col(load_panel, 14),
				NULL);
    load_step_item = xv_create(load_panel, PANEL_TEXT,
			       XV_HELP_DATA, "xvgr:load_step",
			       PANEL_LAYOUT, PANEL_HORIZONTAL,
			       PANEL_LABEL_STRING, "Step:",
			       PANEL_VALUE_DISPLAY_LENGTH, 15,
			       PANEL_VALUE_X, xv_col(load_panel, 14),
			       NULL);
    xv_create(load_panel, PANEL_BUTTON,
	      XV_HELP_DATA, "xvgr:load_apply",
	      PANEL_LABEL_STRING, "Apply",
	      PANEL_NOTIFY_PROC, do_load_proc,
	      XV_X, xv_col(load_panel, 5),
	      XV_Y, xv_row(load_panel, 5),
	      NULL);

    (void) xv_create(load_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:load_done",
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, load_frame,
		     XV_X, xv_col(load_panel, 15),
		     XV_Y, xv_row(load_panel, 5),
		     NULL);

    window_fit(load_panel);
    window_fit(load_frame);
    xv_set(load_frame, WIN_SHOW, TRUE, NULL);
}
/*
 * load a set
 */
/* ARGSUSED */
static void do_load_proc(item, event)
    Panel_item item;
    Event *event;
{
    int setno /*, toval*/;
    char startstr[256], stepstr[256];

    setno = (int) xv_get(load_set_item, PANEL_VALUE);
    if (setno == MAXPLOT) {
	setno = -1;
    }
/*    toval = (int) xv_get(load_to_item, PANEL_VALUE) + 1; */
    strcpy(stepstr, (char *) xv_get(load_step_item, PANEL_VALUE));
    strcpy(startstr, (char *) xv_get(load_start_item, PANEL_VALUE));
/*    do_load(setno, toval, startstr, stepstr); */
}

/* histograms */
static Frame histo_frame = (Frame) 0;
static Panel histo_panel;
static Panel_item histo_binw_item;
static Panel_item histo_limit_item[2];
static Panel_item histo_hxmin_item;
static Panel_item histo_hxmax_item;
static Panel_item histo_type_item;
static Panel_item toggle_set_histo_item;
static Notify_client  histo_nclient = (Notify_client) 113;

void create_histo_frame()
{
    static void do_histo_proc();

    if (histo_frame) {
	xv_set(histo_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    histo_frame = (Frame) xv_create(main_frame, FRAME,
				    FRAME_LABEL, "Histogram",
				    NULL);
    histo_panel = (Panel) xv_create(histo_frame, PANEL,
				    XV_HELP_DATA, "xvgr:histo_panel",
				    PANEL_LAYOUT, PANEL_VERTICAL,
				    NULL);
    define_select_set_panel2(histo_panel, toggle_set_histo_item, "Select set:");
    xv_set(toggle_set_histo_item, PANEL_VALUE_X, xv_col(histo_panel, 15), NULL);
    histo_binw_item = xv_create(histo_panel, PANEL_TEXT,
				XV_HELP_DATA, "xvgr:histo_binwidth",
				PANEL_LABEL_STRING, "Bin width:",
				PANEL_VALUE_DISPLAY_LENGTH, 15,
				PANEL_VALUE_X, xv_col(histo_panel, 15),
				NULL);
    histo_hxmin_item = xv_create(histo_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:histo_minx",
				 PANEL_LABEL_STRING, "Minimum X:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(histo_panel, 15),
				 NULL);
    histo_hxmax_item = xv_create(histo_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:histo_maxx",
				 PANEL_LABEL_STRING, "Maximum X:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(histo_panel, 15),
				 NULL);
    histo_type_item = xv_create(histo_panel, PANEL_CYCLE,
				XV_HELP_DATA, "xvgr:histo_load",
				PANEL_LABEL_STRING, "Load:",
				PANEL_CHOICE_STRINGS,
				"Histogram",
				"Cumulative Histo",
				NULL,
				PANEL_VALUE_X, xv_col(histo_panel, 15),
				NULL);
    histo_limit_item[0] = xv_create(histo_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:histo_minx",
				 PANEL_LABEL_STRING, "Start:",
				 PANEL_VALUE_DISPLAY_LENGTH, 10,
				 PANEL_VALUE_X, xv_col(histo_panel, 5),
				 XV_Y, xv_row(histo_panel, 5),
				 NULL);
    histo_limit_item[1] = xv_create(histo_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:histo_maxx",
				 PANEL_LABEL_STRING, "Stop:",
				 PANEL_VALUE_DISPLAY_LENGTH, 10,
				 PANEL_VALUE_X, xv_col(histo_panel, 22),
				 XV_Y, xv_row(histo_panel, 5),
				 NULL);
    xv_create(histo_panel, PANEL_BUTTON,
	      XV_HELP_DATA, "xvgr:histo_apply",
	      PANEL_LABEL_STRING, "Apply",
	      PANEL_NOTIFY_PROC, do_histo_proc,
	      XV_X, xv_col(histo_panel, 5),
	      XV_Y, xv_row(histo_panel, 7),
	      NULL);

    (void) xv_create(histo_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:histo_done",
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, histo_frame,
		     XV_X, xv_col(histo_panel, 15),
		     XV_Y, xv_row(histo_panel, 7),
		     NULL);
    (void) xv_create(histo_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:histo_tag",
		     PANEL_LABEL_STRING, "Tags",
		     PANEL_NOTIFY_PROC, do_generic_tags,
		     XV_KEY_DATA, TAGS_KEY, histo_limit_item,
		     XV_X, xv_col(histo_panel, 25),
		     XV_Y, xv_row(histo_panel, 7),
		     NULL);
    window_fit(histo_panel);
    window_fit(histo_frame);
    xv_set(histo_frame, WIN_SHOW, TRUE, NULL);
}
/*
 * histograms
 */
/* ARGSUSED */
static void do_histo_proc(item, event)
    Panel_item item;
    Event *event;
{
    int set, setlen, hist_type;
    double binw, start, stop, xmin, xmax;
    double *xdata, *ydata;
    char *out_file, command[BUFSIZ];
    char *c_ptr = command;

    set = (int) xv_get(toggle_set_histo_item, PANEL_VALUE);
    binw = atof((char *) xv_get(histo_binw_item, PANEL_VALUE));
    start = atof((char *) xv_get(histo_limit_item[0], PANEL_VALUE));
    stop = atof((char *) xv_get(histo_limit_item[1], PANEL_VALUE));
    xmin = atof((char *) xv_get(histo_hxmin_item, PANEL_VALUE));
    xmax = atof((char *) xv_get(histo_hxmax_item, PANEL_VALUE));
    hist_type = (int) xv_get(histo_type_item, PANEL_VALUE);
 
    if ( (setlen = check_set_len(set,1)) < 0)
	  return;
    if (binw <= 0.0) {
	  errwin("Bin width <= 0");
	  return;
    }
    if ( check_set_parameters(set, histo_limit_item, &start, &stop) < 0)
	  return;
    if ( ((xmax-xmin)/binw) <= 0) {
	  errwin("No bins, no work to do");
	  return;
    }

/* get pointers to data fields */
    xdata = getx(cg, set);
    ydata = gety(cg, set);

/* fill argument vector my_argv with name of dat file*/
    my_argv[2] = (out_file = tempnam(NULL,"SORT_"));

/* setup command string */
    (void) memset(command,0,sizeof(command));
    sprintf(command,"%d %d %d %g %g %c",CALC_HISTO,setlen,0,start,stop,'\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"%g %d %g %g %c",binw,hist_type,xmin,xmax, '\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"Histogram from set # %d", set);
    
/* write out relevant data */
    compwin2_outdat(out_file,command,sizeof(command),xdata,ydata,setlen);
    
/* start peak find process */
    do_process("sort_calc_xvgr", my_argv, histo_nclient, sigchldcatcher_compwin2);
    if (out_file != NULL) free(out_file);
    return;

}

/* DFTs */
static Frame fourier_frame = (Frame) 0;
static Panel fourier_panel;
static Panel_item toggle_set_fourier_item;
static Panel_item toggle_loadx_fourier_item;
static Panel_item toggle_window_fourier_item;
static Panel_item toggle_load_fourier_item;
static Panel_item toggle_inv_fourier_item;
static Panel_item toggle_type_fourier_item;
static Panel_item fourier_limit_item[2];
static Notify_client  fourier_nclient = (Notify_client) 114;

void create_fourier_frame()
{
    if (fourier_frame) {
	xv_set(fourier_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    fourier_frame = (Frame) xv_create(main_frame, FRAME,
				      FRAME_LABEL, "Fourier",
				      NULL);
    fourier_panel = (Panel) xv_create(fourier_frame, PANEL,
				      XV_HELP_DATA, "xvgr:fourier_panel",
				      PANEL_LAYOUT, PANEL_VERTICAL,
				      NULL);
    define_select_set_panel2(fourier_panel, toggle_set_fourier_item, "Select set:");
    xv_set(toggle_set_fourier_item, PANEL_VALUE_X, xv_col(fourier_panel, 17), NULL);
    toggle_window_fourier_item = xv_create(fourier_panel, PANEL_CYCLE,
					 XV_HELP_DATA, "xvgr:fourier_window",
					 PANEL_LABEL_STRING, "Data window:",
					 PANEL_CHOICE_STRINGS,
					 "None (Rectangular)",
					 "Triangular",
					 "Hanning",
					 "Welch",
					 "Hamming",
					 "Blackman",
					 "Parzen",
					 NULL,
				   PANEL_VALUE_X, xv_col(fourier_panel, 17),
					 NULL);
    toggle_load_fourier_item = xv_create(fourier_panel, PANEL_CYCLE,
					 XV_HELP_DATA, "xvgr:fourier_load",
					 PANEL_LABEL_STRING, "Load:",
					 PANEL_CHOICE_STRINGS,
					 "Magnitude",
					 "Phase",
					 "Coefficients",
					 NULL,
				   PANEL_VALUE_X, xv_col(fourier_panel, 17),
					 NULL);
    toggle_loadx_fourier_item = xv_create(fourier_panel, PANEL_CYCLE,
					  XV_HELP_DATA, "xvgr:fourier_xeq",
					  PANEL_LABEL_STRING, "X = ",
					  PANEL_CHOICE_STRINGS,
					  "Index",
					  "Frequency",
					  "Period",
					  NULL,
				   PANEL_VALUE_X, xv_col(fourier_panel, 17),
					  NULL);
    toggle_inv_fourier_item = xv_create(fourier_panel, PANEL_CYCLE,
					XV_HELP_DATA, "xvgr:fourier_perform",
					PANEL_LABEL_STRING, "Perform:",
					PANEL_CHOICE_STRINGS,
					"Transform",
					"Inverse transform",
					NULL,
				   PANEL_VALUE_X, xv_col(fourier_panel, 17),
					NULL);
    toggle_type_fourier_item = xv_create(fourier_panel, PANEL_CYCLE,
				      XV_HELP_DATA, "xvgr:fourier_datatype",
					 PANEL_LABEL_STRING, "Type:",
					 PANEL_CHOICE_STRINGS,
					 "Real",
					 "Complex",
					 NULL,
				   PANEL_VALUE_X, xv_col(fourier_panel, 17),
					 NULL);

    fourier_limit_item[0] = xv_create(fourier_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:fourier_start",
				 PANEL_LABEL_STRING, "Start:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(fourier_panel, 15),
				 NULL);
    fourier_limit_item[1] = xv_create(fourier_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:fourier_stop",
				 PANEL_LABEL_STRING, "Stop:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(fourier_panel, 15),
				 NULL);
    
    xv_create(fourier_panel, PANEL_BUTTON,
	      XV_HELP_DATA, "xvgr:fourier_applydft",
	      PANEL_LABEL_STRING, "Apply DFT",
	      PANEL_NOTIFY_PROC, do_fourier_proc,
	      XV_KEY_DATA, fourier_nclient, 0,
	      XV_X, xv_col(fourier_panel, 4),
	      XV_Y, xv_row(fourier_panel, 9),
	      0);
    xv_create(fourier_panel, PANEL_BUTTON,
	      XV_HELP_DATA, "xvgr:fourier_applyfft",
	      PANEL_LABEL_STRING, "Apply FFT",
	      PANEL_NOTIFY_PROC, do_fourier_proc,
	      XV_KEY_DATA, fourier_nclient, 1,
	      XV_X, xv_col(fourier_panel, 16),
	      XV_Y, xv_row(fourier_panel, 9),
	      0);
    xv_create(fourier_panel, PANEL_BUTTON,
	      XV_HELP_DATA, "xvgr:fourier_applywindow",
	      PANEL_LABEL_STRING, "Window only",
	      PANEL_NOTIFY_PROC, do_fourier_proc,
	      XV_KEY_DATA, fourier_nclient, 2,
	      XV_X, xv_col(fourier_panel, 27),
	      XV_Y, xv_row(fourier_panel, 9),
	      0);
    xv_create(fourier_panel, PANEL_BUTTON,
	      XV_HELP_DATA, "xvgr:fourier_done",
	      PANEL_LABEL_STRING, "Done",
	      PANEL_NOTIFY_PROC, generic_done_proc,
	      XV_KEY_DATA, FRAME_KEY, fourier_frame,
	      XV_X, xv_col(fourier_panel, 12),
	      XV_Y, xv_row(fourier_panel, 10),
	      NULL);
    xv_create(fourier_panel, PANEL_BUTTON,
	      XV_HELP_DATA, "xvgr:fourier_tags",
	      PANEL_LABEL_STRING, "Tags",
	      PANEL_NOTIFY_PROC, do_generic_tags,
	      XV_KEY_DATA, TAGS_KEY, fourier_limit_item,
	      XV_X, xv_col(fourier_panel, 20),
	      XV_Y, xv_row(fourier_panel, 10),
	      NULL);

    window_fit(fourier_panel);
    window_fit(fourier_frame);
    xv_set(fourier_frame, WIN_SHOW, TRUE, NULL);
}
/* ARGSUSED */
void do_fourier_proc(item, event)
    Panel_item item;
    Event *event;
{
    int load, loadx, invflag, type, wind;
    int set, setlen, imode;
    double start=0, stop=0, *xdata, *ydata;
    char *out_file, command[BUFSIZ];
    char *c_ptr = command;
     
    set = (int) xv_get(toggle_set_fourier_item, PANEL_VALUE);
    wind = (int) xv_get(toggle_window_fourier_item, PANEL_VALUE);
    load = (int) xv_get(toggle_load_fourier_item, PANEL_VALUE);
    loadx = (int) xv_get(toggle_loadx_fourier_item, PANEL_VALUE);
    invflag = (int) xv_get(toggle_inv_fourier_item, PANEL_VALUE);
    type = (int) xv_get(toggle_type_fourier_item, PANEL_VALUE);
    imode = (int) xv_get(item, XV_KEY_DATA, fourier_nclient);

    if ( (setlen = check_set_len(set,2)) < 0)
	  return;

    if ( check_set_parameters(set, fourier_limit_item, &start, &stop) < 0)
	  return;
    if (imode == 1) { /* FFT */
	  if ( ilog2((int) (stop-start+1)) <= 0) {
		errwin("Set length not a power of 2");
	    return;
	  }
    }
   
/* get pointers to data fields */
    xdata = getx(cg, set);
    ydata = gety(cg, set);

/* fill argument vector my_argv with name of dat file*/
    my_argv[2] = (out_file = tempnam(NULL,"SORT_"));

/* setup command string */
    (void) memset(command,0,sizeof(command));
    sprintf(command,"%d %d %d %g %g %c",CALC_FOURIER,setlen,0,start,stop,'\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"%d %d %d %d %d %d %c",imode, load, loadx, invflag, type, wind, '\0');
    c_ptr += strlen(c_ptr) + 1;
    if (imode == 0) {
	  sprintf(c_ptr,"DFT of set %d", set);
    }
    else if (imode == 1) {
	  sprintf(c_ptr,"FFT of set %d", set);
    }
    else
	  sprintf(c_ptr,"Windowed set %d", set);

/* write out relevant data */
    compwin2_outdat(out_file,command,sizeof(command),xdata,ydata,setlen);
    
/* start peak find process */
    do_process("sort_calc_xvgr", my_argv, fourier_nclient, sigchldcatcher_compwin2);
    if (out_file != NULL) free(out_file);

    return;
}


/* running averages */
static Frame run_frame = (Frame) 0;
static Panel run_panel;
static Panel_item toggle_ravglen_item;
static Panel_item toggle_run_item;
static Panel_item toggle_set_runavg_item;
static Panel_item runav_limit_item[2];
static Notify_client  runav_nclient = (Notify_client) 107;

void create_run_frame()
{
    static void do_runavg_proc();

    if (run_frame) {
	xv_set(run_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    run_frame = (Frame) xv_create(main_frame, FRAME,
				  FRAME_LABEL, "Running etc.",
				  NULL);
    run_panel = (Panel) xv_create(run_frame, PANEL,
				  XV_HELP_DATA, "xvgr:run_panel",
				  PANEL_LAYOUT, PANEL_VERTICAL,
				  NULL);
    define_select_set_panel2(run_panel, toggle_set_runavg_item, "Select set:");
    xv_set(toggle_set_runavg_item, PANEL_VALUE_X, xv_col(run_panel, 15), NULL);
    toggle_run_item = xv_create(run_panel, PANEL_CYCLE,
				XV_HELP_DATA, "xvgr:run_toggle",
				PANEL_CHOICE_STRINGS,
				"Average",
				"Median",
				"Minimum",
				"Maximum",
				"Std. dev.", NULL,
				PANEL_VALUE_X, xv_col(run_panel, 15),
				NULL);
    toggle_ravglen_item = xv_create(run_panel, PANEL_TEXT,
				    XV_HELP_DATA, "xvgr:run_length",
				    PANEL_LABEL_STRING, "Length:",
				    PANEL_VALUE_DISPLAY_LENGTH, 10,
				    PANEL_VALUE_X, xv_col(run_panel, 15),
				    NULL);

    runav_limit_item[0] = xv_create(run_panel, PANEL_TEXT,
				    XV_HELP_DATA, "xvgr:run_atg",
				    PANEL_LABEL_STRING, "Start:",
				    PANEL_VALUE_DISPLAY_LENGTH, 10,
				    PANEL_VALUE_X, xv_col(run_panel, 6),
				    XV_Y, xv_row(run_panel, 3),
				    NULL);
    runav_limit_item[1] = xv_create(run_panel, PANEL_TEXT,
				    XV_HELP_DATA, "xvgr:run_tag",
				    PANEL_LABEL_STRING, "Start:",
				    PANEL_VALUE_DISPLAY_LENGTH, 10,
				    PANEL_VALUE_X, xv_col(run_panel, 25),
				    XV_Y, xv_row(run_panel, 3),
				    NULL);
    
    (void) xv_create(run_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:run_apply",
		     PANEL_LABEL_STRING, "Apply",
		     PANEL_NOTIFY_PROC, do_runavg_proc,
		     XV_X, xv_col(run_panel, 5),
		     XV_Y, xv_row(run_panel, 5),
		     NULL);
    (void) xv_create(run_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:run_done",
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, run_frame,
		     XV_X, xv_col(run_panel, 15),
		     XV_Y, xv_row(run_panel, 5),
		     NULL);
    (void) xv_create(run_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:run_tags",
		     PANEL_LABEL_STRING, "Tags",
		     PANEL_NOTIFY_PROC, do_generic_tags,
		     XV_KEY_DATA, TAGS_KEY, runav_limit_item,
		     XV_X, xv_col(run_panel, 25),
		     XV_Y, xv_row(run_panel, 5),
		     NULL);
    window_fit(run_panel);
    window_fit(run_frame);
    xv_set(run_frame, WIN_SHOW, TRUE, NULL);
}

/*
 * running averages, medians, min, max, std. deviation
 */
/* ARGSUSED */
static void do_runavg_proc(item, event)
    Panel_item item;
    Event *event;
{
    int runlen, runtype, set, setlen;
    double start=0, stop=0, *xdata, *ydata;
    char *out_file, command[BUFSIZ];
    char *c_ptr = command;

    set = (int) xv_get(toggle_set_runavg_item, PANEL_VALUE);
    runtype = (int) xv_get(toggle_run_item, PANEL_VALUE);
    runlen = atoi((char *) xv_get(toggle_ravglen_item, PANEL_VALUE));
    
    if ( (setlen = check_set_len(set,2)) < 0)
	  return;

    if ( check_set_parameters(set, runav_limit_item, &start, &stop) < 0)
	  return;

     if (runlen >= (int)(stop-start)) {
	errwin("Length of running average > specified range");
	return;
    }
    if (runlen < 2) {
	errwin("Length of running average < 2");
	return;
    }
   
/* get pointers to data fields */
    xdata = getx(cg, set);
    ydata = gety(cg, set);

/* fill argument vector my_argv with name of dat file*/
    my_argv[2] = (out_file = tempnam(NULL,"SORT_"));

/* setup command string */
    (void) memset(command,0,sizeof(command));
    sprintf(command,"%d %d %d %g %g %c",CALC_RUNA,setlen,0,start,stop,'\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"%d %d %c",runlen,runtype, '\0');

/* write out relevant data */
    compwin2_outdat(out_file,command,sizeof(command),xdata,ydata,setlen);
    
/* start peak find process */
    do_process("sort_calc_xvgr", my_argv, runav_nclient, sigchldcatcher_compwin2);
    if (out_file != NULL) free(out_file);

    return;
   
}

/* items for linear regression */
static Frame reg_frame = (Frame) 0;
static Panel reg_panel;
static Panel_item toggle_degree_item;	/* degree of fit */
static Panel_item toggle_resid_item;	/* load residuals, fitted values or
					 * nothing */
static Panel_item toggle_set_regress_item;	/* which set to use */
static Panel_item reg_limit_item[2];
static Notify_client  reg_nclient = (Notify_client) 108;

void create_reg_frame()
{
    static void do_regress_proc();

    if (reg_frame) {
	xv_set(reg_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    reg_frame = (Frame) xv_create(main_frame, FRAME,
				  FRAME_LABEL, "Regression",
				  NULL);
    reg_panel = (Panel) xv_create(reg_frame, PANEL,
				  XV_HELP_DATA, "xvgr:reg_panel",
				  PANEL_LAYOUT, PANEL_VERTICAL,
				  NULL);
    define_select_set_panel2(reg_panel, toggle_set_regress_item, "Select set:");
    xv_set(toggle_set_regress_item, PANEL_VALUE_X, xv_col(reg_panel, 15), NULL);
    toggle_degree_item = xv_create(reg_panel, PANEL_CYCLE,
				   XV_HELP_DATA, "xvgr:reg_degree",
				   PANEL_LABEL_STRING, "Degree:",
				   PANEL_CHOICE_STRINGS,
				   "Linear",
				   "Quadratic",
				   "Cubic",
				   "4th degree",
				   "5th degree", 
				   "6th degree", 
				   "7th degree", 
				   "8th degree", 
				   "9th degree", 
				   "10th degree", 
				    NULL,
				   PANEL_VALUE_X, xv_col(reg_panel, 15),
				   NULL);
    toggle_resid_item = xv_create(reg_panel, PANEL_CYCLE,
				  XV_HELP_DATA, "xvgr:reg_load",
				  PANEL_LABEL_STRING, "Load:",
				  PANEL_CHOICE_STRINGS,
				  "Fitted values",
				  "Residuals", NULL,
				  PANEL_VALUE_X, xv_col(reg_panel, 15),
				  NULL);

     reg_limit_item[0] = xv_create(reg_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:reg_start",
				 PANEL_LABEL_STRING, "Start:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(reg_panel, 7),
				 XV_Y, xv_row(reg_panel, 3),
				 NULL);
     reg_limit_item[1] = xv_create(reg_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:reg_stop",
				 PANEL_LABEL_STRING, "Stop:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(reg_panel, 7),
				 XV_Y, xv_row(reg_panel, 4),
				 NULL);
   (void) xv_create(reg_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:reg_apply",
		     PANEL_LABEL_STRING, "Apply",
		     PANEL_NOTIFY_PROC, do_regress_proc,
		     XV_X, xv_col(reg_panel, 3),
		     XV_Y, xv_row(reg_panel, 6),
		     NULL);

    (void) xv_create(reg_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:reg_done",
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, reg_frame,
		     XV_X, xv_col(reg_panel, 13),
		     XV_Y, xv_row(reg_panel, 6),
		     NULL);
    (void) xv_create(reg_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:reg_tags",
		     PANEL_LABEL_STRING, "Tags",
		     PANEL_NOTIFY_PROC, do_generic_tags,
		     XV_KEY_DATA, TAGS_KEY, reg_limit_item,
		     XV_X, xv_col(reg_panel, 23),
		     XV_Y, xv_row(reg_panel, 6),
		     NULL);
    window_fit(reg_panel);
    window_fit(reg_frame);
    xv_set(reg_frame, WIN_SHOW, TRUE, NULL);
}
/*
 * regression
 */
/* ARGSUSED */
static void do_regress_proc(item, event)
    Panel_item item;
    Event *event;
{
    int set, ideg, iresid, setlen;
    double start=0, stop=0, *xdata, *ydata;
    char *out_file, command[BUFSIZ];
    char *c_ptr = command;

    set = (int) xv_get(toggle_set_regress_item, PANEL_VALUE);
    ideg = (int) xv_get(toggle_degree_item, PANEL_VALUE) + 1;
    iresid = (int) xv_get(toggle_resid_item, PANEL_VALUE);
/*    do_regress(setno, ideg, iresid); */

    if ( (setlen = check_set_len(set,3)) < 0)
	  return;

    if ( check_set_parameters(set, reg_limit_item, &start, &stop) < 0)
	  return;
    
/* get pointers to data fields */
    xdata = getx(cg, set);
    ydata = gety(cg, set);

/* fill argument vector my_argv with name of dat file*/
    my_argv[2] = (out_file = tempnam(NULL,"SORT_"));

/* setup command string */
    (void) memset(command,0,sizeof(command));
    sprintf(command,"%d %d %d %g %g %c",CALC_REG,setlen,0,start,stop,'\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"%d %d %c",ideg,iresid,'\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"%d deg fit of set %d %c", ideg, set, '\0');

/* write out relevant data */
    compwin2_outdat(out_file,command,sizeof(command),xdata,ydata,setlen);
    
/* start peak find process */
    do_process("sort_calc_xvgr", my_argv, reg_nclient, sigchldcatcher_compwin2);
    if (out_file != NULL) free(out_file);
    return;
   
}

/* finite differencing */
static Frame diff_frame = (Frame) 0;
static Panel diff_panel;
static Panel_item toggle_set_differ_item;
static Panel_item toggle_differ_type_item;
static Panel_item diff_limit_item[2];
static Notify_client  differ_nclient = (Notify_client) 109;

void create_diff_frame()
{
    static void do_differ_proc();

    if (diff_frame) {
	xv_set(diff_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    diff_frame = (Frame) xv_create(main_frame, FRAME,
				   FRAME_LABEL, "Differentiate",
				   NULL);
    diff_panel = (Panel) xv_create(diff_frame, PANEL,
				   XV_HELP_DATA, "xvgr:diff_panel",
				   PANEL_LAYOUT, PANEL_VERTICAL,
				   NULL);
    define_select_set_panel2(diff_panel, toggle_set_differ_item, "Select set:");
    xv_set(toggle_set_differ_item, PANEL_VALUE_X, xv_col(diff_panel, 15), NULL);
    toggle_differ_type_item = xv_create(diff_panel, PANEL_CYCLE,
					XV_HELP_DATA, "xvgr:diff_method",
					PANEL_LABEL_STRING, "Method:",
					PANEL_CHOICE_STRINGS,
					"Forward difference",
					"Backward difference",
					"Centered difference",
					NULL,
				      PANEL_VALUE_X, xv_col(diff_panel, 15),
					NULL);

    diff_limit_item[0] = xv_create(diff_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:diff_minx",
				 PANEL_LABEL_STRING, "Start:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(diff_panel, 15),
				 NULL);
    diff_limit_item[1] = xv_create(diff_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:diff_maxx",
				 PANEL_LABEL_STRING, "Stop:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(diff_panel, 15),
				 NULL);
    (void)   xv_create(diff_panel, PANEL_BUTTON,
	      XV_HELP_DATA, "xvgr:diff_apply",
	      PANEL_LABEL_STRING, "Apply",
	      PANEL_NOTIFY_PROC, do_differ_proc,
	      XV_X, xv_col(diff_panel, 5),
	      XV_Y, xv_row(diff_panel, 5),
	      NULL);

    (void) xv_create(diff_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:diff_done",
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, diff_frame,
		     XV_X, xv_col(diff_panel, 15),
		     XV_Y, xv_row(diff_panel, 5),
		     NULL);
        (void) xv_create(diff_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:diff_tags",
		     PANEL_LABEL_STRING, "Tags",
		     PANEL_NOTIFY_PROC, do_generic_tags,
		     XV_KEY_DATA, TAGS_KEY, diff_limit_item,
		     XV_X, xv_col(diff_panel, 25),
		     XV_Y, xv_row(diff_panel, 5),
		     NULL);
    window_fit(diff_panel);
    window_fit(diff_frame);
    xv_set(diff_frame, WIN_SHOW, TRUE, NULL);
}

/*
 * finite differences
 */
/* ARGSUSED */
static void do_differ_proc(item, event)
    Panel_item item;
    Event *event;
{
    int set, itype, setlen;
    double start=0, stop=0, *xdata, *ydata;
    char *out_file, command[BUFSIZ];
    char *c_ptr = command;

    set = (int) xv_get(toggle_set_differ_item, PANEL_VALUE);
    itype = (int) xv_get(toggle_differ_type_item, PANEL_VALUE);

    if ( (setlen = check_set_len(set,3)) < 0)
	  return;
    if ( check_set_parameters(set, diff_limit_item, &start, &stop) < 0)
	  return;
    
/* get pointers to data fields */
    xdata = getx(cg, set);
    ydata = gety(cg, set);

/* fill argument vector my_argv with name of dat file*/
    my_argv[2] = (out_file = tempnam(NULL,"SORT_"));

/* setup command string */
    (void) memset(command,0,sizeof(command));
    sprintf(command,"%d %d %d %g %g %c",CALC_DIFF,setlen,0,start,stop,'\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"%d %c",itype,'\0');

/* write out relevant data */
    compwin2_outdat(out_file,command,sizeof(command),xdata,ydata,setlen);
    
/* start peak find process */
    do_process("sort_calc_xvgr", my_argv, differ_nclient, sigchldcatcher_compwin2);
    if (out_file != NULL) free(out_file);
    return;
    
}

/* cross correlation */
static Frame xcor_frame = (Frame) 0;
static Panel xcor_panel;
static Panel_item toggle_set_xcor1_item;
static Panel_item toggle_set_xcor2_item;
static Panel_item toggle_xcor_type_item;
static Panel_item xcor_lag_item;
static Panel_item xcor_limit_item[2];
static Notify_client  xcor_nclient = (Notify_client) 110;

void create_xcor_frame()
{
    static void do_xcor_proc();

    if (xcor_frame) {
	xv_set(xcor_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    xcor_frame = (Frame) xv_create(main_frame, FRAME,
				   FRAME_LABEL, "X correlation",
				   NULL);
    xcor_panel = (Panel) xv_create(xcor_frame, PANEL,
				   XV_HELP_DATA, "xvgr:xcor_panel",
				   PANEL_LAYOUT, PANEL_VERTICAL,
				   NULL);
    define_select_set_panel2(xcor_panel, toggle_set_xcor1_item, "Select set:");
    xv_set(toggle_set_xcor1_item, PANEL_VALUE_X, xv_col(xcor_panel, 15), NULL);
    define_select_set_panel2(xcor_panel, toggle_set_xcor2_item, "Select set:");
    xv_set(toggle_set_xcor2_item, PANEL_VALUE_X, xv_col(xcor_panel, 15), NULL);
    toggle_xcor_type_item = xv_create(xcor_panel, PANEL_CYCLE,
				      XV_HELP_DATA, "xvgr:xcor_bias",
				      PANEL_LABEL_STRING, "Bias:",
				      PANEL_CHOICE_STRINGS,
				      "Biased estimate",
				      "Unbiased estimate",
				      NULL,
				      PANEL_VALUE_X, xv_col(xcor_panel, 15),
				      NULL);
    xcor_limit_item[0] = xv_create(xcor_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:xcor_minx",
				 PANEL_LABEL_STRING, "Start:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(xcor_panel, 15),
				 NULL);
    xcor_limit_item[1] = xv_create(xcor_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:xcor_maxx",
				 PANEL_LABEL_STRING, "Stop:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(xcor_panel, 15),
				 NULL);

    xcor_lag_item = xv_create(xcor_panel, PANEL_TEXT,
			      XV_HELP_DATA, "xvgr:xcor_lag",
			      PANEL_LABEL_STRING, "Lag:",
			      PANEL_VALUE_DISPLAY_LENGTH, 15,
			      PANEL_VALUE_X, xv_col(xcor_panel, 15),
			      NULL);

    (void) xv_create(xcor_panel, PANEL_BUTTON,
	      XV_HELP_DATA, "xvgr:xcor_apply",
	      PANEL_LABEL_STRING, "Apply",
	      PANEL_NOTIFY_PROC, do_xcor_proc,
	      XV_X, xv_col(xcor_panel, 5),
	      XV_Y, xv_row(xcor_panel, 7),
	      NULL);

    (void) xv_create(xcor_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, xcor_frame,
		     XV_X, xv_col(xcor_panel, 15),
		     XV_Y, xv_row(xcor_panel, 7),
		     NULL);
    (void) xv_create(xcor_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Tags",
		     PANEL_NOTIFY_PROC, do_generic_tags,
		     XV_KEY_DATA, TAGS_KEY,  xcor_limit_item,
		     XV_X, xv_col(xcor_panel, 25),
		     XV_Y, xv_row(xcor_panel, 7),
		     NULL);
    window_fit(xcor_panel);
    window_fit(xcor_frame);
    xv_set(xcor_frame, WIN_SHOW, TRUE, NULL);
}
/*
 * cross correlation
 */
/* ARGSUSED */
static void do_xcor_proc(item, event)
    Panel_item item;
    Event *event;
{
    int set1, set2, setlen1, setlen2;
    int itype, lag;
    double start=0, stop=0;
    double *xdata1, *ydata1, *xdata2, *ydata2;
    char *out_file, command[BUFSIZ];
    char *c_ptr= command;

    set1 = (int) xv_get(toggle_set_xcor1_item, PANEL_VALUE);
    set2 = (int) xv_get(toggle_set_xcor2_item, PANEL_VALUE);
    itype = (int) xv_get(toggle_xcor_type_item, PANEL_VALUE);
    lag = atoi((char *) xv_get(xcor_lag_item, PANEL_VALUE));

    if ( (setlen1 = check_set_len(set1,3)) < 0)
	  return;
    if ( (setlen2 = check_set_len(set2,3)) < 0)
	  return;
    if (lag == 0 || (setlen1 - 1 < lag)) {
	errwin("Lag incorrectly specified");
	return;
    }
    if ( check_set_parameters(set1, xcor_limit_item, &start, &stop) < 0)
	  return;
  
/* get pointers to data fields */
    xdata1 = getx(cg, set1);
    ydata1 = gety(cg, set1);
    xdata2 = getx(cg, set2);
    ydata2 = gety(cg, set2);

/* fill argument vector my_argv with name of dat file*/
    my_argv[2] = (out_file = tempnam(NULL,"SORT_"));

/* setup command string */
    (void) memset(command,0,sizeof(command));
    sprintf(command,"%d %d %d %g %g %c",CALC_XCOR,setlen1,setlen2,start,stop,'\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"%d %d %c",itype,lag,'\0');
    c_ptr += strlen(c_ptr) + 1;
    if (set1 != set2) {
	  sprintf(c_ptr, "X-correlation of set %d and %d at lag %d %c", set1, set2, lag, '\0');
    } else {
	  sprintf(c_ptr, "Autocorrelation of set %d at lag %d %c", set1, lag, '\0');
    }
	
/* write out relevant data */
    compwin2_outdat(out_file,command,sizeof(command),xdata1,ydata1,setlen1);
    compwin2_outdat(out_file,NULL,0,xdata2,ydata2,setlen2);
    
/* start peak find process */
    do_process("sort_calc_xvgr", my_argv, xcor_nclient, sigchldcatcher_compwin2);
    if (out_file != NULL) free(out_file);
    return;

}

/*
 * splines
 */
static Frame spline_frame = (Frame) 0;
static Panel spline_panel;
Panel_item toggle_spline_item;
Panel_item spline_limit_item[2];
Panel_item spline_step_item;
static Notify_client  spline_nclient = (Notify_client) 111;

static void do_spline_proc();

void create_spline_frame()
{
    if (spline_frame) {
	xv_set(spline_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    spline_frame = (Frame) xv_create(main_frame, FRAME,
				     FRAME_LABEL, "Splines",
				     NULL);
    spline_panel = (Panel) xv_create(spline_frame, PANEL,
				     XV_HELP_DATA, "xvgr:spline_panel",
				     PANEL_LAYOUT, PANEL_VERTICAL,
				     NULL);
    define_select_set_panel2(spline_panel, toggle_spline_item, "Select set:");
    xv_set(toggle_spline_item, PANEL_VALUE_X, xv_col(spline_panel, 15), NULL);
    spline_limit_item[0] = xv_create(spline_panel, PANEL_TEXT,
				  XV_HELP_DATA, "xvgr:spline_start",
				  PANEL_LABEL_STRING, "Start:",
				  PANEL_VALUE_DISPLAY_LENGTH, 15,
				  PANEL_VALUE_X, xv_col(spline_panel, 15),
				  NULL);
    spline_limit_item[1] = xv_create(spline_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:spline_stop",
				 PANEL_LABEL_STRING, "Stop:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(spline_panel, 15),
				 NULL);
    spline_step_item = xv_create(spline_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:spline_nsteps",
				 PANEL_LABEL_STRING, "N steps:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(spline_panel, 15),
				 NULL);

    (void) xv_create(spline_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:spline_apply",
		     PANEL_LABEL_STRING, "Apply",
		     PANEL_NOTIFY_PROC, do_spline_proc,
		     XV_X, xv_col(spline_panel, 2),
		     XV_Y, xv_row(spline_panel, 5),
		     NULL);

    (void) xv_create(spline_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:spline_done",
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, spline_frame,
		     XV_X, xv_col(spline_panel, 12),
		     XV_Y, xv_row(spline_panel, 5),
		     NULL);
    (void) xv_create(spline_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:spline_tag",
		     PANEL_LABEL_STRING, "Tags",
		     PANEL_NOTIFY_PROC, do_generic_tags,
		     XV_KEY_DATA, TAGS_KEY, spline_limit_item,
		     XV_X, xv_col(spline_panel, 22),
		     XV_Y, xv_row(spline_panel, 5),
		     NULL);
    window_fit(spline_panel);
    window_fit(spline_frame);
    xv_set(spline_frame, WIN_SHOW, TRUE, NULL);
}
/* ARGSUSED */
static void do_spline_proc(item, event)
    Panel_item item;
    Event *event;
{
    int set, step, setlen;
    double start, stop, *xdata, *ydata;
    char *out_file, command[BUFSIZ];
    char *c_ptr = command;
    
    set = (int) xv_get(toggle_spline_item, PANEL_VALUE);
    if ( (setlen = check_set_len(set,3)) < 0)
	  return;

    if ( check_set_parameters(set, spline_limit_item, &start, &stop) < 0)
	  return;
    
/* get pointers to data fields */
    xdata = getx(cg, set);
    ydata = gety(cg, set);

    step = atoi((char *) xv_get(spline_step_item, PANEL_VALUE));
    if (step <= 1) {
	errwin("Number of steps must be > 1");
	return;
    }
    
/* fill argument vector my_argv with name of dat file*/
    my_argv[2] = (out_file = tempnam(NULL,"SORT_"));

/* setup command string */
    (void) memset(command,0,sizeof(command));
    sprintf(command,"%d %d %d %g %g %c",CALC_SPLINE,setlen,0,start,stop,'\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"%d %d %d %c",step,(int) start, (int) stop, '\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"Spline fit from set %d %c", set, '\0');

/* write out relevant data */
    compwin2_outdat(out_file,command,sizeof(command),xdata,ydata,setlen);
    
/* start peak find process */
    do_process("sort_calc_xvgr", my_argv, spline_nclient, sigchldcatcher_compwin2);
    if (out_file != NULL) free(out_file);
    return;
    
}


/* sample a set */
static Frame samp_frame = (Frame) 0;
static Panel samp_panel;
static Panel_item toggle_set_sample_item;
static Panel_item sample_limit_item[2];
static Panel_item sample_step_item;
static Panel_item sample_type_item;
static Panel_item sample_expr_item;
static Notify_client  samp_nclient = (Notify_client) 112;

/*
 * service the type cycle for sample
 */
static void do_sample_type_proc()
{
    int itype;

    itype = (int) xv_get(sample_type_item, PANEL_VALUE);
/*    xv_set(sample_limit_item[0], XV_SHOW, !itype, 0);
    xv_set(sample_limit_item[1], XV_SHOW, !itype, 0); */
    xv_set(sample_step_item, XV_SHOW, !itype, 0);
    xv_set(sample_expr_item, XV_SHOW, itype, 0);
    panel_paint(sample_limit_item[0], PANEL_CLEAR);
    panel_paint(sample_limit_item[1], PANEL_CLEAR);
    panel_paint(sample_step_item, PANEL_CLEAR);
    panel_paint(sample_expr_item, PANEL_CLEAR);
}

void create_samp_frame()
{
    static void do_sample_proc();
    static void do_sample_type_proc();

    if (samp_frame) {
	xv_set(samp_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    samp_frame = (Frame) xv_create(main_frame, FRAME,
				   FRAME_LABEL, "Sample",
				   NULL);
    samp_panel = (Panel) xv_create(samp_frame, PANEL,
				   XV_HELP_DATA, "xvgr:samp_panel",
				   PANEL_LAYOUT, PANEL_VERTICAL,
				   NULL);
    define_select_set_panel2(samp_panel, toggle_set_sample_item, "Select set:");
    xv_set(toggle_set_sample_item, PANEL_VALUE_X, xv_col(samp_panel, 13), NULL);
    sample_limit_item[0] = xv_create(samp_panel, PANEL_TEXT,
				  XV_HELP_DATA, "xvgr:samp_start",
				  PANEL_LABEL_STRING, "Start:",
				  PANEL_VALUE_DISPLAY_LENGTH, 15,
				  PANEL_VALUE_X, xv_col(samp_panel, 13),
				  NULL);
    sample_limit_item[1] = xv_create(samp_panel, PANEL_TEXT,
				  XV_HELP_DATA, "xvgr:samp_start",
				  PANEL_LABEL_STRING, "Stop:",
				  PANEL_VALUE_DISPLAY_LENGTH, 15,
				  PANEL_VALUE_X, xv_col(samp_panel, 13),
				  NULL);
    sample_step_item = xv_create(samp_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:samp_step",
				 PANEL_LABEL_STRING, "Step:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(samp_panel, 13),
				 NULL);
    sample_expr_item = xv_create(samp_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:samp_expr",
				 PANEL_LABEL_STRING, "Expr:",
				 PANEL_VALUE_DISPLAY_LENGTH, 25,
				 PANEL_VALUE_X, xv_col(samp_panel, 13),
				 NULL);
    sample_type_item = xv_create(samp_panel, PANEL_CYCLE,
				 XV_HELP_DATA, "xvgr:samp_type",
				 PANEL_LABEL_STRING, "Type:",
				 PANEL_CHOICE_STRINGS,
				 "Start/step",
				 "Logical expression",
				 NULL,
				 PANEL_NOTIFY_PROC, do_sample_type_proc,
				 PANEL_VALUE_X, xv_col(samp_panel, 13),
				 NULL);
    (void) xv_create(samp_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:samp_apply",
		     PANEL_LABEL_STRING, "Apply",
		     PANEL_NOTIFY_PROC, do_sample_proc,
		     XV_X, xv_col(samp_panel, 5),
		     XV_Y, xv_row(samp_panel, 6),
		     NULL);

    (void) xv_create(samp_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:samp_done",
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, samp_frame,
		     XV_X, xv_col(samp_panel, 15),
		     XV_Y, xv_row(samp_panel, 6),
		     NULL);
     (void) xv_create(samp_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:samp_tags",
		     PANEL_LABEL_STRING, "Tags",
		     PANEL_NOTIFY_PROC, do_generic_tags,
		     XV_KEY_DATA, TAGS_KEY, sample_limit_item,
		     XV_X, xv_col(samp_panel, 25),
		     XV_Y, xv_row(samp_panel, 6),
		     NULL);
    window_fit(samp_panel);
    window_fit(samp_frame);
    do_sample_type_proc();
    xv_set(samp_frame, WIN_SHOW, TRUE, NULL);
}
/*
 * sample a set, by start/step or logical expression
 */
/* ARGSUSED */
static void do_sample_proc(item, event)
    Panel_item item;
    Event *event;
{
    int set, setlen, typeno;
    char exprstr[256];
    int stepno;
    double start, stop, *xdata, *ydata;
    char *out_file, command[BUFSIZ];
    char *c_ptr = command;

    set = (int) xv_get(toggle_set_sample_item, PANEL_VALUE);
    typeno = (int) xv_get(sample_type_item, PANEL_VALUE);
    strcpy(exprstr, (char *) xv_get(sample_expr_item, PANEL_VALUE));
    stepno = atoi((char *) xv_get(sample_step_item, PANEL_VALUE));
    start = atof((char *) xv_get(sample_limit_item[0], PANEL_VALUE));
    stop = atof((char *) xv_get(sample_limit_item[1], PANEL_VALUE));

    if ( (setlen = check_set_len(set,2)) < 0)
	  return;

    if (typeno == 0) {
	if (stepno < 1) {
	    errwin("Step < 1");
	    return;
	}
    }
    else {
	if (!strlen(exprstr)) {
	    errwin("Enter logical expression first");
	    return;
	}
    }

    if ( check_set_parameters(set, sample_limit_item, &start, &stop) < 0)
	  return;

/* get pointers to data fields */
    xdata = getx(cg, set);
    ydata = gety(cg, set);

/* fill argument vector my_argv with name of dat file*/
    my_argv[2] = (out_file = tempnam(NULL,"SORT_"));

/* setup command string */
    (void) memset(command,0,sizeof(command));
    sprintf(command,"%d %d %d %g %g %c",CALC_SAMP,setlen,0,start,stop,'\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"%d %d %c",typeno,stepno,'\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"%s",exprstr);

/* write out relevant data */
    compwin2_outdat(out_file,command,sizeof(command),xdata,ydata,setlen);
    
/* start peak find process */
    do_process("sort_calc_xvgr", my_argv, samp_nclient, sigchldcatcher_compwin2);
    if (out_file != NULL) free(out_file);

    return;
}

/* apply a digital filter in set 2 to set 1 */
static Frame digf_frame = (Frame) 0;
static Panel digf_panel;
static Panel_item toggle_set_digf1_item;
static Panel_item toggle_set_digf2_item;
static Panel_item digf_limit_item[2];
static Notify_client  digf_nclient = (Notify_client) 115;

void create_digf_frame()
{
    static void do_digfilter_proc();

    if (digf_frame) {
	xv_set(digf_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    digf_frame = (Frame) xv_create(main_frame, FRAME,
				   FRAME_LABEL, "Digital filter",
				   NULL);
    digf_panel = (Panel) xv_create(digf_frame, PANEL,
				   PANEL_LAYOUT, PANEL_VERTICAL,
				   NULL);
    define_select_set_panel2(digf_panel, toggle_set_digf1_item, "Select set:");
    xv_set(toggle_set_digf1_item, PANEL_VALUE_X, xv_col(digf_panel, 18), NULL);
    define_select_set_panel2(digf_panel, toggle_set_digf2_item, "Weights from set:");
    xv_set(toggle_set_digf2_item, PANEL_VALUE_X, xv_col(digf_panel, 18), NULL);

    digf_limit_item[0] = xv_create(digf_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:digf_minx",
				 PANEL_LABEL_STRING, "Start:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(digf_panel, 15),
				 NULL);
    digf_limit_item[1] = xv_create(digf_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:digf_maxx",
				 PANEL_LABEL_STRING, "Stop:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(digf_panel, 15),
				 NULL);
    (void) xv_create(digf_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Apply",
		     PANEL_NOTIFY_PROC, do_digfilter_proc,
		     XV_X, xv_col(digf_panel, 5),
		     XV_Y, xv_row(digf_panel, 5),
		     NULL);

    (void) xv_create(digf_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, digf_frame,
		     XV_X, xv_col(digf_panel, 15),
		     XV_Y, xv_row(digf_panel, 5),
		     NULL);
        (void) xv_create(digf_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Tags",
		     PANEL_NOTIFY_PROC, do_generic_tags,
		     XV_KEY_DATA, TAGS_KEY, digf_limit_item,
		     XV_X, xv_col(digf_panel, 25),
		     XV_Y, xv_row(digf_panel, 5),
		     NULL);
    window_fit(digf_panel);
    window_fit(digf_frame);
    xv_set(digf_frame, WIN_SHOW, TRUE, NULL);
}
/*
 * apply a digital filter
 */
/* ARGSUSED */
static void do_digfilter_proc(item, event)
    Panel_item item;
    Event *event;
{
    int set1, set2, setlen1, setlen2;
    double start=0, stop=0;
    double *xdata1, *ydata1, *xdata2, *ydata2;
    char *out_file, command[BUFSIZ];
    char *c_ptr = command;

    set1 = (int) xv_get(toggle_set_digf1_item, PANEL_VALUE);
    set2 = (int) xv_get(toggle_set_digf2_item, PANEL_VALUE);
    if ( (setlen1 = check_set_len(set1,3)) < 0)
	  return;
    if ( (setlen2 = check_set_len(set2,3)) < 0)
	  return;
    if ( check_set_parameters(set1, digf_limit_item, &start, &stop) < 0)
	  return;
 
/* get pointers to data fields */
    xdata1 = getx(cg, set1);
    ydata1 = gety(cg, set1);
    xdata2 = getx(cg, set2);
    ydata2 = gety(cg, set2);

/* fill argument vector my_argv with name of dat file*/
    my_argv[2] = (out_file = tempnam(NULL,"SORT_"));

/* setup command string */
    (void) memset(command,0,sizeof(command));
    sprintf(command,"%d %d %d %g %g %c",CALC_DIGF,setlen1,setlen2,start,stop,'\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"Digital filter from set %d applied to set %d %c", set2, set1, '\0');
    
/* write out relevant data */
    compwin2_outdat(out_file,command,sizeof(command),xdata1,ydata1,setlen1);
    compwin2_outdat(out_file,NULL,0,xdata2,ydata2,setlen2);
    
/* start peak find process */
    do_process("sort_calc_xvgr", my_argv, digf_nclient, sigchldcatcher_compwin2);
    if (out_file != NULL) free(out_file);
    return;

}

/* linear convolution */
static Frame lconv_frame = (Frame) 0;
static Panel lconv_panel;
static Panel_item toggle_set_linc1_item;
static Panel_item toggle_set_linc2_item;
static Panel_item lconv_limit_item[2];
static Notify_client  lconv_nclient = (Notify_client) 116;

void create_lconv_frame()
{
    static void do_linearc_proc();

    if (lconv_frame) {
	xv_set(lconv_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    lconv_frame = (Frame) xv_create(main_frame, FRAME,
				    FRAME_LABEL, "Linear convolution",
				    NULL);
    lconv_panel = (Panel) xv_create(lconv_frame, PANEL,
				    PANEL_LAYOUT, PANEL_VERTICAL,
				    NULL);
    define_select_set_panel2(lconv_panel, toggle_set_linc1_item, "Select set:");
    xv_set(toggle_set_linc1_item, PANEL_VALUE_X, xv_col(lconv_panel, 20), NULL);
    define_select_set_panel2(lconv_panel, toggle_set_linc2_item, "Convolve with set:");
    xv_set(toggle_set_linc2_item, PANEL_VALUE_X, xv_col(lconv_panel, 20), NULL);
    lconv_limit_item[0] = xv_create(lconv_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:lconv_minx",
				 PANEL_LABEL_STRING, "Start:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(lconv_panel, 10),
				 XV_Y, xv_row(lconv_panel, 2),  
				 NULL);
    lconv_limit_item[1] = xv_create(lconv_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:lconv_maxx",
				 PANEL_LABEL_STRING, "Stop:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(lconv_panel, 10),
				 XV_Y, xv_row(lconv_panel, 3), 
				 NULL);
    (void) xv_create(lconv_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Apply",
		     PANEL_NOTIFY_PROC, do_linearc_proc,
		     XV_X, xv_col(lconv_panel, 3),
		     XV_Y, xv_row(lconv_panel, 5),
		     NULL);

    (void) xv_create(lconv_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, lconv_frame,
		     XV_X, xv_col(lconv_panel, 13),
		     XV_Y, xv_row(lconv_panel, 5),
		     NULL);
        (void) xv_create(lconv_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Tags",
		     PANEL_NOTIFY_PROC, do_generic_tags,
		     XV_KEY_DATA, TAGS_KEY, lconv_limit_item,
		     XV_X, xv_col(lconv_panel, 23),
		     XV_Y, xv_row(lconv_panel, 5),
		     NULL);
    window_fit(lconv_panel);
    window_fit(lconv_frame);
    xv_set(lconv_frame, WIN_SHOW, TRUE, NULL);
}
/*
 * linear convolution
 */
/* ARGSUSED */
static void do_linearc_proc(item, event)
    Panel_item item;
    Event *event;
{
      int set1, set2, setlen1, setlen2;
      double start=0, stop=0;
      double *xdata1, *ydata1, *xdata2, *ydata2;
      char *out_file, command[BUFSIZ];
      char *c_ptr = command;

      set1 = (int) xv_get(toggle_set_linc1_item, PANEL_VALUE);
      set2 = (int) xv_get(toggle_set_linc2_item, PANEL_VALUE);
      if ( (setlen1 = check_set_len(set1,3)) < 0)
	    return;
      if ( (setlen2 = check_set_len(set2,3)) < 0)
	    return;
      if ( check_set_parameters(set1, lconv_limit_item, &start, &stop) < 0)
	  return;

/* get pointers to data fields */
      xdata1 = getx(cg, set1);
      ydata1 = gety(cg, set1);
      xdata2 = getx(cg, set2);
      ydata2 = gety(cg, set2);

/* fill argument vector my_argv with name of dat file*/
      my_argv[2] = (out_file = tempnam(NULL,"SORT_"));
      
/* setup command string */
      (void) memset(command,0,sizeof(command));
      sprintf(command,"%d %d %d %g %g %c",CALC_LCONV,setlen1,setlen2,start,stop,'\0');
      c_ptr += strlen(c_ptr) + 1;
      sprintf(c_ptr, "Linear convolution of set %d with set %d %c", set1, set2, '\0');
      
/* write out relevant data */
      compwin2_outdat(out_file,command,sizeof(command),xdata1,ydata1,setlen1);
      compwin2_outdat(out_file,NULL,0,xdata2,ydata2,setlen2);
    
/* start peak find process */
      do_process("sort_calc_xvgr", my_argv, lconv_nclient, sigchldcatcher_compwin2);
      if (out_file != NULL) free(out_file);
      return;
}


/* evaluate a formula - load the next set */
static Frame leval_frame = (Frame) 0;
static Panel leval_panel;
static Panel_item compute_formulax_item;
static Panel_item compute_formulay_item;
static Panel_item load_start2_item;
static Panel_item load_stop2_item;
static Panel_item load_npts_item;
static Panel_item load_to2_item;

void create_leval_frame()
{
    static void do_compute_proc2();

    if (leval_frame) {
	xv_set(leval_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    leval_frame = (Frame) xv_create(main_frame, FRAME,
				    FRAME_LABEL, "Load & eval",
				    NULL);
    leval_panel = (Panel) xv_create(leval_frame, PANEL,
				    XV_HELP_DATA, "xvgr:leval_panel",
				    PANEL_LAYOUT, PANEL_VERTICAL,
				    NULL);
    compute_formulax_item = xv_create(leval_panel, PANEL_TEXT,
				      XV_HELP_DATA, "xvgr:leval_fx",
				      PANEL_LABEL_STRING, "Fx: ",
				      PANEL_VALUE_DISPLAY_LENGTH, 25,
				      PANEL_VALUE_X, xv_col(leval_panel, 15),
				      NULL);
    compute_formulay_item = xv_create(leval_panel, PANEL_TEXT,
				      XV_HELP_DATA, "xvgr:leval_fy",
				      PANEL_LABEL_STRING, "Fy: ",
				      PANEL_VALUE_DISPLAY_LENGTH, 25,
				      PANEL_VALUE_X, xv_col(leval_panel, 15),
				      NULL);
    load_to2_item = xv_create(leval_panel, PANEL_CYCLE,
			      XV_HELP_DATA, "xvgr:leval_to",
			      PANEL_LABEL_STRING, "To:",
			      PANEL_CHOICE_STRINGS,
			      "X",
			      "Y",
			      "Scratch array A",
			      "Scratch array B",
			      "Scratch array C",
			      "Scratch array D", NULL,
			      PANEL_VALUE_X, xv_col(leval_panel, 15),
			      NULL);
    load_start2_item = xv_create(leval_panel, PANEL_TEXT,
				 XV_HELP_DATA, "xvgr:leval_start",
				 PANEL_LABEL_STRING, "Start:",
				 PANEL_VALUE_DISPLAY_LENGTH, 15,
				 PANEL_VALUE_X, xv_col(leval_panel, 15),
				 NULL);
    load_stop2_item = xv_create(leval_panel, PANEL_TEXT,
				XV_HELP_DATA, "xvgr:leval_stop",
				PANEL_LABEL_STRING, "Stop:",
				PANEL_VALUE_DISPLAY_LENGTH, 15,
				PANEL_VALUE_X, xv_col(leval_panel, 15),
				NULL);
    load_npts_item = xv_create(leval_panel, PANEL_TEXT,
			       XV_HELP_DATA, "xvgr:leval_npts",
			       PANEL_LABEL_STRING, "# of pts:",
			       PANEL_VALUE_DISPLAY_LENGTH, 15,
			       PANEL_VALUE_X, xv_col(leval_panel, 15),
			       NULL);
    xv_create(leval_panel, PANEL_BUTTON,
	      PANEL_LABEL_STRING, "Apply",
	      PANEL_NOTIFY_PROC, do_compute_proc2,
	      XV_X, xv_col(leval_panel, 5),
	      XV_Y, xv_row(leval_panel, 6),
	      NULL);

    (void) xv_create(leval_panel, PANEL_BUTTON,
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, leval_frame,
		     XV_X, xv_col(leval_panel, 15),
		     XV_Y, xv_row(leval_panel, 6),
		     NULL);
    window_fit(leval_panel);
    window_fit(leval_frame);
    xv_set(leval_frame, WIN_SHOW, TRUE, NULL);
}
/*
 * evaluate a formula loading the next set
 */
/* ARGSUSED */
static void do_compute_proc2(item, event)
    Panel_item item;
    Event *event;
{
/*    int npts, toval; */
    char fstrx[256], fstry[256];
    char startstr[256], stopstr[256];

/*    npts = atoi((char *) xv_get(load_npts_item, PANEL_VALUE)); */
    strcpy(fstrx, (char *) xv_get(compute_formulax_item, PANEL_VALUE));
    strcpy(fstry, (char *) xv_get(compute_formulay_item, PANEL_VALUE));
    strcpy(startstr, (char *) xv_get(load_start2_item, PANEL_VALUE));
    strcpy(stopstr, (char *) xv_get(load_stop2_item, PANEL_VALUE));
/*    toval = (int) xv_get(load_to2_item, PANEL_VALUE) + 1; */
/*    do_compute2(fstrx, fstry, startstr, stopstr, npts, toval); */
}

/*
 *  from orginal xvgr source nonlwin.c
 *  non linear curve fitting
 *
 */

/*
info = 0  improper input parameters.
info = 1  algorithm estimates that the relative error in the sum of squares is at most tol.
info = 2  algorithm estimates that the relative error between x and the solution is at most tol.
info = 3  conditions for info = 1 and info = 2 both hold.
info = 4  fvec is orthogonal to the columns of the jacobian to machine precision.
info = 5  number of calls to fcn has reached or exceeded 200*(n+1).
info = 6  tol is too small. no further reduction in the sum of squares is possible.
info = 7  tol is too small. no further improvement in the approximate solution x is possible.
*/
char *info_strings[] = {
    "Improper input parameters.",
    "Relative error in the sum of squares is at most tol.",
    "Relative error between A and the solution is at most tol.",
    "Relative error in the sum of squares and A and the solution is at most tol.",
    "Fvec is orthogonal to the columns of the jacobian to machine precision.",
    "Number of calls to fcn has reached or exceeded 200*(n+1).",
    "Tol is too small. No further reduction in the sum of squares is possible.",
    "Tol is too small. No further improvement in the approximate solution A is possible."
};

double nonl_parms[10]; /* was external and declared in pars.c */

void create_nonl_frame();

#define MAXPARM 10

static Frame nonl_frame = (Frame) 0;
static Panel nonl_panel;
static Panel_item nonl_formula_item;
static Panel_item nonl_set_item;
static Panel_item nonl_load_item;
static Panel_item nonl_limit_item[2];
static Panel_item nonl_loadgraph_item;
static Panel_item nonl_initial_item[MAXPARM];
static Panel_item nonl_computed_item[MAXPARM];
static Panel_item nonl_tol_item;
static Panel_item nonl_info_item;
static Panel_item nonl_nparm_item;
static void do_nonl_proc();
static Notify_client  nonl_nclient = (Notify_client) 118;

void create_nonl_frame()
{
    int i;

    if (nonl_frame) {
	xv_set(nonl_frame, WIN_SHOW, TRUE, FRAME_CLOSED, FALSE, NULL);
	return;
    }
    nonl_frame = (Frame) xv_create(main_frame, FRAME,
				   FRAME_LABEL, "Non-linear curve fitting",
				   NULL);
    nonl_panel = (Panel) xv_create(nonl_frame, PANEL,
				   XV_HELP_DATA, "xvgr:nonl_panel",
				   PANEL_LAYOUT, PANEL_VERTICAL,
				   NULL);
    define_select_set_panel3(nonl_panel, nonl_set_item);
    xv_set(nonl_set_item, PANEL_VALUE_X, xv_col(nonl_panel, 20), NULL);
    nonl_load_item = (Panel_item) xv_create(nonl_panel, PANEL_CYCLE,
					    XV_HELP_DATA, "xvgr:nonl_load",
					    PANEL_LABEL_STRING, "Load:",
					    PANEL_CHOICE_STRINGS,
					    "Fitted values",
					    "Residuals",
					    "None",
					    NULL,
				      PANEL_VALUE_X, xv_col(nonl_panel, 20),
					    NULL);
    nonl_loadgraph_item = (Panel_item) xv_create(nonl_panel, PANEL_CHOICE_STACK,
				    XV_HELP_DATA, "xvgr:nonl_resulttograph",
					    PANEL_LABEL_STRING, "To graph:",
						 PANEL_CHOICE_STRINGS,
						 "Current",
			   "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
						 NULL,
				      PANEL_VALUE_X, xv_col(nonl_panel, 20),
						 NULL);
    nonl_formula_item = (Panel_item) xv_create(nonl_panel, PANEL_TEXT,
					  XV_HELP_DATA, "xvgr:nonl_formula",
					    PANEL_LABEL_STRING, "Function:",
					     PANEL_VALUE_DISPLAY_LENGTH, 35,
					       PANEL_VALUE, "y = ",
				      PANEL_VALUE_X, xv_col(nonl_panel, 10),
					       0);
    nonl_nparm_item = (Panel_item) xv_create(nonl_panel, PANEL_NUMERIC_TEXT,
					     XV_HELP_DATA, "xvgr:nonl_nparm",
				     PANEL_LABEL_STRING, "# of parameters:",
					     PANEL_VALUE_DISPLAY_LENGTH, 4,
					     PANEL_MIN_VALUE, 1,
					     PANEL_MAX_VALUE, 10,
				      PANEL_VALUE_X, xv_col(nonl_panel, 20),
					     NULL);
    nonl_tol_item = (Panel_item) xv_create(nonl_panel, PANEL_TEXT,
					   XV_HELP_DATA, "xvgr:nonl_tol",
					   PANEL_LABEL_STRING, "Tolerance:",
					   PANEL_VALUE_DISPLAY_LENGTH, 20,
					   PANEL_VALUE, "1e-7",
				      PANEL_VALUE_X, xv_col(nonl_panel, 20),
					   0);
    nonl_limit_item[0] = (Panel_item) xv_create(nonl_panel, PANEL_TEXT,
					   XV_HELP_DATA, "xvgr:nonl_start",
					   PANEL_LABEL_STRING, "Start:",
					   PANEL_VALUE_DISPLAY_LENGTH, 12,
					   PANEL_VALUE_X, xv_col(nonl_panel, 7),
					   XV_Y, xv_row(nonl_panel, 6),
					   0);
    nonl_limit_item[1] = (Panel_item) xv_create(nonl_panel, PANEL_TEXT,
					   XV_HELP_DATA, "xvgr:nonl_stop",
					   PANEL_LABEL_STRING, "Stop:",
					   PANEL_VALUE_DISPLAY_LENGTH, 12,
					   PANEL_VALUE_X, xv_col(nonl_panel, 28),
					   XV_Y, xv_row(nonl_panel, 6),
					   0);

    (void) xv_create(nonl_panel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "Initial guess",
		     XV_X, xv_col(nonl_panel, 5),
		     XV_Y, xv_row(nonl_panel, 7),
		     NULL);
    (void) xv_create(nonl_panel, PANEL_MESSAGE,
		     PANEL_LABEL_STRING, "Computed values",
		     XV_X, xv_col(nonl_panel, 25),
		     XV_Y, xv_row(nonl_panel, 7),
		     NULL);

    for (i = 0; i < MAXPARM; i++) {
	sprintf(buf, "A%1d: ", i);
	nonl_initial_item[i] = (Panel_item) xv_create(nonl_panel, PANEL_TEXT,
					 XV_HELP_DATA, "xvgr:nonl_initparm",
						    PANEL_LABEL_STRING, buf,
					     PANEL_VALUE_DISPLAY_LENGTH, 15,
						      PANEL_VALUE, "0.0",
						XV_X, xv_col(nonl_panel, 1),
					    XV_Y, xv_row(nonl_panel, 8 + i),
						      0);
    }
    for (i = 0; i < MAXPARM; i++) {
	nonl_computed_item[i] = (Panel_item) xv_create(nonl_panel, PANEL_TEXT,
					 XV_HELP_DATA, "xvgr:nonl_compparm",
					     PANEL_VALUE_DISPLAY_LENGTH, 15,
					       XV_X, xv_col(nonl_panel, 25),
					    XV_Y, xv_row(nonl_panel, 8 + i),
						       0);
    }
    nonl_info_item = (Panel_item) xv_create(nonl_panel, PANEL_MESSAGE,
					    PANEL_LABEL_STRING, "Info: None",
					    XV_X, xv_col(nonl_panel, 1),
					    XV_Y, xv_row(nonl_panel, 19),
					    NULL);
    (void) xv_create(nonl_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:nonl_apply",
		     PANEL_LABEL_STRING, "Apply",
		     PANEL_NOTIFY_PROC, do_nonl_proc,
		     XV_X, xv_col(nonl_panel, 5),
		     XV_Y, xv_row(nonl_panel, 20),
		     0);
    (void) xv_create(nonl_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:nonl_done",
		     PANEL_LABEL_STRING, "Done",
		     PANEL_NOTIFY_PROC, generic_done_proc,
		     XV_KEY_DATA, FRAME_KEY, nonl_frame,
		     XV_X, xv_col(nonl_panel, 20),
		     XV_Y, xv_row(nonl_panel, 20),
		     NULL);
    (void) xv_create(nonl_panel, PANEL_BUTTON,
		     XV_HELP_DATA, "xvgr:nonl_tags",
		     PANEL_LABEL_STRING, "Tags",
		     PANEL_NOTIFY_PROC, do_generic_tags,
		     XV_KEY_DATA, TAGS_KEY, nonl_limit_item,
		     XV_X, xv_col(nonl_panel, 35),
		     XV_Y, xv_row(nonl_panel, 20),
		     NULL);
    window_fit(nonl_panel);
    window_fit(nonl_frame);
    xv_set(nonl_frame, WIN_SHOW, TRUE, NULL);
}

void update_nonl()
{
}

/* ARGSUSED */
static void do_nonl_proc(item, event)
    Panel_item item;
    Event *event;
{
    int i, set, setlen, loadto, graphto, npar;
    double tol = 1e-7, a[MAXPARM];
    double start, stop, *xdata, *ydata;
    char *out_file, command[BUFSIZ];
    char *c_ptr = command;
    char fstr[256];
 
    set = (int) xv_get(nonl_set_item, PANEL_VALUE);
    loadto = (int) xv_get(nonl_load_item, PANEL_VALUE);
    graphto = (int) xv_get(nonl_loadgraph_item, PANEL_VALUE) - 1;
    npar = (int) xv_get(nonl_nparm_item, PANEL_VALUE);
    strcpy(fstr, (char *) xv_get(nonl_formula_item, PANEL_VALUE));
    for (i = 0; i < MAXPARM; i++) {
	a[i] = 0.0;
	strcpy(buf,(char *) xv_get(nonl_initial_item[i], PANEL_VALUE));
	sscanf(buf, "%lf", &a[i]);
    }

    if ( (setlen = check_set_len(set,3)) < 0)
	  return;
    if (graphto < 0) {
	graphto = cg;
    }
    if ( check_set_parameters(set, nonl_limit_item, &start, &stop) < 0)
	  return;

    if ( strlen(fstr) <= 3 || strcmp(fstr,"y = ") == 0) {
	  errwin("function not specified");
	  return;
    }
    
/* get pointers to data fields */
    xdata = getx(cg, set);
    ydata = gety(cg, set);

/* fill argument vector my_argv with name of dat file*/
    my_argv[2] = (out_file = tempnam(NULL,"SORT_"));

/* setup command string */
    (void) memset(command,0,sizeof(command));
    sprintf(command,"%d %d %d %g %g %c",CALC_NONL,setlen,0,start,stop,'\0');
    c_ptr += strlen(c_ptr) + 1;
    sprintf(c_ptr,"%g %d %d %d %d %c",tol,npar,loadto,graphto,MAXPARM,'\0');
    c_ptr += strlen(c_ptr) + 1;
    for (i = 0; i < MAXPARM; i++) {
	  sprintf(c_ptr,"%g ",a[i]);
	  c_ptr += strlen(c_ptr);
    }
    sprintf(c_ptr,"%c %s",'\0',fstr);

/* write out relevant data */
    compwin2_outdat(out_file,command,sizeof(command),xdata,ydata,setlen);
    
/* start peak find process */
    do_process("sort_calc_xvgr", my_argv, nonl_nclient, sigchldcatcher_compwin2);
    xv_set(nonl_info_item, PANEL_LABEL_STRING, "fit in progress", NULL);

    if (out_file != NULL) free(out_file);
    return;
}
int nonl_fit(data, graphto)
      char *data;
      int  *graphto;
{
      int info, maxparm, i, load;
      char *ptr= data;

      sscanf(data,"%d %d %d %d",&info,&load,graphto,&maxparm);
      ptr += strlen(ptr) + 1;
      {
	    char a_str[BUFSIZ];
	    for (i=0; i<maxparm && i<MAXPARM; i++) {
		  sscanf(ptr,"%s",a_str);
		  ptr += strlen(a_str) + 1;
		  xv_set(nonl_computed_item[i], PANEL_VALUE, a_str, NULL);
	    }
      }

      if (info >= 0 && info <= 7) {
	    xv_set(nonl_info_item, PANEL_LABEL_STRING, info_strings[info], NULL);
      }
      return(0);
}

/*ARGSUSED*/
Notify_value
sigchldcatcher_compwin2(nclient, pid, status, rusage)
      Notify_client   nclient;
      int             pid;
#ifdef SVR4
      int             *status;
#else
      union wait      *status;
#endif
      struct rusage   *rusage;
{
      if (debuglevel == 2)
	    fprintf(stderr,"sigchldcatcher_compwin2 called for client %d\n",nclient);
      if (WIFEXITED(*status)) {
	    if (WEXITSTATUS(*status)) {
		  sprintf(buf,"calculation2 returned non zero exit status");
		  errwin(buf);
		  return NOTIFY_DONE;
	    }
	    apply_calc_results(nclient, pid);
	    return NOTIFY_DONE;
      }
      sprintf(buf,"SIGCHLD from child process  %d not handled",pid);
      errwin(buf);
      return NOTIFY_IGNORED;
}

static void
apply_calc_results(nclient, pid)
      Notify_client   nclient;
      int pid;
{
      FILE *fp;
      int setlen;
      char in_file[L_tmpnam+24];
      double *xdata, *ydata;
      char comm_buf[BUFSIZ], *ptr = comm_buf;

      sprintf(in_file,"%sCALC_XVGR_%d",P_tmpdir,pid);
      if ( (fp = fopen(in_file,"r")) == NULL) {
	    errwin("failed to open xvgr calculation output file");
	    return;
      }
      if ( fread((char *) comm_buf, BUFSIZ, 1, fp) != 1) {
	    fprintf(stderr,"Read from xvgr data file failed");
	    return;
      }

      sscanf(comm_buf,"%d",&setlen);   /* read data length */
      ptr += strlen(ptr) + 1;          /* skip ptr to start of next field */
      strncpy(buf,ptr,1023);           /* copy into buf string data */
      ptr += strlen(ptr) + 1;          /* skip ptr to start of ancillary data (if any) */
      
/* allocate storage and read in results */
      xdata = (double *) calloc(setlen, sizeof(double));
      ydata = (double *) calloc(setlen, sizeof(double));
      if (xdata == NULL || ydata == NULL) {
	    errwin("failed to allocate enough memory in xvgr calculation");
	    cxfree(xdata);
	    cxfree(ydata);
	    return;
      }
/* read in results */      
      if(nclient==regmstick_nclient){
      		if ( fread((char *) ydata, sizeof(double), setlen, fp) != setlen) {
		   fprintf(stderr,"Read from xvgr data file failed");
	           return;
    	        }
     		if ( fread((char *) xdata, sizeof(double), setlen, fp) != setlen) {
                   fprintf(stderr,"Read from xvgr data file failed");
		   return;
                }
      }
      else{
      		if ( fread((char *) xdata, sizeof(double), setlen, fp) != setlen) {
		   fprintf(stderr,"Read from xvgr data file failed");
	           return;
    	        }
     		if ( fread((char *) ydata, sizeof(double), setlen, fp) != setlen) {
                   fprintf(stderr,"Read from xvgr data file failed");
		   return;
                }
      }

      (void) fclose(fp);
      (void) unlink(in_file);

      {
	    int graphto = cg;
	    int fit_set = -1;
	    if (nclient == nonl_nclient) {
		  nonl_fit(ptr,&graphto);
	    }
	    else if (nclient == eval_nclient) {
		  sscanf(ptr,"%d %d",&graphto,&fit_set);
		  fit_set = (graphto == cg) ? fit_set : -1;
	    }
	    if (fit_set < 0) {
		  if ((fit_set = nextset(graphto)) == -1) {
			cxfree(xdata);
			cxfree(ydata);
			errwin("no new sets currently available");
			return;
		  }
	    }
	    else
		  if (isactive(graphto,fit_set)) killset(graphto, fit_set);
	    
	    activateset(graphto,fit_set);
	    settype(graphto,fit_set,XY);
	    set_spectype(graphto,fit_set,CALC_DATA);
	    setplotcolor(graphto,fit_set,fit_set+1); 
	    setcol(graphto,xdata,fit_set,setlen,0);
	    setcol(graphto,ydata,fit_set,setlen,1);
	    updatesetminmax(graphto,fit_set);
      }
      clear_graph_viewport(cg);
      drawgraph2(cg);
      return;
}
/*
 *   write data out to file
 */
void
compwin2_outdat(out_file, command, com_size, x, y, setlen)
      char   *out_file;
      char   *command;
      double *x, *y;
      int    setlen;
      int    com_size;
{
    FILE *fp;
    if (command != NULL) {
	  if ( (fp = fopen(out_file,"w")) == NULL) {
		errwin("failed to open data file");
		return;
	  }
	  if ( fwrite(command, com_size, 1, fp) != 1) {
		errwin("Write to data file failed");
		return;
	  }
    }
    else {
	  if ( (fp = fopen(out_file,"a")) == NULL) {
		errwin("failed to open data file");
		return;
	  }
    }
    if ( fwrite((char *) x, sizeof(double), setlen, fp) != setlen) {
	  errwin("Write to data file failed");
	  return;
    }
    if ( fwrite((char *) y, sizeof(double), setlen, fp) != setlen) {
	  errwin("Write to data file failed");
	  return;
    }
    (void) fclose(fp);
}

int
check_set_parameters(set, limits_item, start, stop)
      int         set;
      Panel_item  *limits_item;
      double *start, *stop;
{
      double xmin, xmax, ymin, ymax;

/* check-get set properties */    
      getsetminmax(cg, set, &xmin, &xmax, &ymin, &ymax);
      strcpy(buf, (char *) xv_get(limits_item[0], PANEL_VALUE));
      if (strlen(buf) == 0) {
	    errwin("Start item undefined");
	    return -1;
      }
      *start = atof(buf);
      strcpy(buf, (char *) xv_get(limits_item[1], PANEL_VALUE));
      if (strlen(buf) == 0) {
	    errwin("Stop item undefined");
	    return -1;
      }
      *stop = atof(buf);
/* check limits are appropriate  */
      if ( check_limits(start,stop,xmin,xmax) <= 0)
	    return -1;

      return(0);
}

int check_set_len(set,min_points)
      int set;
      int min_points;
{
      int setlen;
      if (!isactive(cg, set)) {
	    errwin("Set not active");
	    return -1;
      }
/* check-get set properties */    
      if ((setlen = getsetlength(cg, set)) < min_points) {
	    errwin("Improper set length");
	    return -1;
      }
      return(setlen);
}
