#include <stdio.h>
#include <math.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/canvas.h>
#include <xview/xv_xrect.h>
#include <xview/cms.h>
#include "spec_ui.h"
#include "spec_stubs.h"
#include "3d_ui.h"
#include "3d_redraw.h"

void forceRedraw3d(void);

double az = 30.0*M_PI/180, el = 50.0*M_PI/180;
int fl = 0, ce = 1<<30;
float data[MAXSPECX][MAXSPECY];
int dragging = 0;
int recalculatePending = 1;
extern unsigned char spec2dcontour[MAXSPECX][MAXSPECY];
int drawn = 0;
int minx_3d, maxx_3d, miny_3d, maxy_3d;

void setAzimuth(Panel_item item, int value, Event *event)
{
    static int oldvalue = -1;
    
    dragging = (value != xv_get(item, PANEL_VALUE) ||
		event_id(event) == LOC_DRAG);
/*
    fprintf(stderr, "setAzimuth: %d %d %d %d %d\n", value, oldvalue,
	    xv_get(item, PANEL_VALUE), event_id(event), event_action(event));
 */
    if (dragging && value == oldvalue)
	return;
    oldvalue = value;
    az = value*M_PI/180;
    forceRedraw3d();
}

void setElevation(Panel_item item, int value, Event *event)
{
    static int oldvalue = -1;

    dragging = (value != xv_get(item, PANEL_VALUE) ||
		event_id(event) == LOC_DRAG);
    if (dragging && value == oldvalue)
	return;
    oldvalue = value;
    el = value*M_PI/180;
    forceRedraw3d();
}

void setFloor(Panel_item item, int value, Event *event)
{
    static int oldvalue = -1;
    
    dragging = (value != xv_get(item, PANEL_VALUE) ||
		event_id(event) == LOC_DRAG);
/*
    fprintf(stderr, "setAzimuth: %d %d %d %d %d\n", value, oldvalue,
	    xv_get(item, PANEL_VALUE), event_id(event), event_action(event));
 */
    if (dragging && value == oldvalue)
	return;
    oldvalue = value;
    fl = value;
    recalculatePending = 1;
    if (fl < specMax)
	xv_set(Spec_3dwindow->ceiling, PANEL_MIN_VALUE, fl,
	       PANEL_INACTIVE, FALSE, NULL);
    else
	xv_set(Spec_3dwindow->ceiling, PANEL_INACTIVE, TRUE, NULL);
    forceRedraw3d();
}

void setCeiling(Panel_item item, int value, Event *event)
{
    static int oldvalue = -1;
    
    dragging = (value != xv_get(item, PANEL_VALUE) ||
		event_id(event) == LOC_DRAG);
/*
    fprintf(stderr, "setAzimuth: %d %d %d %d %d\n", value, oldvalue,
	    xv_get(item, PANEL_VALUE), event_id(event), event_action(event));
 */
    if (dragging && value == oldvalue)
	return;
    oldvalue = value;
    ce = value;
    recalculatePending = 1;
    if (ce > 0)
	xv_set(Spec_3dwindow->floor, PANEL_MAX_VALUE, ce,
	       PANEL_INACTIVE, FALSE, NULL);
    else
	xv_set(Spec_3dwindow->floor, PANEL_INACTIVE, TRUE, NULL);
    forceRedraw3d();
}


void forceRedraw3d(void)
{
/*
    XClearArea(XV_DISPLAY_FROM_WINDOW(Spec_3dwindow->window),
               (Window) xv_get(canvas_paint_window(Spec_3dwindow->canvas),
			       XV_XID), 0, 0, 0, 0, False);
    redraw3d(
	XV_NULL,
	XV_NULL,
	(Display *) XV_DISPLAY_FROM_WINDOW(Spec_3dwindow->window),
	(Window) xv_get(canvas_paint_window(Spec_3dwindow->canvas), 
                        XV_XID),
	(Xv_xrectlist *) NULL);
*/
    if (drawn) 
    {
        drawn = 0;
        XClearArea(XV_DISPLAY_FROM_WINDOW(Spec_3dwindow->window),
                   (Window) xv_get(canvas_paint_window(Spec_3dwindow->canvas),
                                   XV_XID), 0, 0, 0, 0, True);
        XFlush(XV_DISPLAY_FROM_WINDOW(Spec_3dwindow->window));
    }
}

void show3d(Panel_item item, Event *event)
{
    xv_set(Spec_3dwindow->window, XV_SHOW, TRUE, NULL); 
    if (!drawn)
    {
	drawn = 1;
	forceRedraw3d();
    }
}

void recalculate3d(void)
{
    fl = 0;
    ce = specMax;
    xv_set(Spec_3dwindow->floor, PANEL_MAX_VALUE, ce, PANEL_VALUE, fl, NULL);
    xv_set(Spec_3dwindow->ceiling, PANEL_MIN_VALUE, fl, PANEL_MAX_VALUE,
	   specMax, PANEL_VALUE, ce, NULL);
    recalculatePending = 1;
    forceRedraw3d();
}

void doRecalculate3d(void)
{
    int x, y, f, windowing;
    double s, lf;

    switch((int) xv_get(Spec_3dwindow->area, PANEL_VALUE))
    {
    case 0:
	minx_3d = 0;
	maxx_3d = specx-1;
	miny_3d = 0;
	maxy_3d = specy-1;
	windowing = 0;
	break;
    case 1:
	for(x=0; x<specx; x++)
	    for(y=0; y<specy; y++)
		if (window[x][y])
		    goto GOT_MINX; /* break 2 */

    GOT_MINX:
	minx_3d = x;

	for(x=specx; x--; )
	    for(y=0; y<specy; y++)
		if (window[x][y])
		    goto GOT_MAXX; /* break 2 */

    GOT_MAXX:
	maxx_3d = x;


	for(y=0; y<specy; y++)
	    for(x=0; x<specx; x++)
		if (window[x][y])
		    goto GOT_MINY; /* break 2 */

    GOT_MINY:
	miny_3d = y;

	for(y=specy; y--; )
	    for(x=0; x<specx; x++)
		if (window[x][y])
		    goto GOT_MAXY; /* break 2 */

    GOT_MAXY:
	maxy_3d = y;

	if (minx_3d > maxx_3d)
	{
	    minx_3d = 0;
	    maxx_3d = specx-1;
	}

	if (miny_3d > maxy_3d)
	{
	    miny_3d = 0;
	    maxy_3d = specy-1;
	}
	windowing = 1;
	break;
    }

    switch((int) xv_get(Spec_3dwindow->verticalaxis, PANEL_VALUE))
    {
    case 0:
	if (ce == fl)
	    s = 0;
	else
	    s = 1.0/(ce - fl);
	
	for(x=0; x<specx; x++)
	    for(y=0; y<specy; y++)
		if (spec2d[x][y] < fl || spec2d[x][y] > ce ||
		    (windowing && !window[x][y]))
		    data[x][y] = -1.0;
		else
		    data[x][y] = (spec2d[x][y] - fl) * s;
	break;
    default:
	if (fl == 0)
	    f = 1;
	else
	    f = fl;
	
	lf = log((double) f);

	if (ce == f)
	    s = 0;
	else
	    s = 1.0/(log((double) ce) - lf);
	
	
	for(x=0; x<specx; x++)
	    for(y=0; y<specy; y++)
		if (spec2d[x][y] < f || spec2d[x][y] > ce ||
		    (windowing && !window[x][y]))
		    data[x][y] = -1.0;
		else
		    data[x][y] = (log((double) spec2d[x][y]) - lf) * s;
	break;
    }

    recalculatePending = 0;
}

void verticalAxis(Panel_item item, int value, Event *event)
{
    recalculatePending = 1;
    forceRedraw3d();
}

void area3d(Panel_item item, int value, Event *event)
{
    recalculatePending = 1;
    forceRedraw3d();
}

void windowChanged3d(void)
{
    if ((int) xv_get(Spec_3dwindow->area, PANEL_VALUE) > 0)
	recalculate3d();
}

