#include <stdio.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include "3d_ui.h"
#include "xv_layout.h"

spec_3dwindow_objects *spec_3dwindow_objects_initialize(
    spec_3dwindow_objects *ip, Xv_opaque owner)
{
    extern void setAzimuth();
    extern void setElevation();
    extern void setFloor();
    extern void setCeiling();
    extern void verticalAxis();
    extern void area3d();
    extern void redraw3d();
    extern void resize3d();
    extern void showPrint();

    int x, y;

    if (ip)
	return ip;

    if (!(ip = (spec_3dwindow_objects *)
	  calloc(1, sizeof (spec_3dwindow_objects))))
	return (spec_3dwindow_objects *) NULL;

    ip->window = 
	xv_create(owner, FRAME,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 100,
		  XV_LABEL, "3d view",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  NULL);
    ip->controls = 
	xv_create(ip->window, PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, 64,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 2,
		  NULL);
    ip->azimuth =
	xv_create(ip->controls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, 10,
		  PANEL_SLIDER_WIDTH, 100,
		  PANEL_TICKS, 12,
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Azimuth:",
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, TRUE,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 360,
		  PANEL_VALUE, 30,
		  PANEL_NOTIFY_PROC, setAzimuth,
		  PANEL_NOTIFY_LEVEL, PANEL_ALL,
		  NULL);
    ip->elevation =
	xv_create(ip->controls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, y = NEXT_ROW(ip->azimuth),
		  PANEL_SLIDER_WIDTH, 100,
		  PANEL_TICKS, 9,
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Elevation:",
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, TRUE,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 90,
		  PANEL_VALUE, 50,
		  PANEL_NOTIFY_PROC, setElevation,
		  PANEL_NOTIFY_LEVEL, PANEL_ALL,
		  NULL);
    hv_align(ip->azimuth, ip->elevation, NULL);
    ip->floor =
	xv_create(ip->controls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x = NEXT_COL(ip->azimuth),
		  XV_Y, 10,
		  PANEL_SLIDER_WIDTH, 100,
		  PANEL_TICKS, 10,
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Floor:",
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, TRUE,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 100000,
		  PANEL_VALUE, 0,
		  PANEL_NOTIFY_PROC, setFloor,
		  PANEL_NOTIFY_LEVEL, PANEL_ALL,
		  PANEL_SLIDER_END_BOXES, TRUE,
		  NULL);
    ip->ceiling =
	xv_create(ip->controls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x,
		  XV_Y, y,
		  PANEL_SLIDER_WIDTH, 100,
		  PANEL_TICKS, 10,
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Ceiling:",
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, TRUE,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 1000000,
		  PANEL_VALUE, 1000000,
		  PANEL_NOTIFY_PROC, setCeiling,
		  PANEL_NOTIFY_LEVEL, PANEL_ALL,
		  PANEL_SLIDER_END_BOXES, TRUE,
		  NULL);
    hv_align(ip->floor, ip->ceiling, NULL);
    ip->verticalaxis =
	xv_create(ip->controls, PANEL_CHOICE,
		 PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		 XV_KEY_DATA, INSTANCE, ip,
		 XV_X, 10,
		 XV_Y, y = NEXT_ROW(ip->elevation),
		 PANEL_CHOICE_NCOLS, 1,
		 PANEL_LAYOUT, PANEL_HORIZONTAL,
		 PANEL_LABEL_STRING, "Vertical axis:",
		 PANEL_NOTIFY_PROC, verticalAxis,
		 PANEL_CHOICE_STRINGS,
		 "Linear",
		 "Logarithmic",
		 NULL,
		 PANEL_VALUE, 0,
		 NULL);
    ip->area =
	xv_create(ip->controls, PANEL_CHOICE,
		 PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		 XV_KEY_DATA, INSTANCE, ip,
		 XV_X, NEXT_COL(ip->verticalaxis),
		 XV_Y, y,
		 PANEL_CHOICE_NCOLS, 1,
		 PANEL_LAYOUT, PANEL_HORIZONTAL,
		 PANEL_LABEL_STRING, "Plot area:",
		 PANEL_NOTIFY_PROC, area3d,
		 PANEL_CHOICE_STRINGS,
		 "Whole spectrum",
		 "Inside slicing window",
		 NULL,
		 PANEL_VALUE, 0,
		 NULL);
    ip->print = 
	xv_create(ip->controls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->area),
		  XV_Y, y,
		  PANEL_LABEL_STRING, "Print...",
		  PANEL_NOTIFY_PROC, showPrint,
		  NULL);

    x = NEXT_COL(ip->ceiling);
    if (x < 512)
	x = 512;
    xv_set(ip->controls, XV_WIDTH, x, XV_HEIGHT, NEXT_ROW(ip->verticalaxis),
	   NULL);

    ip->canvas = 
	xv_create(ip->window, CANVAS,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, xv_get(ip->controls, XV_HEIGHT),
		  XV_WIDTH, x,
		  XV_HEIGHT, 512,
/*		  CANVAS_RETAINED, FALSE, */
		  CANVAS_REPAINT_PROC, redraw3d,
		  CANVAS_RESIZE_PROC, resize3d,
		  CANVAS_X_PAINT_WINDOW, TRUE,
		  WIN_COLLAPSE_EXPOSURES, TRUE,
		  NULL);

    window_fit(ip->window);

    return ip;
}
