#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/xv_xrect.h>
#include <xview/cms.h>
#include <xview/wmgr.h>
#include <xview/notice.h>
#include <xview/scrollbar.h>
#include <X11/Xutil.h>
#include "spec_ui.h"
#include "3d_ui.h"
#include "spec_stubs.h"
#include "lookup_proc.h"

double legendre();

Menu_item contourColourHues();
void	initialiseColourmap();
void	initialiseContourObjects();
void	repaintSpectrum();
void	setContoursAndRedraw();
Menu_item abortSetWindow();
void	newPoint();
void	deletePoint();
void	closeWindow();
void	freeWindowList();
void	showRgbPopup();
void	store_window();
int     store_spectrum();
void    do_projection();
void	createDithers();
void	initialiseMonochrome();
void	setContourImages();
void	setContourDithers();
void	setContourArray();
void	setMagnification();
void	readSpectrumFromPipe();
void	spectrumLoaded();
void	repaintProjection();
void	drawGuidelines();
void	drawCrosshairs();
void	RRP();
int	calcScaleAndOffset();
void	brighten();
void	contourLevelDefaultSet();
int	goodInteger();
FILE *	mypopen();
int	mypopenfd();
#ifdef SVR4
int	getdtablesize();
#endif
int	writeSpectrumToPipe();
Notify_value destroy_func();
Notify_value sort_sigusr2_handler();
Notify_value recalculateIcon();
void event_proc();

extern int sys_nerr;
extern char *sys_errlist[];

struct colour {
    unsigned char r;
    unsigned char g;
    unsigned char b;
    unsigned char fade;
};

#define RED 255, 0, 0
#define GREEN 0, 255, 0
#define BLUE 0, 0, 255
#define GREY96 96, 96, 96
#define CYAN 0, 255, 255
#define YELLOW 255, 255, 0
#define WHITE 255, 255, 255
#define BLACK 0, 0, 0
#define FORESTGREEN 64, 64, 0
#define GREY128 128, 128, 127
#define MAGENTA 128, 0, 128

spec_specWindow_objects	        *Spec_specWindow;
spec_contourPopup_objects	*Spec_contourPopup;
spec_levelPopup_objects	        *Spec_levelPopup;
spec_gammaPopup_objects	        *Spec_gammaPopup;
spec_rgbPopup_objects	        *Spec_rgbPopup;
spec_printerPopup_objects	*Spec_printerPopup;
spec_projectPopup_objects	*Spec_projectPopup;
spec_customPopup_objects	*Spec_customPopup;
spec_3dwindow_objects		*Spec_3dwindow;

struct windowPointList {
    int x;
    int y;
    struct windowPointList *next;
};

#define MYCMS "SPEC CMS"
#define MAXPROJWIDTH 730 /* > sqrt(MAXSPECX^2 + MAXSPECY^2), > 256 */
#define WINDOW_NONE 0
#define WINDOW_OUTSIDE 1
#define WINDOW_INSIDE 2
#define WINDOW_ONLY 3
#define WINDOW_SET 4
#define ERRSTRING ((errno > sys_nerr) ? "*** Unknown error ***" : \
                   sys_errlist[errno])
#define MAXSCALE 16
#define MAXSPECSIZE 800
#define POLYARRAYLEN 1024 /* must be power of 2 */

static Xv_opaque contourSlider[MAXCONTOURS], contourButton[MAXCONTOURS];
static Xv_opaque contourObject[MAXCONTOURS+1];
int usedContours = MAXCONTOURS;
static Xv_opaque squareblack;
static unsigned short squarebits[] = {
#include "/usr/openwin/include/images/square_black.pr"
	};
Xv_singlecolor rawColour[NCOLOURS];
Xv_singlecolor displayColour[NCOLOURS];
Cms cms = XV_NULL;
int specx = 73, specy = 73, spec2d[MAXSPECX][MAXSPECY], specMax = 0;
unsigned char spec2dcontour[MAXSPECX][MAXSPECY];
unsigned char window[MAXSPECX][MAXSPECY];
static char spectrumName[80], windowName[80];
static int windowStatus = WINDOW_NONE;
static float displayGamma = 2, printoutGamma = 1, projectAngle = 90;
static unsigned char *iconBits;
static int iconWidth, iconHeight;
static Xv_opaque iconBitmap = XV_NULL;
static Icon iconIcon = XV_NULL;
static int rgbColour = 0;
int debuglevel = 0;
int DBX_val = 0;
int sort_window = 0;
static int monochrome = 0;
static Pixmap dither[MAXSCALE*MAXSCALE+1], windither;
static Xv_opaque XVdither[MAXSCALE*MAXSCALE+1];
static int forceRedraw;
static int mag = 4;
static char *programName;
static unsigned int projection[MAXPROJWIDTH];
static int forceProject = 1, projectArea = 0;
static int showGuidelines = 0, projectAxis = 0, showCrosshairs = 0;
static float Xgain = 1.0, Ygain = 1.0, Xoffset = 0.0, Yoffset = 0.0;
static float screenAngle = M_PI/2, Xtarget = 0.0, Ytarget = 0.0;
static int polynomialOrder = 0;
static float polynomial[POLYARRAYLEN], polynomialScale = 1.0;
static int iconLine = 0;
static int cmsType = XV_DYNAMIC_CMS;

#define OBJ_RIGHT(x) ((int) xv_get(x, XV_X) + (int) xv_get(x, XV_WIDTH))
#define NEXT_COL(x) (OBJ_RIGHT(x) + 10)
#define OBJ_BOT(x) ((int) xv_get(x, XV_Y) + (int) xv_get(x, XV_HEIGHT))
#define NEXT_ROW(x) (OBJ_BOT(x) + 15)

/**** 16/1/95 ****/

static int Slicing;
extern void do_simple_slice();

#define SLICING 0x1
#define PROJECTION 0x2

/*****************/

#define SORT_TRUE   1
#define SORT_FALSE  0
#define SORT_FAIL  -1
#define SORT_NOS_ERR -2

Notify_client sort_client = (Notify_client) 104;

void testSpectrum()
{
    int i,j;
    double x,y,r,t;

    for(i=0; i<specx; i++)
    {
	x = ((double) i)/(specx-1) * 2 - 1;
	for(j=0; j<specy; j++)
	{
	    y = ((double) j)/(specy-1) * 2 -1;
	    r = sqrt(x*x + y*y);
	    t = (r > 0) ? atan2(y,x) : 0 ;
	    if (r < 0.1 || (r >= 0.95 && r < 1.01)
		|| (r > 0.15 && r < 0.9 && sin(t*3) > 0))
		spec2d[i][j] = (int) (r*300) + 1;
	    else
		spec2d[i][j] = 0;
    }
  }
    specMax = 303;
    strcpy(spectrumName, "startup");
    strcpy(windowName, "slice");

}

void getIconSize(Xv_opaque obj)
{
    Display *dpy;
    XIconSize *isp;

    dpy = (Display *) xv_get(obj, XV_DISPLAY);
    if (XGetIconSizes(dpy, DefaultRootWindow(dpy), &isp, &iconWidth) == 0)
	iconWidth = iconHeight = 64;
    else
    {
	iconWidth = isp->max_width;
	iconHeight = isp->max_height;
	while((iconWidth != iconHeight || iconWidth > 64) &&
	      iconWidth >= isp->min_width && iconHeight >= isp->min_height)
	{
	    if (iconWidth > iconHeight)
		iconWidth -= isp->width_inc;
	    else
		iconHeight -= isp->height_inc;
	}
	if (iconWidth != iconHeight || iconWidth > 64 ||
	    iconWidth < isp->min_width || iconHeight < isp->min_height)
	    iconWidth = iconHeight = 64;
    }
    if ((iconBits = malloc(iconWidth*iconHeight)) == NULL)
    {
	perror("sort_spec2d");
	exit(1);
    }
}
    
#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

int main(argc, argv)
int argc;
char **argv;
{
      int i, piped = 0;

      programName = *argv;
/* check options*/
      for(i=1; i<argc; i++)
      {
	    if (!strcmp(argv[i],"-sort"))
	    {
		  sort_window = 1;
		  fprintf(stderr,"sort_spec2d started\n");
	    }
  	    else if (!strcmp(argv[i],"-dbx"))
	    {
		  debuglevel = (int) atof(argv[++i]);
		  DBX_val = debuglevel;
		  fprintf(stderr,"sort_spec2d: diagnostics level set to %d\n",
			  debuglevel);
	    } 
	    else if (!strcmp(argv[i], "-pipe"))
		piped = 1;
      }
/*
 * Initialize XView.
 */
      xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
      INSTANCE = xv_unique_key();

/* initialize the signal handler for SIGUSR2 */
      notify_set_signal_func(sort_client, sort_sigusr2_handler, SIGUSR2,
			     NOTIFY_SYNC);
      notify_set_destroy_func(sort_client, destroy_func);

/* generate file name of SORT pipe for use with communications with sort process */
      if (sort_window)
      {
#ifdef SVR4
	  sigset(SIGINT, SIG_IGN);
#else
	  signal(SIGINT, SIG_IGN);
#endif
      }
      
      Spec_specWindow = spec_specWindow_objects_initialize(NULL, NULL);
      Spec_contourPopup =
	  spec_contourPopup_objects_initialize(NULL,
					       Spec_specWindow->specWindow);
      Spec_levelPopup =
	  spec_levelPopup_objects_initialize(NULL,
					     Spec_specWindow->specWindow);
      Spec_gammaPopup =
	  spec_gammaPopup_objects_initialize(NULL,
					     Spec_specWindow->specWindow);
      Spec_rgbPopup =
	  spec_rgbPopup_objects_initialize(NULL, Spec_specWindow->specWindow); 
      Spec_printerPopup =
	  spec_printerPopup_objects_initialize(NULL,
					       Spec_specWindow->specWindow);
      Spec_projectPopup =
	  spec_projectPopup_objects_initialize(NULL,
					       Spec_specWindow->specWindow);
      Spec_customPopup =
	  spec_customPopup_objects_initialize(NULL,
					      Spec_specWindow->specWindow);
      Spec_3dwindow =
	  spec_3dwindow_objects_initialize(NULL, Spec_specWindow->specWindow);

      getIconSize(Spec_specWindow->specWindow);

      for(i=MAXSCALE*MAXSCALE+1; i--; )
      {
	  dither[i] = 0;
	  XVdither[i] = XV_NULL;
      }

      initialiseColourmap(Spec_contourPopup->contourControls);
      if (!monochrome)
	  initialiseColourmap(Spec_specWindow->spectrum);
      initialiseContourObjects();
      if (piped)
	  readSpectrumFromPipe();
      else
      {
	  testSpectrum();	
	  spectrumLoaded();
	  contourLevelDefaultSet();
	  setMagnification(4);
      }
      setContourImages(Spec_contourPopup->contourControls);
      
      setContourArray();
      while(iconLine < iconHeight)
	  recalculateIcon();
      
      xv_set(Spec_specWindow->spectrum,
	     CANVAS_X_PAINT_WINDOW, TRUE, 
	     CANVAS_RETAINED, TRUE,
	     CANVAS_AUTO_EXPAND, FALSE,
	     CANVAS_AUTO_SHRINK, FALSE,
	     CANVAS_AUTO_CLEAR, FALSE,
	     NULL);
      xv_set(canvas_paint_window(Spec_specWindow->spectrum),
	     WIN_IGNORE_EVENTS, WIN_UP_EVENTS, NULL,
	     WIN_CONSUME_EVENTS, LOC_MOVE, LOC_DRAG, NULL,
	     NULL);
      xv_set(Spec_specWindow->specWindow, WIN_EVENT_PROC, event_proc, NULL);
      if (cmsType == XV_DYNAMIC_CMS)
      {
	  xv_set(Spec_gammaPopup->displayGammaSlider,
		 PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL);
	  xv_set(Spec_gammaPopup->printoutGammaSlider,
		 PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL);
	  xv_set(Spec_rgbPopup->redSlider,
		 PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL);
	  xv_set(Spec_rgbPopup->greenSlider,
		 PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL);
      xv_set(Spec_rgbPopup->blueSlider,
	     PANEL_NOTIFY_LEVEL, PANEL_ALL, NULL); 
      }
      xv_set(Spec_projectPopup->projectAngleSlider, PANEL_NOTIFY_LEVEL,
	     PANEL_ALL, NULL); 
      xv_set(Spec_specWindow->specWindow,
	     FRAME_LEFT_FOOTER, "Sort_spec2d version 1.07", NULL);
      if (monochrome)
	  xv_set(Spec_specWindow->specWindow,
		 FRAME_RIGHT_FOOTER, "Monochrome display - Yuk !", NULL);

      if (sort_window)
	  xv_set(Spec_specWindow->specWindow, FRAME_CLOSED, TRUE, NULL);
      
      xv_main_loop(Spec_specWindow->specWindow);
      return(0);
}

#endif

void initialiseContourObjects()
{
    int i, x, y, t, mh;
    char label[10];

    if (!contourObject[0])
    {
        squareblack = xv_create(XV_NULL, SERVER_IMAGE,
                                SERVER_IMAGE_DEPTH, 1,
                                SERVER_IMAGE_BITS, squarebits,
                                XV_WIDTH, 16,
                                XV_HEIGHT, 16,
                                NULL);
	x = 8;
	y = NEXT_ROW(Spec_contourPopup->presetPalette);
	mh = 0;
	/* We do this in two passes, first we make the objects, then we
	   lay then out exactly */
        for(i=0; i<MAXCONTOURS; i++)
        {
	    if (i == (MAXCONTOURS+1)/2)
	    {
		x = NEXT_COL(contourButton[1]);
		y = NEXT_ROW(Spec_contourPopup->presetPalette);
	    }
	    if (i == MAXCONTOURS-1)
		sprintf(label, "%8d", specMax);
	    else
		sprintf(label, "%6d", i);
            if (i == 0 || i == MAXCONTOURS - 1)
                contourSlider[i] =
                    xv_create(Spec_contourPopup->contourControls,
                              PANEL_MESSAGE,
                              XV_KEY_DATA, INSTANCE,
                              Spec_contourPopup,
			      XV_X, x,
			      XV_Y, y,
                              PANEL_LABEL_STRING, label,
			      NULL);
            else
                contourSlider[i] =
                    xv_create(Spec_contourPopup->contourControls,
                              PANEL_SLIDER,
                              XV_KEY_DATA, INSTANCE,
                              Spec_contourPopup,
			      XV_X, x,
			      XV_Y, y,
                              PANEL_SLIDER_WIDTH, 100,
                              PANEL_TICKS, 0,
                              PANEL_LABEL_STRING, label,
                              PANEL_DIRECTION, PANEL_HORIZONTAL,
                              PANEL_SLIDER_END_BOXES, FALSE,
                              PANEL_SHOW_RANGE, FALSE,
                              PANEL_SHOW_VALUE, TRUE,
                              PANEL_MIN_VALUE, 0,
                              PANEL_MAX_VALUE, specMax,
                              PANEL_VALUE, i,
			      PANEL_NOTIFY_LEVEL, PANEL_DONE,
			      PANEL_NOTIFY_PROC, setContoursAndRedraw,
                              NULL);
            contourButton[i] =
                xv_create(Spec_contourPopup->contourControls,
                          PANEL_BUTTON,
			  XV_X, OBJ_RIGHT(contourSlider[i])+4,
			  XV_Y, y,
                          PANEL_LABEL_IMAGE, squareblack,
                          PANEL_ITEM_COLOR, i+COLOUROFFSET,
                          PANEL_NOTIFY_PROC, showRgbPopup,
                          PANEL_CLIENT_DATA, i,
                          NULL);
	    if ((t = (int) xv_get(contourSlider[i], XV_HEIGHT)) > mh)
		mh = t;
	    if ((t = (int) xv_get(contourButton[i], XV_HEIGHT)) > mh)
		mh = t;
        }

        for(i=0; i<MAXCONTOURS; i++, y += mh + 4)
        {
	    if (i == 0 || i == (MAXCONTOURS+1)/2)
		y = OBJ_BOT(Spec_contourPopup->presetPalette) + 4;
	    xv_set(contourSlider[i], XV_Y,
		   y + (mh - (int) xv_get(contourSlider[i], XV_HEIGHT))/2,
		   NULL);
	    xv_set(contourButton[i], XV_Y,
		   y + (mh - (int) xv_get(contourButton[i], XV_HEIGHT))/2,
		   NULL);
	}

	x = 0;
	for(i=0; i<(MAXCONTOURS+1)/2; i++)
	    if ((t = (int) xv_get(contourButton[i], XV_X)) > x)
		x = t;
	for(i=0; i<(MAXCONTOURS+1)/2; i++)
	{
	    xv_set(contourButton[i], XV_X, x, NULL);
	    xv_set(contourSlider[i], XV_X,
		   x - (int) xv_get(contourSlider[i], XV_WIDTH) - 4, NULL);
	}
	x = 0;
	for(i=(MAXCONTOURS+1)/2; i < MAXCONTOURS; i++)
	    if ((t = (int) xv_get(contourButton[i], XV_X)) > x)
		x = t;
	for(i=(MAXCONTOURS+1)/2; i < MAXCONTOURS; i++)
	{
	    xv_set(contourButton[i], XV_X, x, NULL);
	    xv_set(contourSlider[i], XV_X,
		   x - (int) xv_get(contourSlider[i], XV_WIDTH) - 4, NULL);
	}

	window_fit(Spec_contourPopup->contourControls);
	window_fit(Spec_contourPopup->contourPopup);

        contourLevelDefaultSet();
    }
}

void initialiseColourmap(win)
Xv_opaque win;
{
    int i;
    int depth = (unsigned int) xv_get(win, XV_DEPTH);
    int visual_class = (int) xv_get(win, XV_VISUAL_CLASS);
    Xv_Screen screen = (Xv_Screen) xv_get(win, XV_SCREEN);
    static Xv_cmsdata *ocms_data;

    cms = (Cms) xv_find(screen, CMS, CMS_NAME, MYCMS,
                        XV_AUTO_CREATE, FALSE, 0);

    if ((depth < 8) || !((visual_class == StaticColor) ||
			 (visual_class == PseudoColor) ||
			 (visual_class == TrueColor) ||
			 (visual_class == DirectColor)))
    {
	monochrome = 1;
	initialiseMonochrome(win);
	return;
    }

    if (cms == XV_NULL)
    {
	contourColourHues((Menu_item) 0, MENU_NOTIFY);

        ocms_data = (Xv_cmsdata *) xv_get(win, WIN_CMS_DATA);

        i = (int) xv_get(win, WIN_BACKGROUND_COLOR);
 
        displayColour[BG_INDEX - CMS_CONTROL_COLORS].red =
	    ocms_data->red[i];
        displayColour[BG_INDEX - CMS_CONTROL_COLORS].green =
	    ocms_data->green[i];
        displayColour[BG_INDEX - CMS_CONTROL_COLORS].blue =
	    ocms_data->blue[i];
 
        i = (int) xv_get(win, WIN_FOREGROUND_COLOR);
 
        displayColour[FG_INDEX - CMS_CONTROL_COLORS].red =
	    ocms_data->red[i];
        displayColour[FG_INDEX - CMS_CONTROL_COLORS].green =
	    ocms_data->green[i];
        displayColour[FG_INDEX - CMS_CONTROL_COLORS].blue =
	    ocms_data->blue[i];

        if ((cms = xv_create(screen, CMS,
			     CMS_NAME, MYCMS,
			     XV_VISUAL, xv_get(win, XV_VISUAL),
			     CMS_TYPE, XV_DYNAMIC_CMS,
			     CMS_CONTROL_CMS, TRUE,
			     CMS_SIZE, NCOLOURS,
			     CMS_COLORS, displayColour,
			     NULL)) == XV_NULL)
	{
	    if ((cms = xv_create(screen, CMS,
				 CMS_NAME, MYCMS,
				 XV_VISUAL, xv_get(win, XV_VISUAL),
				 CMS_TYPE, XV_STATIC_CMS,
				 CMS_CONTROL_CMS, TRUE,
				 CMS_SIZE, NCOLOURS,
				 CMS_COLORS, displayColour,
				 NULL)) == XV_NULL)
	    {
		monochrome = 1;
		initialiseMonochrome(win);
		return;
	    }
	    else
		cmsType = XV_STATIC_CMS;
	}
    }

    xv_set(win, WIN_CMS_NAME, MYCMS, WIN_CMS, cms, NULL);
    xv_set(win, WIN_BACKGROUND_COLOR, BG_INDEX, NULL);
    xv_set(win, WIN_FOREGROUND_COLOR, FG_INDEX, NULL);

}

void
loadContourValueArray(contourValue)
int *contourValue;
{
    int k;

    contourValue[0] = 0;
    for(k=1; k<usedContours-1; k++)
    {
	contourValue[k] = xv_get(contourSlider[k], PANEL_VALUE);
	if (contourValue[k] <= contourValue[k-1])
	{
	    contourValue[k] = contourValue[k-1] + 1;
	    xv_set(contourSlider[k], PANEL_VALUE, contourValue[k], NULL);
	}
    }
    xv_set(contourSlider[MAXCONTOURS-1], XV_X,
	   (int) xv_get(contourButton[MAXCONTOURS-2], XV_X) -
	   (int) xv_get(contourSlider[MAXCONTOURS-1], XV_WIDTH) - 4, NULL);
    contourValue[usedContours-1] = specMax;
}

static int contourValue[MAXCONTOURS];
struct itimerval iconTimer;

Notify_value
recalculateIcon()
{
    int i, k, u, t, n, x, y;
    unsigned char *p;
    double specxstep, specystep;
    int monoicon = (cms == XV_NULL) ||
	(xv_get(Spec_specWindow->specWindow, WIN_DEPTH) != 8);

    if (iconLine == iconHeight)
    {
	notify_set_itimer_func(Spec_specWindow->specWindow,
				   NOTIFY_FUNC_NULL, ITIMER_REAL, NULL, NULL);
	return NOTIFY_DONE;
    }

    specxstep = ((double) specx)/iconWidth;
    specystep = ((double) specy)/iconHeight;

    if (monoicon)
    {
	p = iconBits + iconLine*((iconWidth+7)>>3);

	u = 1;
	*p = 0;
	for(i=0; i<iconWidth; i++)
	{
	    n = t = 0;
	    for(x=i*specxstep; x<(i+1)*specxstep; x++)
		for(y=iconLine*specystep; y<(iconLine+1)*specystep; y++)
		{
		    t += spec2d[x][y];
		    n++;
		}
	    t /= n;
	    if (t > 0)
		*p |= u;
	    u <<= 1;
	    if (u > 128)
	    {
		*++p = 0;
		u = 1;
	    }
	}
    }
    else
    {
	p = iconBits + iconLine*iconWidth;
	for(i=0; i<iconWidth; i++)
	{
	    n = t = 0;
	    for(x=i*specxstep; x<(i+1)*specxstep; x++)
		for(y=iconLine*specystep; y<(iconLine+1)*specystep; y++)
		{
		    t += spec2d[x][y];
		    n++;
		}
	    t /= n;
	    for(k=usedContours-1; k;)
		if (t > contourValue[--k])
		{
		    k++;
		    break;
		}
	    *p++ = ((k == usedContours-1) ? MAXCONTOURS-1 : k) +
		COLOUROFFSET;
	}
    }

    if (++iconLine == iconHeight)
    {
	notify_set_itimer_func(Spec_specWindow->specWindow,
				   NOTIFY_FUNC_NULL, ITIMER_REAL, NULL,
				   NULL);
	if (!iconBitmap)
	    if (monoicon)
		iconBitmap = xv_create(XV_NULL, SERVER_IMAGE,
				       SERVER_IMAGE_DEPTH, 1,
				       SERVER_IMAGE_X_BITS, iconBits,
				       XV_WIDTH, iconWidth,
				       XV_HEIGHT, iconHeight,
				       NULL);
	    else
		iconBitmap = xv_create(XV_NULL, SERVER_IMAGE,
				      SERVER_IMAGE_DEPTH, 8,
				      SERVER_IMAGE_X_BITS, iconBits,
				      XV_WIDTH, iconWidth,
				      XV_HEIGHT, iconHeight,
				      SERVER_IMAGE_COLORMAP, MYCMS,
				      NULL);
	else
	    xv_set(iconBitmap, SERVER_IMAGE_X_BITS, iconBits, NULL);
	if (!iconIcon)
	    iconIcon = xv_create(XV_NULL, ICON, ICON_IMAGE, iconBitmap, NULL);
	else
	    iconIcon = xv_set(iconIcon, ICON_IMAGE, iconBitmap, NULL);
	xv_set(Spec_specWindow->specWindow, FRAME_ICON, iconIcon, NULL);
    }
    
    return NOTIFY_DONE;
}


void
setContourArray()
{
    int i, j, k, *cvp;

    loadContourValueArray(contourValue);
    for(i=0; i<specx; i++)
	for(j=0; j<specy; j++)
	{
	    for(cvp = contourValue, k=usedContours-1; k--; cvp++)
		if (spec2d[i][j] <= *cvp)
		    break;
	    k = cvp - contourValue;
	    spec2dcontour[i][j] = (unsigned char)
		(((k == usedContours-1) ? MAXCONTOURS - 1 : k) + COLOUROFFSET);
	}

    iconLine = 0;
    iconTimer.it_value.tv_usec = iconTimer.it_interval.tv_usec = 100;
    iconTimer.it_value.tv_sec = iconTimer.it_interval.tv_sec = 0;
    notify_set_itimer_func(Spec_specWindow->specWindow,
			       recalculateIcon, ITIMER_REAL, &iconTimer, NULL);
}

void redrawSpectrum()
{
    repaintSpectrum(
	XV_NULL,
	XV_NULL,
	(Display *) XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	(Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum), 
			XV_XID),
	(Xv_xrectlist *) NULL);
/*
  XClearArea(XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
	       XV_XID), 0, 0, 0, 0, True);
*/
}

void setContoursAndRedraw()
{
    setContourArray();
    if (monochrome)
	setContourDithers(Spec_contourPopup->contourControls);
    redrawSpectrum();
    forceRedraw3d();
    if (usedContours == MAXCONTOURS)
        xv_set(xv_get(xv_get(Spec_contourPopup->levels, PANEL_ITEM_MENU),
                      MENU_NTH_ITEM, 4), MENU_INACTIVE, TRUE, NULL);
    else
        xv_set(xv_get(xv_get(Spec_contourPopup->levels, PANEL_ITEM_MENU),
                      MENU_NTH_ITEM, 4), MENU_INACTIVE, FALSE, NULL);
    if (usedContours == 2)
        xv_set(xv_get(xv_get(Spec_contourPopup->levels, PANEL_ITEM_MENU),
                      MENU_NTH_ITEM, 5), MENU_INACTIVE, TRUE, NULL);
    else
        xv_set(xv_get(xv_get(Spec_contourPopup->levels, PANEL_ITEM_MENU),
                      MENU_NTH_ITEM, 5), MENU_INACTIVE, FALSE, NULL);
}

/*ARGSUSED*/
void levelSetLinear(item, event)
Panel_item item;
Event *event;
{
    int first, step, number;
    int i;

    if ((first = goodInteger(Spec_levelPopup->levelControls, (char *)
			     xv_get(Spec_levelPopup->firstValue, PANEL_VALUE),
			     0, specMax, event)) < 0)
	return;
    if ((step = goodInteger(Spec_levelPopup->levelControls, (char *)
			    xv_get(Spec_levelPopup->step, PANEL_VALUE),
			    1, specMax, event)) < 1)
	return;
    if ((number = goodInteger(Spec_levelPopup->levelControls, (char *)
			      xv_get(Spec_levelPopup->numContours,
				     PANEL_VALUE), 2, MAXCONTOURS,
			      event)) < 2)
	return;
    usedContours = number;
    for(i=1; i<number-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, first, XV_SHOW, TRUE, NULL);
	xv_set(contourButton[i], XV_SHOW, TRUE, NULL);
	first += step;
    }
    for(; i<MAXCONTOURS-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, first, XV_SHOW, FALSE, NULL);
	xv_set(contourButton[i], XV_SHOW, FALSE, NULL);
	first += step;
    }
    setContoursAndRedraw();
}

int goodInteger(item, s, min, max, event)
Panel_item item;
char *s;
int min, max;
Event *event;
{
    char *p, *q;
    int num;

    p = s;
    while(*p == ' ')
	p++;
    if (*p == '-')
	p++;
    q = p;
    while(*p >= '0' && *p <= '9')
	p++;
    while(*p == ' ')
	p++;
    if (*p != '\0')
    {
	p = malloc(strlen(s) + 32);
	sprintf(p, "Can't convert \"%s\" to an integer.", s);
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS, p, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(p);
	return(min - 1);
    }
    if (p == q)
    {
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "You've left a field incomplete.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return(min - 1);
    }
    sscanf(s, "%d", &num);
    if (num < min || num > max)
    {
	p = malloc(strlen(s) + 50);
	sprintf(p, "\"%s\" is not in the range %d to %d.", s, min, max);
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS, p, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(p);
	return(min - 1);
    }
    return(num);
}

double goodFloat(item, s, min, max, event)
Panel_item item;
char *s;
double min, max;
Event *event;
{
    char *p, *q;
    float num;

    p = s;
    while(*p == ' ')
	p++;
    if (*p == '-')
	p++;
    q = p;
    while(*p >= '0' && *p <= '9')
	p++;
    if (*p == '.')
    {
	p++;
	while(*p >= '0' && *p <= '9')
	    p++;
    }
    if ((*p == 'e' || *p == 'E') && q != p)
    {
	p++;
	if (*p == '-')
	    p++;
	q = p;
	while(*p >= '0' && *p <= '9')
	    p++;
    }
    while(*p == ' ')
	p++;
    if (*p != '\0')
    {
	p = malloc(strlen(s) + 32);
	sprintf(p, "Can't convert \"%s\" to a number.", s);
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS, p, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(p);
	return((min == max) ? min : min - fabs(min/10) - 1);
    }
    if (p == q)
    {
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "You've left a field incomplete.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return((min == max) ? min : min - fabs(min/10) - 1);
    }
    sscanf(s, "%f", &num);
    if (min != max)
    {
	if (num < min || num > max)
	{
	    p = malloc(strlen(s) + 70);
	    sprintf(p, "\"%s\" is not in the range %f to %f.", s, min, max);
	    notice_prompt(item, NULL,
			  NOTICE_FOCUS_XY, event_x(event), event_y(event),
			  NOTICE_MESSAGE_STRINGS, p, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    free(p);
	    return(min - fabs(min/10) - 1);
	}
    }
    else if (num == min)
    { 
	p = malloc(strlen(s) + 70);
	sprintf(p, "A value of \"%s\" is not acceptable here.", s);
	notice_prompt(item, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS, p, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(p);
	return(min);
    }
    return(num);
}


/*ARGSUSED*/
void levelSetPseudo(item, event)
Panel_item item;
Event *event;
{
    float first, step;
    int number;
    int i;

    if ((first = goodFloat(Spec_levelPopup->levelControls, (char *)
			   xv_get(Spec_levelPopup->firstValue, PANEL_VALUE),
			   1.0, (double) specMax, event)) < 1.0)
	return;
    if ((step = goodFloat(Spec_levelPopup->levelControls, (char *)
			  xv_get(Spec_levelPopup->spacing, PANEL_VALUE),
			  1.0, (double) specMax, event)) < 1.0)
	return;
    if ((number = goodInteger(Spec_levelPopup->levelControls, (char *)
			      xv_get(Spec_levelPopup->numContours,
				     PANEL_VALUE), 2, MAXCONTOURS, event)) < 2)
	return;
    usedContours = number;
    for(i=1; i<number-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, (int) first, XV_SHOW, TRUE,
	       NULL);
	xv_set(contourButton[i], XV_SHOW, TRUE, NULL);
	first *= step;
    }
    for(; i<MAXCONTOURS-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, (int) first, XV_SHOW, FALSE,
	       NULL);
	xv_set(contourButton[i], XV_SHOW, FALSE, NULL);
	first *= step;
    }
    setContoursAndRedraw();
}

Menu_item
popupLinear(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op == MENU_NOTIFY)
    {
	xv_set(Spec_levelPopup->spacing, XV_SHOW, FALSE, NULL);
	xv_set(Spec_levelPopup->step, XV_SHOW, TRUE, NULL);
	xv_set(Spec_levelPopup->levelSetApply, PANEL_NOTIFY_PROC,
	       levelSetLinear, NULL);
	xv_set(Spec_levelPopup->levelPopup, XV_LABEL, "Set linear contours",
	       XV_SHOW, TRUE, NULL);
    }

    return item;
}

Menu_item
popupPseudo(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op == MENU_NOTIFY)
    {
	xv_set(Spec_levelPopup->step, XV_SHOW, FALSE, NULL);
	xv_set(Spec_levelPopup->spacing, XV_SHOW, TRUE, NULL);
	xv_set(Spec_levelPopup->levelSetApply, PANEL_NOTIFY_PROC,
	       levelSetPseudo, NULL);
	xv_set(Spec_levelPopup->levelPopup, XV_LABEL,
	       "Set pseudo-logarithmic contours", XV_SHOW, TRUE, NULL);
    }

    return item;
}

/*ARGSUSED*/
void showContours(item, event)
	Panel_item	item;
	Event		*event;
{
    xv_set(Spec_contourPopup->contourPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
    xv_set(Spec_contourPopup->contourPopup, XV_SHOW, TRUE, NULL);
}

void alterColours()
{
    if (cms == XV_NULL)
	return;
    if (cmsType == XV_DYNAMIC_CMS)
	xv_set(cms, CMS_COLORS, displayColour, NULL);
    else
    {
	xv_destroy(cms);
	cms = xv_create(xv_get(Spec_specWindow->spectrum, XV_SCREEN), CMS,
			CMS_NAME, MYCMS,
			XV_VISUAL,
			xv_get(Spec_specWindow->spectrum, XV_VISUAL),
			CMS_TYPE, XV_STATIC_CMS,
			CMS_CONTROL_CMS, TRUE,
			CMS_SIZE, NCOLOURS,
			CMS_COLORS, displayColour,
			NULL);
	
	xv_set(Spec_contourPopup->contourControls, WIN_CMS_NAME, MYCMS,
	       WIN_CMS, cms, NULL);
	xv_set(Spec_specWindow->spectrum, WIN_CMS_NAME, MYCMS,
	       WIN_CMS, cms, NULL);
	redrawSpectrum();
	forceRedraw3d();
	XClearArea(XV_DISPLAY_FROM_WINDOW(Spec_contourPopup->contourControls),
		   (Window) xv_get(Spec_contourPopup->contourControls, XV_XID),
		   0, 0, 0, 0, True);
	
    }
}

void
contourColourList(struct colour *list, int size)
{
    int n, i, nc, c, levs, steps, j;
    struct colour *lp;

    for(i = size-1, lp = list, n = 0, nc = usedContours-1; i--; lp++)
	if (lp->fade)
	    n++;
	else
	    nc--;

    if (nc < 0)
	nc = 0;
    steps = 0;
    j = 1;

    for(lp = list, c = 0; c < usedContours-1; lp++)
    {
	if (lp->fade)	
	{
	    levs = (nc*(j++)+n-1)/n + steps - c;
	    for(i = 0; i < levs; i++)
	    {
		rawColour[c].red = ((int) lp[1].r - (int) lp->r)*i/levs +
		    lp->r;
		rawColour[c].green = ((int) lp[1].g - (int) lp->g)*i/levs +
		    lp->g;
		rawColour[c++].blue = ((int) lp[1].b - (int) lp->b)*i/levs +
		    lp->b;
	    }
	}
	else
	{
	    rawColour[c].red = lp->r;
	    rawColour[c].green = lp->g;
	    rawColour[c++].blue = lp->b;
	    steps++;
	}
    }

    lp = list + size-1;

    while(c < MAXCONTOURS)
    {
	rawColour[c].red = lp->r;
	rawColour[c].green = lp->g;
	rawColour[c++].blue = lp->b;
    }
    
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    xv_set(Spec_rgbPopup->redSlider, PANEL_VALUE, rawColour[rgbColour].red,
           NULL);
    xv_set(Spec_rgbPopup->greenSlider, PANEL_VALUE, rawColour[rgbColour].green,
           NULL);
    xv_set(Spec_rgbPopup->blueSlider, PANEL_VALUE, rawColour[rgbColour].blue,
           NULL);
    alterColours();
}

Menu_item
contourColourGreyscale(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    static struct colour scheme[] = {
	{WHITE, 1}, {BLACK, 1}};

    if (op != MENU_NOTIFY)
	return item;

    rawColour[MAXCONTOURS].red = 255;
    rawColour[MAXCONTOURS].green = 192;
    rawColour[MAXCONTOURS].blue = 192;

    contourColourList(scheme, sizeof(scheme)/sizeof(struct colour));
    
    return item;
}

Menu_item
contourColourReverseGreyscale(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    static struct colour scheme[] = {
	{BLACK, 1}, {WHITE, 1}};

    if (op != MENU_NOTIFY)
	return item;

    rawColour[MAXCONTOURS].red = 255;
    rawColour[MAXCONTOURS].green = 192;
    rawColour[MAXCONTOURS].blue = 192;

    contourColourList(scheme, sizeof(scheme)/sizeof(struct colour));
    
    return item;
}

Menu_item
contourColourHues(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    static struct colour scheme[] = {
	{GREY96, 0}, {BLUE, 1}, {CYAN, 1}, {GREEN, 1}, {RED, 1}, {YELLOW, 1},
	{WHITE, 1}};

    if (op != MENU_NOTIFY)
	return item;

    rawColour[MAXCONTOURS].red = 255;
    rawColour[MAXCONTOURS].green = 192;
    rawColour[MAXCONTOURS].blue = 192;

    contourColourList(scheme, sizeof(scheme)/sizeof(struct colour));
    
    return item;
}

Menu_item
contourColourHeat(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    static struct colour scheme[] = {
	{BLACK, 1}, {RED, 1}, {YELLOW, 1}, {WHITE, 1}};

    if (op != MENU_NOTIFY)
	return item;

    rawColour[MAXCONTOURS].red = 255;
    rawColour[MAXCONTOURS].green = 192;
    rawColour[MAXCONTOURS].blue = 192;

    contourColourList(scheme, sizeof(scheme)/sizeof(struct colour));
    
    return item;
}

Menu_item
contourColourTopographic(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    static struct colour scheme[] = {
    {BLACK, 1}, {BLUE, 1}, {CYAN, 1}, {GREEN, 1}, {FORESTGREEN, 1},
    {GREY128, 1}, {WHITE, 1}, {MAGENTA, 1}};

    if (op != MENU_NOTIFY)
	return item;

    rawColour[MAXCONTOURS].red = 255;
    rawColour[MAXCONTOURS].green = 128;
    rawColour[MAXCONTOURS].blue = 0;

    contourColourList(scheme, sizeof(scheme)/sizeof(struct colour));
    
    return item;
}

Menu_item
contourColourColdAndHot(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    static struct colour scheme[] = {
	{BLACK, 1}, {BLUE, 1}, {CYAN, 1}, {GREY128, 1}, {RED, 1}, {YELLOW, 1},
	{WHITE, 1}};

    if (op != MENU_NOTIFY)
	return item;

    rawColour[MAXCONTOURS].red = 255;
    rawColour[MAXCONTOURS].green = 192;
    rawColour[MAXCONTOURS].blue = 192;

    contourColourList(scheme, sizeof(scheme)/sizeof(struct colour));
    
    return item;
}
    
void
brighten(colour, i, last, newColour, gam)
Xv_singlecolor *colour, *newColour;
int i, last;
double gam;
{
    double g = 1/gam;

    newColour += i;
    colour += i;
    for(; i<last; i++)
    {
	newColour->red = pow((double) colour->red/255.0, g)*255;
	newColour->green = pow((double) colour->green/255.0, g)*255;
	newColour->blue = pow((double) colour->blue/255.0, g)*255;
	newColour++;
	colour++;
    }
}

void
contourLevelDefaultSet()
{
    static int defaultLevel[] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13,
				      14, 15, 18, 22, 27, 32, 39, 46, 55, 66,
				      80, 95, 114, 140, 166, 200, 240};
    int i;

    usedContours = sizeof(defaultLevel) / sizeof(int) + 2;
    for(i=1; i<usedContours-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, defaultLevel[i-1],
	       XV_SHOW, TRUE, NULL);
	xv_set(contourButton[i], XV_SHOW, TRUE, NULL);
    }
    for(; i<MAXCONTOURS-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, specMax,
	       XV_SHOW, FALSE, NULL);
	xv_set(contourButton[i], XV_SHOW, FALSE, NULL);
    }
}

Menu_item
contourLevelDefault(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op == MENU_NOTIFY)
    {
	contourLevelDefaultSet();
	setContoursAndRedraw();
    }

    return item;
}

static GC gc = NULL;
static struct windowPointList *windowPoints = NULL, *windowTail = NULL;
static int winX, winY;

void
repaintRectangle(display, xid, index, wincol, minx, miny, maxx, maxy, uselast)
Display *display;
Window xid;
unsigned long *index, wincol;
int minx, miny, maxx, maxy, uselast;
{
    int x, y, ystart, oldcont, i;
    static char lastredraw[MAXSPECX][MAXSPECY];
    static int lastlevels = -1;
    XImage *line;
    Pixmap lbuf = None;
    XWindowAttributes wa;
    GC lgc;

    if (monochrome*usedContours != lastlevels)
    {
	forceRedraw = 1;
	lastlevels = monochrome*usedContours;
    }
    if (forceRedraw == 1 || (windowStatus == WINDOW_SET && forceRedraw != 2))
	uselast = 0;

    if (minx < 0)
	minx = 0;
    if (miny < 0)
	miny = 0;
    if (maxx > specx)
	maxx = specx;
    if (maxy > specy)
	maxy = specy;

    XGetWindowAttributes(display, xid, &wa);
/*
    fprintf(stderr, "Image at %d,%d size %dx%d\n", minx*mag, miny*mag,
	    (maxx-minx)*mag, (maxy-miny)*mag);
*/
    if (!monochrome &&
	(line = XCreateImage(display, wa.visual, wa.depth, ZPixmap, 0,
			     NULL, (maxx-minx)*mag, 1, 8, 0)) != NULL)
    {
	if (mag > 1)
	{
	    lbuf = XCreatePixmap(display, xid,  (maxx-minx)*mag, 1, wa.depth);
	    lgc =  XCreateGC(display, xid, 0, NULL);
	    XSetFunction(display, lgc, GXcopy);
	}

/*
	fprintf(stderr, "Bytes per line = %d, width = %d\n",
		line->bytes_per_line, (maxx-minx)*mag);
*/
	if ((line->data = malloc(line->bytes_per_line*wa.depth)) == NULL)
	    XDestroyImage(line);
	else
	{
	    int xl = minx*mag, xw = (maxx - minx)*mag, xp;
	    lastlevels = -1;
/*
	    fprintf(stderr, "Using new redraw.\n");
*/
	    ystart = miny*mag;
	    for(y = miny; y < maxy; y++)
	    {
		xp = 0;

		switch(windowStatus)
		{
		case WINDOW_NONE:
		case WINDOW_SET:
		{
		    register unsigned char (*sp)[MAXSPECY] =
			(unsigned char (*)[MAXSPECY]) &spec2dcontour[minx][y];
		    register long col;
		    
		    for(x = maxx - minx; x--; sp++)
		    {
			col = index[**sp];
			for(i = mag; i--; )
			    XPutPixel(line, xp++, 0, col);
		    }
		}
		break;
		case WINDOW_OUTSIDE:
		{
		    register unsigned char (*sp)[MAXSPECY] =
			(unsigned char (*)[MAXSPECY]) &spec2dcontour[minx][y];
		    register unsigned char (*wp)[MAXSPECY] =
			(unsigned char (*)[MAXSPECY]) &window[minx][y];
		    register long col;
			
		    for(x = maxx - minx; x--; sp++)
		    {
			col = (*(*wp++)) ? wincol : index[**sp];
			for(i = mag; i--; )
			    XPutPixel(line, xp++, 0, col);
		    }
		}
		break;
		case WINDOW_INSIDE:
		{
		    register unsigned char (*sp)[MAXSPECY] =
			(unsigned char (*)[MAXSPECY]) &spec2dcontour[minx][y];
		    register unsigned char (*wp)[MAXSPECY] =
			(unsigned char (*)[MAXSPECY]) &window[minx][y];
		    register long col;
			
		    for(x = maxx - minx; x--; sp++)
		    {
			col = (*(*wp++)) ? index[**sp] : wincol;
			for(i = mag; i--; )
			    XPutPixel(line, xp++, 0, col);
		    }
		}
		break;
		case WINDOW_ONLY:
		{
		    register unsigned char (*wp)[MAXSPECY] =
			(unsigned char (*)[MAXSPECY]) &window[minx][y];
		    register long col;
			
		    for(x = maxx - minx; x--; wp++)
		    {
			col = (**wp) ? index[MAXCONTOURS+COLOUROFFSET-1] :
			    index[COLOUROFFSET];
			for(i = mag; i--; )
			    XPutPixel(line, xp++, 0, col);
		    }
		}
		break;
		}
		if (mag == 1)
		    XPutImage(display, xid, gc, line, 0, 0, xl, ystart++,
			      xw, 1);
		else
		{
		    XPutImage(display, lbuf, lgc, line, 0, 0, 0, 0, xw, 1);
		    for(i=0; i<mag; i++)
			XCopyArea(display, lbuf, xid, gc, 0, 0,
				  xw, 1, xl, ystart++);
		}
	    }
	    if (mag > 1)
	    {
		XFreeGC(display, lgc);
		XFreePixmap(display, lbuf);
	    }
	    XDestroyImage(line);

	    return;
	}
    }

/*
    fprintf(stderr, "Using old redraw.\n");
*/
    for(x = minx; x < maxx; x++)
    {
	ystart = -1;
	oldcont = -1;
	for(y = miny; y < maxy; y++)
	{
	    register int newcont;

	    switch (windowStatus)
	    {
	    case WINDOW_NONE:
	    case WINDOW_SET:
		newcont = spec2dcontour[x][y];
		break;
	    case WINDOW_OUTSIDE:
		newcont = (window[x][y]) ? 127 : spec2dcontour[x][y];
		break;
	    case WINDOW_INSIDE:
		newcont = (window[x][y]) ? spec2dcontour[x][y] : 127;
		break;
	    case WINDOW_ONLY:
		newcont = (window[x][y]) ? MAXCONTOURS+COLOUROFFSET-1 :
		    COLOUROFFSET;
		break;
	    }
	    if (uselast && newcont == lastredraw[x][y])
		newcont = -1;
	    if (newcont != -1)
		lastredraw[x][y] = newcont;
	    if (newcont != oldcont && oldcont != -1)
	    {
		if (monochrome)
		{
		    i = ((oldcont-COLOUROFFSET)*(mag*mag)
			 +usedContours/2)/(usedContours-1);
		    if (i > mag*mag)
			i = mag*mag;
		    fflush(stderr);
		    XSetStipple(display, gc, (oldcont == 127) ? windither
				: dither[i]);
		}
		else
		    XSetForeground(display, gc, (oldcont == 127) ? wincol
				   : index[oldcont]);
		XFillRectangle(display, xid, gc, x*mag, ystart*mag, mag,
			       (y-ystart)*mag);
	    }
	    if (newcont != oldcont || ystart == -1)
	    {
		oldcont = newcont;
		ystart = y;
	    }
	}
	if (oldcont != -1)
	{
	    if (monochrome)
	    {
		i = ((oldcont-COLOUROFFSET)*(mag*mag)+usedContours/2)
		    /(usedContours-1);
		if (i > mag*mag)
		    i = mag*mag;
		XSetStipple(display, gc, (oldcont == 127) ? windither
			    : dither[i]);
	    }
	    else
		XSetForeground(display, gc, (oldcont == 127) ? wincol :
			       index[oldcont]);
	    XFillRectangle(display, xid, gc, x*mag, ystart*mag, mag,
			   (y-ystart)*mag);
	}
    }
}

/*ARGSUSED*/
void
repaintSpectrum(canvas, paint_window, display, xid, rects)
	Canvas		canvas;
	Xv_window	paint_window;
	Display		*display;
	Window		xid;
	Xv_xrectlist	*rects;
{
    int i;
    XRectangle *r;
    XGCValues gc_val;
    unsigned long *index, wincol;
    struct windowPointList *p = windowPoints;
    char spectrum_label[80];

    switch(windowStatus)
    {
    case WINDOW_NONE:
	strcpy(spectrum_label,spectrumName);
	break;
    case WINDOW_INSIDE:
	sprintf(spectrum_label," %s inside %s",spectrumName, windowName);
	break;
    case WINDOW_OUTSIDE:
	sprintf(spectrum_label, "%s outside %s",spectrumName, windowName);
	break;
    case WINDOW_ONLY:
	sprintf(spectrum_label, "%s on %s",windowName, spectrumName);
	break;
    case WINDOW_SET:
        sprintf(spectrum_label, "Setting %s on %s", windowName, spectrumName);
        break;
    }

    xv_set(Spec_specWindow->specWindow, FRAME_LABEL, spectrum_label, NULL);

    XSetFunction(display, gc, GXcopy);

    if (rects)
    {
	XSetClipRectangles(display, gc, 0, 0, rects->rect_array,
			   rects->count, Unsorted);
    }
    else
    {
	gc_val.clip_mask = None;
	XChangeGC(display, gc, GCClipMask, &gc_val);
    }

    if (showGuidelines)
	drawGuidelines(display, xid, gc);
    if (showCrosshairs)
	drawCrosshairs(display, xid, gc, 0, 0, 0);

    if (monochrome)
    {
	XSetForeground(display, gc, BlackPixel(display,
					       DefaultScreen(display)));
	XSetBackground(display, gc, WhitePixel(display,
					       DefaultScreen(display)));
	XSetFillStyle(display, gc, FillOpaqueStippled);
	index = NULL;
    }
    else
    {
	XSetFillStyle(display, gc, FillSolid);
	index = (unsigned long *) xv_get(cms, CMS_INDEX_TABLE);
	wincol = index[COLOUROFFSET+MAXCONTOURS];
    }

    if (rects)
    {
/*
	fprintf(stderr, "repaintSpectrum rectangle list:");
*/
	i = rects->count;
	r = rects->rect_array;
	while(i--)
	{
/*
	    fprintf(stderr, " %dx%d+%d+%d", r->width, r->height, r->x, r->y);
*/
	    repaintRectangle(display, xid, index, wincol, (r->x-1)/mag,
			     (r->y-1)/mag, (r->x+r->width+mag-2)/mag,
			     (r->y+r->height+mag-2)/mag, 0);
	    r++;
	}
/*
	putc('\n', stderr);
*/
    }
    else
    {
/*
	fprintf(stderr, "repaintSpectrum full\n");
*/
	repaintRectangle(display, xid, index, wincol, 0, 0, specx, specy, 1);
    }
    
    if (monochrome)
	XSetFillStyle(display, gc, FillSolid);

    if (windowStatus == WINDOW_SET && p != NULL)
    {
	if (monochrome)
	{
	    XSetForeground(display, gc,
			   BlackPixel(display, DefaultScreen(display)) ^
			   WhitePixel(display, DefaultScreen(display)));
	    XSetFunction(display, gc, GXxor);
	}
	else
	    XSetForeground(display, gc, wincol);

        while(p->next != NULL)
        {
            XFillRectangle(display, xid, gc, p->x*mag, p->y*mag, 4, mag);
            XDrawLine(display, xid, gc, p->x*mag+mag/2, p->y*mag+mag/2,
		      p->next->x*mag+mag/2, p->next->y*mag+mag/2);
            p = p->next;
        }
        XFillRectangle(display, xid, gc, p->x*mag, p->y*mag, mag, mag);

        if (windowTail != NULL)
        {
            XSetFunction(display, gc, GXxor);
	    if (!monochrome)
		XSetForeground(display, gc, index[COLOUROFFSET+MAXCONTOURS-1]
			       ^ index[COLOUROFFSET]);
            XDrawLine(display, xid, gc, windowTail->x*mag+mag/2,
		      windowTail->y*mag+mag/2, winX*mag+mag/2, winY*mag+mag/2);
        }

    }

    if (showGuidelines)
	drawGuidelines(display, xid, gc);
    if (showCrosshairs)
	drawCrosshairs(display, xid, gc, 0, 0, 0);
	
    forceRedraw = 0;
}

Menu_item
addLevel(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op == MENU_NOTIFY)
    {
	if (usedContours < MAXCONTOURS)
	{
	    xv_set(contourSlider[usedContours-1], XV_SHOW, TRUE, NULL);
	    xv_set(contourButton[usedContours-1], XV_SHOW, TRUE, NULL);
	    usedContours++;
	}
	setContoursAndRedraw();
    }

    return item;
}

Menu_item
removeLevel(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op == MENU_NOTIFY)
    {
	if (usedContours > 2)
	{
	    usedContours--;
	    xv_set(contourSlider[usedContours-1], XV_SHOW, FALSE, NULL);
	    xv_set(contourButton[usedContours-1], XV_SHOW, FALSE, NULL);
	}
	setContoursAndRedraw();
    }

    return item;
}

Menu_item
showGamma(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op == MENU_NOTIFY)
	xv_set(Spec_gammaPopup->gammaPopup, XV_SHOW, TRUE, NULL);
    return item;
}

Panel_setting valueSetDisplayGamma(item, event)
	Panel_item	item;
	Event		*event;
{
    float num;

    if ((num = goodFloat(Spec_gammaPopup->gammaControls, (char *)
			 xv_get(item, PANEL_VALUE), 0.1, 10.0, event)) >= 0.1)
    {
	xv_set(Spec_gammaPopup->displayGammaSlider, PANEL_VALUE, (int) num*100,
	       NULL);
	displayGamma = num;
	brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
	alterColours();
    }
    return panel_text_notify(item, event);
}

/*ARGSUSED*/
void
sliderSetDisplayGamma(item, value, event)
Panel_item	item;
int		value;
Event		*event;
{
    char buffer[6];

    displayGamma = ((float) value) / 100;
    sprintf(buffer, "%5.2f", displayGamma);
    xv_set(Spec_gammaPopup->displayGammaValue, PANEL_VALUE, buffer, NULL);
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    alterColours();
}

/*ARGSUSED*/
Panel_setting
valueSetPrintoutGamma(item, event)
	Panel_item	item;
	Event		*event;
{
    float num;

    if ((num = goodFloat(Spec_gammaPopup->gammaControls, (char *)
			 xv_get(item, PANEL_VALUE), 0.1, 10.0, event)) >= 0.1)
    {
	xv_set(Spec_gammaPopup->printoutGammaSlider, PANEL_VALUE,
	       (int) num*100, NULL);
	printoutGamma = num;
    }
    return panel_text_notify(item, event);
}

/*ARGSUSED*/
void
sliderSetPrintoutGamma(item, value, event)
Panel_item item;
int value;
Event *event;
{
    char buffer[6];

    printoutGamma = ((float) value) / 100;
    sprintf(buffer, "%5.2f", printoutGamma);
    xv_set(Spec_gammaPopup->printoutGammaValue, PANEL_VALUE, buffer, NULL);
}

Menu_item
setWindow(item, op)
Menu_item	item;
Menu_generate	op;
{
    Xv_opaque menu;

    if (op != MENU_NOTIFY)
	return item;

/* window menu */
    menu = xv_get(Spec_specWindow->windowButton, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 1), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 2), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 6), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 7), MENU_INACTIVE, FALSE, NULL);

/* slice menu 16/1/95 */
    menu = xv_get(Spec_specWindow->sliceButton, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 7), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 8), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 9), MENU_INACTIVE, TRUE, NULL);

    windowStatus = WINDOW_SET;
    forceRedraw = 2;
    repaintSpectrum(XV_NULL, XV_NULL, (Display *)
		    XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			    XV_XID), (Xv_xrectlist *) NULL);

    if (windowPoints != NULL)
    {
        freeWindowList(windowPoints);
        windowPoints = NULL;
    }
    windowTail = NULL;
    xv_set(Spec_specWindow->specWindow,
	   FRAME_LEFT_FOOTER, "LEFT: add point   MIDDLE: delete last point   "
	   "RIGHT: finish", FRAME_RIGHT_FOOTER, "", NULL);
    if (showCrosshairs)
    {
	drawCrosshairs((Display *)
		       XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
		       (Window)
		       xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			      XV_XID), gc, 0, 0, 0);
	showCrosshairs = 0;
    }

    return item;
}

Menu_item
showInsideWindow(item, op)
Menu_item	item;
Menu_generate	op;
{
    if (op == MENU_NOTIFY)
    {
	windowStatus = WINDOW_INSIDE;
	repaintSpectrum(XV_NULL, XV_NULL, (Display *)
			XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
			(Window) 
			xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			       XV_XID), (Xv_xrectlist *) NULL);
    }

    return item;
}

Menu_item
showOutsideWindow(item, op)
Menu_item	item;
Menu_generate	op;
{
    if (op == MENU_NOTIFY)
    {
	windowStatus = WINDOW_OUTSIDE;
	repaintSpectrum(XV_NULL, XV_NULL, (Display *)
			XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
			(Window)
			xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			       XV_XID), (Xv_xrectlist *) NULL);
    }

    return item;
}

Menu_item
showWindow(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op == MENU_NOTIFY)
    {
	windowStatus = WINDOW_ONLY;
	repaintSpectrum(XV_NULL, XV_NULL, (Display *)
			XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
			(Window)
			xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			       XV_XID), (Xv_xrectlist *) NULL);
    }

    return item;
}

Menu_item
clearWindow(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    int i, j;

    if (op == MENU_NOTIFY)
    {
	for(i=0; i<specx; i++)
	    for(j=0; j<specy; j++)
		window[i][j] = 0;

	repaintSpectrum(XV_NULL, XV_NULL, (Display *)
			XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
			(Window)
			xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			       XV_XID), (Xv_xrectlist *) NULL);
    }

    return item;
}

Menu_item
showWithoutWindow(item, op)
Menu_item	item;
Menu_generate	op;
{
    if (op == MENU_NOTIFY)
    {
	windowStatus = WINDOW_NONE;
	repaintSpectrum(XV_NULL, XV_NULL, (Display *)
			XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
			(Window)
			xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			       XV_XID), (Xv_xrectlist *) NULL);
    }

    return item;
}

Menu_item
abortSetWindow(item, op)
Menu_item	item;
Menu_generate	op;
{
    Xv_opaque menu;

    if (op != MENU_NOTIFY)
	return item;

/* window menu */    
    menu = xv_get(Spec_specWindow->windowButton, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 1), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 2), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 6), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 7), MENU_INACTIVE, TRUE, NULL);

/* slice menu 16/1/95 */
    menu = xv_get(Spec_specWindow->sliceButton, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 7), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 8), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 9), MENU_INACTIVE, FALSE, NULL);

    windowStatus = WINDOW_OUTSIDE;
    forceRedraw = 1;
    repaintSpectrum(XV_NULL, XV_NULL, (Display *)
		    XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			    XV_XID), (Xv_xrectlist *) NULL);

    if (windowPoints != NULL)
    {
        freeWindowList(windowPoints);
        windowPoints = NULL;
    }
    windowTail = NULL;
    Slicing &= (~PROJECTION);

    if (Slicing & SLICING)
    {
	drawCrosshairs((Display *)
		       XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
		       (Window)
		       xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			      XV_XID), gc, 0, 0, 0);
	showCrosshairs = 1;
    }
    
    xv_set(Spec_specWindow->specWindow,
	   FRAME_LEFT_FOOTER, "Window set abandoned",
	   FRAME_RIGHT_FOOTER, (Slicing & SLICING) ? "Slicing on":"", NULL);

    return item;
}

Notify_value
rubberBand(win, event, arg, type)
Xv_window	win;
Event		*event;
Notify_arg	arg;
Notify_event_type type;
{
    unsigned long *index;
    Display *display = XV_DISPLAY_FROM_WINDOW(win);
    Window xid = xv_get(win, XV_XID);
    int move = ((event_action(event) == ACTION_SELECT ||
		 event_action(event) == ACTION_ADJUST ||
		 event_action(event) == ACTION_MENU) &&
		event_is_down(event)) || event_action(event) == LOC_MOVE ||
		    event_action(event) == LOC_DRAG,
		    newX, newY;

    static char coordinates[32];

    if (move)
    {
	newX = (event_x(event)-1)/mag;
	newY = (event_y(event)-1)/mag;

	if (newX < specx && newY < specy && newX >= 0 && newY >= 0)
	{
	    sprintf(coordinates, "(%d, %d) = %d", newX, specy-newY-1,
		    spec2d[newX][newY]);
	    xv_set(Spec_specWindow->coordinates,
		   PANEL_LABEL_STRING, coordinates, NULL);
	}
    }

    if (gc == NULL)
	gc = XCreateGC(display, xid, 0, NULL);

    XSetClipMask(display, gc, None);

    if (windowStatus == WINDOW_SET && move)
    {
	if (monochrome)
	    XSetForeground(display, gc,
			   BlackPixel(display, DefaultScreen(display)) ^
			   WhitePixel(display, DefaultScreen(display)));
	else
	    index = (unsigned long *) xv_get(cms, CMS_INDEX_TABLE);
	
        if (windowTail != NULL)
        {
	    if (!monochrome)
		XSetForeground(display, gc, index[COLOUROFFSET+MAXCONTOURS-1]
			       ^ index[COLOUROFFSET]);
            XSetFunction(display, gc, GXxor);
            XDrawLine(display, xid, gc, windowTail->x*mag+mag/2,
		      windowTail->y*mag+mag/2, winX*mag+mag/2, winY*mag+mag/2);
            XSetFunction(display, gc, GXcopy);
        }
	
	if (!monochrome)
	    XSetForeground(display, gc, index[COLOUROFFSET+MAXCONTOURS]);
	
        winX = newX;
        winY = newY;
    }

    if (event_action(event) == ACTION_SELECT)
	newPoint(win, event, arg, type);
    
    if (event_action(event) == ACTION_ADJUST)
	deletePoint(win, event, arg, type);
    
    if (event_action(event) == ACTION_MENU)
	closeWindow(win, event, arg, type);
    
    if (windowStatus == WINDOW_SET && windowTail != NULL && move)
    {
	if (monochrome)
	    XSetForeground(display, gc,
			   BlackPixel(display, DefaultScreen(display)) ^
			   WhitePixel(display, DefaultScreen(display)));
	else
	{
	    index = (unsigned long *) xv_get(cms, CMS_INDEX_TABLE);
	    XSetForeground(display, gc, index[COLOUROFFSET+MAXCONTOURS-1] ^
			   index[COLOUROFFSET]);
	}
	XSetFunction(display, gc, GXxor);
	XDrawLine(display, xid, gc, windowTail->x*mag+mag/2,
		  windowTail->y*mag+mag/2, winX*mag+mag/2, winY*mag+mag/2);
	XSetFunction(display, gc, GXcopy);
    }

    if (showCrosshairs)
    {
	drawCrosshairs(display, xid, gc, 0, 0, 0);
	drawCrosshairs(display, xid, gc, 1, event_x(event), event_y(event));
    }

    /*** 16/1/95 ***/
    if ( (Slicing & SLICING) && windowStatus != WINDOW_SET) {
	if (event_is_down(event) && event_action(event) ==  ACTION_SELECT)
	    do_simple_slice(event, newX, newY);
    }

    return notify_next_event_func(win, (Notify_event) event, arg, type);
}

/*ARGSUSED*/
void
newPoint(win, event, arg, type)
Xv_window	win;
Event		*event;
Notify_arg	arg;
Notify_event_type type;
{
    Display *display = XV_DISPLAY_FROM_WINDOW(win);
    Window xid = xv_get(win, XV_XID);

    if (windowStatus != WINDOW_SET || !event_is_down(event))
        return;

    if (monochrome)
	XSetFunction(display, gc, GXxor);
    XFillRectangle(display, xid, gc, winX*mag, winY*mag, mag, mag);
    if (windowTail != NULL)
    {
        XDrawLine(display, xid, gc, windowTail->x*mag+mag/2,
		  windowTail->y*mag+mag/2, winX*mag+mag/2, winY*mag+mag/2);
        windowTail = windowTail->next = (struct windowPointList *)
            malloc(sizeof(struct windowPointList));
    }
    else
        windowTail = windowPoints = (struct windowPointList *)
            malloc(sizeof(struct windowPointList));
    windowTail->x = winX;
    windowTail->y = winY;
    windowTail->next = NULL;
}

/*ARGSUSED*/
void
deletePoint(win, event, arg, type)
Xv_window	win;
Event		*event;
Notify_arg	arg;
Notify_event_type type;
{
    Xv_xrectlist rects;
    struct windowPointList *p = windowPoints;

    if (windowStatus != WINDOW_SET || !event_is_down(event) ||
	windowTail == NULL)
        return;


    if (p == windowTail)
    {
	rects.count = 1;
	rects.rect_array->x = windowTail->x*mag;
	rects.rect_array->y = windowTail->y*mag;
	rects.rect_array->width = mag;
	rects.rect_array->height = mag;

	free(windowPoints);
	windowPoints = NULL;
	windowTail = NULL;
	p = NULL;
    }
    else
    {
	rects.count = 1;
	while(p->next != windowTail)
	    p = p->next;
	rects.rect_array->x = ((windowTail->x < p->x) ? windowTail->x :
			       p->x)*mag;
	rects.rect_array->y = ((windowTail->y < p->y) ? windowTail->y :
			       p->y)*mag;
	rects.rect_array->width = ((windowTail->x > p->x) ? windowTail->x :
				   p->x)*mag - rects.rect_array->x + mag;
	rects.rect_array->height = ((windowTail->y > p->y) ? windowTail->y :
				    p->y)*mag - rects.rect_array->y+mag;

	free(windowTail);
	p->next = NULL;
	windowTail = NULL;
    }

    repaintSpectrum(XV_NULL, XV_NULL, (Display *)
		    XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
	    (Window) xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			    XV_XID), &rects);

    windowTail = p;
}

/*ARGSUSED*/
void
closeWindow(win, event, arg, type)
Xv_window	win;
Event		*event;
Notify_arg	arg;
Notify_event_type type;
{
    Pixmap pix;
    Display *display = XV_DISPLAY_FROM_WINDOW(win);
    Window xid = xv_get(win, XV_XID);
    XPoint *points;
    int ps = 0, i, j;
    struct windowPointList *p = windowPoints;
    XImage *filled;
    GC gc1;
    
    if (windowStatus != WINDOW_SET || !event_is_down(event))
        return;

    if (windowPoints == NULL || windowTail == windowPoints)
    {
	abortSetWindow(XV_NULL, MENU_NOTIFY);
	return;
    }

    while(p)
    {
	ps++;
	p = p->next;
    }

    points = (XPoint *) malloc(sizeof(XPoint) * ps);

    ps = 0;

    p = windowPoints;

    while(p)
    {
	points[ps].x = p->x;
	points[ps++].y = p->y;
	p = p->next;
    }

    pix = XCreatePixmap(display, xid, specx, specy, 1);

    gc1 = XCreateGC(display, pix, 0, NULL);

    XSetForeground(display, gc1, 0);

    XSetFillStyle(display, gc1, FillSolid);
    XFillRectangle(display, pix, gc1, 0, 0, specx, specy);

    XSetForeground(display, gc1, 1);
    XSetFillRule(display, gc1, WindingRule);

    XFillPolygon(display, pix, gc1, points, ps, Complex, CoordModeOrigin);
    XDrawLines(display, pix, gc1, points, ps, CoordModeOrigin);
    XDrawLine(display, pix, gc1, windowPoints->x, windowPoints->y,
              windowTail->x, windowTail->y);

    free(points);
    XFreeGC(display, gc1);

    filled = XGetImage(display, pix, 0, 0, specx, specy, 1, XYPixmap);

    for(i=0; i<specx; i++)
	for(j=0; j<specy; j++)
	    window[i][j] = (unsigned char) XGetPixel(filled, i, j);

    XDestroyImage(filled);
    XFreePixmap(display, pix);

    if (Slicing & PROJECTION) {
	  do_projection(event);
	  Slicing &= (~PROJECTION);
    }
    else
	  store_window();

    RRP(0);
    windowChanged3d();
    abortSetWindow(XV_NULL, MENU_NOTIFY);

    xv_set(Spec_specWindow->specWindow,
	   FRAME_LEFT_FOOTER, "Window closed and stored",
	   FRAME_RIGHT_FOOTER, (Slicing & SLICING) ? "Slicing on":"", NULL);
}

void freeWindowList(p)
struct windowPointList *p;
{
    if (p->next != NULL)
        freeWindowList(p->next);
    free(p);
}

/*ARGSUSED*/
void
changeRed(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
    rawColour[rgbColour].red = value;
    brighten(rawColour, rgbColour, rgbColour+1, displayColour, displayGamma);
    alterColours();
}

/*ARGSUSED*/
void
changeGreen(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
    rawColour[rgbColour].green = value;
    brighten(rawColour, rgbColour, rgbColour+1, displayColour, displayGamma);
    alterColours();
}

/*ARGSUSED*/
void
changeBlue(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
    rawColour[rgbColour].blue = value;
    brighten(rawColour, rgbColour, rgbColour+1, displayColour, displayGamma);
    alterColours();
}

/*ARGSUSED*/
void
showRgbPopup(item, event)
Panel_item item;
Event *event;
{
    int i;

    if (monochrome)
	return;
    i = (int) xv_get(item, PANEL_CLIENT_DATA);
    xv_set(Spec_rgbPopup->redSlider, PANEL_VALUE, rawColour[i].red, NULL);
    xv_set(Spec_rgbPopup->greenSlider, PANEL_VALUE, rawColour[i].green, NULL);
    xv_set(Spec_rgbPopup->blueSlider, PANEL_VALUE, rawColour[i].blue, NULL);
    xv_set(Spec_rgbPopup->rgbPopup, XV_SHOW, TRUE, NULL);
    rgbColour = i;
}

#include "sort_def.h"
#include "sort_mem.h"
static int win2d;
/*ARGSUSED*/
Notify_value
sort_sigusr2_handler(client,sig,mode)
      Notify_client    client;
      int              sig;
      Notify_signal_mode              mode;
{
/* receive this signal from sort process to display 2d spectra */
    int spec_type;
    int x;

    if (debuglevel >= 3)
	fprintf(stderr,"sort_spec2d: received SIGUSR2\n");
      
/* open if in iconic state and set window on top */
    xv_set(Spec_specWindow->specWindow, FRAME_CLOSED, FALSE, NULL);
    wmgr_top(Spec_specWindow->specWindow);
      
/* read data from .SORT_pipe */
    if (read_from_pipe(".SORT_pipe") == SORT_FAIL) {
	fprintf(stderr,"sort_spec2d: Read from sort process failed");
	return NOTIFY_DONE;
    }
    if ( sscanf(pshm->com_str,"%*s %d",&spec_type) != 1) {
	fprintf(stderr,"sort_spec2d: Decoding of display spectrum "
		"command \"%s\" failed.", pshm->com_str);
	return NOTIFY_DONE;
    }
    if (spec_type != 2 && spec_type != 3) {
	fprintf(stderr,"sort_spec2d asked to display non 2d spectrum!");
	return NOTIFY_DONE;
    }

/* clear down old spectrum */
    xv_set(Spec_specWindow->windowButton,PANEL_INACTIVE,TRUE,NULL);
    xv_set(Spec_specWindow->sliceButton,PANEL_INACTIVE,FALSE,NULL);
    win2d = -1;
    memset(spec2d, 0, sizeof(spec2d));
    windowStatus = WINDOW_NONE;
    specMax = 0;

    strcpy(spectrumName,pshm->name);
    specx = (pshm->size > MAXSPECX) ? MAXSPECX : pshm->size;
    specy = specx; /* square spectra to start off with */
      
/*
 * spec2d[0][0] is the pixel on top left hand corner of the display
 * display still adheres to x=0, y=0 being in the bottom left hand corne
 * however
 */

    for(x=0; x < specx ;x++)
    {
	register int *dp = pshm->array + (x+1)*specy - 1;
	register int *sp = spec2d[x];
	register int data, y;

	for(y=0; y < specy ; y++)
	    if ((data = *sp++ = *dp--) > specMax)
		specMax = data;
    }
      
    xv_set(Spec_printerPopup->printTitle, PANEL_VALUE, pshm->name, NULL);

    if (spec_type == 3)
    {
	win2d = pshm->win2d;
	if (read_from_pipe(".SORT_pipe_W") == SORT_FAIL)
	    fprintf(stderr,"sort_spec2d: Read of window from sort process "
		    "failed");
	else if ( sscanf(pshm->com_str,"%*s %d",&spec_type) != 1)
	    fprintf(stderr,"sort_spec2d: Decoding of display window "
		    "command \"%s\" failed.", pshm->com_str);
	else if (spec_type != 3)
	    fprintf(stderr,"sort_spec2d asked to display unexpected window "
		    "type \"%s\".", pshm->com_str);
	else if (pshm->size != specx)
	    fprintf(stderr, "sort_spec2d: Window size does not match "
		    "spectrum size.\n");
	else
	{
	    memset(window, 0, sizeof(window));
	    windowStatus = WINDOW_OUTSIDE;
	    strcpy(windowName, pshm->name);
	    for(x=0; x < specx ;x++)
	    {
		register int *dp = pshm->array + (x+1)*specy - 1;
		register unsigned char *wp = window[x];
		register int y;

		for(y=0; y < specy; y++)
		    *wp++ = *dp-- != 0;
	    }
	    xv_set(Spec_specWindow->windowButton,PANEL_INACTIVE,FALSE,NULL);
	    xv_set(Spec_specWindow->sliceButton,PANEL_INACTIVE,TRUE,NULL);
	}
    }

    spectrumLoaded();
    setContoursAndRedraw();

    return NOTIFY_DONE;
}
/***  16/1/95 ***/
void
store_window()
{
    if (debuglevel >= 3)
	fprintf(stderr,"sort_spec2d: storing 2d window\n");

    if (!sort_window)
	return;

    if (store_spectrum(".SORT_pipe_W", "WINDOW 4", SORT_TRUE) == -1) {
	  fprintf(stderr,"sort_spec2d: failure to write out window\n");
	  return;
    }
      
/* tell the sort process to read the window and store it */
    (void) kill(getppid(),SIGUSR2);
      
    return;
}

/*ARGSUSED*/
Notify_value
destroy_func(client,sig,mode)
      Notify_client    client;
      int              sig;
      Notify_signal_mode              mode;
{
      if (DBX_val > 3) fprintf(stderr,"sort_spec2d: received SIGTERM\n");
/*      xv_destroy_safe(Spec_specWindow->specWindow); */
      exit(0); 
#ifdef lint
      return XV_OK;
#endif
}

/*ARGSUSED*/
void
showPrint(item, event)
Panel_item item;
Event *event;
{
    xv_set(Spec_printerPopup->printerPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
    xv_set(Spec_printerPopup->printerPopup, XV_SHOW, TRUE, NULL);
}

/*ARGSUSED*/
Menu_item
arbitraryAngle(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op != MENU_NOTIFY)
	return item;

    xv_set(Spec_projectPopup->projectPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
    xv_set(Spec_projectPopup->projectPopup, XV_SHOW, TRUE, NULL);
    if (!showGuidelines)
    {
	showGuidelines = 1;
	drawGuidelines((Display *)
		       XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
		       (Window)
		       xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			      XV_XID), gc);
	RRP(0);
    }
    return item;
}

void
psstring(fp, s)
FILE *fp;
char *s;
{
    if (putc('(', fp) == EOF)
        return;
    while(*s != '\0')
    {
	switch(*s)
	{
	case '(':
	case ')':
	case '\\':
	    if (putc('\\', fp) == EOF)
                return;
	    /* FALL THROUGH */
	default:
	    if (putc(*s, fp) == EOF)
                return;
	    break;
	}
	s++;
    }
    if (putc(')', fp) == EOF)
        return;
    if (putc('\n', fp) == EOF)
        return;
}

float tickspacing(range)
double range;
{
    float ts;

    ts = pow(10.0, floor(log10(range)))*2;
    if (range/ts < 3)
	ts /= 2;
    if (range/ts < 3)
	ts /= 2;
    if (range/ts < 3)
	ts /= 2.5;
    if (range/ts < 3)
	ts /= 2;
    return(ts);
}

/*
 * Because of the nofitier we can't use popen as that calls system which calls
 * wait. So we have to fork() before we can system()
 */
FILE *
mypopen(command, type)
char *command, *type;
{
    int fd;
    FILE *fp;

    if ((fd = mypopenfd(command, type)) == -1)
	return(NULL);

    fp = fdopen(fd, type);

    return(fp);
}

int mypopenfd(command, type)
char *command;
char *type;
{
    int fd[2], i;
    pid_t pid;

    if (socketpair(AF_UNIX, SOCK_STREAM, 0, fd) == -1)
	return(-1);
    switch(pid = fork())
    {
    case -1:
	close(fd[0]);
	close(fd[1]);
	return(-1);
    case 0:
	close(fd[0]);
        /* Decide which descriptor to connect to pipe, and which to leave
           as parent */
        switch(*type)
        {
        case 'r':
            dup2(fd[1], 1);
            break;
        case 'w':
            dup2(fd[1], 0);
            break;
        default:
            dup2(fd[1], 0);
            dup2(fd[1], 1);
            break;
        }
        /*
         * As recommended in xview programming manual, close all file
         * descriptors and reset all signals.
         */
	for(i=getdtablesize(); i>2; i--)
	    close(i);
	for(i=NSIG+1; i--; )
	    signal(i, SIG_DFL);
	/* Let sh worry about parsing the command line */
	_exit(system(command));
	break;
    default:
	close(fd[1]);
	break;
    }

    /* Setup child catcher */

    notify_set_wait3_func(sort_client, notify_default_wait3, pid);

    return(fd[0]);
}

/*ARGSUSED*/
Notify_value
blankfunc(client, sig, when)
Notify_client client;
int sig;
Notify_signal_mode when;
{
    return(NOTIFY_DONE);
}

void printPalette(fp, palette)
FILE *fp;
int palette;
{
    int i, j, v;

    j = 0;
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, printoutGamma);
    for(i=0; i<MAXCONTOURS; i++)
    {
	v = (i >= usedContours-1) ? MAXCONTOURS-1 : i;
	switch(palette)
	{
	case 0: /* White to black */
	    fprintf(fp, "%02x", (i >= usedContours) ? 0 :
		    (int) (255-i*255.0/(usedContours-1)));
	    j++;
	    break;
	case 1: /* Greyscale version of display */
	    fprintf(fp, "%02x", (int) (displayColour[v].red*0.299 +
				       displayColour[v].green*0.587 +
				       displayColour[v].blue*0.114 + 0.5));
	    j++;
	    break;
	case 2: /* Colour */
	    fprintf(fp, "%02x%02x%02x", displayColour[v].red,
		    displayColour[v].green, displayColour[v].blue);
	    j+=3;
	    break;
	}
	if (j >= 32)
	{
	    putc('\n', fp);
	    j = 0;
	}
    }
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    if (j != 0)
	putc('\n', fp);
}

static int printerPipe;

FILE *openPrinterFile(x, y)
int x,y;
{
    FILE *fp;

    switch(xv_get(Spec_printerPopup->printTo, PANEL_VALUE))
    {
    case 0: /* print to command */
	printerPipe = 1;
        if ((fp = mypopen((char *)
			  xv_get(Spec_printerPopup->printString, PANEL_VALUE),
                          "w")) == NULL)
        {
	    notice_prompt(Spec_printerPopup->printerPopup, NULL,
			  NOTICE_FOCUS_XY, x, y,
			  NOTICE_MESSAGE_STRINGS,
			  "Unable to open output pipe. Error was",
                          ERRSTRING, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    return NULL;
        }
        /*
         * Ignore SIGPIPE signals, we'll detect those by looking for errors
         * returned by writing.
         */
        notify_set_signal_func(sort_client, blankfunc, SIGPIPE, NOTIFY_ASYNC);
	break;
    default: /* print to file */
	printerPipe = 0;
	if ((fp = fopen((char *) xv_get(Spec_printerPopup->printFilename,
					PANEL_VALUE), "w")) == NULL)
	{
	    notice_prompt(Spec_printerPopup->printerPopup, NULL,
			  NOTICE_FOCUS_XY, x, y,
			  NOTICE_MESSAGE_STRINGS,
			  "Error whilst opening output file. Error was :",
			  ERRSTRING, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    return NULL;
	}
	break;
    }
    
    return fp;
}

void closePrinterFile(fp, x, y)
FILE *fp;
int x, y;
{
    if (ferror(fp))
        notice_prompt(Spec_printerPopup->printerPopup, NULL,
                      NOTICE_FOCUS_XY, x, y,
                      NOTICE_MESSAGE_STRINGS,
                      "Error whilst writing output file. Error was :",
		      (errno == EPIPE) ?
		      "Broken pipe. Try checking your print command." :
		      ERRSTRING, NULL,
                      NOTICE_BUTTON_YES, "Ok",
                      NULL);
    fclose(fp);
    if (printerPipe)
        notify_set_signal_func(sort_client, NOTIFY_FUNC_NULL, SIGPIPE,
                               NOTIFY_ASYNC);
}

void writeFshowCode(fp)
FILE *fp;
{
    if (!ferror(fp))
	fputs(
"/reencodeISO {dup dup findfont dup length dict begin {1 index\n"
"/FID ne {def} {pop pop} ifelse } forall /Encoding ISOLatin1Encoding def\n"
"currentdict end definefont def } def\n"
"/ISOLatin1Encoding [\n"
"/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
"/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
"/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
"/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
"/space/exclam/quotedbl/numbersign/dollar/percent/ampersand/quoteright\n"
"/parenleft/parenright/asterisk/plus/comma/minus/period/slash\n"
"/zero/one/two/three/four/five/six/seven/eight/nine/colon/semicolon\n"
"/less/equal/greater/question/at/A/B/C/D/E/F/G/H/I/J/K/L/M/N\n"
"/O/P/Q/R/S/T/U/V/W/X/Y/Z/bracketleft/backslash/bracketright\n"
"/asciicircum/underscore/quoteleft/a/b/c/d/e/f/g/h/i/j/k/l/m\n"
"/n/o/p/q/r/s/t/u/v/w/x/y/z/braceleft/bar/braceright/asciitilde\n"
"/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
"/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef/.notdef\n"
"/.notdef/dotlessi/grave/acute/circumflex/tilde/macron/breve\n"
"/dotaccent/dieresis/.notdef/ring/cedilla/.notdef/hungarumlaut\n"
"/ogonek/caron/space/exclamdown/cent/sterling/currency/yen/brokenbar\n"
"/section/dieresis/copyright/ordfeminine/guillemotleft/logicalnot\n"
"/hyphen/registered/macron/degree/plusminus/twosuperior/threesuperior\n"
"/acute/mu/paragraph/periodcentered/cedilla/onesuperior/ordmasculine\n"
"/guillemotright/onequarter/onehalf/threequarters/questiondown\n"
"/Agrave/Aacute/Acircumflex/Atilde/Adieresis/Aring/AE/Ccedilla\n"
"/Egrave/Eacute/Ecircumflex/Edieresis/Igrave/Iacute/Icircumflex\n"
"/Idieresis/Eth/Ntilde/Ograve/Oacute/Ocircumflex/Otilde/Odieresis\n"
"/multiply/Oslash/Ugrave/Uacute/Ucircumflex/Udieresis/Yacute\n"
"/Thorn/germandbls/agrave/aacute/acircumflex/atilde/adieresis\n"
"/aring/ae/ccedilla/egrave/eacute/ecircumflex/edieresis/igrave\n"
"/iacute/icircumflex/idieresis/eth/ntilde/ograve/oacute/ocircumflex\n"
"/otilde/odieresis/divide/oslash/ugrave/uacute/ucircumflex/udieresis\n"
"/yacute/thorn/ydieresis] def\n"
"/Times-Roman reencodeISO\n"
"/Times-Bold reencodeISO\n"
"/Times-Italic reencodeISO\n"
"/Times-BoldItalic reencodeISO\n"
"/Helvetica reencodeISO\n"
"/Helvetica-Bold reencodeISO\n"
"/Helvetica-Oblique reencodeISO\n"
"/Helvetica-BoldOblique reencodeISO\n"
"/D {load def} def\n"
"/m /moveto D\n"
"/l /lineto D\n"
"/rm /rmoveto D\n"
"/rl /rlineto D\n"
"/s /stroke D\n"
"/c /closepath D\n"
"/cp /currentpoint D\n"
"/sw /stringwidth D\n"
"/ss {scalefont setfont} def\n"
"/css {findfont dup /curfont exch def cursize ss} def\n"
"/ccss {curfont cursize ss} def\n"
"/o0 {/offset 0 def} def\n"
"/o1 {/offset 128 def} def\n"
"/css0 {/hbarmove exch def css o0} def\n"
"/ch 1 string def\n"
"/fs {/cursize cursize 0.7 mul def ccss} def\n"
"/actarray 256 array def\n"
"0 1 255 {actarray exch {} put} for\n"
"actarray 43 {/cursize cursize 0.7 div def ccss} put\n"
"actarray 45 {fs} put\n"
"actarray 48 {/Times-Roman {0.33 -0.02} css0} put\n"
"actarray 49 {/Times-Bold {0.33 -0.02} css0} put\n"
"actarray 50 {/Times-Italic {0.33 0.05} css0} put\n"
"actarray 51 {/Times-BoldItalic {0.33 0.05} css0} put\n"
"actarray 52 {/Helvetica {0.4 -0.02} css0} put\n"
"actarray 53 {/Helvetica-Bold {0.4 -0.02} css0} put\n"
"actarray 54 {/Helvetica-Oblique {0.4 0.06} css0} put\n"
"actarray 55 {/Helvetica-BoldOblique {0.4 0.08} css0} put\n"
"actarray 56 {/Symbol {1 0} css0} put\n"
"actarray 57 {/Symbol /hbarmove {1 0} def css o1} put\n"
"actarray 67 {o1} put\n"
"actarray 71 {gsave /gdepth gdepth 1 add def} put\n"
"actarray 78 {/cursize initsize def ccss 0 baseline cp exch pop sub rm} put\n"
"actarray 83 {0 cursize 2 div rm fs} put\n"
"actarray 85 {/underline true def} put\n"
"actarray 90 {/ZapfDingbats /hbarmove {1 0} def css o1} put\n"
"actarray 92 {(\\\\) action} put\n"
"actarray 99 {o0} put\n"
"actarray 103 {gdepth 0 gt {grestore /gdepth gdepth 1 sub def} if} put\n"
"actarray 104 {/cursize cursize /underline underline /underline false def\n"
"gsave hbarmove cursize mul exch cursize mul rm fs 10 rotate (-) action\n"
"grestore def def ccss (h) action} put\n"
"actarray 115 {0 cursize 2 div neg rm fs} put\n"
"actarray 117 {/underline false def} put\n"
"actarray 122 {/ZapfDingbats {1 0} css0} put\n"
"/fproc {/initsize exch def /cursize initsize def /underline false def\n"
"/command false def /baseline cp exch pop def /Helvetica {0.4 0} css0\n"
"/gdepth 0 def {command {actarray exch get exec /command false def} {dup 92\n"
"eq {/command true def pop} {offset add ch exch 0 exch put ch action}\n"
"ifelse} ifelse} forall gdepth {grestore} repeat} def\n"
"/fshow {/action {underline {cursize 10 div setlinewidth dup sw pop\n"
"gsave 0 cursize 5 div neg rm 0 rl s grestore} if show} def fproc} def\n"
"/cfshow {2 copy cp pop /left exch def gsave /action {sw pop 0 rm} def fproc\n"
"cp pop left sub 2 div neg grestore 0 rm fshow} def\n"
"/rshow {dup sw pop neg dup 0 rm exch show 0 rm} def\n", fp);
}


/*ARGSUSED*/
void
printSpectrum(item, event)
	Panel_item	item;
	Event		*event;
{
    FILE *fp;
    float xgain, ygain, xoffset, yoffset, xt, yt, xf, yf;
    int i, j, v, contourValue[MAXCONTOURS], palette, dest, top, scale;

    if ((xgain = goodFloat(Spec_printerPopup->printerPopup, (char *)
			   xv_get(Spec_printerPopup->printXGain, PANEL_VALUE),
			   -1e37, 1e37, event)) < -1e37)
	return;
    if ((ygain = goodFloat(Spec_printerPopup->printerPopup, (char *)
			   xv_get(Spec_printerPopup->printYGain, PANEL_VALUE),
			   -1e37, 1e37, event)) < -1e37)
	return;
    if ((xoffset = goodFloat(Spec_printerPopup->printerPopup, (char *)
			     xv_get(Spec_printerPopup->printXOffset,
				    PANEL_VALUE),
			     -1e37, 1e37, event)) < -1e37)
	return;
    if ((yoffset = goodFloat(Spec_printerPopup->printerPopup, (char *)
			   xv_get(Spec_printerPopup->printYOffset,
				  PANEL_VALUE),
			   -1e37, 1e37, event)) < -1e37)
	return;

    palette = xv_get(Spec_printerPopup->printerPalette, PANEL_VALUE);

    if ((fp = openPrinterFile(event_x(event), event_y(event))) == NULL)
	return;

    dest = xv_get(Spec_printerPopup->printTo, PANEL_VALUE);

    top = 105 + 15*usedContours;
    if (top < 495)
	top = 495;
    if (*((char *) xv_get(Spec_printerPopup->printTitle, PANEL_VALUE)) != '\0'
	&& top < 580)
	top=580;
    if (*((char *) xv_get(Spec_printerPopup->printSubtitle, PANEL_VALUE))
	!= '\0' && top < 545)
	top=545;

    scale = xv_get(Spec_printerPopup->printScaleSlider, PANEL_VALUE);

    fputs("%!PS-Adobe-2.0\n%%Title: sunsort\n%%Creator: sort_spec2d\n", fp);
    if (!ferror(fp))
    {
	if (dest == 2)
	    fprintf(fp, "%%%%BoundingBox: %d %d %d %d\n", 30*scale/100,
		    40*scale/100, 580*scale/100, top*scale/100);
	else
	    fputs("%%Pages: 1\n", fp);
    }
    if (!ferror(fp))
	fputs("%%EndComments\n/spec2ddict 64 dict def spec2ddict begin\n"
	      "/pixline 128 string def\n", fp);
    if (palette == 2)
    {
	if (!ferror(fp))
	    fprintf(fp, "/colline 384 string def\n/table %d string def\n",
		    MAXCONTOURS*3);
	if (!ferror(fp))
	    fputs(
"% Supply colorimage for printers which don't support it. This version from\n"
"% xv which got it from xwd2ps, though I've changed the red, green and blue\n"
"% multipliers to match the values in the C code\n"
"/colorimage where {pop} {/colortogray {/rgbdata exch store rgbdata length 3\n"
"idiv /npixls exch store /rgbindx 0 store /grays npixls string store 0 1\n"
"npixls 1 sub {grays exch rgbdata rgbindx get 299 mul rgbdata rgbindx 1 add\n"
"get 587 mul rgbdata rgbindx 2 add get 114 mul add add 1000 idiv put\n"
"/rgbindx rgbindx 3 add store} for grays} bind def /mergeprocs {dup length 3\n"
"-1 roll dup length dup 5 1 roll 3 -1 roll add array cvx dup 3 -1 roll 0\n"
"exch putinterval dup 4 2 roll putinterval} bind def /colorimage {pop pop\n"
"{colortogray} mergeprocs image} bind def} ifelse\n", fp);
    }
    else
	if (!ferror(fp))
	    fprintf(fp, "/table %d string def\n", MAXCONTOURS);
    writeFshowCode(fp);
    if (!ferror(fp))
	fputs(
"/format {dup dup 0 eq {pop (0.00) cvs rshow} {abs log floor cvi dup dup 6\n"
"le exch 0 ge and {pop 10 string cvs rshow} {dup 5 string cvs 3 1 roll 10\n"
"exch exp div 100 mul 0.5 add floor 100 div 0.001 add 5 string cvs 0 4\n"
"getinterval exch 0 5 rm currentfont dup 0.66666 ss exch\n"
"rshow setfont 0 -5 rm (x10) rshow rshow } ifelse} ifelse} def\n"
"/tick {/d exch def /L exch def {-10 exch h mul m 10 0 rl w 0 rm 10 0 rl\n"
"w 25 add neg 0 rm L format s /L L d add def} for /d exch def /L exch def {w\n"
"mul -10 m 0 10 rl 0 h rm 0 10 rl 0 h 30 add neg rm L pixline cvs dup\n"
"sw neg exch neg 2 div exch rm show s /L L d add def} for {-5 exch h\n"
"mul m 5 0 rl w 0 rm 5 0 rl} for {w mul -5 m 0 5 rl 0 h rm 0 5 rl} for} def\n"
"/dumptwo {gsave dup scale table currentfile exch readhexstring pop pop\n"
"currentfile pixline readline pop pop dup 1 add dup table exch 0 exch", fp);
    if (palette == 2)
	if (!ferror(fp))
	    fputs(" 3 mul", fp);
    if (!ferror(fp))
	fputs("\n"
	      "getinterval exch 1 exch 8 [0.03333 0 0 0.06667 -2 -6.6667] {}",
	      fp);
    if (!ferror(fp))
    {
	if (palette == 2)
	    fputs("false 3\ncolor", fp);
	else
	    putc('\n', fp);
    }
    if (!ferror(fp))
	fputs(
"image 0 setgray 0 setlinewidth /Helvetica findfont 10 ss -1 0 {15 mul\n"
"100 add dup 60 exch newpath m 30 0 rl 0 15 rl -30 0 rl c s 9 add 55 exch m\n"
"format} for 185 100 translate 1 setlinewidth /w 384 def /h 384 def tick w 2\n"
"div 420 m 18 cfshow w 2 div 450 m 24 cfshow 90 rotate h 2 div 65 m 24\n"
"cfshow -90 rotate w 2 div -50 m 24 cfshow\n", fp);
    if (!ferror(fp))
	fprintf(fp, "%d %d 8 [%f 0 0 %f 0 0] {currentfile pixline readline\n",
		specx, specy, specx/384.0, specy/384.0);
    if (!ferror(fp))
    {
	if (palette == 2)
	    fputs(
"pop length dup 1 sub 0 exch 1 exch {dup pixline exch get table exch 48 sub\n"
"3 mul 3 getinterval exch 3 mul exch colline 3 1 roll putinterval} for\n"
"colline exch 0 exch 3 mul getinterval} false 3 colorimage", fp);
	else
	    fputs(
"pop dup length 1 sub 0 exch 1 exch {dup pixline exch get table exch 48 sub\n"
"get pixline 3 1 roll put} for} image", fp);
    }
    if (!ferror(fp))
	fputs("\n0 0 0 h w h w 0 m l l l c s grestore} def\n"
	      "end\n%%EndProlog\n%%Page: 1\nspec2ddict begin\n", fp);
    if (!ferror(fp))
        psstring(fp, (char *) xv_get(Spec_printerPopup->printXLabel,
                                     PANEL_VALUE));
    if (!ferror(fp))
        psstring(fp, (char *) xv_get(Spec_printerPopup->printYLabel,
                                     PANEL_VALUE));
    if (!ferror(fp))
        psstring(fp, (char *) xv_get(Spec_printerPopup->printTitle,
                                     PANEL_VALUE));
    if (!ferror(fp))
        psstring(fp, (char *) xv_get(Spec_printerPopup->printSubtitle,
                                     PANEL_VALUE));

    xt=tickspacing(specx*xgain);
    if (!ferror(fp))
        fprintf(fp, "%f %f 1.0001\n", (ceil(xoffset/xt*10)*xt/10-xoffset)
                /xgain/specx, xt/specx/xgain/10);
    yt=tickspacing(specy*ygain);
    if (!ferror(fp))
        fprintf(fp, "%f %f 1.0001\n", (ceil(yoffset/yt*10)*yt/10-yoffset)
                /ygain/specy, yt/specy/ygain/10);
    xf=ceil(xoffset/xt)*xt;
    if (!ferror(fp))
        fprintf(fp, "%f %f 1.0001 %f %f\n", (xf-xoffset)/xgain/specx,
                xt/specx/xgain, xf, xt);
    yf=ceil(yoffset/yt)*yt;
    if (!ferror(fp))
        fprintf(fp, "%f %f 1.0001 %f %f\n", (yf-yoffset)/ygain/specy,
                yt/specy/ygain, yf, yt);
    loadContourValueArray(contourValue);
        for(i=0; i<usedContours-1; i++)
	    if (!ferror(fp))
		fprintf(fp, "%d\n", contourValue[i]);
    if (!ferror(fp))
	fprintf(fp, "%d\n", specMax);
    if (!ferror(fp))
        fprintf(fp, "%d %f\ndumptwo\n", usedContours-1, scale/100.0);
    printPalette(fp, palette);
    for(j=specy; j--;)
	for(i=0; i<specx; i++)
	{
	    v = spec2dcontour[i][j] - COLOUROFFSET + 48;
	    if (!ferror(fp))
		putc(v, fp);
	    if (i % 64 == 63 || i == specx-1)
		if (!ferror(fp))
                    putc('\n', fp);
	}
    if (!ferror(fp))
	fputs("end\n", fp);
    if (dest != 2 && !ferror(fp))
	fputs("showpage\n", fp);
    if (!ferror(fp))
        fputs("%%Trailer\n", fp);
    closePrinterFile(fp, event_x(event), event_y(event));
}

/*ARGSUSED*/
void
printTo(item, value, event)
	Panel_item	item;
	int		value;
	Event		*event;
{
    switch(value)
    {
    case 0:
	xv_set(Spec_printerPopup->printFilename, XV_SHOW, FALSE, NULL);
	xv_set(Spec_printerPopup->printString, XV_SHOW, TRUE, NULL);
	break;
    default:
	xv_set(Spec_printerPopup->printString, XV_SHOW, FALSE, NULL);
	xv_set(Spec_printerPopup->printFilename, XV_SHOW, TRUE, NULL);
	break;
    }
}

Menu_item
autoscaleLinear(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    int i, first, step;
    char buffer[16];

    if (op != MENU_NOTIFY)
	return item;

    step = (((float) specMax)/(usedContours-1) + 0.5);
    if (step < 1)
	step = 1;
    first = step;
    sprintf(buffer, "%d", first);
    xv_set(Spec_levelPopup->firstValue, PANEL_VALUE, buffer, NULL);
    xv_set(Spec_levelPopup->spacing, XV_SHOW, FALSE, NULL);
    sprintf(buffer, "%d", step);
    xv_set(Spec_levelPopup->step, PANEL_VALUE, buffer, XV_SHOW, TRUE, NULL);
    sprintf(buffer, "%d", usedContours);
    xv_set(Spec_levelPopup->numContours, PANEL_VALUE, buffer, NULL);
    xv_set(Spec_levelPopup->levelPopup, XV_LABEL, "Set linear contours", NULL);
    xv_set(Spec_levelPopup->levelSetApply, PANEL_NOTIFY_PROC,
	   levelSetLinear, NULL);
    for(i=1; i<usedContours-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, first, NULL);
	first += step;
    }
    setContoursAndRedraw();
    
    return item;
}

Menu_item
autoscaleLogarithmic(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    int i;
    float first=1, spacing;
    char buffer[32];

    if (op != MENU_NOTIFY)
	return item;

    spacing = pow((double) specMax, 1.0/(usedContours-2));
    xv_set(Spec_levelPopup->firstValue, PANEL_VALUE, "1", NULL);
    xv_set(Spec_levelPopup->step, XV_SHOW, FALSE, NULL);
    sprintf(buffer, "%f", spacing);
    xv_set(Spec_levelPopup->spacing, PANEL_VALUE, buffer, XV_SHOW, TRUE, NULL);
    sprintf(buffer, "%d", usedContours);
    xv_set(Spec_levelPopup->numContours, PANEL_VALUE, buffer, NULL);
    xv_set(Spec_levelPopup->levelPopup, XV_LABEL,
	   "Set pseudo-logarithmic contours", NULL);
    xv_set(Spec_levelPopup->levelSetApply, PANEL_NOTIFY_PROC,
	   levelSetPseudo, NULL);
    for(i=1; i<usedContours-1; i++)
    {
	xv_set(contourSlider[i], PANEL_VALUE, (int) first, NULL);
	first *= spacing;
    }
    setContoursAndRedraw();
    
    return item;
}

static int intcompare(const int *i, const int *j)
{
    if (*i > *j)
	return 1;
    if (*i < *j)
	return -1;
    return 0;
}

/* This is almost histogram equalisation, it ignores zeroes */
Menu_item
autoscaleHistogram(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    int *p, *hist, x, y, (*xp)[MAXSPECX], *yp;
    
    if (op != MENU_NOTIFY)
	return item;

    if ((hist = calloc(specx*specy, sizeof(int))) == NULL)
    {
	notice_prompt(item, NULL,
/*		      NOTICE_FOCUS_XY, event_x(event), event_y(event), */
		      NOTICE_MESSAGE_STRINGS,
		      "Unable to perform histogram equalisation. Error was",
		      ERRSTRING, NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return item;
    }
    
    for(p = hist, x = specx, xp = spec2d; x--; xp++)
	for(y = specy, yp = *xp; y--; yp++)
	    if (*yp != 0)
		*p++ = *yp;
    
    x = p - hist;

    qsort(hist, x, sizeof(int),
	  (int (*)(const void *, const void *)) intcompare);

    for(y = 0; y < usedContours-1; y++)
	xv_set(contourSlider[y], PANEL_VALUE, hist[y*x/(usedContours-1)],
	       NULL);

    free(hist);

    setContoursAndRedraw();
    
    return item;
}

void
initialiseMonochrome(win)
Xv_opaque win;
{
    Xv_opaque menu;

    createDithers(win);

    menu = xv_get(Spec_contourPopup->presetPalette, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 1), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 2), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 6), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 8), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 9), MENU_INACTIVE,
	   (cms == XV_NULL) ? TRUE : FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 10), MENU_INACTIVE, TRUE, NULL);
}

void
createDithers(win)
Xv_opaque win;
{
    int i, x, y, grid[MAXSCALE][MAXSCALE], maxx, maxy, u, v, maxd, d, du, dv;
    char bitmap[MAXSCALE*2];
    Display *display = XV_DISPLAY_FROM_WINDOW(win);
    Window xid = xv_get(win, XV_XID);
    Pixmap pix;
    GC gc1;

    if (windither != 0)
	XFreePixmap(display, windither);
    if (mag > 8)
	for(x=mag; x--; )
	    bitmap[x*2+1] = bitmap[x*2] = 04444 >> (x % 3);
    else
	for(x=mag; x--; )
	    bitmap[x] = 04444 >> (x % 3);
    windither = XCreateBitmapFromData(display, xid, bitmap, mag, 
				      mag);

    for(x=mag; x--; )
    {
	for(y=mag; y--; )
	    grid[x][y] = 0;
	bitmap[x*2+1] = bitmap[x*2] = 0;
    }
    if (dither[0] != 0)
	XFreePixmap(display, dither[0]);
    dither[0] = XCreateBitmapFromData(display, xid, bitmap, mag, 
				      mag);

    for(i=1; i<=mag*mag; i++)
    {
	maxx = -1;
	maxy = -1;
	maxd = mag*mag*mag*mag;

	for(x=mag; x--; )
	    for(y=mag; y--; )
		if (!grid[x][y])
		{
		    d = 0;
		    for(u=mag; u--; )
			for(v=mag; v--; )
			    if (grid[u][v])
			    {
				du = abs(u-x);
				if (du > mag/2)
				    du = mag - du;
				dv = abs(v-y);
				if (dv > mag/2)
				    dv = mag - dv;
				d += (mag*mag)/(du*du + dv*dv);
			    }
		    if (d < maxd)
		    {
			maxd = d;
			maxx = x;
			maxy = y;
		    }
		}

	grid[maxx][maxy] = 1;

	for(y=mag; y--; )
	{
	    if (mag > 8)
	    {
		bitmap[y*2+1] = bitmap[y*2] = 0;
		u = 1;
		for(x=8; x--; )
		{
		    if (grid[(x + mag/2) % mag][(y + mag/2) % mag])
			bitmap[y*2] |= u;
		    u <<= 1;
		}
		u = 1;
		for(x=mag; x-- > 8; )
		{
		    if (grid[(x + mag/2) % mag][(y + mag/2) % mag])
			bitmap[y*2+1] |= u;
		    u <<= 1;
		}
	    }
	    else
	    {
		u = 1;
		bitmap[y] = 0;
		for(x=mag; x--; )
		{
		    if (grid[(x + mag/2) % mag][(y + mag/2) % mag])
			bitmap[y] |= u;
		    u <<= 1;
		}
	    }
	}
	if (dither[i] != 0)
	    XFreePixmap(display, dither[i]);
	dither[i] = XCreateBitmapFromData(display, xid, bitmap, mag, mag);
    }

    gc1 = XCreateGC(display, dither[1], 0, NULL);
    XSetBackground(display, gc1, 0);
    XSetForeground(display, gc1, 1);
    XSetFillStyle(display, gc1, FillOpaqueStippled);
    
    for(i=mag*mag+1; i--; )
    {
	if (XVdither[i] != XV_NULL)
	    xv_destroy(XVdither[i]); /* Also frees old pixmap */

	pix = XCreatePixmap(display, xid, 16, 16, 1);
	XSetStipple(display, gc1, dither[i]);
	XFillRectangle(display, pix, gc1, 0, 0, 16, 16);
	XVdither[i] = xv_create(XV_NULL, SERVER_IMAGE,
				SERVER_IMAGE_PIXMAP, pix,
				NULL);
    }

    XFreeGC(display, gc1);
}    

void
setContourImages(win)
Xv_opaque win;
{
    int i;

    if (monochrome)
	setContourDithers(win);
    else
	for(i=0; i<MAXCONTOURS; i++)
	    xv_set(contourButton[i], PANEL_LABEL_IMAGE, squareblack,
		   PANEL_ITEM_COLOR, i+COLOUROFFSET,
		   NULL);
}

/*ARGSUSED*/
void
setContourDithers(win)
Xv_opaque win;
{
    int i,j;

    if (!monochrome)
	return;

    for(i=0; i<MAXCONTOURS; i++)
    {
	j = (i*(mag*mag)+usedContours/2)/(usedContours-1);
	if (j > mag*mag)
	    j = mag*mag;
	xv_set(contourButton[i], PANEL_LABEL_IMAGE, XVdither[j],
	       PANEL_ITEM_COLOR, -1,
	       NULL);
    }
}

Menu_item
changeToMonochrome(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op != MENU_NOTIFY)
	return item;

    if (monochrome)
	return item;
    monochrome = 1;
    initialiseMonochrome(Spec_contourPopup->contourControls);
    setContoursAndRedraw();
    xv_set(Spec_rgbPopup->rgbPopup, XV_SHOW, FALSE, NULL);
    xv_set(Spec_customPopup->customPopup, XV_SHOW, FALSE, NULL);
    return item;
}

Menu_item
changeToColour(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    Xv_opaque menu;
	
    if (op != MENU_NOTIFY)
	return item;

    if (!monochrome)
	return item;
    if (cms == XV_NULL)
    {
	fprintf(stderr, "Activated changeToColour() without a colourmap ! "
		"Please report this.\n");
	monochrome = 1;
	return item;
    }
    monochrome = 0;
	
    menu = xv_get(Spec_contourPopup->presetPalette, PANEL_ITEM_MENU);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 1), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 2), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 3), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 4), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 5), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 6), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 8), MENU_INACTIVE, FALSE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 9), MENU_INACTIVE, TRUE, NULL);
    xv_set(xv_get(menu, MENU_NTH_ITEM, 10), MENU_INACTIVE, FALSE, NULL);

    setContourImages(Spec_contourPopup->contourControls);
    setContoursAndRedraw();
    return item;
}

void
setMagnification(newmag)
int newmag;
{
    int wx, wy, minx, vneeded = FALSE, hneeded = FALSE;

    if (newmag > MAXSCALE)
	newmag = MAXSCALE;

    mag = newmag;

    wx = mag * specx;
    wy = mag * specy;

    xv_set(Spec_specWindow->spectrum,
	   CANVAS_WIDTH, wx, CANVAS_HEIGHT, wy,
	   NULL);

    if (newmag*specx > MAXSPECSIZE)
	hneeded = TRUE;
	
    if (newmag*specy > MAXSPECSIZE)
	vneeded = TRUE;

    if (hneeded)
    {
	wx = MAXSPECSIZE;
	if (Spec_specWindow->hscroll == NULL)
	    Spec_specWindow->hscroll =
		xv_create(Spec_specWindow->spectrum, SCROLLBAR,
			  SCROLLBAR_SPLITTABLE, FALSE,
			  SCROLLBAR_DIRECTION, SCROLLBAR_HORIZONTAL,
			  NULL);
    }
    else
    {
	wx += 2;
	if (Spec_specWindow->hscroll != NULL)
	{
	    xv_destroy(Spec_specWindow->hscroll);
	    Spec_specWindow->hscroll = NULL;
	}
    }

    if (vneeded)
    {
	wy = MAXSPECSIZE;
	if (Spec_specWindow->vscroll == NULL)
	    Spec_specWindow->vscroll =
		xv_create(Spec_specWindow->spectrum, SCROLLBAR,
			  SCROLLBAR_SPLITTABLE, FALSE,
			  SCROLLBAR_DIRECTION, SCROLLBAR_VERTICAL,
			  NULL);
    }
    else
    {
	wy += 2;
	if (Spec_specWindow->vscroll != NULL)
	{
	    xv_destroy(Spec_specWindow->vscroll);
	    Spec_specWindow->vscroll = NULL;
	}
    }

    if (Spec_specWindow->vscroll != NULL)
	wx += xv_get(Spec_specWindow->vscroll, XV_WIDTH);
    if (Spec_specWindow->hscroll != NULL)
	wy += xv_get(Spec_specWindow->hscroll, XV_HEIGHT);

    xv_set(Spec_specWindow->spectrum, XV_WIDTH, wx, XV_HEIGHT, wy, NULL);

    minx = (int) xv_get(Spec_specWindow->magnifyButton, XV_X) +
	(int) xv_get(Spec_specWindow->magnifyButton, XV_WIDTH) + 7;

    xv_set(Spec_specWindow->specWindow, XV_WIDTH, (wx < minx) ? minx : wx,
	   XV_HEIGHT,
	   wy + (int) xv_get(Spec_specWindow->spectrum, XV_Y),
	   NULL);

    if (monochrome)
	createDithers(Spec_specWindow->spectrum);
    forceRedraw = 1;

    /* You must now set reset the contour images */
}

Menu_item
menuSetMagnification(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op == MENU_NOTIFY)
    {
	xv_set(Spec_specWindow->spectrum, XV_SHOW, FALSE, NULL);
	setMagnification(atoi((char *) xv_get(item, MENU_STRING)));
	xv_set(Spec_specWindow->spectrum, XV_SHOW, TRUE, NULL);
	redrawSpectrum();
    }
    return item;
}

void readSpectrumFromPipe()
{
    int x, y;
    char buffer[6];

    read(0, (char *) &specx, sizeof(int));
    read(0, (char *) &specy, sizeof(int));
    read(0, (char *) &specMax, sizeof(int));
    for(x = specx; x--; )
	read(0, (char *) spec2d[x], specy*sizeof(int));
    read(0, (char *) &usedContours, sizeof(int));
    for(x = specx; x--; )
	read(0, (char *) window[x], specy);
    read(0, (char *) &windowStatus, sizeof(int));
    read(0, (char *) &mag, sizeof(int));
    read(0, (char *) &x, sizeof(int));
    read(0, spectrumName, x);
    spectrumName[x] = '\0';
    spectrumLoaded();
    x = MAXCONTOURS-1;
    while(--x)
    {
	read(0, (char *) &y, sizeof(int));
	xv_set(contourSlider[x], PANEL_VALUE, y, NULL);
    }
    read(0, (char *) rawColour, sizeof(rawColour));
    read(0, (char *) &displayGamma, sizeof(float));

    if (strstr(spectrumName, "(copy)") == NULL)
	strcat(spectrumName, " (copy)");

    xv_set(Spec_gammaPopup->displayGammaSlider, PANEL_VALUE,
	   (int) displayGamma*100, NULL);
    sprintf(buffer, "%5.2f", displayGamma);
    xv_set(Spec_gammaPopup->displayGammaValue, PANEL_VALUE, buffer, NULL);
    brighten(rawColour, 0, MAXCONTOURS+1, displayColour, displayGamma);
    alterColours();
}

void spectrumLoaded()
{
    char buf[16];
    int x;

    for(x=1; x<MAXCONTOURS-1; x++)
    {
	xv_set(contourSlider[x], PANEL_MAX_VALUE, specMax, NULL);
	if (((int) xv_get(contourSlider[x], PANEL_VALUE)) > specMax)
	    xv_set(contourSlider[x], PANEL_VALUE, specMax, NULL);
    }
    sprintf(buf,"%d",specMax);
    xv_set(contourSlider[x], PANEL_LABEL_STRING, buf, NULL);
    setMagnification(mag);
    RRP(0);
    recalculate3d();
}

/*ARGSUSED*/
void
forkProgram(item, event)
	Panel_item	item;
	Event		*event;
{
	int fd;
	char *buf;

	buf = malloc(strlen(programName) + 7);
	sprintf(buf, "%s -pipe", programName);
	
        if ((fd = mypopenfd(buf, "w")) == -1)
        {
	    free(buf);
	    notice_prompt(Spec_specWindow->specWindow, NULL,
			  NOTICE_FOCUS_XY, event_x(event), event_y(event),
			  NOTICE_MESSAGE_STRINGS,
			  "Unable to run copy of program. Error was",
                          ERRSTRING, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    return;
        }
	free(buf);

        /*
         * Ignore SIGPIPE signals, we'll detect those by looking for errors
         * returned by writing.
         */
        notify_set_signal_func(sort_client, blankfunc, SIGPIPE, NOTIFY_ASYNC);

	if (writeSpectrumToPipe(fd) == -1)
	{
	    notice_prompt(Spec_specWindow->specWindow, NULL,
			  NOTICE_FOCUS_XY, event_x(event), event_y(event),
			  NOTICE_MESSAGE_STRINGS,
			  "Error whilst writing spectrum to pipe. It was",
                          ERRSTRING, NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    return;
        }

	(void) close(fd);
}

int writeSpectrumToPipe(fd)
int fd;
{
    int x, y;

    if (write(fd, (char *) &specx, sizeof(int)) == -1)
	return(-1);
    if (write(fd, (char *) &specy, sizeof(int)) == -1)
	return(-1);
    if (write(fd, (char *) &specMax, sizeof(int)) == -1)
	return(-1);
    for(x = specx; x--; )
	if (write(fd, (char *) spec2d[x], specy*sizeof(int)) !=
	    specy*sizeof(int))
	{
	    if (errno == 0)
		errno = EPIPE;
	    return -1;
	}
    if (write(fd, (char *) &usedContours, sizeof(int)) == -1)
	return(-1);
    for(x = specx; x--; )
	if (write(fd, (char *) window[x], specy) != specy)
	{
	    if (errno == 0)
		errno = EPIPE;
	    return -1;
	}
    if (write(fd, (char *) &windowStatus, sizeof(int)) == -1)
	return(-1);
    if (write(fd, (char *) &mag, sizeof(int)) == -1)
	return(-1);
    x = strlen(spectrumName);
    if (write(fd, (char *) &x, sizeof(int)) == -1)
	return(-1);
    if (write(fd, spectrumName, x) == -1)
	return(-1);
    x = MAXCONTOURS-1;
    while(--x)
    {
	y = (int) xv_get(contourSlider[x], PANEL_VALUE);
	if (write(fd, (char *) &y, sizeof(int)) == -1)
	    return(-1);
    }
    if (write(fd, (char *) rawColour, sizeof(rawColour)) == -1)
	return(-1);
    if (write(fd, (char *) &displayGamma, sizeof(float)) == -1)
	return(-1);
    return(0);
}

/****************** sjah 16/1/95 ********************************/
/*
 *  getdtablesize() is a BSD function
 *  keep name but use Solaris equivalent if SVR4
 */
#ifdef SVR4
#include <sys/time.h>
#include <sys/resource.h>

int getdtablesize(void)
{
      struct rlimit rlp;
      if ( getrlimit(RLIMIT_NOFILE, &rlp) == -1)
	    return(-1);
      else
	    return((int) rlp.rlim_cur);
}
#endif

/*ARGSUSED*/
Menu_item
toggleSlicing(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op != MENU_NOTIFY)
	return item;

    /* if Slicing is on switch it off and vice versa */
    if (Slicing & SLICING) {
	Slicing &= (~SLICING);
	xv_set(item, MENU_STRING, "Slicing On", NULL);
	xv_set(Spec_specWindow->specWindow,
	       FRAME_RIGHT_FOOTER, "", NULL);
	showCrosshairs = 0;
    }
    else {
	Slicing |= SLICING;
	xv_set(item, MENU_STRING, "Slicing Off", NULL);
	xv_set(Spec_specWindow->specWindow,
	       FRAME_RIGHT_FOOTER, "Slicing On", NULL);
	showCrosshairs = 1;
    }
    drawCrosshairs((Display *)
		       XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
		       (Window)
		       xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			      XV_XID), gc, 0, 0, 0);
    return item;
}

Menu_item
setSliceWindow(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op != MENU_NOTIFY)
	return item;

    Slicing |= PROJECTION;
    setWindow(item,op);
    return item;
}

/*ARGSUSED*/
Menu_item
reslice(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op != MENU_NOTIFY)
	return item;

    do_projection(NULL);
    return item;
}

void
signal_1d()
{
    /* signal 1d display process to show slices */

    if (pshm->pid_1d <= 0 || kill(pshm->pid_1d, SIGUSR1) == -1) {
	pid_t pid = lookup_proc("sort_xvgr");
	
	if ((int) pid > 0) {
	    if (kill(pid, SIGUSR1) == -1) {
		perror("projecting-kill");
		fprintf(stderr,"projecting: failed to signal 1D display "
			"process pid = %d\n",
			(int) pid);
	    }
	    else
		pshm->pid_1d = pid;
	}
	else 
	    fprintf(stderr,"projecting: failed to locate 1D display proces\n");
    }
}

/*ARGSUSED*/
void do_simple_slice(event,x,y)
      Event *event;
      int x;
      int y;
{
      int *px, i, *q, (*py)[MAXSPECX];

      strcpy(pshm->com_str, "DISPLAY 1");
      sprintf(pshm->name, "X=%d", x);
      pshm->more = 1;
      pshm->size = specy;

      for(px = spec2d[x], q = pshm->array + specy, i = specy; i--; )
	  *--q = *px++;

      write_to_pipe(".SORT_pipe0", pshm->size);

      sprintf(pshm->name, "Y=%d", specy-y-1);
      pshm->more = 0;
      pshm->size = specx;

      for(py = spec2d, q = pshm->array, i = specx; i--; )
	  *q++ = (*py++)[y];

      write_to_pipe(".SORT_pipe1", pshm->size);

      signal_1d();
}

int
store_spectrum(outfile, command, win)
char *outfile;
char *command;
int  win;
{
    register int x, y;
      
    if (debuglevel >= 3)
	fprintf(stderr,"sort_spec2d: storing 2d spectra\n");

    /* copy spectrum window data into pshm structure*/
    strncpy(pshm->com_str,command,NAME_SIZE);
    pshm->size = (specx != specy) ? MAX(specx,specy) : specx;
    pshm->win2d = win2d;
      
    /*
     * x=0, y=0 on display is top right hand corner and 1st element of
     *  pshm->array win = TRUE store window otherwise store displayed spectrum
     */
    if (win == SORT_TRUE)
	for(x=0; x < specx ;x++)
	    for(y=0; y < specy ; y++)
		pshm->array[x*specy + (specy-1-y)] = (window[x][y]) ? 30 : 0;
    else
	for(x=0; x < specx ;x++)
	    for(y=0; y < specy ; y++)
		pshm->array[x*specy + (specy-1-y)] = spec2d[x][y];
      
/* no ipcs on system */
    if ( write_to_pipe(outfile,SHM_ARRAY_SIZE) == SORT_FAIL)
	return -1;
    return 0;
}

/*ARGSUSED*/
void do_projection(event)
Event *event;
{
      int *px, i, j, *q, (*py)[MAXSPECX], n;
      unsigned char *wx, (*wy)[MAXSPECX];

      strcpy(pshm->com_str, "DISPLAY 1");
      strcpy(pshm->name, "Proj onto Y");
      pshm->more = 1;
      pshm->size = specy;

      memset(pshm->array, 0, specy * sizeof(int));

      for(py = spec2d, wy = window, i = specx; i--; wy++, py++)
	  for(px = *py, wx = *wy, j = specy; j--; px++)
	      if (*wx++)
		  pshm->array[j] += *px;

      write_to_pipe(".SORT_pipe0", pshm->size);

      strcpy(pshm->name, "Proj onto X");
      pshm->more = 0;
      pshm->size = specx;

      for(py = spec2d, wy = window, q = pshm->array, i = specx; i--;
	  wy++, py++)
      {
	  for(n = 0, px = *py, wx = *wy, j = specy; j--; px++)
	      if (*wx++)
		  n += *px;
	  *q++ = n;
      }

      write_to_pipe(".SORT_pipe1", pshm->size);

      signal_1d();
}

Panel_setting
valueSetProjectAngle(item, event)
	Panel_item	item;
	Event		*event;
{
    float num;

    if ((num = goodFloat(Spec_projectPopup->projectControls, (char *)
			 xv_get(item, PANEL_VALUE), 0.0, 180.0, event)) >= 0.0)
    {
	xv_set(Spec_projectPopup->projectAngleSlider, PANEL_VALUE,
	       (int) num*10, NULL);
	RRP(1);
	projectAngle = num;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

/*ARGSUSED*/
void
sliderSetProjectAngle(item, value, event)
Panel_item	item;
int		value;
Event		*event;
{
    char buffer[6];
    double num;

    num = ((float) value) / 10;
    sprintf(buffer, "%5.1f", num);
    xv_set(Spec_projectPopup->projectAngleValue, PANEL_VALUE, buffer, NULL);
    if (projectAngle != num)
    {
	RRP(1);
	projectAngle = num;
	RRP(2);
    }
}


void recalculateProjection(scale)
int scale;
{
    unsigned int x, y, *up;
    int (*colp)[MAXSPECX], *sp;
    unsigned char (*wcolp)[MAXSPECX], *wp;
    int colpos, pos, dx, dy, f;

    dx = sin(screenAngle) * 65536;
    dy = cos(screenAngle) * 65536;
    colpos = (-(specy-2)*dy - specx*dx)/2 + MAXPROJWIDTH*32768;

    memset(projection, 0, sizeof(projection));

    switch(projectArea)
    {
    case 0:
	for(colp = spec2d, x = specx; x--; colp++, colpos += dx)
	    for(pos = colpos, sp = &(colp[0][0]), y = specy; y--;
		sp++, pos += dy)
	    {
		f = pos & 65535;
		projection[pos>>16] += *sp * ((65536-f)>>8);
		projection[(pos>>16)+1] += *sp * (f>>8);
	    }
	break;
    case 1:
	for(colp = spec2d, wcolp = window, x = specx; x--;
	    colp++, wcolp++, colpos += dx)
	    for(pos = colpos, sp = &(colp[0][0]), wp = &(wcolp[0][0]),
		y = specy; y--; sp++, wp++, pos += dy)
		if (*wp)
		{
		    f = pos & 65535;
		    projection[pos>>16] += *sp * ((65536-f)>>8);
		    projection[(pos>>16)+1] += *sp * (f>>8);
		}
	break;
    }

    if (scale)
    {
	for(x = 0, up = projection, y=MAXPROJWIDTH; y--; up++)
	    if (*up > x)
		x = *up;
	
	x = (x + 255) / 256;
	
	if (x > 0)
	    for(up = projection, y=MAXPROJWIDTH; y--; up++)
		*up /= x;
	
	forceProject = 0;
    }
}

/*ARGSUSED*/
void
repaintProjection(canvas, paint_window, display, xid, rects)
	Canvas		canvas;
	Xv_window	paint_window;
	Display		*display;
	Window		xid;
	Xv_xrectlist	*rects;
{
    static GC gc = NULL;
    int i, l, x, y, lx, ly;
    double s, o;
    XPoint polypoints[MAXPROJWIDTH*2], *pp;
    
    if (!showGuidelines)
	return;

    if (forceProject)
	recalculateProjection(1);

    if (gc == NULL)
	gc = XCreateGC(display, xid, 0, NULL);

    XSetFunction(display, gc, GXcopy);
    XSetForeground(display, gc, BlackPixel(display,
					   DefaultScreen(display)));
    XSetBackground(display, gc, WhitePixel(display,
					   DefaultScreen(display)));

    if (rects)
        XSetClipRectangles(display, gc, 0, 0, rects->rect_array,
                           rects->count, Unsorted);
    else
    {
        XSetClipMask(display, gc, None);
        XClearWindow(display, xid);
    }

    XSetLineAttributes(display, gc, 1, LineSolid, CapButt, JoinMiter);

    l = sqrt((double) (specx*specx + specy*specy))/2;
    lx = 0;
    for(pp = polypoints, i = -l; i < l; i++, pp += 2)
    {
	pp->x = lx;
	pp[1].x = lx =  i * 256 / l + 256;
	pp[1].y = pp->y = 255 - projection[i + MAXPROJWIDTH/2];
    }
    XDrawLines(display, xid, gc, polypoints, l*4, CoordModeOrigin);

    if (polynomialOrder > 0 && calcScaleAndOffset(&s, &o) == 0)
    {
	static char dashed[2] = { 4, 4 };

	o += s/2;
	s *= POLYARRAYLEN/180.0*l/256;
	o *= POLYARRAYLEN/180.0;
	lx = (int) (o - 256*s);
	ly = (int) (((o - 256*s) - lx) * 65536);
	lx = ((lx & (POLYARRAYLEN - 1))<<16)+ly;
	ly = (int) (s * 65536);

	for(pp = polypoints, x = 0; x < 512; x++, pp++)
	{
	    y = 255 - polynomial[lx>>16]*polynomialScale*255;
	    lx = (lx+ly) & ((POLYARRAYLEN<<16)-1);
	    pp->x = x;
	    pp->y = y;
	}
	XSetDashes(display, gc, 0, dashed, sizeof(dashed));
	XSetLineAttributes(display, gc, 0, LineOnOffDash, CapButt, JoinMiter);
	XDrawLines(display, xid, gc, polypoints, 512, CoordModeOrigin);
	XSetLineAttributes(display, gc, 0, LineSolid, CapButt, JoinMiter);
    }
}


/*ARGSUSED*/
void
setProjectArea(item, value, event)
Panel_item	item;
int		value;
Event		*event;
{
    projectArea = value;
    RRP(0);
}

int
projectDone(item)
Xv_opaque item;
{
    xv_set(item, XV_SHOW, FALSE, NULL);
    if (showGuidelines)
	drawGuidelines((Display *)
		       XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow),
		       (Window)
		       xv_get(canvas_paint_window(Spec_specWindow->spectrum),
			      XV_XID), gc);
    showGuidelines = 0;
    return XV_OK;
}

void
drawGuidelines(display, xid, gc)
Display *display;
Window xid;
GC gc;
{
    double dx, dy, i, l, tx, ty;
    unsigned long *index;

    if (monochrome)
	XSetForeground(display, gc,
		       BlackPixel(display, DefaultScreen(display)) ^
		       WhitePixel(display, DefaultScreen(display)));
    else
    {
	index = (unsigned long *) xv_get(cms, CMS_INDEX_TABLE);
	XSetForeground(display, gc, index[COLOUROFFSET+MAXCONTOURS-1] ^
		       index[COLOUROFFSET]);
    }
    
    XSetFunction(display, gc, GXxor);

    l = sqrt((double) specx*specx + specy*specy);

    dx = sin(screenAngle);
    dy = -cos(screenAngle);

    tx = (Xtarget - Xoffset)/Xgain;
    ty = (Ytarget - Yoffset)/Ygain;

    i = tx*dx + ty*dy;
    i -= floor(i/10)*10;

    for(i -= floor(l/10)*10; i<l; i += 10)
    {
	XDrawLine(display, xid, gc, (int) ((i*dx - l*dy + 0.5)*mag),
		  (int) ((specy - (i*dy + l*dx + 0.5))*mag),
		  (int) ((i*dx + l*dy + 0.5)*mag),
		  (int) ((specy - (i*dy - l*dx + 0.5))*mag));
    }

    switch(projectAxis)
    {
    case 0: /* Perpendicular */
	XDrawLine(display, xid, gc, (int) ((tx + l*dx + 0.5)*mag),
		  (int) ((specy - (ty + l*dy + 0.5))*mag),
		  (int) ((tx - l*dx + 0.5)*mag),
		  (int) ((specy - (ty - l*dy + 0.5))*mag));
	break;
    case 1: /* X */
	XDrawLine(display, xid, gc, 0, (int) ((specy - ty - 0.5)*mag),
		  specx*mag, (int) ((specy - ty - 0.5)*mag));
	break;
    case 2: /* Y */
	XDrawLine(display, xid, gc, (int) ((tx+ 0.5)*mag), 0,
		  (int) ((tx + 0.5)*mag), specy*mag);
	break;
    }

    XSetFunction(display, gc, GXcopy);
}

void drawCrosshairs(display, xid, gc, n, x, y)
Display *display;
Window xid;
GC gc;
int n, x, y;
{
    static int last_x = 0, last_y = 0;
    unsigned long *index;

    if (n)
    {
	last_x = x;
	last_y = y;
    }
    else
    {
	x = last_x;
	y = last_y;
    }

    if (monochrome)
	XSetForeground(display, gc,
		       BlackPixel(display, DefaultScreen(display)) ^
		       WhitePixel(display, DefaultScreen(display)));
    else
    {
	index = (unsigned long *) xv_get(cms, CMS_INDEX_TABLE);
	XSetForeground(display, gc, index[COLOUROFFSET+MAXCONTOURS-1] ^
		       index[COLOUROFFSET]);
    }
    XSetFunction(display, gc, GXxor);
    XDrawLine(display, xid, gc, x, 0, x, specy*mag);
    XDrawLine(display, xid, gc, 0, y, specx*mag, y);
    XSetFunction(display, gc, GXcopy);

}

int
calcScaleAndOffset(double *s, double *o)
{
    if ((projectAxis == 1 && (projectAngle == 0 || projectAngle == 180)) ||
	(projectAxis == 2 && projectAngle == 90))
	return -1;

    switch(projectAxis)
    {
    case 0: /* Perpendicular */
	*s = sin(screenAngle)*Xgain*sin(projectAngle*M_PI/180) +
	    cos(screenAngle)*Ygain*cos(projectAngle*M_PI/180);
	*o = (specx/2.0*Xgain+Xoffset-Xtarget)*sin(projectAngle*M_PI/180) + 
	    (-specy/2.0*Ygain-Yoffset+Ytarget)*cos(projectAngle*M_PI/180);
	break;
    case 1: /* X */
	*s = sin(screenAngle)*Xgain +
	    cos(screenAngle)*Ygain/tan(projectAngle*M_PI/180);
	*o = specx/2.0*Xgain+Xoffset +
	    (-specy/2.0*Ygain-Yoffset+Ytarget)/tan(projectAngle*M_PI/180);
	break;
    case 2: /* Y */
	*s = -cos(screenAngle)*Ygain -
	    sin(screenAngle)*Xgain*tan(projectAngle*M_PI/180);
	*o = specy/2.0*Ygain+Yoffset -
	    (specx/2.0*Xgain+Xoffset-Xtarget)*tan(projectAngle*M_PI/180);
	break;
    }
    return 0;
}

/*ARGSUSED*/
void
doProjection(item, event)
	Panel_item	item;
	Event		*event;
{
    int i, l;
    unsigned int y, max;
    float *p;
    double s, o;

    if (calcScaleAndOffset(&s, &o))
    {
	notice_prompt(Spec_projectPopup->projectPopup, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "Don't try to project parallel to the axis you want",
		      "to read the numbers off - it won't work.", NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return;
    }

    recalculateProjection(0);
    forceProject = 1;

    l = sqrt((double) (specx*specx + specy*specy))/2;
    strcpy(pshm->com_str, "DISPLAX 1");
    sprintf(pshm->name, "%5.1f\\So\\N", projectAngle);
    pshm->more = 0;
    pshm->size = l*4;

    max = 256;
    for(p = (float *) pshm->array, i = -l; i < l; i++, p += 2)
    {
	*p = i * s + o;
	y = projection[i + MAXPROJWIDTH/2];
	if (y > max)
	    max = y;
	p[1] = y / 256.0;
    }

    write_to_pipe(".SORT_pipe0", l*4); 

    signal_1d();

    if (polynomialOrder > 0)
    {
	double x;

	sleep(1);

	strcpy(pshm->com_str, "OVERLAX 1");
	sprintf(pshm->name, "|P%d|\\S2\\N", polynomialOrder);
	pshm->more = 0;
	pshm->size = 1024;

	s *= M_PI/180*l/256;
	o *= M_PI/180;

	for(p = (float *) pshm->array, i = 0; i < 512; i++, p += 2)
	{
	    x = ((i-256)*s + o);
	    *p = x*180/M_PI;
	    p[1] = pow(legendre(polynomialOrder, cos(x)),2.0) * polynomialScale
		* max / 256;
	}

	write_to_pipe(".SORT_pipe0", 1024);
	signal_1d();
    } 
}

Panel_setting
projectXGain(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_projectPopup->projectControls, (char *)
			   value, 0.0, 0.0, event)) != 0.0)
    {
	xv_set(Spec_printerPopup->printXGain, PANEL_VALUE, value, NULL);
	RRP(1);
	Xgain = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

Panel_setting
projectXOffset(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_projectPopup->projectControls, (char *)
			   value, -1e37, 1e37, event)) >= -1e37)
    {
	xv_set(Spec_printerPopup->printXOffset, PANEL_VALUE, value, NULL);
	RRP(1);
	Xoffset = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

Panel_setting
projectYGain(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_projectPopup->projectControls, (char *)
			   value, 0.0, 0.0, event)) != 0.0)
    {
	xv_set(Spec_printerPopup->printYGain, PANEL_VALUE, value, NULL);
	RRP(1);
	Ygain = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

Panel_setting
projectYOffset(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_projectPopup->projectControls, (char *)
			   value, -1e37, 1e37, event)) >= -1e37)
    {
	xv_set(Spec_printerPopup->printYOffset, PANEL_VALUE, value, NULL);
	RRP(1);
	Yoffset = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

Panel_setting
printXGain(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_printerPopup->printerControls, (char *)
			   value, 0.0, 0.0, event)) != 0.0)
    {
	xv_set(Spec_projectPopup->projectXGain, PANEL_VALUE, value, NULL);
	RRP(1);
	Xgain = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

Panel_setting
printXOffset(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_printerPopup->printerControls, (char *)
			   value, -1e37, 1e37, event)) >= -1e37)
    {
	xv_set(Spec_projectPopup->projectXOffset, PANEL_VALUE, value, NULL);
	RRP(1);
	Xoffset = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

Panel_setting
printYGain(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_printerPopup->printerControls, (char *)
			   value, 0.0, 0.0, event)) != 0.0)
    {
	xv_set(Spec_projectPopup->projectYGain, PANEL_VALUE, value, NULL);
	RRP(1);
	Ygain = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

Panel_setting
printYOffset(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_printerPopup->printerControls, (char *)
			   value, -1e37, 1e37, event)) >= -1e37)
    {
	xv_set(Spec_projectPopup->projectYOffset, PANEL_VALUE, value, NULL);
	RRP(1);
	Yoffset = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

void RRP(change) /* Recalculate and Repaint Projection */
int change;
{
    Display *disp = (Display *)
	XV_DISPLAY_FROM_WINDOW(Spec_specWindow->specWindow);
    Window specwin = (Window)
	xv_get(canvas_paint_window(Spec_specWindow->spectrum), XV_XID);
    Window projwin = (Window)
	xv_get(canvas_paint_window(Spec_projectPopup->projection), XV_XID);

    if (change == 1)
	drawGuidelines(disp, specwin, gc);
    else if (change == 2)
    {
	if (projectAngle == 0.0 || projectAngle == 180.0)
	    screenAngle = projectAngle * M_PI / 180.0;
	else
	    screenAngle = atan(tan(projectAngle * M_PI/180) * Xgain / Ygain);
	if (screenAngle < 0)
	    screenAngle += M_PI;
	drawGuidelines(disp, specwin, gc);
    }
    forceProject = 1;
    repaintProjection(XV_NULL, XV_NULL, disp, projwin, (Xv_xrectlist *) NULL);
}

Panel_setting
projectXTarget(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_projectPopup->projectControls, (char *)
			   value, -1e37, 1e37, event)) >= -1e37)
    {
	RRP(1);
	Xtarget = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

Panel_setting
projectYTarget(item, event)
	Panel_item	item;
	Event		*event;
{
    char *value = (char *) xv_get(item, PANEL_VALUE);
    double val;

    if ((val = goodFloat(Spec_projectPopup->projectControls, (char *)
			   value, -1e37, 1e37, event)) >= -1e37)
    {
	RRP(1);
	Ytarget = val;
	RRP(2);
    }
    return panel_text_notify(item, event);
}

/*ARGSUSED*/
void
setProjectAxis(item, value, event)
Panel_item	item;
int		value;
Event		*event;
{
    RRP(1);
    projectAxis = value;
    RRP(2);
}

Panel_setting
setPolynomial(item, event)
Panel_item item;
Event *event;
{
    int value = (int) xv_get(item, PANEL_VALUE);
    int i;
    
    polynomialOrder = value;
    if (value > 0)
    {
	for(i = 0; i < POLYARRAYLEN; i++)
	    polynomial[i] = pow(legendre(value, cos(i*M_PI/POLYARRAYLEN)),2.0);
    }
    RRP(0);

    return panel_text_notify(item, event);
}

/*ARGSUSED*/
void
scaleUp(item, event)
	Panel_item	item;
	Event		*event;
{
    polynomialScale *= 1.1;
    RRP(0);
}

/*ARGSUSED*/
void
scaleDown(item, event)
	Panel_item	item;
	Event		*event;
{
    polynomialScale /= 1.1;
    if (polynomialScale < 1)
	polynomialScale = 1;
    RRP(0);
}

void resizeSpectrum()
{
    static int last_w = -1, last_h = -1;
    int w, h, i, d;

    w = (int) xv_get(Spec_specWindow->specWindow, XV_WIDTH);
    h = (int) xv_get(Spec_specWindow->specWindow, XV_HEIGHT) -
	    (int) xv_get(Spec_specWindow->spectrum, XV_Y);

    /*
      This is not the prettiest way of doing this, but it works (mostly).
      The problem is that when setMagnification does a resize, this routine
      gets called twice, once with just the vertical done and once with both
      axes resized. Some of this code is to make sure we don't try and second
      guess the setMagnification resize when it's halfway through.
    */

    for(;;)
    {
	if (last_w != w)
	{
	    last_w = w;
	    
	    d = specx*mag+2;
	    if (Spec_specWindow->vscroll != NULL)
		d += xv_get(Spec_specWindow->vscroll, XV_WIDTH);
	    
	    i = (int) xv_get(Spec_specWindow->spectrum, XV_WIDTH);
	    if (i == w && (w >= d || Spec_specWindow->hscroll != NULL))
		continue;
	    if (i < w)
	    {
		i = d;
		if (i > w)
		    i = w;
		xv_set(Spec_specWindow->spectrum, XV_WIDTH, i, NULL);
	    }
	    else
	    {
		xv_set(Spec_specWindow->spectrum, XV_WIDTH, w, NULL);
		i = w;
	    }
	    if (i >= d)
	    {
		if (Spec_specWindow->hscroll != NULL)
		{
		    xv_set(Spec_specWindow->spectrum, WIN_HORIZONTAL_SCROLLBAR,
			   FALSE, NULL);
		    Spec_specWindow->hscroll = NULL;
		    last_h = -1;
		}
	    }
	    else if (Spec_specWindow->hscroll == NULL)
	    {
		Spec_specWindow->hscroll = 	
		    xv_create(Spec_specWindow->spectrum, SCROLLBAR,
			      SCROLLBAR_SPLITTABLE, FALSE,
			      SCROLLBAR_DIRECTION, SCROLLBAR_HORIZONTAL,
			      NULL);
		last_h = -1;
	    }
	}

	if (last_h != h)
	{
	    last_h = h;
	    
	    d = specy*mag+2;
	    if (Spec_specWindow->hscroll != NULL)
		d += xv_get(Spec_specWindow->hscroll, XV_HEIGHT);

	    i = (int) xv_get(Spec_specWindow->spectrum, XV_HEIGHT);
	    if (i == w && (h >= d || Spec_specWindow->vscroll != NULL))
		continue;
	    if (i < h)
	    {
		i = d;
		if (i > h)
		    i = h;
		xv_set(Spec_specWindow->spectrum, XV_HEIGHT, i, NULL);
	    }
	    else
	    {
		xv_set(Spec_specWindow->spectrum, XV_HEIGHT, h, NULL);
		i = h;
	    }
	    if (i >= d)
	    {
		if (Spec_specWindow->vscroll != NULL)
		{
		    xv_set(Spec_specWindow->spectrum, WIN_VERTICAL_SCROLLBAR,
			   FALSE, NULL);
		    Spec_specWindow->vscroll = NULL;
		    last_w = -1;
		}
	    }
	    else if (Spec_specWindow->vscroll == NULL)
	    {
		Spec_specWindow->vscroll = 	
		    xv_create(Spec_specWindow->spectrum, SCROLLBAR,
			      SCROLLBAR_SPLITTABLE, FALSE,
			      SCROLLBAR_DIRECTION, SCROLLBAR_VERTICAL,
			      NULL);
		last_w = -1;
	    }
	}
	
	if ((int) xv_get(Spec_specWindow->spectrum, XV_WIDTH) >= specx*mag+2 &&
	    (int) xv_get(Spec_specWindow->spectrum, XV_HEIGHT) >= specy*mag+2
	    && (Spec_specWindow->hscroll != NULL ||
		Spec_specWindow->vscroll != NULL))
	{
	    xv_set(Spec_specWindow->spectrum, WIN_VERTICAL_SCROLLBAR, NULL,
		   WIN_HORIZONTAL_SCROLLBAR, NULL, NULL);
	    Spec_specWindow->hscroll = Spec_specWindow->vscroll = NULL;
	}

	if (last_w == w && last_h == h)
	    break;
    }

}

void event_proc(window, event, arg)
Xv_Window       window;
Event           *event;
Notify_arg      arg;
{
    if (event_action(event) == WIN_RESIZE &&
	event_xevent(event)->type == ConfigureNotify)
	resizeSpectrum();
}

/*ARGSUSED*/
Menu_item
showCustom(item, op)
	Menu_item	item;
	Menu_generate	op;
{
    if (op != MENU_NOTIFY)
	return item;

    xv_set(Spec_customPopup->customPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
    xv_set(Spec_customPopup->customPopup, XV_SHOW, TRUE, NULL);

    return item;
}

/*ARGSUSED*/
void
customPaletteApply(item, event)
	Panel_item	item;
	Event		*event;
{
    char *p, *q, *string;
    int n, c;
    struct colour *list, *lp;
    Display *dpy;
    Colormap cmap;
    XColor col, wincol;

    if ((string = strdup((char *)
			 xv_get(Spec_customPopup->customWindow, PANEL_VALUE)))
	== NULL)
    {
	notice_prompt(Spec_customPopup->customPopup, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "Out of memory trying to build palette.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return;
    }

    for(q = p = string; *p != '\0'; p++)
    {
	if (*p != ' ')
	    *q++ = *p;
    }
    *q = '\0';

    dpy = (Display *) XV_DISPLAY_FROM_WINDOW(Spec_customPopup->customPopup);
    cmap = DefaultColormapOfScreen(DefaultScreenOfDisplay(dpy));

    if (!XParseColor(dpy, cmap, string, &wincol))
    {
	notice_prompt(Spec_customPopup->customPopup, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "Unable to find definition of colour",
		      string,
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(string);
	return;
    }

    free(string);

    if ((string = strdup((char *)
			 xv_get(Spec_customPopup->customString, PANEL_VALUE)))
	== NULL)
    {
	notice_prompt(Spec_customPopup->customPopup, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "Out of memory trying to build palette.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	return;
    }

    for(p = string; *p != '-' && *p != '\0'; p++)
	;
    if (*p != '-')
    {
	notice_prompt(Spec_customPopup->customPopup, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "A palette must contain at least one smooth fade.",
		      "Use a - to signify a fade, for example, white-black.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(string);
	return;
    }
    
    for(q = p = string, n=1; *p != '\0'; p++)
    {
	if (*p == ',' || *p == '-')
	    n++;
	if (*p != ' ')
	    *q++ = *p;
    }
    *q = '\0';

    if ((list = calloc(n, sizeof(struct colour))) == NULL)
    {
	notice_prompt(Spec_customPopup->customPopup, NULL,
		      NOTICE_FOCUS_XY, event_x(event), event_y(event),
		      NOTICE_MESSAGE_STRINGS,
		      "Out of memory trying to build palette.",
		      NULL,
		      NOTICE_BUTTON_YES, "Ok",
		      NULL);
	free(string);
	return;
    }

    for(p = string, lp = list; ; lp++)
    {
	for(q = p; *q != '\0' && *q != '-' && *q != ','; q++)
	    ;
	c = *q;
	*q = '\0';
	if (!XParseColor(dpy, cmap, p, &col))
	{
	    notice_prompt(Spec_customPopup->customPopup, NULL,
			  NOTICE_FOCUS_XY, event_x(event), event_y(event),
			  NOTICE_MESSAGE_STRINGS,
			  "Unable to find definition of colour",
			  p,
			  NULL,
			  NOTICE_BUTTON_YES, "Ok",
			  NULL);
	    free(list);
	    free(string);
	    return;
	}
	lp->r = col.red>>8;
	lp->g = col.green>>8;
	lp->b = col.blue>>8;
	if (c == ',')
	    lp->fade = 0;
	else
	    lp->fade = 1;
	*q = c;
	if (*q != '\0')
	    p = q+1;
	else
	    p = q;
	if (c == '\0')
	    break;
    }

    rawColour[MAXCONTOURS].red = wincol.red>>8;
    rawColour[MAXCONTOURS].green = wincol.green>>8;
    rawColour[MAXCONTOURS].blue = wincol.blue>>8;

    contourColourList(list, n);

    free(list);
    free(string);
}
