#include <stdio.h>
#include <stdarg.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/svrimage.h>
#include <xview/scrollbar.h>
#include "spec_ui.h"
#include "xv_layout.h"

/*
 * Create object `palettes' in the specified instance.
 */
/*ARGSUSED*/
Xv_opaque
spec_palettes_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
    extern Menu_item contourColourHues();
    extern Menu_item contourColourGreyscale();
    extern Menu_item contourColourHeat();
    extern Menu_item contourColourReverseGreyscale();
    extern Menu_item contourColourTopographic();
    extern Menu_item contourColourColdAndHot();
    extern Menu_item showGamma();
    extern Menu_item changeToMonochrome();
    extern Menu_item changeToColour();
    extern Menu_item showCustom();
    Xv_opaque obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Hues",
			MENU_GEN_PROC, contourColourHues,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Greyscale",
			MENU_GEN_PROC, contourColourGreyscale,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Heat",
			MENU_GEN_PROC, contourColourHeat,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Reverse Greyscale",
			MENU_GEN_PROC, contourColourReverseGreyscale,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Topographic",
			MENU_GEN_PROC, contourColourTopographic,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Cold And Hot",
			MENU_GEN_PROC, contourColourColdAndHot,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Set Gamma...",
			MENU_GEN_PROC, showGamma,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Monochrome Display",
			MENU_GEN_PROC, changeToMonochrome,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Colour Display",
			MENU_INACTIVE, TRUE,
			MENU_GEN_PROC, changeToColour,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Custom palette",
			MENU_GEN_PROC, showCustom,
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `levelMenu' in the specified instance.
 */
/*ARGSUSED*/
Xv_opaque
spec_levelMenu_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Menu_item	contourLevelDefault();
	extern Menu_item	popupLinear();
	extern Menu_item	popupPseudo();
	extern Menu_item	addLevel();
	extern Menu_item	removeLevel();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Default",
			MENU_GEN_PROC, contourLevelDefault,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Linear...",
			MENU_GEN_PROC, popupLinear,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Pseudo-log...",
			MENU_GEN_PROC, popupPseudo,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Add level",
			MENU_INACTIVE, TRUE,
			MENU_GEN_PROC, addLevel,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Remove level",
			MENU_GEN_PROC, removeLevel,
			NULL,
		MENU_DEFAULT, 1,
		NULL);
	return obj;
}

/*
 * Create object `windowMenu' in the specified instance.
 */
/*ARGSUSED*/
Xv_opaque
spec_windowMenu_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Menu_item	showWithoutWindow();
	extern Menu_item	showInsideWindow();
	extern Menu_item	showOutsideWindow();
	extern Menu_item	showWindow();
	extern Menu_item	setWindow();
	extern Menu_item	clearWindow();
	extern Menu_item	abortSetWindow();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show without window",
			MENU_GEN_PROC, showWithoutWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show inside window",
			MENU_GEN_PROC, showInsideWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show outside window",
			MENU_GEN_PROC, showOutsideWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show window",
			MENU_GEN_PROC, showWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Set window",
			MENU_GEN_PROC, setWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Clear window",
			MENU_GEN_PROC, clearWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Abort set window",
			MENU_INACTIVE, TRUE,
			MENU_GEN_PROC, abortSetWindow,
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `autoscaleMenu' in the specified instance.
 */
/*ARGSUSED*/
Xv_opaque
spec_autoscaleMenu_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{
	extern Menu_item	autoscaleLinear();
	extern Menu_item	autoscaleLogarithmic();
	extern Menu_item	autoscaleHistogram();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Linear",
			MENU_GEN_PROC, autoscaleLinear,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Pseudo-logarithmic",
			MENU_GEN_PROC, autoscaleLogarithmic,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Histogram equalisation",
			MENU_GEN_PROC, autoscaleHistogram,
			NULL,
		MENU_DEFAULT, 1,
		NULL);
	return obj;
}

/*
 * Create object `magnifyMenu' in the specified instance.
 */
/*ARGSUSED*/

#define MAXSCALE 16

Xv_opaque
spec_magnifyMenu_create(ip, owner)
caddr_t ip;
Xv_opaque owner;
{
    extern Menu_item menuSetMagnification();
    Xv_opaque avl[MAXSCALE*11+8];
    int i, j;
    static char buf[MAXSCALE][3];

    i = 0;
    avl[i++] = (Xv_opaque) XV_KEY_DATA;
    avl[i++] = (Xv_opaque) INSTANCE;
    avl[i++] = (Xv_opaque) ip;
    avl[i++] = (Xv_opaque) MENU_NCOLS;
    avl[i++] = (Xv_opaque) 4;

    for(j=0; j<MAXSCALE; j++)
    {
	sprintf(buf[j], "%d", j+1);
	avl[i++] = (Xv_opaque) MENU_ITEM;
	avl[i++] = (Xv_opaque) XV_KEY_DATA;
	avl[i++] = (Xv_opaque) INSTANCE;
	avl[i++] = (Xv_opaque) ip;
	avl[i++] = (Xv_opaque) MENU_STRING;
	avl[i++] = (Xv_opaque) buf[j];
	avl[i++] = (Xv_opaque) MENU_GEN_PROC;
	avl[i++] = (Xv_opaque) menuSetMagnification;
	avl[i++] = (Xv_opaque) MENU_SELECTED;
	avl[i++] = (Xv_opaque) (j == 4);
	avl[i++] = (Xv_opaque) NULL;
    }

    avl[i++] = (Xv_opaque) MENU_DEFAULT;
    avl[i++] = (Xv_opaque) 4;
    avl[i++] = (Xv_opaque) NULL;

    return xv_create_avlist(XV_NULL, MENU_CHOICE_MENU, avl);
}

/*
 * Create object `slicingMenu' in the specified instance.
 */
/*ARGSUSED*/
Xv_opaque
spec_slicingMenu_create(ip, owner)
	caddr_t		ip;
	Xv_opaque	owner;
{

        extern Menu_item	toggleSlicing();
	extern Menu_item	setSliceWindow();
	extern Menu_item	reslice();
	extern Menu_item	arbitraryAngle();
	extern Menu_item	abortSetWindow();
	extern Menu_item	showWithoutWindow();
	extern Menu_item	showInsideWindow();
	extern Menu_item	showOutsideWindow();
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Slicing On",
			MENU_GEN_PROC, toggleSlicing,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Set Slice Window",
			MENU_GEN_PROC, setSliceWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Reslice",
			MENU_GEN_PROC, reslice,
			NULL,
       /* call directly the functions defined for windowMenu here */
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Arbitrary angle",
			MENU_GEN_PROC, arbitraryAngle,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Abort Slice Window",
			MENU_INACTIVE, TRUE,
			MENU_GEN_PROC, abortSetWindow,
			NULL,
		MENU_ITEM,
			MENU_STRING, "",
			MENU_INACTIVE, TRUE,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show without Window",
			MENU_GEN_PROC, showWithoutWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show inside Window",
			MENU_GEN_PROC, showInsideWindow,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Show outside Window",
			MENU_GEN_PROC, showOutsideWindow,
			NULL,		
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `specWindow'.
 */
spec_specWindow_objects *
spec_specWindow_objects_initialize(ip, owner)
	spec_specWindow_objects	*ip;
	Xv_opaque	owner;
{
    extern void	showPrint();
    extern void	showContours();
    extern void forkProgram();
    extern Notify_value	rubberBand();
    extern void	repaintSpectrum();
    extern void show3d();

    int y;

    if (ip)
	return ip;

    if (!(ip = (spec_specWindow_objects *)
	  calloc(1, sizeof (spec_specWindow_objects))))
	return (spec_specWindow_objects *) NULL;

    ip->specWindow = 
	xv_create(owner, FRAME,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 100,
		  XV_LABEL, "Spectrum nn",
		  FRAME_SHOW_FOOTER, TRUE,
/*		  FRAME_SHOW_RESIZE_CORNER, FALSE, */
		  NULL);
    ip->spectrumControls = 
	xv_create(ip->specWindow, PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, 64,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 2,
		  NULL);
    ip->printButton = 
	xv_create(ip->spectrumControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 7,
		  XV_Y, xv_row(ip->spectrumControls, 0),
		  PANEL_LABEL_STRING, "Print...",
		  PANEL_NOTIFY_PROC, showPrint,
		  NULL);
    ip->contourButton = 
	xv_create(ip->spectrumControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, OBJ_RIGHT(ip->printButton)+7,
		  XV_Y, xv_row(ip->spectrumControls, 0),
		  PANEL_LABEL_STRING, "Contours...",
		  PANEL_NOTIFY_PROC, showContours,
		  NULL);
    ip->windowButton = 
	xv_create(ip->spectrumControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, OBJ_RIGHT(ip->contourButton)+7,
		  XV_Y, xv_row(ip->spectrumControls, 0),
		  PANEL_LABEL_STRING, "Window",
		  PANEL_ITEM_MENU,
		  spec_windowMenu_create((caddr_t) ip, ip->specWindow),
		  NULL);
    ip->autoscaleButton = 
	xv_create(ip->spectrumControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, OBJ_RIGHT(ip->windowButton)+7,
		  XV_Y, xv_row(ip->spectrumControls, 0),
		  PANEL_LABEL_STRING, "Autoscale",
		  PANEL_ITEM_MENU,
		  spec_autoscaleMenu_create((caddr_t) ip, ip->specWindow),
		  NULL);
    ip->sliceButton = 
	xv_create(ip->spectrumControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, OBJ_RIGHT(ip->autoscaleButton)+7,
		  XV_Y, xv_row(ip->spectrumControls, 0),
		  PANEL_LABEL_STRING, "Slicing",
		  PANEL_ITEM_MENU,
		  spec_slicingMenu_create((caddr_t) ip, ip->specWindow),
		  NULL);
    ip->magnifyButton = 
	xv_create(ip->spectrumControls,  PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, OBJ_RIGHT(ip->sliceButton)+7,
		  XV_Y, xv_row(ip->spectrumControls, 0),
		  PANEL_LABEL_STRING, "Magnify",
		  PANEL_ITEM_MENU,
		  spec_magnifyMenu_create((caddr_t) ip, ip->specWindow),
		  NULL);
    ip->forkButton = 
	xv_create(ip->spectrumControls,  PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 7,
		  XV_Y, xv_row(ip->spectrumControls, 1),
		  PANEL_LABEL_STRING, "Fork",
		  PANEL_NOTIFY_PROC, forkProgram,
		  NULL);
    xv_set(ip->forkButton, XV_X, y = OBJ_RIGHT(ip->magnifyButton) -
	   (int) xv_get(ip->forkButton, XV_WIDTH), NULL);
    ip->button3d =
	xv_create(ip->spectrumControls,  PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 7,
		  XV_Y, xv_row(ip->spectrumControls, 1),
		  PANEL_LABEL_STRING, "3d...",
		  PANEL_NOTIFY_PROC, show3d,
		  NULL);
    xv_set(ip->button3d, XV_X, y - 10 -
	   (int) xv_get(ip->button3d, XV_WIDTH), NULL);
    ip->xy = 
	xv_create(ip->spectrumControls, PANEL_MESSAGE,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 7,
		  XV_Y, xv_row(ip->spectrumControls, 1),
		  PANEL_LABEL_STRING, "X,Y,Counts:",
		  PANEL_LABEL_BOLD, TRUE,
		  NULL);
    ip->coordinates = 
	xv_create(ip->spectrumControls, PANEL_MESSAGE,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, OBJ_RIGHT(ip->xy)+7,
		  XV_Y, xv_row(ip->spectrumControls, 1),
		  PANEL_LABEL_STRING, "(X, Y) = Counts",
		  PANEL_LABEL_BOLD, FALSE,
		  NULL);
    vc_align(ip->forkButton, ip->xy, ip->coordinates, NULL);

    /* Some of these settings are temporary, they are overridden in
       setMagnification() in spec_stubs.c */
    xv_set(ip->specWindow, XV_WIDTH, OBJ_RIGHT(ip->magnifyButton) + 7, NULL);
    xv_set(ip->spectrumControls, XV_HEIGHT,
	   y = xv_row(ip->spectrumControls, 2), NULL);
    xv_set(ip->specWindow, XV_HEIGHT, y + 514, NULL);
    ip->spectrum = 
	xv_create(ip->specWindow, CANVAS,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, y,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  CANVAS_REPAINT_PROC, repaintSpectrum,
		  CANVAS_X_PAINT_WINDOW, TRUE,
		  NULL);
    ip->hscroll = NULL;
    ip->vscroll = NULL;

    xv_set(canvas_paint_window(ip->spectrum), WIN_CONSUME_EVENTS,
	   WIN_MOUSE_BUTTONS,
	   NULL, NULL);
    notify_interpose_event_func(canvas_paint_window(ip->spectrum),
				(Notify_func) rubberBand, NOTIFY_SAFE);
    /*
     * This line is here for backwards compatibility. It will be
     * removed for the next release.
     */
    xv_set(canvas_paint_window(ip->spectrum), XV_KEY_DATA, INSTANCE, ip,
	   NULL);

    return ip;
}

/*
 * Initialize an instance of object `contourPopup'.
 */
spec_contourPopup_objects *
spec_contourPopup_objects_initialize(ip, owner)
	spec_contourPopup_objects	*ip;
	Xv_opaque	owner;
{
    if (ip)
	return ip;

    if (!(ip = (spec_contourPopup_objects *)
	  calloc(1, sizeof (spec_contourPopup_objects))))
	return (spec_contourPopup_objects *) NULL;

    ip->contourPopup =
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 100,
		  XV_LABEL, "Contours",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, TRUE,
		  NULL);
    ip->contourControls =
	xv_create(ip->contourPopup,  PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->presetPalette =
	xv_create(ip->contourControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->contourControls, 0),
		  PANEL_LABEL_STRING, "Palettes",
		  PANEL_ITEM_MENU,
		  spec_palettes_create((caddr_t) ip, ip->contourPopup),
		  NULL);
    ip->levels =
	xv_create(ip->contourControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->presetPalette),
		  XV_Y, xv_row(ip->contourControls, 0),
		  PANEL_LABEL_STRING, "Levels",
		  PANEL_ITEM_MENU,
		  spec_levelMenu_create((caddr_t) ip, ip->contourPopup),
		  NULL);

    /* The initialisation of this object is finished in
       initialiseContourObjects() in spec_stubs.c */

	return ip;
}

/*
 * Initialize an instance of object `levelPopup'.
 */
spec_levelPopup_objects *
spec_levelPopup_objects_initialize(ip, owner)
	spec_levelPopup_objects	*ip;
	Xv_opaque	owner;
{
    if (ip)
	return ip;

    if (!(ip = (spec_levelPopup_objects *)
	  calloc(1, sizeof (spec_levelPopup_objects))))
	return (spec_levelPopup_objects *) NULL;

    ip->levelPopup =
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 100,
		  XV_LABEL, "Set contour levels",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, TRUE,
		  NULL);
    ip->levelControls =
	xv_create(ip->levelPopup, PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->firstValue =
	xv_create(ip->levelControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->levelControls, 0),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "First contour:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->spacing =
	xv_create(ip->levelControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->levelControls, 1),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "Spacing:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->step =
	xv_create(ip->levelControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->levelControls, 1),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "Step:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->numContours =
	xv_create(ip->levelControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->levelControls, 2),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "Number of Contours:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->levelSetApply =
	xv_create(ip->levelControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->levelControls, 3),
		  PANEL_LABEL_STRING, "Apply",
		  NULL);
    
    hv_align(ip->firstValue, ip->spacing, ip->step, ip->numContours, NULL);

    window_fit(ip->levelControls);
    window_fit(ip->levelPopup);

    xv_set(ip->levelSetApply, XV_X,
	   ((int) xv_get(ip->levelControls, XV_WIDTH) - 
	    (int) xv_get(ip->levelSetApply, XV_WIDTH))/2, NULL);

    return ip;
}

/*
 * Initialize an instance of object `gammaPopup'.
 */
spec_gammaPopup_objects *
spec_gammaPopup_objects_initialize(ip, owner)
	spec_gammaPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern Panel_setting valueSetDisplayGamma();
    extern void sliderSetDisplayGamma();
    extern Panel_setting valueSetPrintoutGamma();
    extern void sliderSetPrintoutGamma();

    int x;

    if (ip)
	return ip;

    if (!(ip = (spec_gammaPopup_objects *)
	  calloc(1, sizeof (spec_gammaPopup_objects))))
	return (spec_gammaPopup_objects *) NULL;

    ip->gammaPopup =
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 20,
		  XV_LABEL, "Set Gamma",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, FALSE,
		  NULL);
    ip->gammaControls =
	xv_create(ip->gammaPopup,  PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->displayGammaValue =
	xv_create(ip->gammaControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->gammaControls, 0),
		  PANEL_VALUE_DISPLAY_LENGTH, 5,
		  PANEL_VALUE_STORED_LENGTH, 5,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Display gamma:",
		  PANEL_VALUE, "2.00",
		  PANEL_READ_ONLY, FALSE,
		  PANEL_NOTIFY_PROC, valueSetDisplayGamma,
		  NULL);
    ip->printoutGammaValue =
	xv_create(ip->gammaControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->gammaControls, 1),
		  PANEL_VALUE_DISPLAY_LENGTH, 5,
		  PANEL_VALUE_STORED_LENGTH, 5,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Printout gamma:",
		  PANEL_VALUE, "1.00",
		  PANEL_READ_ONLY, FALSE,
		  PANEL_NOTIFY_PROC, valueSetPrintoutGamma,
		  NULL);
    hv_align(ip->displayGammaValue, ip->printoutGammaValue, NULL);
    ip->displayGammaSlider =
	xv_create(ip->gammaControls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x = NEXT_COL(ip->displayGammaValue),
		  XV_Y, xv_row(ip->gammaControls, 0),
		  PANEL_SLIDER_WIDTH, 100,
		  PANEL_TICKS, 0,
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, FALSE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, FALSE,
		  PANEL_MIN_VALUE, 10,
		  PANEL_MAX_VALUE, 1000,
		  PANEL_MIN_VALUE_STRING, "0.1",
		  PANEL_MAX_VALUE_STRING, "10",
		  PANEL_VALUE, 200,
		  PANEL_NOTIFY_PROC, sliderSetDisplayGamma,
		  NULL);
    ip->printoutGammaSlider =
	xv_create(ip->gammaControls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x,
		  XV_Y, xv_row(ip->gammaControls, 1),
		  PANEL_SLIDER_WIDTH, 100,
		  PANEL_TICKS, 0,
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, FALSE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, FALSE,
		  PANEL_MIN_VALUE, 10,
		  PANEL_MAX_VALUE, 1000,
		  PANEL_MIN_VALUE_STRING, "0.1",
		  PANEL_MAX_VALUE_STRING, "10",
		  PANEL_VALUE, 100,
		  PANEL_NOTIFY_PROC, sliderSetPrintoutGamma,
		  NULL);

    xv_set(ip->gammaControls, XV_WIDTH, NEXT_COL(ip->printoutGammaSlider),
	   XV_HEIGHT, xv_row(ip->gammaControls, 2), NULL);
    window_fit(ip->gammaPopup);

    return ip;
}

/*
 * Initialize an instance of object `rgbPopup'.
 */
spec_rgbPopup_objects *
spec_rgbPopup_objects_initialize(ip, owner)
	spec_rgbPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern void		changeRed();
    extern void		changeGreen();
    extern void		changeBlue();

    if (ip)
	return ip;

    if (!(ip = (spec_rgbPopup_objects *)
	  calloc(1, sizeof (spec_rgbPopup_objects))))
	return (spec_rgbPopup_objects *) NULL;

    ip->rgbPopup =
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 20,
		  XV_LABEL, "Set Colour",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, FALSE,
		  NULL);
    ip->rgbControls =
	xv_create(ip->rgbPopup, PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->redSlider =
	xv_create(ip->rgbControls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->rgbControls, 0),
		  PANEL_SLIDER_WIDTH, 128,
		  PANEL_TICKS, 0,
		  PANEL_LABEL_STRING, "Red:",
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, TRUE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, TRUE,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 255,
		  PANEL_VALUE, 0,
		  PANEL_NOTIFY_PROC, changeRed,
		  NULL);
    ip->greenSlider =
	xv_create(ip->rgbControls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->rgbControls, 1),
		  PANEL_SLIDER_WIDTH, 128,
		  PANEL_TICKS, 0,
		  PANEL_LABEL_STRING, "Green:",
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, TRUE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, TRUE,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 255,
		  PANEL_VALUE, 0,
		  PANEL_NOTIFY_PROC, changeGreen,
		  NULL);
    ip->blueSlider =
	xv_create(ip->rgbControls, PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->rgbControls, 2),
		  PANEL_SLIDER_WIDTH, 128,
		  PANEL_TICKS, 0,
		  PANEL_LABEL_STRING, "Blue:",
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, TRUE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, TRUE,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 255,
		  PANEL_VALUE, 0,
		  PANEL_NOTIFY_PROC, changeBlue,
		  NULL);
    hv_align(ip->redSlider, ip->greenSlider, ip->blueSlider, NULL);

    xv_set(ip->rgbControls, XV_WIDTH, NEXT_COL(ip->redSlider),
	   XV_HEIGHT, xv_row(ip->rgbControls, 3), NULL);
    window_fit(ip->rgbPopup);

    return ip;
}

/*
 * Initialize an instance of object `printerPopup'.
 */
spec_printerPopup_objects *
spec_printerPopup_objects_initialize(ip, owner)
	spec_printerPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern void	printTo();
    extern Panel_setting printXGain();
    extern Panel_setting printXOffset();
    extern Panel_setting printYGain();
    extern Panel_setting printYOffset();
    extern void printSpectrum();
    extern void print3d();

    int x, t;

    if (ip)
	return ip;

    if (!(ip = (spec_printerPopup_objects *)
	  calloc(1, sizeof (spec_printerPopup_objects))))
	return (spec_printerPopup_objects *) NULL;
    
    ip->printerPopup = 
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 100,
		  XV_LABEL, "Printer select",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, TRUE,
		  NULL);
    ip->printerControls = 
	xv_create(ip->printerPopup, PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->printTo = 
	xv_create(ip->printerControls, PANEL_CHOICE,
		  PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 0),
		  PANEL_CHOICE_NCOLS, 1,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Print to:",
		  PANEL_NOTIFY_PROC, printTo,
		  PANEL_CHOICE_STRINGS,
		  "Printer",
		  "File (Postscript)",
		  "File (Encapsulated Postscript)",
		  NULL,
		  PANEL_VALUE, 0,
		  NULL);
    ip->printerPalette = 
	xv_create(ip->printerControls, PANEL_CHOICE,
		  PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 1),
		  PANEL_CHOICE_NCOLS, 1,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Printer Palette:",
		  PANEL_CHOICE_STRINGS,
		  "White to Black (no gamma)",
		  "Greyscale version of display (gamma)",
		  "Colour (gamma)",
		  NULL,
		  NULL);
    ip->printString = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 2),
		  PANEL_VALUE_DISPLAY_LENGTH, 35,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "Printer control string:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "lp -o nobanner -c",
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printFilename = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 2),
		  PANEL_VALUE_DISPLAY_LENGTH, 35,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "Print Filename:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "pout.ps",
		  XV_SHOW, FALSE,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printXLabel = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 3),
		  PANEL_VALUE_DISPLAY_LENGTH, 35,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "X label:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printYLabel = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 4),
		  PANEL_VALUE_DISPLAY_LENGTH, 35,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "Y Label:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printTitle = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 5),
		  PANEL_VALUE_DISPLAY_LENGTH, 35,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "Title:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printSubtitle = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 6),
		  PANEL_VALUE_DISPLAY_LENGTH, 35,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "Subtitle:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printScaleSlider = 
	xv_create(ip->printerControls,  PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 7),
		  PANEL_SLIDER_WIDTH, 150,
		  PANEL_TICKS, 16,
		  PANEL_LABEL_STRING, "Scaling (%):",
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, FALSE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, TRUE,
		  PANEL_MIN_VALUE, 25,
		  PANEL_MAX_VALUE, 400,
		  PANEL_VALUE, 100,
		  NULL);
    ip->printXGain = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 8),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "X: Units = channels *",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "1",
		  PANEL_NOTIFY_PROC, printXGain,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printYGain = 
	xv_create(ip->printerControls,  PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 9),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "Y: Units = channels *",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "1",
		  PANEL_NOTIFY_PROC, printYGain,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    hv_align(ip->printTo, ip->printerPalette, ip->printString,
	     ip->printFilename, ip->printXLabel, ip->printYLabel,
	     ip->printTitle, ip->printSubtitle, ip->printScaleSlider,
	     ip->printXGain, ip->printYGain, NULL);

    x = NEXT_COL(ip->printXGain);
    if ((t = NEXT_COL(ip->printYGain)) > x)
	x = t;
    ip->printXOffset = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x,
		  XV_Y, xv_row(ip->printerControls, 8),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "+",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "0",
		  PANEL_NOTIFY_PROC, printXOffset,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->printYOffset = 
	xv_create(ip->printerControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x,
		  XV_Y, xv_row(ip->printerControls, 9),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "+",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "0",
		  PANEL_NOTIFY_PROC, printYOffset,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->doPrint = 
	xv_create(ip->printerControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 10),
		  PANEL_LABEL_STRING, "Print 2d",
		  PANEL_NOTIFY_PROC, printSpectrum,
		  NULL);
    ip->doPrint3d = 
	xv_create(ip->printerControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->printerControls, 10),
		  PANEL_LABEL_STRING, "Print 3d",
		  PANEL_NOTIFY_PROC, print3d,
		  NULL);

    window_fit(ip->printerControls);
    window_fit(ip->printerPopup);

    hlw_align(ip->doPrint, ip->doPrint3d, NULL);

    x = (int) xv_get(ip->printerControls, XV_WIDTH)/2; 
    xv_set(ip->doPrint, XV_X, x - (int) xv_get(ip->doPrint, XV_WIDTH) - 5, 
	   NULL);
    xv_set(ip->doPrint3d, XV_X, x + 5, NULL);

    return ip;
}

/*
 * Initialize an instance of object `projectPopup'.
 */
spec_projectPopup_objects *
spec_projectPopup_objects_initialize(ip, owner)
	spec_projectPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern projectDone();
    extern void setProjectArea();
    extern Panel_setting valueSetProjectAngle();
    extern void sliderSetProjectAngle();
    extern void doProjection();
    extern void	repaintProjection();
    extern void setProjectAxis();
    extern Panel_setting projectXGain();
    extern Panel_setting projectXOffset();
    extern Panel_setting projectYGain();
    extern Panel_setting projectYOffset();
    extern Panel_setting projectXTarget();
    extern Panel_setting projectYTarget(); 
    extern Panel_setting setPolynomial(); 
    extern void scaleDown();
    extern void scaleUp();

    int x, y, t;

    if (ip)
	return ip;

    if (!(ip = (spec_projectPopup_objects *)
	  calloc(1, sizeof (spec_projectPopup_objects))))
	return (spec_projectPopup_objects *) NULL;

    ip->projectPopup = 
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 100,
		  XV_LABEL, "Slicing",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, TRUE,
		  FRAME_DONE_PROC, projectDone,
		  NULL);
    ip->projectControls = 
	xv_create(ip->projectPopup,  PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, 100,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->projectArea = 
	xv_create(ip->projectControls, PANEL_CHOICE,
		  PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->projectControls, 0),
		  PANEL_CHOICE_NCOLS, 1,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Project Area:",
		  PANEL_CHOICE_STRINGS,
		  "Whole spectrum",
		  "Inside window",
		  NULL,
		  PANEL_NOTIFY_PROC, setProjectArea,
		  NULL);
    ip->projectAxis = 
	xv_create(ip->projectControls, PANEL_CHOICE,
		  PANEL_DISPLAY_LEVEL, PANEL_CURRENT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->projectArea),
		  XV_Y, xv_row(ip->projectControls, 0),
		  PANEL_CHOICE_NCOLS, 1,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Axis:",
		  PANEL_CHOICE_STRINGS,
		  "Perpendicular",
		  "X",
		  "Y",
		  NULL,
		  PANEL_NOTIFY_PROC, setProjectAxis,
		  NULL);
    ip->doProject = 
	xv_create(ip->projectControls,  PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->projectAxis),
		  XV_Y, xv_row(ip->projectControls, 0),
		  PANEL_LABEL_STRING, "Do Projection",
		  PANEL_NOTIFY_PROC, doProjection,
		  NULL);
    vc_align(ip->projectArea, ip->projectAxis, ip->doProject, NULL);
    ip->projectAngleValue = 
	xv_create(ip->projectControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->projectControls, 1),
		  PANEL_VALUE_DISPLAY_LENGTH, 5,
		  PANEL_VALUE_STORED_LENGTH, 5,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "90.0",
		  PANEL_LABEL_STRING, "Projection angle:",
		  PANEL_READ_ONLY, FALSE,
		  PANEL_NOTIFY_PROC, valueSetProjectAngle,
		  NULL);
    ip->projectAngleSlider = 
	xv_create(ip->projectControls,  PANEL_SLIDER,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->projectAngleValue),
		  XV_Y, xv_row(ip->projectControls, 1),
		  PANEL_SLIDER_WIDTH, 100,
		  PANEL_TICKS, 0,
		  PANEL_DIRECTION, PANEL_HORIZONTAL,
		  PANEL_SLIDER_END_BOXES, FALSE,
		  PANEL_SHOW_RANGE, TRUE,
		  PANEL_SHOW_VALUE, FALSE,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 1800,
		  PANEL_MIN_VALUE_STRING, "0.0",
		  PANEL_MAX_VALUE_STRING, "180.0",
		  PANEL_VALUE, 900,
		  PANEL_NOTIFY_PROC, sliderSetProjectAngle,
		  NULL);
    ip->projectXGain = 
	xv_create(ip->projectControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->projectControls, 2),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "X: Degrees = channels *",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "1",
		  PANEL_NOTIFY_PROC, projectXGain,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->projectXOffset = 
	xv_create(ip->projectControls,  PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x = NEXT_COL(ip->projectXGain),
		  XV_Y, xv_row(ip->projectControls, 2),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "+",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "0",
		  PANEL_NOTIFY_PROC, projectXOffset,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->passingLabel = 
	xv_create(ip->projectControls, PANEL_MESSAGE,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->projectXOffset),
		  XV_Y, xv_row(ip->projectControls, 2),
		  PANEL_LABEL_STRING, "Project onto line through",
		  PANEL_LABEL_BOLD, TRUE,
		  NULL);
    ip->projectYGain = 
	xv_create(ip->projectControls,  PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->projectControls, 3),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "Y: Degrees = channels *",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "1",
		  PANEL_NOTIFY_PROC, projectYGain,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->projectYOffset = 
	xv_create(ip->projectControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x,
		  XV_Y, xv_row(ip->projectControls, 3),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "+",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "0",
		  PANEL_NOTIFY_PROC, projectYOffset,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->projectXTarget = 
	xv_create(ip->projectControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, x = NEXT_COL(ip->projectYOffset),
		  XV_Y, y = xv_row(ip->projectControls, 3),
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, "",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "0",
		  PANEL_NOTIFY_PROC, projectXTarget,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->projectYTarget = 
	xv_create(ip->projectControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->projectXTarget),
		  XV_Y, y, 
		  PANEL_VALUE_DISPLAY_LENGTH, 8,
		  PANEL_VALUE_STORED_LENGTH, 80,
		  PANEL_LABEL_STRING, ",",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, "0",
		  PANEL_NOTIFY_PROC, projectYTarget,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    xv_set(ip->passingLabel, XV_Y, y -
	   (int) xv_get(ip->passingLabel, XV_HEIGHT) - 5, NULL);
    y = OBJ_RIGHT(ip->projectYTarget) - x;
    t = (int) xv_get(ip->passingLabel, XV_WIDTH);
    if (t < y)
	xv_set(ip->passingLabel, XV_X, x + (y - t)/2, NULL);
    else
    {
	xv_set(ip->projectXTarget, XV_X, x + (t - y)/2, NULL);
	xv_set(ip->projectYTarget, XV_X, NEXT_COL(ip->projectXTarget), NULL);
    }

    ip->polynomial = 
	xv_create(ip->projectControls, PANEL_NUMERIC_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->projectControls, 4),
		  PANEL_VALUE_DISPLAY_LENGTH, 2,
		  PANEL_VALUE_STORED_LENGTH, 4,
		  PANEL_LABEL_STRING, "|P|\262 order",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE, 0,
		  PANEL_MIN_VALUE, 0,
		  PANEL_MAX_VALUE, 50,
		  PANEL_NOTIFY_PROC, setPolynomial,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->scaleUp = 
	xv_create(ip->projectControls,PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->polynomial),
		  XV_Y, xv_row(ip->projectControls, 4),
		  PANEL_LABEL_STRING, "+",
		  PANEL_NOTIFY_PROC, scaleUp,
		  NULL);
    ip->scaleDown = 
	xv_create(ip->projectControls,  PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, NEXT_COL(ip->scaleUp),
		  XV_Y, xv_row(ip->projectControls, 4),
		  PANEL_LABEL_STRING, "-",
		  PANEL_NOTIFY_PROC, scaleDown,
		  NULL);
    vc_align(ip->polynomial, ip->scaleUp, ip->scaleDown, NULL);
    window_fit_width(ip->projectControls);
    if ((x = (int) xv_get(ip->projectControls, XV_WIDTH)) < 514)
	xv_set(ip->projectControls, XV_WIDTH, x = 514, NULL);
    xv_set(ip->projectControls, XV_HEIGHT, xv_row(ip->projectControls, 5),
	   NULL);
    xv_set(ip->projectPopup, XV_HEIGHT,
	   (int) xv_get(ip->projectControls, XV_HEIGHT) + 288, NULL);

    ip->projection = 
	xv_create(ip->projectPopup, CANVAS,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, (x - 514)/2,
		  XV_Y, OBJ_BOT(ip->projectControls),
		  XV_WIDTH, 514,
		  XV_HEIGHT, 257,
		  CANVAS_REPAINT_PROC, repaintProjection,
		  CANVAS_X_PAINT_WINDOW, TRUE,
		  NULL);
    /*
     * This line is here for backwards compatibility. It will be
     * removed for the next release.
     */
    xv_set(canvas_paint_window(ip->projection), XV_KEY_DATA, INSTANCE, ip,
	   NULL);

    window_fit_width(ip->projectPopup);
    if (x > 514)
    {
	x = (x - 514)/2;
	if (x > 10)
	    x = 10;
    }
    else
	x = 0;
    xv_set(ip->projectPopup, XV_HEIGHT, OBJ_BOT(ip->projection) + x, NULL);
    
    return ip;
}

/*
 * Initialize an instance of object `customPopup'.
 */
spec_customPopup_objects *
spec_customPopup_objects_initialize(ip, owner)
	spec_customPopup_objects	*ip;
	Xv_opaque	owner;
{
    extern void customPaletteApply();

    if (ip)
	return ip;

    if (!(ip = (spec_customPopup_objects *)
	  calloc(1, sizeof (spec_customPopup_objects))))
	return (spec_customPopup_objects *) NULL;

    ip->customPopup = 
	xv_create(owner, FRAME_CMD,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 10,
		  XV_LABEL, "Custom Palette",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  NULL);
    ip->customControls = 
	xv_create(ip->customPopup,  PANEL,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  WIN_ROW_GAP, 4,
		  NULL);
    ip->customString =
	xv_create(ip->customControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, xv_row(ip->customControls, 0),
		  PANEL_VALUE_DISPLAY_LENGTH, 70,
		  PANEL_VALUE_STORED_LENGTH, 255,
		  PANEL_LABEL_STRING, "Enter palette as a list of colours "
		      "separated by commas or dashes*",
		  PANEL_LAYOUT, PANEL_VERTICAL,
		  PANEL_READ_ONLY, FALSE,
		  PANEL_VALUE, "black,white-yellow-red-green-cyan-blue",
		  NULL);
    ip->customWindow =
	xv_create(ip->customControls, PANEL_TEXT,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->customString),
		  PANEL_VALUE_DISPLAY_LENGTH, 30,
		  PANEL_VALUE_STORED_LENGTH, 30,
		  PANEL_LABEL_STRING, "Window colour:",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_READ_ONLY, FALSE,
		  PANEL_VALUE, "pink",
		  NULL);
    ip->customApply =
	xv_create(ip->customControls, PANEL_BUTTON,
		  XV_KEY_DATA, INSTANCE, ip,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->customWindow),
		  PANEL_LABEL_STRING, "Apply",
		  PANEL_NOTIFY_PROC, customPaletteApply,
		  NULL);

    window_fit(ip->customControls);
    window_fit(ip->customPopup);

    xv_set(ip->customApply, XV_X,
	   ((int) xv_get(ip->customControls, XV_WIDTH) -
	    (int) xv_get(ip->customApply, XV_WIDTH))/2, NULL);

    return ip;
}
