/*cal.h     declarations used in calibration and sort routines*/

/*Calibration parameters*/
#define PULVETO   22                  /*minimum pulser signal multiplicity*/
#define PULVETOS  30, 30, 30, 30, 30, 30, 30, 30, 22, 30  /*crate by crate*/
#define PSCALE   256.0
#ifndef MIN_ENERGY
#define MIN_ENERGY 0.0
#endif
#ifndef MAX_ENERGY
#define MAX_ENERGY 9999999999.0
#endif
#define MIN_T 0
#define MAX_T 8000

/*spectrum scaling*/
#ifndef ASCALE
#define ASCALE 32
#endif
#ifndef TSCALE
#define TSCALE 8
#endif
#ifndef ESCALE
#define ESCALE 32
#endif
#ifndef THSCALE
#define THSCALE 4
#endif
#ifndef Q2SCALE
#define Q2SCALE 32
#endif

#define EDIV (1.0/ESCALE)
#define Q2DIV (1.0/Q2SCALE)

/*Special spectrum numbers*/
#define SP1_MONITOR 385
#define SP1_CHANNSAT 386
#define SP1_ZEROAT   387
#define SP2_AHIT    1
#define SP2_THIT    2
#define SP2_CMULT   3
#define SP2_PMULT   4
#define SP2_CHANNSA 5
#define SP2_CHANNST 6
#define SP2_PULSERA 7
#define SP2_PULSERT 8
#define SP2_THPHI   11
#define SP2_TDIFF   12
#define SP2_TABS    13
#define SP2_CAL     100  /*ALL detector calibrations into one spectrum*/
#define SP2_EVX     51

/*Event classification*/
#define EV_OK 0
#define EV_PULSER 1
#define EV_SKIP   -1
#define EV_ABORT  -2

int cal_init(void);  /*Calibration initialisation*/
int cal(void);     /*Ebye calibration routines*/

/*user defined detector procedures*/
int strip_event(int, struct detectors *);
int monitor_event(int, struct detectors *);
