/*
 * Main code for calculating theta of PSSD strip ends         Steve Chappell
 *
 * usage "pssd_angs coordfile ndet" 
 */

#include <stdio.h>
#include <stdlib.h>
#include "../evsubs.h"

int main(int argc, char **argv)
{
    FILE *fp;
    char *infile;
    int i,j,k,ndet;
    struct xy xydat;
    struct vector hitvec;
    float xdat[] = {-0.5, 0.5};
            
    if (argc != 3){
	printf("usage: pssd_angs coordfile ndet\n");
	return 1;
    }
    infile = *++argv;
    ndet = atoi(*++argv);
    
    if(coord_init(ndet) != 0){  /*initialise detector coordinates*/
	fprintf(stderr, "Error initialising Co-ordinates\n");
	return 1;
    }

    if((fp = fopen(infile, "r")) == NULL)
    {
	perror(infile);
	return 1;
    }
    
    /*read abcd coordinates for each detector*/
    
    for(i=1;i<ndet+1;i++){
	if(coord_det(i,fp) != 0)
	    return 1;
    }
    fclose(fp);
    /*End of Inputs*/

    
    if((fp = fopen("pssd_angs.out","w"))!= NULL){
	fprintf(stderr, "Writing output to file \"%s\".\n",
		"pssd_angs.out");
    }
    
    fprintf(stderr, "\n xdat ydat :  x y th phi\n\n");
    
    for(i=1; i<ndet+1; i++){
	fprintf(stderr,"\ndet: %i\n",i);
	fprintf(fp,"\n");
	for(k=0;k<16;k++){
	    for(j=0; j<2; j++){
		xydat.x=xdat[j];
		xydat.y = k * 0.0625 - .46875;
		coord(i,&xydat,&hitvec);
		fprintf(stderr, " %8.3f %8.3f : %8.3f %8.3f\n",
			xydat.x,xydat.y,vector_td(&hitvec),vector_pd(&hitvec));
		fprintf(fp, "%8.3f\n", vector_td(&hitvec),vector_pd(&hitvec));
	    }
	}
    }
    
    fprintf(stderr,"finished\n");
    fclose(fp);
    return 0;
}
