********Classical calculation for 2-body breakup angles and energies
********                                       ...........SPC Sep '93




       program twobody

       implicit none
       double precision ecm,e1,m1,m2,m3,m4,th3,e3a,e3b,e4a,e4b,thcm
       double precision ex,et,q,th3r,th4a,th4b,th4ra,th4rb,a,b,c
       double precision ex1,ex2
       double precision thresh

       write(6,*) 'input Ebeam'
       read*,e1
       write(6,*) 'input Ex1,Ex2'
       read*,ex1,ex2

       m1 = 12.0
       m2 = 12.0
       m3 = 12.0
       m4 = 12.0

       ecm = m2*e1/(m1+m2)

       ex=ex1+ex2

       open(unit=10,file='./2body.out')


*       do 200 while(ecm.le.40.0)

       thresh=0.0
       th3= 0.0


       q = -1.0*ex
       et = e1+q

       write(6,*) 'Ecm= ',ecm,' E1= ',e1,' Ex= ',ex 
       write(6,*) ' th3, th4a, th4b, e3a, e3b,e4a, e4b ' 
 
 50    th3r=th3/180.0*3.14159

       a = m3 + m4
       b = -2.0*(dsqrt(m1*m3*e1))*dcos(th3r)
       c = -(m4-m1)*e1-m4*q

       if( (b**2).lt.(4.0*a*c)) then
           write(6,*) 'only one solution at ',th3
           goto 110
       end if

*two solutions for each th3 (e3a,e4a,th4a) (e3b,e4b,th4b)       

       e3a = ( (-b+ dsqrt((b**2) - 4*a*c))/(2*a))**2
       e3b = ( (-b-dsqrt ((b**2) - 4*a*c))/(2*a))**2

       e4a = et - e3a
       e4b = et - e3b

       th4ra=dasin((dsqrt((m3*e3a)/(m4*e4a)))*dsin(th3r))
       th4a=th4ra*180.0/3.14159
       th4rb=dasin((dsqrt((m3*e3b)/(m4*e4b)))*dsin(th3r))
       th4b=th4rb*180.0/3.14159

       thcm=dasin(dsin(th3r)*sqrt(e3a*(m1+m2)*(m3+m4)/
     +  (m4*(m2*(e3a+e4a)+m1*q))))*180.0/3.14159

        if(e3a.lt.thresh) then
           th4a = -10.0
        endif
       if(e3b.lt.thresh) then
           th4b = -10.0
        endif
        if(e4a.lt.thresh) then
           th4a = -10.0
        endif
        if(e4b.lt.thresh) then
           th4b = -10.0
        endif

       write(10,'(10f8.3)') th3,th4a,th4b,e3a,e3b,e4a,e4b,thcm
*       write(6,'(10f8.3)') th3,th4a,th4b,e3a,e3b,e4a,e4b,thcm

 100   th3=th3+0.1

       if(th3.le.90.) goto 50

 110   continue

*       ecm = ecm + 1

 200   continue

       close(10)

       end
