/*
 * ''cal_init''   Calibration Setup                           Steve Chappell
 *
 * Subroutines to set up calibration
 *                                          
 */

#include <stdio.h>
#include <stdlib.h>
#include ".sunsort_initadc.h"
#include <subs.h>
#include "cal.h"

/*
 * calset called from init
 */
int cal_init(void)
{
    /*initialise next generation code*/
    if(nextgen_init(0,   /*no egmap*/
		    49,  /*max number ADC/TDC channel*/
		    0    /*No auto TDC numbering*/)) 
	return ABORT;

    /* Select the procedures to be called for the different types of
       detectors by detector_init and detector_event...

       user_ procedures defined in cal_init.c and cal.c
       proc_ procedures are defined in the library code detproc.c */

    setdetprocs("experiment", proc_expt_preinit, proc_expt_init, NULL, NULL);
    setdetprocs("typeA",      user_typeA_preinit,  user_typeA_init, 
		              user_typeA_preevent, user_typeA_event);
    setdetprocs("typeB",      NULL, user_typeB_init, NULL, user_typeB_event);
    setdetprocs("segment",    NULL, user_segment_init,NULL,user_segment_event);
    setdetprocs("signala",    NULL, proc_ampsig_init, NULL, NULL);
    setdetprocs("signalb",    NULL, proc_ampsig_init, NULL, NULL);
    setdetprocs("signale",    NULL, proc_ampsig_init, NULL, NULL);
    setdetprocs("junksig",    NULL, NULL, NULL, proc_junksig_event);
 
    /* Run detector_init procedures */
    if (detector_init(expt) == DET_ABORTSORT)
	return ABORT;
    
    expt_dump(expt, 0);         /*Output the experiment set-up*/


    return OK;
}



/* Put user functions called by detector_init here.............. */

int user_typeA_preinit(struct detectors *dp)
{
    fprintf(stderr,"Running preinit for: det %d (%s)\n",dp->number,
	    dp->info->name);
    return DET_OK;
}


int user_typeA_init(struct detectors *dp)
{
    fprintf(stderr,"Running init for: det %d (%s)\n",dp->number,
	    dp->info->name);
    return DET_OK;
}

int user_typeB_init(struct detectors *dp)
{
    fprintf(stderr,"Running init for: det %d (%s)\n",dp->number,
	    dp->info->name);
    return DET_OK;
}

int user_segment_init(struct detectors *dp)
{
    fprintf(stderr,"Running init for: %s %d of det %d\n",dp->info->name, 
	    dp->number, dp->parent->number);
    return DET_OK;
}
