/* coord.h     coordinate header file*/

struct xy {     /*2 components of a trajectory*/
    double x;
    double y;
}; 

struct xyz {     /*3 components of a trajectory*/
    double x;
    double y;
    double z;
}; 

struct det_coord { 
    double Xp0;    /*X position of detector centre*/
    double Yp0;    /*Y position of detector centre*/
    double Xp2;    /*modulus squared of X vector*/
    double Yp2;    /*modulus squared of Y vector*/
    struct xyz ra; /*detector corner coordinates*/
    struct xyz rb;
    struct xyz rc;
    struct xyz rd;
    struct xyz r0; /*detector centre coordinates*/
    struct xyz Xp; /*X position vector*/
    struct xyz Yp; /*Y position vector*/
    struct xyz n;  /*normal vector*/
};

struct traj {    /* Trajectories for correlations*/
    double ths;          /* Nb.Particles hi,li in lab, vrp in c.m. frame */
    double phis;        
    double psi;
    double chi;
    struct xyz vrel;    /*relative velocities between hi and li*/
    struct xyz p_li;    /*li momenta*/
    struct xyz p_hi;    /*hi momenta*/
    struct xyz p_vrp;   /*vrp momenta*/
};

struct coords {   /*co-ordinate schemes for correlations*/
    struct traj polar;
    struct traj axial;
    struct traj basel;
};

extern struct coords pspace, *psp;
extern struct det_coord *dcp;

int coord_input(int, char *);
int coord(int, struct xy *, struct vector *);
int det_coord(int, struct xy *, struct vector *);
int coord_init(int);
int coord_det(int, FILE *);
int coord_andet(int, FILE *);
int det_hit(int, double, double);
int ndet_hit(int, double, double);
void freehitbins(void);
int inithitbins(double, double);
int *gethitbin(double, double);
