/*
 * ''crhit''      Recalculate and copy hit                      Steve Chappell
 *
 *   General Subroutines to recalculate event parameters of a hit
 *   given that the mass originally associated with the 
 *   particle has been changed

 * Updates
 *   6th Mar 98: Recalculates resonant particles too
 *   10th Jun 98: chit to copy hit to new position in ev array
 *              : crhit to copy hit then recalculate mass for new position
 *   
 */

#include <stdio.h>
#include <string.h>
#include <math.h>
#include "evsubs.h"

/* Note changed syntax of chit to match other functions */

particle *chit(particle *new, particle *old)
{
    memcpy(new, old, sizeof(particle));
    return new;
}

void chit_(int *new, int *old)
{
    chit(evhead.ev+*new, evhead.ev+*old);
}

particle *new_chit(particle *old)
{
    particle *new;
    int n;
    struct evhead *evh;

    evh = old->head;

    n = evh->n[0]+1;
    if(n > evh->numparticles){
	fprintf(stderr,"new_chit: Error ev[%d] > MAX(%d)!\n", n,
		evh->numparticles);
	return NULL;
    }
    evh->n[0] = n;
    new = evh->ev + n;
    return chit(new, old);
}

int new_chit_(int *old)
{
    particle *new;
    
    new = new_chit(evhead.ev+*old);
    return (new == NULL) ? -1 : (new - evhead.ev);
}

/* Note changed syntax of crhit */

particle *crhit(particle *new, double newmass, particle *old)
{
    chit(new, old);
    evs_m(new, newmass);
    return new;
}

void crhit_(int *new, double *newmass, int *old)
{
    crhit(evhead.ev+*new, *newmass, evhead.ev+*old);
}

particle *new_crhit(double newmass, particle *old)
{
    particle *new;

    if ((new = new_chit(old)) != NULL)
	evs_m(new, newmass);
    return new;
}

int new_crhit_(double *newmass, int *old)
{
    particle *new;

    new = new_crhit(*newmass, evhead.ev+*old);
    return (new == NULL) ? -1 : (new - evhead.ev);
}
