/*
 *  Detector Routines                                   Steve Chappell
 *
 *  Generic procedures to set up detector structure
 */

#include <stdio.h>
#include "structure.h"
#include "detector.h"
#include "fortprop.h"

int detector_init(struct detectors *dp)
{
    int i;

    while (dp != NULL)
    {
	if (dp->info->preinit.c != NULL)
	{
	    if (dp->info->preinit_type == DETPROC_C)
		i = dp->info->preinit.c(dp);
	    else
	    {
		detector_ = dp;
		i = dp->info->preinit.f();
	    }
	    if (DET_SOFT(i))
		continue;
	    else if (DET_HARD(i))
		return i;
	}
	if (dp->children != NULL && DET_HARD(i = detector_init(dp->children)))
	    return i;
	if (dp->info->init.c != NULL)
	{
	    if (dp->info->init_type == DETPROC_C)
		i = dp->info->init.c(dp);
	    else
	    {
		detector_ = dp;
		i = dp->info->init.f();
	    }
	    if (DET_HARD(i))
		return i;
	}
	dp = dp->next;
    }

    return DET_OK;
}

int detector_init_()
{
    return detector_init(expt);
}

/*
 * Detector event handler
 *        loops through all detector signals
 */

int detector_event(int proc, struct detectors *dp)
{
    int i;
    struct information *info;
    struct detectors *tmp;

    for(;;)
    {
	info = dp->info;

	if (dp->hitlist.head != NULL)
	{
	    if (info->preevent.c != NULL)
	    {
		if ((info->preevent_type & DETPROC_LANG_MASK) == DETPROC_C)
		    i = info->preevent.c(proc, dp);
		else
		{
		    detector_ = dp;
		    i = info->preevent.f(&proc);
		}
		if (DET_SOFT(i))
		    goto DET_CONT;
		else if (DET_HARD(i))
		    break;
	    }
	    dp = dp->hitlist.head;
	    continue;
	}
    DET_LOOP:
	;
	if (info->event.c != NULL)
	{
	    if ((info->event_type & DETPROC_LANG_MASK) == DETPROC_C)
		i = info->event.c(proc, dp);
	    else
	    {
		detector_ = dp;
		i = info->event.f(&proc);
	    }
	    if (DET_HARD(i))
		break;
	}

    DET_CONT:
	;

	if ((tmp = dp->hitlist.next) != NULL)
	    dp = tmp;
	else
	{
	    if ((dp = dp->parent) == NULL)
	    {
		i = DET_OK;
		break;
	    }
	    info = dp->info;
	    goto DET_LOOP;
	}
    }
    
    return i;

}

int detector_event_(int *proc)
{
    return detector_event(*proc, expt);
}

