/*
 * ''missing_p''     Missing Momentum                      Steve Chappell
 *
 *   General Subroutine to reconstruct a new particle from the missing 
 *   momentum and fill out the event structure
 
 * Notes
   evhead.pmult[*] and evhead.n[1] are NOT changed here, but evhead.etot, 
   but evhead.n[*] IS. The actual hit multiplicity can therefore be tracked! 
 

 * Updates
 *   20th May 98: Birth
     22nd May 98: Keep the convention of Phi in positive range 0->360
     14th Jan 99: Put particle in next available slot of ev array.
                  instead of straight after singles.
      7th Jun 99: n[1] is updated (again). Etot is now calculated externally.

 */
#include <stdio.h>
#include <math.h>
#include "evsubs.h"

particle *missing_p(struct evhead *evh)
{
    double px, py, pz;
    double mtot;
    int i;
    particle *evp;
    
    /*zero momenta etc*/
    px = py = pz = mtot = 0.0;
    
    /*generate particle and fill out event structure*/

    for(i=1; i < evh->n[1]+1 ; i++){
	evp = evh->ev + i;
	px += ev_p_x(evp);
	py += ev_p_y(evp);
	pz += ev_p_z(evp);
	mtot += ev_m(evp);
    }
    
    evp = evh->ev + ++(evh->n[0]);
    evh->n[1]++;
    ev_reset_particle(evp);
    evs_p_xyz(evp, -px, -py, evh->reac->p1 - pz);
    evs_t(evp, 0);
    evs_m(evp, evh->reac->mass[1]+evh->reac->mass[2] - mtot);
    evs_det(evp, 0);
    evs_seg(evp, 0);
    evs_fold(evp, 1);
    evs_q(evp, 0.0);
    evs_hi(evp, 0);
    evs_li(evp, 0);
    
    return evp;
}

int missing_p_(void)
{
    return missing_p(&evhead) - evhead.ev;
}
