/*
 * ''nrhit''      Recalculate N hit dependencies                Steve Chappell
 *
 *   General Subroutine to recalculate all dependencies
 *   in the event array given that the mass originally
 *   associated with a particle has been changed.

 *   Note: Can only recalculate for composite particles if
 *         lower fold changed. It does NOT propogate downwards.

 * Updates
 *   20th Jul 97: 
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "evsubs.h"

void nrhit(double newmass, particle *vrp)
{
    char *flag;
    particle *evp, *last;
    struct evhead *evh = vrp->head;

    /*recalculate for vrp*/
    if(ev_fold(vrp) == 1)
	evs_m(vrp, newmass);
    else
	rp(vrp, ev_hi(vrp), ev_li(vrp));

    if ((flag = (char *) calloc(evh->n[0]+1, 1)) != NULL)
    {
	flag[vrp-evh->ev] = 1;
	/*Check dependencies and recalculate for other particles*/
	for(evp = vrp, last = evh->ev+evh->n[0]; evp <= last; evp++)
	{
	    if (flag[ev_li(evp) - evh->ev] || flag[ev_hi(evp) - evh->ev])
	    {
		rp(evp, ev_hi(evp), ev_li(evp));
		flag[evp-evh->ev] = 1;
	    }
	}
	free(flag);
    }
    else /* We resort to a slower version */
    {
	for(evp = vrp, last = evh->ev+evh->n[0]; evp <= last; evp++)
	{
	    if (ev_hi(evp) == vrp)
		nrhit(0.0, ev_hi(vrp));
	    if (ev_li(evp) == vrp)
		nrhit(0.0, ev_li(vrp));
	}
    }
}
