/*
 * "plot_spec"      Spectrum plotting routines                 Steve Chappell
 *
 * Updates
 *   15th Oct 98
 */

#include <stdlib.h>
#include <stdio.h>
#include "evsubs.h"
#include "hitsubs.h"
#include "sunsort_initadc.h"

/*plot channel spectra*/

static int cal, shift1d, plota, plott;
static int last_type = -1;

#define LIST_LEN 64

/* Faster iterative method that will only plot the full experiment tree */
static void plot_chanspecs_full(struct detectors *dp, int sp2_channsa,
				int sp2_channst)
{
    int chan;
    struct spec2d_list alist[LIST_LEN], *ap = alist;
    struct spec2d_list tlist[LIST_LEN], *tp = tlist;
    /*
     * Take a local copy of the settings so the compiler knows they can't
     * alter during the loop
     */
    int r_cal = cal, r_shift1d = shift1d, r_plota = plota, r_plott = plott;

    /* We can guarantee that dp is not NULL on entry */

    do {
	chan = dp->adcnum;
	if (chan > 384){
	    int chanval;

	    if(r_cal)
		chanval=dp->value;
	    else
		chanval=ADC(chan);
	    
	    chan -= 384;
	    if (((char *) tp - ((char *) tlist + sizeof(tlist))) == 0)
	    {
		inc2d_list(sp2_channst, tlist, LIST_LEN);
		tp = tlist;
	    }
	    tp->x = (chanval + 4)>>3;
	    tp++->y = chan;
	    if(r_plott) 
		inc1d(chan, (chanval>>r_shift1d) + (r_plota) ? 4096 : 0);
	}
	else if (chan > 0){
	    int chanval;

	    if(r_cal)
		chanval=dp->value;
	    else
		chanval=ADC(chan);
	    
	    if (((char *) ap - ((char *) alist + sizeof(tlist))) == 0)
	    {
		inc2d_list(sp2_channsa, alist, LIST_LEN);
		ap = alist;
	    }
	    ap->x = (chanval + 16)>>5;
	    ap++->y = chan;
	    if(r_plota) 
		inc1d(chan, chanval>>r_shift1d);
	}

	if (dp->hitlist.head != NULL)
	    dp = dp->hitlist.head;
	else
	{
	    struct detectors *tmp;

	    while (dp && (tmp = dp, dp = dp->hitlist.next) == NULL)
		dp = tmp->parent;
	}
    } while(dp != NULL);

    if (tp > tlist)
	inc2d_list(sp2_channst, tlist, tp - tlist);
    if (ap > alist)
	inc2d_list(sp2_channsa, alist, ap - alist);
}

/* Slower recursive method that will plot any part of the experiment tree */
static void plot_chanspecs_partial(struct detectors *dp, int sp2_channsa,
				   int sp2_channst)
{
    int sp2, chan, chanval, sig, rnd2d, offset, shift2d, plot1d;

    /* We can guarantee that dp is not NULL on entry */

    do {
	sig = 0;
	offset = 0;
	if (dp->adcnum > 384){
	    sig = 1;
	    sp2 = sp2_channst;
	    shift2d = 3;
	    rnd2d = 4;
	    chan=dp->adcnum - 384;
	    plot1d = plott;
	    if (plota)
		offset = 4096;
	}
	else if (dp->adcnum > 0){
	    sig = 1;
	    sp2 = sp2_channsa;
	    shift2d = 5;
	    rnd2d = 16;
	    chan=dp->adcnum;
	    plot1d = plota;
	}
	if(sig){
	    if(cal)
		chanval=dp->value;
	    else
		chanval=ADC(dp->adcnum);
	    
	    inc2d(sp2, (chanval + rnd2d)>>shift2d, chan);
	    if(plot1d) 
		inc1d(chan, (chanval>>shift1d) + offset);
	}
	
	if (dp->hitlist.head != NULL)
	    plot_chanspecs_partial(dp->hitlist.head, sp2_channsa, sp2_channst);
	dp = dp->hitlist.next;
    } while(dp != NULL);
}

/* Calculate fixed values and choose appropriate routine */

void plot_chanspecs(int plot_type, struct detectors *dp, 
		    int sp2_channsa, int sp2_channst)
{
    if (dp == NULL)
	return;

    if (plot_type != last_type)
    {
	shift1d = 0;
	plota = 0;
	plott = 0;
	
	switch(plot_type)
	{
	case PLOT_2D:
	    cal = 0;
	    break;
	case PLOT_2DC:
	    cal = 1;
	    break;
	case PLOT_A:
	    cal = 0;
	    plota = 1;
	    break;
	case PLOT_T:
	    cal = 0;
	    plott = 1;
	    break;
	case PLOT_AT:
	    cal = 0;
	    shift1d = 1;
	    plota = 1;
	    plott = 1;
	    break;
	case PLOT_AC:
	    cal = 1;
	    plota = 1;
	    break;
	case PLOT_TC:
	    cal = 1;
	    plott = 1;
	    break;
	case PLOT_ATC:
	    cal = 1;
	    shift1d = 2;
	    plota = 1;
	    plott = 1;
	    break;
	default:
	    fprintf(stderr,"plot_spec: Plot type  %d unknown\n",plot_type);
	    return;
	}
	last_type = plot_type;
    }

    if (dp->parent == NULL)
	plot_chanspecs_full(dp, sp2_channsa, sp2_channst);
    else
	plot_chanspecs_partial(dp, sp2_channsa, sp2_channst);
}

void plot_chanspecs_(int *plot_type, int *sp2_channsa, int *sp2_channst)
{
    plot_chanspecs(*plot_type, expt, *sp2_channsa, *sp2_channst);
}

/*
 * Plot channel hit patterns i.e. Tartan plots
 */
void plot_hits(int sp1_channsat, int sp1_zeroat, int sp2_ahit, int sp2_thit)
{
    short *sp, a;
    static int *ylist = NULL, *yp;

    if (ylist == NULL)
	ylist = (int *) calloc(adcnum_.nos_adcs, sizeof(int));

    yp = ylist;
    for(sp = adclist_.adclist; (a = *sp) != -1; sp++)
    {
	if(ADC(a) > 0)
	{
	    inc1d(sp1_channsat, a);
	    if (a < 385)
		*yp++ = a;
	}
	else
	    inc1d(sp1_zeroat, a);
    }
    *yp = -1;
    inc2d_tartan(sp2_ahit, ylist);
 
    yp = ylist;
    for(sp = adclist_.adclist; (a = *sp) != -1; sp++)
	if(ADC(a) > 0 && a > 384)
	    *yp++ = a - 384;
    *yp = -1;
    inc2d_tartan(sp2_thit, ylist);

    
}

void plot_hits_(int *sp1_channsat, int *sp1_zeroat, int *sp2_ahit,
		int *sp2_thit)
{
    plot_hits(*sp1_channsat, *sp1_zeroat, *sp2_ahit, *sp2_thit);
}


/*
 * Plot channel multiplicities
 */
void plot_cmult(struct evhead *evh, int sp2_cmult)
{
    int i;
    struct spec2d_list mlist[NDET_MAX+1], *mp = mlist;

    if (expt->info->ndetel > NDET_MAX)
    {
	for (i=0; i <= expt->info->ndetel; i++)
	    if (evh->cmult[i] > 0)
		inc2d(sp2_cmult, evh->cmult[i], i);
    }
    else
    {
	for (i=0; i <= expt->info->ndetel; i++)
	    if (evh->cmult[i] > 0)
	    {
		mp->x = evh->cmult[i];
		mp++->y = i;
	    }
	inc2d_list(sp2_cmult, mlist, mp - mlist);
/*
		   ((char*) mp - (char *) mlist)/sizeof(struct spec2d_list));
*/
    }
}

/*
 * Plot particle multiplicities
 */
void plot_pmult(struct evhead *evh, int sp2_pmult)
{
    int i;
    struct spec2d_list mlist[NDET_MAX+1], *mp = mlist;

    if (expt->info->ndetel > NDET_MAX)
    {
	for(i = 0; i <= expt->info->ndetel; i++)
	    if (evh->pmult[i] > 0)
		inc2d(sp2_pmult, evh->pmult[i], i);
    }
    else
    {
	for (i=0; i <= expt->info->ndetel; i++)
	    if (evh->pmult[i] > 0)
	    {
		mp->x = evh->pmult[i];
		mp++->y = i;
	    }
	    inc2d_list(sp2_pmult, mlist, mp - mlist);
    }
}

void plot_cmult_(int *sp2_cmult)
{
    plot_cmult(&evhead, *sp2_cmult);
}

void plot_pmult_(int *sp2_pmult)
{
    plot_pmult(&evhead, *sp2_pmult);
}

