/*
 * ''punchthru''     calculates most likely punchthru hit       Steve Chappell
 *
 *   Calculates missing momentum. Then scans event array for particle with 
 *   same trajectory. Recalculates particle parameters incorporating 
 *   punchthru energy. Old particle params saved in next slot of the event array.
 *   Returns NULL if no punchthrough candidate could be found.
 *   Position of original particle given by ev[phit].hi
 
 * Updates
 *   12th Feb 99: Birth
 *   22nd Apr 99: Changed structure in ev to use new vector package
 *                Altered calculation of proximity of two vectors
 */
#include <stdio.h>
#include <math.h>
#include "evsubs.h"

particle *punchthru(struct evhead *evh)
{
    int i;
    double px, py, pz, bestang = 0, b;
    particle *evp, *phit, *save;
#if 0
    double th_diff, phi_diff, th_diff_sav=1000.0, phi_diff_sav=1000.0;
    double pr, pth, pphi;
#endif
    /*zero momenta etc*/
    px = py = pz = 0.0;

    /*generate missing momentum vector*/

    for(evp = evh->ev, i=1; i< evh->n[1]+1 ; i++){
	evp++;
	px += ev_p_x(evp);
	py += ev_p_y(evp);
	pz += ev_p_z(evp);
    }

    px = -px;
    py = -py;
    pz = reac.p1 - pz;
#if 0    
    pr = sqrt(px*px + py*py + pz*pz);
    pth = acos(pz/pr);
    if ((pphi = atan2(py,px)) < 0) 
	pphi += 2*M_PI;

    /*fprintf(stderr,"\n\nth=%f phi=%f\n",pth*DEG,pphi*DEG);*/
    /*selection of possible hit could be improved?*/
    
    for(evp = evh->ev, i=1; i<evh->n[1]+1; i++){
	evp++;
	th_diff = fabs(pth - ev_p_t(evp));
	phi_diff = fabs(pphi - ev_p_p(evp));
	
	if(th_diff < th_diff_sav &&
	   phi_diff <  phi_diff_sav){
	    th_diff_sav = th_diff;
	    phi_diff_sav = phi_diff;
	    phit = evp;
	    /*
	     * fprintf(stderr,"\n\npunchthru: possible hit %d\n",phit-evh->ev);
	     */
	}
    }
#endif

    for(evp = evh->ev, i=1; i<evh->n[1]+1; i++)
    {
	evp++;
	b = (px*ev_p_x(evp) + py*ev_p_y(evp) +
	     pz*ev_p_z(evp))/ev_p_r(evp);
	if (b > bestang)
	{
	    bestang = b;
	    phit = evp;
	}
    }

    /*Save old parameters in next slot of the event array*/
    if ((save = new_chit(phit)) == NULL)
	return NULL;

    /*reminder that this particle is recalculated from hit k*/
    evs_hi(evp, save);
    
    /*recalculate hit parameters by adding back punchthrough energy*/
    
    px += ev_p_x(evp);
    py += ev_p_y(evp);
    pz += ev_p_z(evp);
    evs_p_xyz(evp, px, py, pz);
    fprintf(stderr, "punchthru: ev_e = %f cf. %f\n", ev_e(evp),
	    ev_p_r2(evp)/(2.0*ev_m(evp)));
    evs_q(evp, 0.0);

    return phit;
}

int punchthru_()
{
    particle *p;

    p = punchthru(&evhead);
    return (p == NULL) ? -1 : (p - evhead.ev);
}
