/* reac.h   reaction structure*/

#define REAC_SORT 0  /*Initialisation from sort code*/
#define REAC_SIM  1  /*Initialisation from simulation*/ 

extern struct reac { /*Reaction Parameters also used in fortran common block*/
    double edisp;     /*energy dispersion*/
    double e1;        /*beam energy*/
    double p1;        /*beam momentum*/ 
    double mass[/*5*/13];
    double q1;        /*reaction q value*/
    double vcm;       /*c.o.m. velocity*/
} reac;

int reac_init(int);  /*reaction definition*/

double reac_edisp(void);
void reacs_edisp(double);

double reac_e1(void);
void reacs_e1(double);

double reac_mass(int);
void reacs_mass(int, double);


