/*
 * ''rp''      Resonant Particle                           Steve Chappell
 *
 *   General Subroutine to reconstruct a resonant particle
 *   from two breakup fragments given the particle positions
 *   in the event array...
 *   rp* -> Heavy Ion (hi) + Light Ion (li)

 * Updates
 *   17th Dec 97: Angles in positive range 0->360
 *   6th Jul 98: q calc now independent of daughter grouping into hi and li
 *
 */

#include <stdio.h>
#include <math.h>
#include "evsubs.h"

particle *rp(particle *vrp, particle *hi, particle *li)
{
    ev_reset_particle(vrp);
    evs_hi(vrp, hi);
    evs_li(vrp, li);
    evs_fold(vrp, ev_fold(hi)+ev_fold(li));
    evs_t(vrp, 0.0);
    evs_det(vrp, 0);
    evs_seg(vrp, 0);
    evs_m(vrp, ev_m(hi)+ev_m(li));
    vector_add(ev_pvec(vrp), ev_pvec(hi), ev_pvec(li));
    evs_p_set(vrp); /* Inform event-struct code that we've changed p behind its
		       back */

    if(ev_fold(li) < 2)
	evs_etot(li, ev_e(li));
    if(ev_fold(hi) < 2)
	evs_etot(hi, ev_e(hi));

    evs_etot(vrp, ev_etot(hi) + ev_etot(li));
    evs_q(vrp, ev_etot(vrp) - ev_e(vrp));

    return vrp;
}

void rp_(int *vrp, int *hi, int *li)
{
    rp(evhead.ev+*vrp, evhead.ev+*hi, evhead.ev+*li);
}

particle *new_rp(particle *hi, particle *li)
{
    int n;
    particle *vrp;
    struct evhead *evh = hi->head;

    if (evh != li->head)
    {
	fprintf(stderr, "new_rp: Unable to combine particles from different "
		"arrays.\n");
	return NULL;
    }

    n = ++evh->n[0];
    if(n > evh->numparticles)
    {
	fprintf(stderr,"new_rp: Error ev[%d] > MAX(%d)!\n", n,
		evh->numparticles);
	return NULL;
    }

    vrp = evh->ev + n;

    rp(vrp, hi, li);
    return vrp;
}

int new_rp_(int *hi, int *li)
{
    return new_rp(evhead.ev+*hi, evhead.ev+*li) - evhead.ev;
}

    
