/* 
 * ''energy loss''   Energy loss calculation for scanga         Steve Chappell
 *
 *   Code below only checked for alphas
 *   evsim[i].e is energy before passage through medium
*/ 

#include <stdio.h>
#include <math.h>
#include "../evsubs.h"
#define C     15.7
#define N     1.67


double scanga_energy_loss(int i)
{

    double powm,a,de,range_e,range_after,e_after;
    particle *part;

    part = evsim + i;

    powm=pow(ev_m(part),N-1);
    range_e = C * pow(ev_e(part),N) /
	(ev_z(part)*ev_z(part)*powm);
    if(range_e > sim.det_thickness[ev_det(part)]){
	range_after = range_e - sim.det_thickness[ev_det(part)];
	a = range_after*ev_z(part)*ev_z(part)*powm/C;
	e_after =  pow(a,(1.0/N));
	de = ev_e(part) - e_after;
    }
    else
	de = ev_e(part);

    return (de);
}
