/*
 * Input file reader for scanga
 */
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "../evsubs.h"

int scanga_input(char *filename)
{
    FILE  *fp;
    char  buf[SUBS_BUFSIZE];
    char det_type,det_sims,det_covs,random_s;
    char *p, *q;
    double distabs,radabs;
    int i,j,k,det_num, coinc, bkup, hi, li, a, z, max_j;
    double mass, ex, w, qb, m1, m2, m3, m4;
    particle *evp, *evhi, *evli;
    /*initialise*/
    sim.thabs=0;
    sim.ndet=0;
    
    /*open the input file*/
    if(filename == NULL){
	fprintf(stderr, "Scanga: Enter name of input file: " );
	if(scanf("%s",buf) != 1)
	    fprintf(stderr, "Scanga: Error reading name of input file\n");
	filename = buf;
    }
    if ((fp = fopen(filename, "r")) != NULL){
	fprintf(stderr, "Scanga: Using input file \"%s\".\n",filename);
    }
    else{	    
	fprintf(stderr, "Scanga: Error! could not open \"%s\".\n", filename);
	return ABORT;
    }


    /*Process Input file.......................*/
   
    /*Randomise order of Pseudodata in ev array?*/
    MYGETLINE(buf, SUBS_BUFSIZE, fp, 
	      "Scanga: End of file reading random order flag", ABORT)
    if(sscanf(buf, " %c", &random_s) !=1){
	fprintf(stderr,"Scanga: Error! Expected Y/N "
		"for Random Order?\n"
		"got \"%s\"\n",buf);
	return ABORT;
    }
    switch(random_s){
    case 'y':
    case 'Y':
	sim.random=1;
	break;
    case 'n':
    case 'N':
	sim.random=0;
	break;
    default:
	fprintf(stderr,"Scanga: Error reading random order flag\n");
	return ABORT;
    }
    
    /*Simulate the detection of particles?*/    
    MYGETLINE(buf, SUBS_BUFSIZE, fp, 
	      "Scanga: End of file reading detection system flag", ABORT)
    if(sscanf(buf, " %c", &det_sims) !=1){
	fprintf(stderr,"Scanga: Error! Expected Y/N/T "
		"for Simulate detection system?\n"
		"got \"%s\"\n",buf);	
	return ABORT;
    }
    switch(det_sims){
    case 'c':
    case 'C':
	sim.det_sim=1;
	sim.det_t_sim=0;
	sim.det_pthru=1;
	fprintf(stderr,
		"Scanga: Complete detection simulation\n");
	break;
    case 'y':
    case 'Y':
	sim.det_sim=1;
	sim.det_t_sim=0;
	sim.det_pthru=0;
	fprintf(stderr,
		"Scanga: Simulating angle coverage + low E thresholds only\n");
	break;
    case 'n':
    case 'N':
	sim.det_sim=0;
	sim.det_t_sim=0;
	sim.det_pthru=0;
	fprintf(stderr, "Scanga: Simulating kinematics only.\n");
	break;
    case 't':
    case 'T':
	sim.det_sim=0;
	sim.det_t_sim=1;
	sim.det_pthru=0;
	sim.ndet=1;
	fprintf(stderr,
		"Scanga: Simulating low E thresholds only\n");
	break;
    case 'p':
    case 'P':
	sim.det_sim=0;
	sim.det_t_sim=1;
	sim.det_pthru=1;
	sim.ndet=1;
	fprintf(stderr,
		"Scanga: Simulating low E thresholds + punchthru calc only\n");
       	break;
    default:
	fprintf(stderr,"Scanga: Error reading detection system flag\n");
	return ABORT;
    }


    /*Detection System*/    
    if(sim.det_sim){
	fprintf(stderr, "Scanga: Defining Detection System:\n");

	if(coord_init(NDET_MAX) != 0){  /*initialise detector coordinates*/
	    fprintf(stderr, "Scanga: Error initialising Co-ordinates\n");
	    return ABORT;
	}
	
	while(strncmp(buf, "DETSYS",6)){
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		      "Scanga: Can't find DETSYS line.\n" , ABORT)
	}	
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "Scanga: End of file reading coverage flag.\n" , ABORT)
	if(sscanf(buf, " %c", &det_covs) !=1){
	    fprintf(stderr,"Scanga: Error! Expected Y/N "
		    "for Generate coverage?\n"
		    "got \"%s\"\n",buf);	
	    return ABORT;
	}
	switch(det_covs){
	case 'y':
	case 'Y':
	    sim.cov=1;
	    break;
	default:
	    sim.cov=0;
	}
	
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "Scanga: End of file reading Eres.\n", ABORT)
	if(sscanf(buf, " %lf", &sim.eres) !=1){
	  fprintf(stderr,"Scanga: Error! Expected Eres\n"
		  "got \"%s\"\n",buf);	
	  return ABORT;
	}
	else
	  fprintf(stderr, "Scanga: Smearing particle Energies "
		  "by %lf MeV\n",sim.eres);
	
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "Scanga: End of file reading Pres.\n", ABORT)
	if(sscanf(buf, " %lf %lf", &sim.pres_x, &sim.pres_y) !=2){
	  fprintf(stderr,"Scanga: Error! Expected Pres\n"
		  "got \"%s\"\n",buf);	
	  return ABORT;
	}
	else
	  fprintf(stderr, "Scanga: Smearing detector hit positions "
		  "by %lf (x), %lf (y) (as fraction)\n\n",
		  sim.pres_x,sim.pres_y);

	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "Scanga: No REAC section in file.\n", ABORT)
	while(strncmp(buf, "REAC",4)){
	    if(sscanf(buf, " %c %d", &det_type, &det_num) !=2){
		switch(det_type){
		case 'M':
		    break;
		case 'S':
		    break;
		case 'R':
		    break;
		default:
		    fprintf(stderr,"Scanga: Error! Expected Array M/S or"
			    " detector type and number\n"
			    "got \"%s\"\n",buf);
		    return ABORT;
		}
	    }
	    
	    switch(det_type){
	    case 'a':
		fprintf(stderr, "Scanga: %d (a)ncillary detectors\n",det_num);
		for(i=1; i<det_num+1; i++){
		    sim.det_type[++sim.ndet]=DTYPE_a;
		    if(coord_andet(sim.ndet,fp) !=0)
			return ABORT;
		}
		break;
	    case 'm':
		fprintf(stderr, "Scanga: %d Megha (m)odules\n",det_num);
		break;
	    case 's':
		fprintf(stderr, "Scanga: %d (s)trip detectors\n",det_num);
		break;
	    case 'p':
		fprintf(stderr, "Scanga: %d (p)sd detectors\n",det_num);
		break;
	    case 'M':
		fprintf(stderr, "Scanga: (M)EGHA\n");
		break;
	    case 'S':
		fprintf(stderr, "Scanga: (S)trip Array with %d detectors\n",
			det_num);
		for(i=1 ; i<det_num+1; i++){
		    sim.det_type[++sim.ndet]=DTYPE_S;
		    if(coord_det(sim.ndet,fp) !=0)
			return ABORT;
		}
		break;
	    case 'R':
		fprintf(stderr, "Scanga: circular absorbe(R) "
			"around beam axis\n");
		MYGETLINE(buf, SUBS_BUFSIZE, fp,
			  "Scanga: End of file reading distabs radabs.\n", 
			  ABORT)
		if( sscanf(buf, " %lf %lf", &distabs,&radabs) !=2){
		    fprintf(stderr,"Error! Expected "
			    "'distabs radabs'\n"
			    "got \"%s\".\n", buf);
		    return ABORT;
		}
		else{
		    sim.thabs=(atan(radabs/distabs))/RAD;	
		}	    
		break;
	    default:
		fprintf(stderr,"Scanga: Error! Expected 'a/m/s/p/M/S'\n"
			" got \"%c\".\n", det_type);
		return ABORT;
	    }
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		      "Scanga: No REAC section in file.\n", ABORT)
	}
	fprintf(stderr,"Scanga: Total of %d Detectors defined\n",sim.ndet);

    }
    
    
    /*Reaction*/
    while(strncmp(buf, "REAC",4)){
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "Scanga: No REAC section in file.\n", ABORT)
    }
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "Scanga: End of file reading beam target e1.\n", ABORT)
    if( sscanf(buf, " %n%*s %n%*s %lf", &i, &j, &sim.e1) !=1){
	fprintf(stderr,"Scanga: Error! Expected "
		"'beam target e1'\n"
		"got \"%s\".\n", buf);
	return ABORT;
    }
    nucleus_az(&a, &z, buf+i);
    if (a < 0)
    {
	fprintf(stderr, "Scanga: Can't identify first nucleus in line:\n"
		"\"%s\".\n", buf);
	return ABORT;
    }
    evs_m(evsim+1, a);
    evs_z(evsim+1, z);
    nucleus_az(&a, &z, buf+j);
    if (a < 0)
    {
	fprintf(stderr, "Scanga: Can't identify second nucleus in line:\n"
		"\"%s\".\n", buf);
	return ABORT;
    }
    evs_m(evsim+2, a);
    evs_z(evsim+2, z);
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "Scanga: End of file reading number of particles "
	      "in reaction'.\n",ABORT)
    if(sscanf(buf, " %d", &sim.np) !=1){
	fprintf(stderr,"Scanga: Error! Expected numb_particles' value\n"
		"got \"%s\"\n",buf);
	return ABORT;
    }

    max_j = 0;
    for(i=0; i<sim.np; i++){
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "Scanga: End of file reading m ex w bkup .....\n", ABORT)
	if( sscanf(buf, " %d %n%*s %lf %lf %d %d %d %d",&j,&k,&ex,&w,&coinc,
		   &bkup,&hi,&li)!=7){
	    fprintf(stderr,"Scanga: Error! Expected "
		    "'particle_number nucleus ex w bkup coinc hi li'\ngot "
		    "\"%s\".\n",buf);
	    return ABORT;
	}
	if(sim.np > SIM_NPMAX-1 || j > SIM_NPMAX-1 || 
	   hi  > SIM_NPMAX-1  ||  li> SIM_NPMAX-1 ){
	    fprintf(stderr,"Scanga: Can only do simulation for "
		    "<= %d particles\n",
		    SIM_NPMAX-1);
	    return ABORT;
	}
	nucleus_az(&a, &z, buf+k);
	if (a < 0)
	{
	    fprintf(stderr, "Scanga: Can't identify nucleus in line:\n"
		    "\"%s\".\n", buf);
	    return ABORT;
	}
	if (j > max_j)
	    max_j = j;
	evp = evsim+j;
	evs_m(evp, a);
	evs_z(evp, z);
	sim.ex[j] = ex;
	sim.w[j] = w;
	sim.coinc[j] = coinc;
	sim.bkup[j] = bkup;
	evs_hi(evp, evsim+hi);
	evs_li(evp, evsim+li);
    }

    if ((m1 = getmass_az((int) (ev_m(evsim+1)+0.5), ev_z(evsim+1)))
	< UNKNOWNMASS)
	return ABORT;
    if ((m2 = getmass_az((int) (ev_m(evsim+2)+0.5), ev_z(evsim+2)))
	< UNKNOWNMASS)
	return ABORT;
    if ((m3 = getmass_az((int) (ev_m(evsim+3)+0.5), ev_z(evsim+3)))
	< UNKNOWNMASS)
	return ABORT;
    if ((m4 = getmass_az((int) (ev_m(evsim+4)+0.5), ev_z(evsim+4)))
	< UNKNOWNMASS)
	return ABORT;
    
    sim.q1 = m1+m2-m3-m4;

    for(j=3; j <= max_j; j++)
    {
	evp = evsim+j;
	if (ev_m(evp) <= 0)
	    continue;
	if ((m1 = getmass_az((int) (ev_m(evp)+0.5), ev_z(evp)))
	    < UNKNOWNMASS)
	    return ABORT;
/*	evs_m(evp, ev_m(evp) + m1); */
	if (sim.bkup[j])
	{
	    evhi = ev_hi(evp);
	    evli = ev_li(evp);
	    if ((m2 = getmass_az((int) (ev_m(evhi)+0.5), ev_z(evhi)))
		< UNKNOWNMASS)
		return ABORT;
	    if ((m3 = getmass_az((int) (ev_m(evli)+0.5), ev_z(evli)))
		< UNKNOWNMASS)
		return ABORT;
	    sim.qb[j] = m1-m2-m3;
	}
    }


    /*Breakup simulation*/
    MYGETLINE(buf, SUBS_BUFSIZE, fp,
	      "Scanga: End of file reading breakup simulation type.\n", ABORT)
    if(sscanf(buf, " %c", &sim.bkup_coords) !=1){
	fprintf(stderr,"Scanga: Error! Expected Bkup coords\n"
		"got \"%s\"\n",buf);
	return ABORT;
    }
    switch(sim.bkup_coords){
    case 'b':
	fprintf(stderr, "Scanga: Simulating breakup "
		"over Basel Coordinates:\n");
	MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "Scanga: End of file reading breakup simulation Nl'.\n",
		  ABORT)
	if(sscanf(buf, " %d %d %d", &sim.b_nl) !=1){
	    fprintf(stderr,"Scanga: Error! Expected Nl' value\n"
		    "got \"%s\"\n",buf);
	    return ABORT;
	}
	fprintf(stderr,"Scanga: Nl'=%d\n",sim.b_nl);
        for(i=0;i<sim.b_nl;i++){
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		  "Scanga: End of file reading " 
		      "breakup simulation a_l',l'....\n",ABORT)
	    if(sscanf(buf, " %lf %d %d %d", 
		      &sim.b_al[i], &sim.b_l[i],
		      &sim.b_k[i], &sim.b_kp[i]) !=4){
		fprintf(stderr,"Scanga: Error! Expected "
			"al', l', k, k' values\n"
			"got \"%s\"\n",buf);
		return ABORT;
	    }
	    fprintf(stderr,"Scanga: al'=%lf l'=%d k=%d  k'=%d\n",
		    sim.b_al[i],sim.b_l[i],sim.b_k[i],sim.b_kp[i]);	
	}
      	break;
    default:
	fprintf(stderr, "Scanga: Simulating Structureless"
		" Isotropic breakup\n");
    }
    
    
    if(sim.det_sim || sim.det_t_sim){
	/*Hit patterns and low energy thresholds*/
	while(strncmp(buf, "HITPAT",6)){
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		      "Scanga: No HITPAT section in file.\n", ABORT)
	}	
	for(i=1; i<sim.ndet+1; i++){
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		      "Scanga: End of file reading hitpat 3-N.\n", ABORT)
	    for(p=buf, k=3; k<sim.np+3; k++, p=q){
		sim.hitpat[i][k] = strtod(p, &q);
		if(q==p)
		{
		    fprintf(stderr,"Scanga: Error! reading "
			    "'hitpat'\ngot \"%s\".\n", buf);
		    return ABORT;
		}
	    }
	}
	
	/*Inputs for punchthru calculation*/
	if(sim.det_pthru){
	    while(strncmp(buf, "PTHRU",5)){
		MYGETLINE(buf, SUBS_BUFSIZE, fp, 
			  "Scanga: No PTHRU section in file.\n", ABORT);
	    }    
	    MYGETLINE(buf, SUBS_BUFSIZE, fp,
		      "Scanga: End of file reading thickness.\n", ABORT)
	    for(p=buf, i=1; i<sim.ndet+1; i++, p=q){
		sim.det_thickness[i] = strtod(p, &q);
		if(q==p)
		{
		    fprintf(stderr,"Scanga: Error! reading "
			    "'thickness'\ngot \"%s\".\n", buf);
		    return ABORT;
		}
	    }
	}
	
	
    }
    
    fclose(fp);
    /* End of Inputs */
    
    
    return OK;   
}

