/* sim.h   Simulation routine Declarations */

#define SIM_NPMAX 13 /*Max Number of particles+1 in simulation*/

/*Detector Types*/
#define DTYPE_S 1 /*Detector in the (S)trip Array*/
#define DTYPE_a 2 /*(a)ncillary detector*/

extern particle *evsim;

extern struct sim{         /*Simulation inputs structure*/
  double q1;
  double e1;
  double ex[SIM_NPMAX];
  double w[SIM_NPMAX];
  double qb[SIM_NPMAX];
  int  bkup[SIM_NPMAX];
  double  effmin,effmax,effstep;
  int np;
  int effcalc;
  double effvar;
  char bkup_coords;
  int b_nl,b_l[10],b_k[10],b_kp[10];    /*basel l and k values for simulation*/
  double b_al[10];
  /*detector stuff*/
  double eres;
  double pres_x;
  double pres_y;
  int det_sim;
  int det_t_sim;
  int det_pthru;
  int random;
  int cov;
  int ndet;
  int det_type[NDET_MAX+1];
  double thabs;
  int fstate[SIM_NPMAX];
  int coinc[SIM_NPMAX],hit[SIM_NPMAX];
  double hitpat[NDET_MAX+1][SIM_NPMAX];
  double det_thickness[NDET_MAX+1];
} sim;


int evsim_init(int);                    /*Simulated event structure init*/
int scanga_init(char *);                /*Scanga simulation init*/
int scanga_kin_init(void);              /*Scanga simulation kin init*/
int scanga_event(void);                 /*Scanga simulation event*/
int scanga_finish(void);                /*Scanga simulation finish*/
int scanga_input(char *);               /*input file reader for scanga*/
int wrt_evsim(int, FILE *);             /*writes simulated event to file*/
int read_evsim(void);                   /*reads simulated event from file*/
double grand(double, double);            /*gaussian random number generator*/
int read_scanga_args(int, char **);     /*read Scanga command line args*/
double scanga_energy_loss(int);          /*energy loss calc for punchthru*/
