/*
 * This file was generated by `gxv' from `sort_gui.G'.
 * last mod 27/3/95
 * last mod by spgc 6 Aug 96
 */

#include <stdio.h>

#include <sys/param.h>
#include <sys/types.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/svrimage.h>

#include "sort_def.h"
#include "sort_thread.h"
#include "gui_alerts.h"
#include "gui_main.h"
#include "gui_ui_main.h"
#include "gui_filtpop.h"
#include "gui_extern.h"

Xv_opaque sort_gui_filt_popup_filt_create P((Xv_opaque));
Xv_opaque sort_gui_filt_popup_control_filt_create P((Xv_opaque));
Xv_opaque sort_gui_filt_popup_filt_setting1_create P((Xv_opaque));
Xv_opaque sort_gui_filt_popup_filt_setting2_create P((Xv_opaque));
Xv_opaque sort_gui_filt_popup_filt_tf1_create P((Xv_opaque));
Xv_opaque sort_gui_filt_popup_filt_tf2_create P((Xv_opaque));
Xv_opaque sort_gui_filt_popup_filt_b1_create P((Xv_opaque));
Xv_opaque sort_gui_filt_popup_filt_b2_create P((Xv_opaque));
Xv_opaque sort_gui_filt_popup_filt_b3_create P((Xv_opaque));
Xv_opaque sort_gui_filt_popup_filt_message_create P((Xv_opaque));

/*
 * Initialize an instance of object `filt_popup'.
 */
sort_gui_filt_popup_objects *
sort_gui_filt_popup_objects_initialize
#if NeedFunctionPrototype
(sort_gui_filt_popup_objects *ip, Xv_opaque owner)
#else
(ip, owner)
sort_gui_filt_popup_objects *ip;
Xv_opaque owner;
#endif
{
    static unsigned short	window64_bits[] = {
#include "./icons/64/write.icon"
    };
    static unsigned short mask64_bits[] = {
#include "./icons/64/write_mask.icon"
    };
    static unsigned short	window48_bits[] = {
#include "./icons/48/write.icon"
    };
    static unsigned short mask48_bits[] = {
#include "./icons/48/write_mask.icon"
    };

    extern void filt_b1_nh P((Panel_item, Event *));
    extern void filt_b2_nh P((Panel_item, Event *));
    extern void filt_b3_nh P((Panel_item, Event *));
      
    int x, isize;

    if (ip)
	return ip;

    if (!(ip = (sort_gui_filt_popup_objects *)
	  calloc(1, sizeof (sort_gui_filt_popup_objects))))
	return (sort_gui_filt_popup_objects *) NULL;
    ip->filt_popup = 
	xv_create(owner, FRAME,
		  XV_WIDTH, 100,
		  XV_HEIGHT, 100,
		  XV_LABEL, "SunSort Filtering",
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  NULL);
    isize = getIconSize(ip->filt_popup);
    xv_set(ip->filt_popup, 
	   FRAME_ICON,
	   xv_create(XV_NULL, ICON,
		     ICON_IMAGE,
		     xv_create(XV_NULL,
			       SERVER_IMAGE,
			       SERVER_IMAGE_BITS,
			       (isize == 64) ? window64_bits : window48_bits,
			       SERVER_IMAGE_DEPTH, 1,
			       XV_WIDTH, isize,
			       XV_HEIGHT, isize,
			       NULL),
		     ICON_MASK_IMAGE,
		     xv_create(XV_NULL, SERVER_IMAGE,
			       SERVER_IMAGE_BITS,
			       (isize == 64) ? mask64_bits : mask48_bits,
			       XV_WIDTH, isize,
			       XV_HEIGHT, isize,
			       NULL),
		     ICON_TRANSPARENT, TRUE, 
		     NULL),
	   NULL);

    ip->control_filt = 
	xv_create(ip->filt_popup, PANEL,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  NULL);
    ip->filt_setting1 = 
	xv_create(ip->control_filt, PANEL_CHOICE,
		  XV_X, 10,
		  XV_Y, 10,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_CHOICE_NROWS, 1,
		  PANEL_VALUE, 0x1,
		  PANEL_LABEL_STRING, "Write Media:",
		  PANEL_CHOICE_STRINGS, "Exabyte", "Disk", NULL,
		  NULL);
    ip->filt_setting2 = 
	xv_create(ip->control_filt, PANEL_CHOICE_STACK,
		  XV_X, NEXT_COL(ip->filt_setting1),
		  XV_Y, 10,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LABEL_STRING, "Drive:",
		  PANEL_CHOICE_STRINGS,
		  "rst0", "rst1", "rst2", "rst3", "rst4", "rst5", NULL,
		  NULL);
    ip->filt_tf1 = 
	xv_create(ip->control_filt, PANEL_TEXT,
		  XV_Y, NEXT_ROW(ip->filt_setting1),
		  PANEL_LABEL_STRING, "Write file:",
		  PANEL_VALUE_X, x = xv_get(ip->filt_setting1, PANEL_VALUE_X),
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE_DISPLAY_LENGTH, 32,
		  PANEL_VALUE_STORED_LENGTH, 132,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->filt_tf2 = 
	xv_create(ip->control_filt, PANEL_TEXT,
		  XV_Y, NEXT_ROW(ip->filt_tf1),
		  PANEL_LABEL_STRING, "Write vol:",
		  PANEL_VALUE_X, x,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE_DISPLAY_LENGTH, 32,
		  PANEL_VALUE_STORED_LENGTH, 132,
		  PANEL_READ_ONLY, FALSE,
		  NULL);
    ip->filt_b1 = 
	xv_create(ip->control_filt, PANEL_BUTTON,
		  XV_X, 10,
		  XV_Y, x = NEXT_ROW(ip->filt_tf2),
		  PANEL_LABEL_WIDTH, 50,
		  XV_WIDTH, 50,
		  XV_HEIGHT, 19,
		  PANEL_LABEL_STRING, "Open",
		  PANEL_NOTIFY_PROC, filt_b1_nh,
		  NULL);
    ip->filt_b2 = 
	xv_create(ip->control_filt, PANEL_BUTTON,
		  XV_X, NEXT_COL(ip->filt_b1),
		  XV_Y, x,
		  PANEL_INACTIVE, FALSE,
		  PANEL_LABEL_STRING, "Mount",
		  PANEL_NOTIFY_PROC, filt_b2_nh,
		  NULL);
    ip->filt_b3 = 
	xv_create(ip->control_filt, PANEL_BUTTON,
		  XV_X, NEXT_COL(ip->filt_b2),
		  XV_Y, x,
		  PANEL_INACTIVE, FALSE,
		  PANEL_LABEL_STRING, "NewVol",
		  PANEL_NOTIFY_PROC, filt_b3_nh,
		  NULL);
    ip->filt_message = 
	xv_create(ip->control_filt, PANEL_MESSAGE,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->filt_b3),
		  PANEL_LABEL_STRING, "State:",
		  PANEL_LABEL_BOLD, TRUE,
		  NULL);

    x = (int) xv_get(ip->filt_tf1, XV_X) +
	(int) xv_get(ip->filt_tf1, XV_WIDTH);

    xv_set(ip->filt_setting2, XV_X,
	   x - (int) xv_get(ip->filt_setting2, XV_WIDTH), NULL);
    
    xv_set(ip->filt_b2, XV_X, (int) xv_get(ip->filt_tf1, XV_X) +
	   ((int) xv_get(ip->filt_tf1, XV_WIDTH) -
	   (int) xv_get(ip->filt_b3, XV_WIDTH))/2, NULL);

    xv_set(ip->filt_b3, XV_X,
	   x - (int) xv_get(ip->filt_b3, XV_WIDTH), NULL);

    window_fit(ip->control_filt);
    window_fit(ip->filt_popup);

    return ip;
}


int
open_write_file(
#if NeedFunctionPrototype
		sort_IO_t *ptr)
#else
				ptr)
      sort_IO_t *ptr;
#endif
{
      char 	*write_file;
      int       write_media;
      
/*	get data from screen to perform open command */
      write_file = (char *) xv_get(sort_gui_filt_popup->filt_tf1,PANEL_VALUE);
      write_file = rm_leading_blanks(write_file,MED_SUNSORT_BUFFER);
      if (strlen(write_file) == 0) {
	    errwin(sort_gui_window1->window1,"No write sort file specified");
	    return(SORT_FALSE);
      }
      write_media = (int) xv_get(sort_gui_filt_popup->filt_setting1,PANEL_VALUE);
      if (write_media == 1) write_media++;   /* DISK_DATA == 2 */
      
      if ( DBX_val >= 6) {
	    fprintf(stderr,"sort_gui: media vaue = %d\n",write_media);
      }
      
/*	open sort file connection for writing data*/
      switch (write_media) {
/*	if exabyte chosen as sort media get details on the drive and volume name */
	  case EXABYTE_DATA:
	    if ( ! (ptr->IO_state & W_TAPE_MOUNTED)) {
		  errwin(sort_gui_window1->window1,"No tape volume mounted!");
		  return(SORT_FALSE);
	    }
	    strcpy(sbuf,"Tape write file open : ");
	    strncat(sbuf,write_file,MED_SUNSORT_BUFFER - strlen(sbuf) -1);
	    strcpy(tmp_str,"wopen tape ");
	    break;
	    
	  case DISK_DATA:
	    strcpy(sbuf,"Disk write file open : ");
	    strncat(sbuf,write_file,MED_SUNSORT_BUFFER - strlen(sbuf) -1);
	    strcpy(tmp_str,"wopen disk ");
	    break;
	    
	  default:
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: Sunsort failed to establish media on OPEN...seek help\n");
	    errwin(sort_gui_window1->window1,"failed to establish media on open");
	    return(SORT_FALSE);
	}
      
/*      communicate with sort server	*/
	    if (DBX_val >= 2) fprintf(stderr,"sort_gui: %s %s\n",tmp_str,write_file);
	    if (talk_to_server(TRUE,tmp_str,write_file,NULL) != 0)
		  return(SORT_FALSE);


/* deactivate certain control panel elements */
	xv_set(sort_gui_filt_popup->filt_setting1,PANEL_INACTIVE,TRUE,NULL); 
	
/* write out message declaring current sort file state */
	xv_set(sort_gui_filt_popup->filt_message,PANEL_LABEL_STRING,sbuf,NULL);

      return(SORT_TRUE);
}

int
close_write_file(
#if NeedFunctionPrototype
		void
#endif
)
{
/*      communicate with sort server	*/
      if (DBX_val >= 6) fprintf(stderr,"sort_gui: close write file");
      if (talk_to_server(TRUE,"wclose",NULL) != 0)
	    return(SORT_FALSE);
      
/* activate certain control panel elements */
	xv_set(sort_gui_filt_popup->filt_setting1,PANEL_INACTIVE,FALSE,NULL); 
      
/* write out message declaring current sort file state */
      xv_set(sort_gui_filt_popup->filt_message,PANEL_LABEL_STRING,"State:",NULL);

      return(SORT_TRUE);
}

int
mount_write_tape(
#if NeedFunctionPrototype
    void
#endif
)
{
      int     write_drive;
      char    *write_vol;

      write_drive = (int) xv_get(sort_gui_filt_popup->filt_setting2,PANEL_VALUE);
      write_vol = (char *) xv_get(sort_gui_filt_popup->filt_tf2,PANEL_VALUE);

      if (strlen(write_vol) == 0) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: no tape volume specified\n");
	    errwin(sort_gui_window1->window1,"no tape volume specified");
	    return(SORT_FALSE);
      }
/* check that Charles hasn't left the name of his last disk file in the text fields */
      if ( strchr(write_vol,'/') != NULL ) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: unexpected write volume name %s for exabyte\n",write_vol);
	    errwin(sort_gui_window1->window1,"unexpected write volume name for exabyte");
	    return(SORT_FALSE);
      }
      write_vol = rm_leading_blanks(write_vol,MED_SUNSORT_BUFFER);
      if ( DBX_val >= 6) fprintf(stderr,
				       "write volume << %s >>\nexabyte drive rst%d\n",write_vol,write_drive);
/* check that user really wants to do this */	    
      sprintf(tmp_str,"mount tape volume %s on drive %d ?",write_vol,write_drive);
      switch( yesno(sort_gui_filt_popup->filt_popup,tmp_str,"yes","no")) {
	  case SORT_FALSE:
	    return(SORT_FALSE);
	  case SORT_TRUE:		
	    default:
	    break;
      }

      sprintf(tmp_str," %s %d ",write_vol,write_drive);
	    
/* communicate with sort server */
      if (talk_to_server(TRUE,"tapemount",tmp_str," w",NULL) != 0)
	    return(SORT_FALSE);
      
      xv_set(sort_gui_filt_popup->filt_b3, PANEL_INACTIVE, TRUE, NULL);
      xv_set(sort_gui_filt_popup->filt_tf2, PANEL_INACTIVE, TRUE, NULL);
      xv_set(sort_gui_filt_popup->filt_setting2 ,PANEL_INACTIVE, TRUE, NULL);
      
      return(SORT_TRUE);
}


int
umount_write_tape(
#if NeedFunctionPrototype
		sort_IO_t *ptr)
#else
				ptr)
      sort_IO_t *ptr;
#endif
{
      if (ptr->IO_state & WRITING_TAPE) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: tape write file still open\n");
	    errwin(sort_gui_window1->window1,"exabyte write file still open");
	    return(SORT_FALSE);
      }
	
/* communicate with sort server */
      if (talk_to_server(TRUE,"tapeumount w",NULL) != 0)
	    return(SORT_FALSE);
	    
      xv_set(sort_gui_filt_popup->filt_b3, PANEL_INACTIVE, FALSE, NULL);
      xv_set(sort_gui_filt_popup->filt_tf2, PANEL_INACTIVE, FALSE, NULL);
      xv_set(sort_gui_filt_popup->filt_setting2 ,PANEL_INACTIVE, FALSE, NULL);
      
      return(SORT_TRUE);
}

int
label_write_tape(
#if NeedFunctionPrototype
void
#endif
)
{
      int     write_drive;
      char    *write_vol;

      write_drive = (int) xv_get(sort_gui_filt_popup->filt_setting2,PANEL_VALUE);
      write_vol = (char *) xv_get(sort_gui_filt_popup->filt_tf2,PANEL_VALUE);

      if (strlen(write_vol) == 0) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: no tape volume specified\n");
	    errwin(sort_gui_window1->window1,"no tape volume specified");
	    return(SORT_FALSE);
      }
/* check that Charles hasn't left the name of his last disk file in the text fields */
      if ( strchr(write_vol,'/') != NULL ) {
	    if (DBX_val >= 2)
		  fprintf(stderr,"sort_gui: unexpected write volume name %s for exabyte\n",write_vol);
	    errwin(sort_gui_window1->window1,"unexpected write volume name for exabyte");
	    return(SORT_FALSE);
      }
      write_vol = rm_leading_blanks(write_vol,MED_SUNSORT_BUFFER);
      if ( DBX_val >= 6) fprintf(stderr,
				       "write volume << %s >>\nexabyte drive rst%d\n",write_vol,write_drive);

/* check that user really wants to do this */	    
      sprintf(tmp_str,"label tape as %s on drive %d ?",write_vol,write_drive);
      switch( yesno(sort_gui_filt_popup->filt_popup,tmp_str,"yes","no")) {
	  case SORT_FALSE:
	    return(SORT_FALSE);
	  case SORT_TRUE:		
	    default:
	    break;
      }
	
      sprintf(tmp_str," %s %d ",write_vol,write_drive);
	    
/* communicate with sort server */
      if (talk_to_server(TRUE,"newtape",tmp_str,NULL) != 0)
	    return(SORT_FALSE);
      
      xv_set(sort_gui_filt_popup->filt_b3, PANEL_INACTIVE, TRUE, NULL);
      xv_set(sort_gui_filt_popup->filt_tf2, PANEL_INACTIVE, TRUE, NULL);
      xv_set(sort_gui_filt_popup->filt_setting2 ,PANEL_INACTIVE, TRUE, NULL);

      return(SORT_TRUE);
}

