/*
 * variables popup
 * last mod 
 */
#include <stdio.h>

#include <sys/param.h>
#include <sys/types.h>

#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/svrimage.h>

#include "sort_def.h"
#include "sort_thread.h"
#include "gui_extern.h"
#include "gui_alerts.h"
#include "gui_main.h"
#include "gui_varpop.h"

#include <xview/font.h>
static Xv_Font font;

/*
 * Initialize an instance of object `var_popup'.
 */
sort_gui_var_popup_objects *
sort_gui_var_popup_objects_initialize
#if NeedFunctionPrototype
(sort_gui_var_popup_objects *ip, Xv_opaque owner)
#else
(ip, owner)
sort_gui_var_popup_objects *ip;
Xv_opaque owner;
#endif
{
    extern int var_list_nh P((Panel_item, char *, Xv_opaque, Panel_list_op,
			      Event *));
    extern void var_but_nh P((Panel_item, Event *));
    extern Panel_setting var_eot_nh P((Panel_item, Event *));

    int x;
    Font_string_dims dims;

    if (ip)
	return ip;

    if (!(ip = (sort_gui_var_popup_objects *)
	  calloc(1, sizeof (sort_gui_var_popup_objects))))
	return (sort_gui_var_popup_objects *) NULL;

    ip->var_popup = 
	xv_create(owner, FRAME_CMD,
		  XV_LABEL, "SunSort Variables",
		  XV_WIDTH, 250,
		  XV_HEIGHT, 250,
		  XV_SHOW, FALSE,
		  FRAME_SHOW_FOOTER, FALSE,
		  FRAME_SHOW_RESIZE_CORNER, FALSE,
		  FRAME_CMD_PUSHPIN_IN, TRUE,
		  NULL);
    font = (Xv_Font)
	xv_find(owner, FONT,
		FONT_FAMILY, FONT_FAMILY_DEFAULT_FIXEDWIDTH,
		NULL);
    xv_get(font, FONT_STRING_DIMS, "888 MMMMMMMMMMMM -8.888888e-88", &dims);
	
    ip->controls_vars = 
	xv_create(ip->var_popup,  PANEL,
		  XV_X, 0,
		  XV_Y, 0,
		  XV_WIDTH, WIN_EXTEND_TO_EDGE,
		  XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		  WIN_BORDER, FALSE,
		  NULL);
    ip->var_list = 
	xv_create(ip->controls_vars, PANEL_LIST,
		  XV_X, 10,
		  XV_Y, 10,
		  PANEL_LIST_WIDTH, 0,
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_LIST_DISPLAY_ROWS, 18,
		  PANEL_READ_ONLY, TRUE,
		  PANEL_CHOOSE_ONE, TRUE,
		  PANEL_CHOOSE_NONE, TRUE,
		  PANEL_NOTIFY_PROC, var_list_nh,
		  NULL);
    xv_set(ip->var_list, PANEL_LIST_WIDTH,
	   (int) xv_get(ip->var_list, PANEL_LIST_WIDTH) + dims.width, NULL);
    ip->var_message = 
	xv_create(ip->controls_vars, PANEL_MESSAGE,
		  XV_X, 10,
		  XV_Y, NEXT_ROW(ip->var_list),
		  PANEL_LABEL_STRING, "Variable: #0, Name: nothing",
		  PANEL_LABEL_BOLD, FALSE,
		  NULL);
    ip->var_tf = 
	xv_create(ip->controls_vars, PANEL_TEXT,
		  XV_X, 10,
		  XV_Y, x = NEXT_ROW(ip->var_message),
		  PANEL_LABEL_STRING, "Value: ",
		  PANEL_LAYOUT, PANEL_HORIZONTAL,
		  PANEL_VALUE_DISPLAY_LENGTH, 14,
		  PANEL_VALUE_STORED_LENGTH, 64,
		  PANEL_READ_ONLY, FALSE,
		  PANEL_NOTIFY_LEVEL, PANEL_SPECIFIED,
		  PANEL_NOTIFY_STRING, "\n\r\t",
		  PANEL_NOTIFY_PROC, var_eot_nh,
		  NULL);
    ip->var_but = 
	xv_create(ip->controls_vars, PANEL_BUTTON,
		  XV_X, NEXT_COL(ip->var_tf),
		  XV_Y, x,
		  PANEL_LABEL_STRING, "Modify",
		  PANEL_NOTIFY_PROC, var_but_nh,
		  NULL);

    window_fit(ip->controls_vars);
    window_fit(ip->var_popup);
    xv_set(ip->var_list, PANEL_LIST_WIDTH, -1, NULL);

    return ip;
}

void var_popup_var_list_reset(values)
char **values;
{
    static int len = 0;

    len = list_reset(sort_gui_var_popup->var_list, (Xv_opaque *) values, len);
}

/*
 * Notify callback function for `var_list'. 	"VARIABLES VALUE LIST"
 */
/*ARGSUSED*/
int
var_list_nh(
#if NeedFunctionPrototype
	    Panel_item	        item,
	    char		*string,
	    Xv_opaque	        client_data,
	    Panel_list_op	op,
	    Event		*event)
#else
      item, string, client_data, op, event)
      Panel_item	item;
      char		*string;
      Xv_opaque	        client_data;
      Panel_list_op	op;
      Event		*event;
#endif
{
	char	var_value[SMALL_SUNSORT_BUFFER],
		var_name[SMALL_SUNSORT_BUFFER],
		var_nos[SMALL_SUNSORT_BUFFER];
		
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: var_list_nh: PANEL_LIST_OP_DESELECT: %s\n",string);
		xv_set(sort_gui_var_popup->var_message,PANEL_LABEL_STRING,"",NULL);
		xv_set(sort_gui_var_popup->var_tf,PANEL_VALUE,"",NULL);
		break;

	case PANEL_LIST_OP_SELECT:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: var_list_nh: PANEL_LIST_OP_SELECT: %s\n",string);
/* display selected variable's name number and value */
		if (sscanf(string,"%s %s %s",var_nos,var_name,var_value) != 3) {
			fprintf(stderr,"sort_gui: failed to read variable data correctly\n");
			return XV_OK;
		}
		xv_set(sort_gui_var_popup->var_tf,PANEL_VALUE,var_value,NULL);
		sprintf(sbuf, "Variable: #%s, Name: %s",var_nos,var_name);
		xv_set(sort_gui_var_popup->var_message,PANEL_LABEL_STRING,sbuf,NULL);
		break;

	case PANEL_LIST_OP_VALIDATE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: var_list_nh: PANEL_LIST_OP_VALIDATE: %s\n",string);
		break;

	case PANEL_LIST_OP_DELETE:
		if ( DBX_val >= 6) fprintf(stderr, "sort_gui: var_list_nh: PANEL_LIST_OP_DELETE: %s\n",string);
		break;
	}
	return XV_OK;
}


/*
 * Notify callback function for `var_but'.  	"MODIFY VARIABLE"
 */
/*ARGSUSED*/
void
var_but_nh(
#if NeedFunctionPrototype
	   Panel_item	item,
	   Event	*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
	char		var_name[SMALL_SUNSORT_BUFFER];
	char		*string;
	int		var_nos;
	register int	row;
	float		var_value;
      
	if ( DBX_val >= 6) fputs("sort_gui: var_but_nh\n", stderr);

/* check that a list element has been selected and if so record its row number */
  	row = (int) xv_get(sort_gui_var_popup->var_list,PANEL_LIST_FIRST_SELECTED);	
	if (row == -1) {
		if (DBX_val >= 1)
		      fprintf(stderr,"sort: no variable selected from list\n");
		errwin(sort_gui_var_popup->var_popup,"no variable selected from list");
		return;
	}

/* get variable number and name from message string */
	string = (char *) xv_get(sort_gui_var_popup->var_message,PANEL_LABEL_STRING);
	if (sscanf(string,"Variable: #%d, Name: %s",&var_nos,var_name) != 2) {
	      if (DBX_val >= 1) {
		    fprintf(stderr,"no variable selected from list or\n");
		    fprintf(stderr,"error in reading variable contents from list\n");
	      }
	      errwin(sort_gui_var_popup->var_popup,"error reading variable from list");
	      return;
	}

/* get pointer to string containing new variable value */
	string = (char *) xv_get(sort_gui_var_popup->var_tf,PANEL_VALUE);
	if (sscanf(string,"%g",&var_value) != 1) {
		fprintf(stderr,"sort: new variable value not read correctly\n");
		return;
	}

	sprintf(tmp_str,"var %d %-20g",var_nos,var_value);
/* communicate with sort server */
	if (talk_to_server(TRUE,tmp_str,NULL) != 0)
	      return;
	
/* update display list in sort_gui_var_popup */
	sprintf(sbuf,"%3d %-12s %13.6g",var_nos,var_name,var_value);
	xv_set(sort_gui_var_popup->var_list,
		PANEL_LIST_STRING,	row,	sbuf,
		NULL);

	return;
}

Panel_setting
var_eot_nh(
#if NeedFunctionPrototype
	   Panel_item	item,
	   Event	*event)
#else
      item, event)
      Panel_item	item;
      Event		*event;
#endif
{
      if ( DBX_val >= 6) fputs("sort_gui: var_eot_nh\n", stderr);
      switch( event_id(event)) {
	    case '\r':
	    case '\n':
	    case '\t':
	       var_but_nh(item, event);
	       return PANEL_DONE;
	    default:
	       return(panel_text_notify(item, event));
	 }
}

