/*
 *  decoding routine to unpack event by event data and pass this on to user routines
 *  *** FSU style polarization data ***
 *
 *  started on new version 4/7/95
 *  modified 9/2/96
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/time.h>

#include "sort_def.h"
#include "rdtape.h"

#define SWAPSHORT(s) ( ((s&0x00ff) << 8) + ((s&0xff00) >> 8) )
#define FSU_L_TRIG 15
#define FSU_U_TRIG 21
#define FSU_MAX_ELEN 8
#define FSU_RECORD_COUNT 4096


int
rdtape_fsu
#if NeedFunctionPrototype
(int filter)
#else
(filter)
int filter;
#endif
{
    register short *eptr, *header_ptr, *adclist;
    register short trig_nos, event_len;
    
    time_t start_time, time_now;
    long trig_counter[MAX_NOS_TRIGS];
    int bytes, header, record = 0;
    
    register int i;
    register int adc_bytes, bit_bytes;
    
/* initialize event sorting */
    (void) memset((char *) trig_counter, 0, sizeof(trig_counter));
    adc_bytes = adcnum_.nos_adcs * sizeof(short);
    bit_bytes = sizeof(adcs_.bitpattern);
    
/* call user's initialization function */      
    if (init())
    {
	fprintf(stderr, initfailmess);
	return filter;
    }
    
/* set start time */
    start_time  = time(NULL);
    
/* sort requested number of records or until end of file etc */
    for (record=1; ; record++) {
	if ( (eptr = read_block(&bytes)) == NULL) 
	    break;
	
	/* decode event block */
	while ( (header = *eptr) != 0) {
	    header_ptr = eptr++;
	    /* reset adcs_ common block */
	    (void) memset((char *) adcs_.adcs, -1, adc_bytes);
	    (void) memset((char *) adcs_.bitpattern, 0, bit_bytes);
	    adclist = adclist_.adclist;
	    *adclist_.grouplist = -1;

	    /* decode event header */
	    adcs_.triggernos = trig_nos = (header & 0xff00) >> 8;
	    event_len = (header & 0x007f);
	    
/* pack adc array */		  
	    if (trig_nos > FSU_L_TRIG && trig_nos < FSU_U_TRIG &&
		event_len <= FSU_MAX_ELEN) {
		for (i=0; i<event_len; i++) {
		    adcs_.adcs[i] = (short) SWAPSHORT(*eptr);
		    *adclist++ = i + 1;
		    eptr++;
		}
		event_len += 1; /* account for header word */
		if (header_ptr+event_len != eptr) {
		    fprintf(stderr,"Event length is inconsistent with number "
			    "of adcs read from event stack\n");
		    fprintf(stderr,"... skipping rest of record %d\n",record);
		    break;
		}
	    }
	    else {
		fprintf(stderr,"ERROR decoding event header in record %d ..."
			" skipping rest of record\n",record);
		break;
	    }
	    
	    /* call user provided event sorting routine */
	    trig_counter[trig_nos]++;
		  adcs_.record = record;
		  adcs_.wrtevt = 0;
		  *adclist = -1;
	          if (sortin())
		  {
		      fprintf(stderr, sortinfailmess);
		      goto ABORT_SORT;
		  }
		  
		  /* write out event if wrtevt set to true */
		  if (filter && adcs_.wrtevt) {
		      if ( write_filt(header_ptr, event_len) )
			  filter = 0;
		  }
		  
	}   /* loop on the ebye buffer until next header == 0 */
	
    }         /* loop over requested number of records or until eof */

ABORT_SORT:
    
/* lets note the time at end */
    time_now = time(NULL);
    
/* call user provided clearup routine  */
      if (finish())
	  fprintf(stderr, finishfailmess);
      
/* output statistics */
      fprintf(stderr,"\n*** sort statistics ***\n");
      for(i=1; i<MAX_NOS_TRIGS; i++) {
	  if (trig_counter[i] > 0) {
	      fprintf(stderr,"%ld trigger %d events\n", trig_counter[i],i);
	      trig_counter[0] += trig_counter[i];
	  }
      }
      fprintf(stderr,"\nread %ld events in %d seconds\n"
	      "Average sort rate = %g events per second\n\n",
	      trig_counter[0], (int) (time_now-start_time),
	      (double) trig_counter[0] / (time_now-start_time));
      
      fprintf(stderr,"\nfinished sorting data after reading %d records\n",
	      record-1);
      return filter;
}

/*
 *  functions used in the filtering of data
 *  write any data to end of filtered data block
 */
/*ARGSUSED*/
static void
filt_tail(
#if NeedFunctionPrototype
	  short *base, short *fptr)
#else
      base, fptr)
      short *base;
      short *fptr;
#endif
{
      *fptr = 0;
      return;
}
/*
 *  write any data to the beginning of filtered data block
 */
static short *
filt_head(
#if NeedFunctionPrototype
	  short *base)
#else
      base)
      short *base;
#endif
{
      return(base);
}

/* FSU filter data specification */
static filtdat_t fsu_filtdat = {
      FSU_RECORD_COUNT,
      FSU_RECORD_COUNT/2,
      filt_head,
      filt_tail,
      NULL,
      "FSU"
};

/* routine to get pointer to nsf_filtdat */
filtdat_t *
get_fsu_filtdat(
#if NeedFunctionPrototype
		void
#endif
		)
{
      return(&fsu_filtdat);
}
