/*
 * decoding routine to unpack event by event data and 
 * pass this on to user routines
 * *** Data style == JYFL ***
 *
 * started on 10/7/97
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/time.h>

#include "sort_def.h"
#include "rdtape.h"

#define NUM_ADCS 4

int
rdtape_jyfl
#if NeedFunctionPrototype
(int filter)
#else
(filter)
int filter;
#endif
{
    time_t start_time, time_now;
    int i, record, bytes, first = 1;
    unsigned short *ptr, *ebye, *recordend;
    short *adclist;
    short *adcp;
    long in_events = 0;
    int adc_bytes;

    adc_bytes = adcnum_.nos_adcs * sizeof(short);

    /* call user's initialization function */      
    if (init())
    {
	fprintf(stderr, initfailmess);
	return filter;
    }
  
    /* set start time */
    start_time = time(NULL);
      
    /* sort requested number of records or until end of file etc */
    for (record=1; ;record++) {
	if ( (ebye = (unsigned short *) read_block(&bytes)) == NULL) 
	    break;

	recordend = ebye + bytes/sizeof(short);

	if (first || *ebye == 0xffff)
	{
	    ebye += 8;
	    first = 0;
	}

	while(ebye < recordend && *ebye != 0xffff)
	{
	    memset((char *) adcs_.adcs, -1, adc_bytes);
	    adclist = adclist_.adclist;
	    *adclist_.grouplist = -1;
	    
	    for(i = NUM_ADCS, ptr = ebye, adcp = adcs_.adcs; i--; )
	    {
		*adcp++ = *ptr++;
		*adclist++ = ptr - ebye;
	    }
	    
	    adcs_.triggernos = NUM_ADCS;
	    adcs_.event = ++in_events;
	    adcs_.record = record;
            adcs_.wrtevt = 0;
	    *adclist = -1;

	    /*user supplied routine*/
	    if (sortin())
	    {
		fprintf(stderr, sortinfailmess);
		goto ABORT_SORT;
	    }
	    
	    if (filter && adcs_.wrtevt)
		if (write_filt((short *) ebye, NUM_ADCS))
		    filter = 0;
	    
	    ebye = ptr;
	}
    }

ABORT_SORT:

    /* lets note the time at end */
    time_now = time(NULL);
    
    /* call user provided clearup routine  */
    if (finish())
	fprintf(stderr, finishfailmess);

    /* output statistics */
    record--;
    fprintf(stderr, "\n*** sort statistics ***\n");
    fprintf(stderr, "\nsorted %ld events in %d seconds\n"
	    "Average sort rate = %g events per second\n",
	    in_events, (int) (time_now-start_time),
	    (double) in_events / (time_now-start_time));

    return filter;
}

/*
 *  functions used in the filtering of data
 *  write any data to end of filtered data block
 */

/*ARGSUSED*/
static void
filt_tail
#if NeedFunctionPrototype
(short *base, short *fptr)
#else
(base, fptr)
short *base;
short *fptr;
#endif
{
    *fptr = (short) 0xffff;

    return;
}

/*
 *  write any data to the beginning of filtered data block
 */
static short *
filt_head
#if NeedFunctionPrototype
(short *base)
#else
(base)
short *base;
#endif
{
    int i;

    for(i = 8; i--; )
	*base++ = (short) 0xffff;

    return(base);
}

/* jyfl filter data specification */
static filtdat_t jyfl_filtdat = {
      4096,
      2040,
      filt_head,
      filt_tail,
      NULL,
      "JYFL"
};

/* routine to get pointer to jyfl_filtdat */
filtdat_t *
get_jyfl_filtdat
#if NeedFunctionPrototype
(void)
#else
()
#endif
{
      return(&jyfl_filtdat);
}
