/*
 * MEGHA data decoder. This is a true Eurogam format.
 * Most of the functionality is in rdtape_eg.c
 */

#include "sort_def.h"
#include "rdtape.h"
#include "rdtape_eg.h"

#define STYLE_MEGHA
#define DECODER_NAME rdtape_megha
#define ENCODER_NAME write_megha
#include "rdtape_eg_core.c"

/* megha filter data specification */
static filtdat_t megha_filtdat = {
      EG_RECORD_COUNT,
      EG_RECORD_HWM/2,        /* in terms of shorts */
      eg_filt_head,
      eg_filt_tail,
      write_megha,
      "MEGHA"
};

/* routine to get pointer to megha_filtdat */
filtdat_t *
get_megha_filtdat(
#if NeedFunctionPrototype
		void
#endif
		)
{
      return(&megha_filtdat);
}

