/*
 *  decoding routine to unpack event by event data and pass this on to user routines
 *  *** Data style == NONE ***
 *
 *  this is a dummy rotine that provided no data decoding 
 *
 *  started on new version 16/7/95
 *  modified 8/2/96
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/time.h>

#include "sort_def.h"
#include "rdtape.h"

#define MIN_OUTREC_LEN   256
#define MAX_OUT_LEN      4096
#define MAX_OUTREC_BYTES 8192

int
rdtape_none
#if NeedFunctionPrototype
(int filter)
#else
(filter)
int filter;
#endif
{
    register short *ebye;                     /* pointer to input buffer */
    
    register short event_len;
    register short *eptr, *end_ptr;
    
    time_t start_time, time_now;
    int bytes, record = 0;
    register int adc_bytes;
    
    /* initialize event sorting */
    adc_bytes = adcnum_.nos_adcs * sizeof(short);
    (void) memset((char *) adcs_.bitpattern, 0, sizeof(adcs_.bitpattern));
    event_len = adcnum_.nos_adcs;
    
    /* call user's initialization function */      
    if (init())
    {
	fprintf(stderr, initfailmess);
	return filter;
    }

/* set start time */
    start_time = time(NULL);
    
/* sort requested number of records or until end of file etc */
    for (record=1; ; record++) {
	if ( (eptr = ebye = read_block(&bytes)) == NULL) 
	    break;
	
	adcs_.record = record;
	end_ptr = ebye + bytes;
	
	/* decode event block */
	while ( eptr+event_len < end_ptr ) {
	    /* reset adcs_ common block */
	    (void) memset((char *) adcs_.adcs, -1, adc_bytes);
	    
	    /* copy fixed length of data block to adcs array */
	    adcs_.triggernos = -1;
	    (void) memcpy((char *) adcs_.adcs, eptr, adc_bytes);
	    adcs_.wrtevt = 0;
	    *adclist_.adclist = -1;
	    *adclist_.grouplist = -1;
	    
	    /* call user's sort routine */
	    if (sortin())
	    {
		fprintf(stderr, sortinfailmess);
		goto ABORT_SORT;
	    }
	    
	    if (filter && adcs_.wrtevt) {
		if ( write_filt(eptr, event_len) )
		    filter = 0;
	    }
	    
	    /* advance to next chunk of the data buffer */
	    eptr += event_len;
	    
	}   /* loop on the ebye buffer until next header == 0 */
	
    }         /* loop over requested number of records or until eof */
    
ABORT_SORT:
    
/* lets note the time at end */
    time_now = time(NULL);
    
/* call user provided clearup routine  */
    if (finish())
	  fprintf(stderr, finishfailmess);
 
/* output statistics */
    fprintf(stderr,"\n*** sort statistics ***\n");
    fprintf(stderr,"\nread %d records in %d seconds\n",
	    record-1, (int) (time_now-start_time));
    
    fprintf(stderr,"\nfinished sorting data after reading %d records\n",
	    record-1);
   
    return filter;
}


/*
 *  user callable write event function
 *  write data to filter stream with no format
 *
 *  first draft 9/2/95
 */
int
write_none(
#if NeedFunctionPrototype
	  int size, short *array)
#else
      size, array)
      int size;
      short *array;
#endif
{

      /* ensure that we have an event length within acceptable ranges */
      if (size >= MAX_OUT_LEN || size <= 0) {
	    fprintf(stderr,"this format support maximum event length of %d words\n",
		    MAX_OUT_LEN);
	    fprintf(stderr,"you call writefn with value of %d\n",size);
	    return(-2);
      }

       /* write out buffer if present event takes us beyond HWM */
      if ( write_filt(array, size) )
	    return(-3);
      	    
      return(size);
}


/*
 *  functions used in the filtering of data
 *  write any data to end of filtered data block
 */
/*ARGSUSED*/
static void
filt_tail(
#if NeedFunctionPrototype
	  short *base, short *fptr)
#else
      base, fptr)
      short *base;
      short *fptr;
#endif
{
}
/*
 *  write any data to the beginning of filtered data block
 */
static short *
filt_head(
#if NeedFunctionPrototype
	  short *base)
#else
      base)
      short *base;
#endif
{
      return(base);
}

/* NSF filter data specification */
static filtdat_t none_filtdat = {
      MAX_OUTREC_BYTES,
      MAX_OUTREC_BYTES/2,
      filt_head,
      filt_tail,
      write_none,
      "NONE"
};

/* routine to get pointer to nsf_filtdat */
filtdat_t *
get_none_filtdat(
#if NeedFunctionPrototype
		void
#endif
		)
{
      return(&none_filtdat);
}
