/*
 * decoding routine to unpack event by event data and 
 * pass this on to user routines
 * *** Data style == S4418 ***
 *
 * started on 19/12/97
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/time.h>

#include "sort_def.h"
#include "rdtape.h"

int
rdtape_s4418
#if NeedFunctionPrototype
(int filter)
#else
(filter)
int filter;
#endif
{
    time_t start_time, time_now;
    int i, j, record, bytes, vsn, vdc;
    unsigned short *eptr, *ebye, *bl;
    short *adclist;
    long in_events = 0;
    int adc_bytes, badhead = 0, badheadrec = 0, bad, rechead = 0, total;
    int recovered = 0;

    adc_bytes = adcnum_.nos_adcs * sizeof(short);

    /* call user's initialization function */      
    if (init())
    {
	fprintf(stderr, initfailmess);
	return filter;
    }
      
    /* set start time */
    start_time = time(NULL);
      
    /* sort requested number of records or until end of file etc */
    for (record=1; ;record++) {
	if ( (bl = ebye = (unsigned short *) read_block(&bytes)) == NULL) 
	    break;

#ifdef DUMP
	fprintf(stderr, "Block read at %08x:\n", (unsigned int) ebye);
	for(eptr = ebye, i = 0, j = bytes/sizeof(unsigned short); j--; eptr++)
	{
	    fprintf(stderr, "%04x", *eptr);
	    i += 4;
	    if (i > 76)
	    {
		putc('\n', stderr);
		i = 0;
	    }
	    else
	    {
		putc(' ', stderr);
		i++;
	    }
	}
	if (i != 0)
	    putc('\n', stderr);
#endif
	bad = 0;

	while(*ebye != 0xffff)
	{
	    memset((char *) adcs_.adcs, -1, adc_bytes);
	    adclist = adclist_.adclist;
	    *adclist_.grouplist = -1;

	    eptr = ebye;

	    j = 0;
	    while(*eptr != 0xf000) /* end of record */
	    {
		if ((*eptr & 0xf000) != 0x8000)
		{
		    fprintf(stderr, "Bad S4418 ADC header:");
		    badhead++;
		    if (!bad)
		    {
			bad = 1;
			badheadrec++;
		    }
		    ebye = eptr;
		    while((char *) eptr < (char *) bl + bytes &&
			  *eptr != 0xf000)
			eptr++;
		    if ((char *) eptr < (char *) bl + bytes)
		    {
			fprintf(stderr, "Recovering on next event, after %d "
				"bytes.\n", (char *) eptr - (char *) ebye);
			ebye = eptr + 1;
			rechead++;
			goto NEXT_EVENT;
		    }
		    fprintf(stderr, "Skipping rest of block.\n");
		    badheadrec++;
		    goto ABORT_BLOCK;
              }

		vdc = (*eptr >> 8) & 15; /* valid data words */
		vsn = *eptr++ & 255; /* virtual station number */
		eptr++; /* skip pattern word */
		for(; vdc--; eptr++)
		{
		    i = (vsn<<3) + ((*eptr>>12) & 7);
		    if (i < adcnum_.nos_adcs)
		    {
			j++;
			if (*eptr & 0x8000) /* overflow */
			    adcs_.adcs[i] = 0;
			else
			{
			    adcs_.adcs[i] = *eptr & 0x0fff;
			    *adclist++ = i+1;
			}
		    }
		}
	    }
	    eptr++;
	    
	    adcs_.triggernos = j;
	    adcs_.event = ++in_events;
	    adcs_.record = record;
	    adcs_.wrtevt = 0;
	    *adclist = -1;
	    if (bad)
		recovered++;

	    if (sortin())
	    {
		fprintf(stderr, sortinfailmess);
		goto ABORT_SORT;
	    }
	    
	    if (filter && adcs_.wrtevt)
	    {
		if (write_filt((short *) ebye, eptr - ebye))
		    filter = 0;
	    }

	    ebye = eptr;
	NEXT_EVENT:
	    ;
	}
    ABORT_BLOCK:
	;
    }

ABORT_SORT:

    /* lets note the time at end */
    time_now = time(NULL);
    
    /* call user provided clearup routine  */
    if (finish())
	fprintf(stderr, finishfailmess);
      
    /* output statistics */
    record--;
    fprintf(stderr, "\n*** sort statistics ***\n");
    fprintf(stderr, "\nsorted %ld events in %d seconds\n"
	    "Average sort rate = %g events per second\n",
	    in_events, (int) (time_now-start_time),
	    (double) in_events / (time_now-start_time));
    fprintf(stderr, "Records with bad ADC headers: %d (%8.4f%%)\n",
	    badheadrec, 100.0*badheadrec/record);
    total = in_events + badhead;
    fprintf(stderr, "Events with bad ADC headers : %d (%8.4f%%); "
	    "recoveries: %d\n", badhead, 100.0*badhead/total, rechead);
    fprintf(stderr, "Events recovered by recovery procedures: %d (%8.4f%%)\n",
	    recovered, 100.0*recovered/total);

    return filter;
}

/*
 *  functions used in the filtering of data
 *  write any data to end of filtered data block
 */

/*ARGSUSED*/
static void
filt_tail
#if NeedFunctionPrototype
(short *base, short *fptr)
#else
(base, fptr)
short *base;
short *fptr;
#endif
{
    *fptr = (short) 0xffff;

    return;
}

/*
 *  write any data to the beginning of filtered data block
 */
static short *
filt_head
#if NeedFunctionPrototype
(short *base)
#else
(base)
short *base;
#endif
{
    return(base);
}

/* s4418 filter data specification */
static filtdat_t s4418_filtdat = {
      256,
      100,
      filt_head,
      filt_tail,
      NULL,
      "S4418"
};

/* routine to get pointer to s4418_filtdat */
filtdat_t *
get_s4418_filtdat
#if NeedFunctionPrototype
(void)
#else
()
#endif
{
      return(&s4418_filtdat);
}
