/*
 *
 *   data_remote.c  routines that interface with DL/DB libspy library
 *
 *   last modified 2/8/95
 */

#include <stdio.h>
#include <signal.h>
#include <unistd.h>

#include <sys/file.h>
#include <sys/types.h>
#include <sys/time.h>

#include <time.h>

#include "libspy.h"
#include "sort_def.h"
#include "sort_threadint.h"
#include "data_remote.h"

#define DELTA_BLOCKS  100

/* open stream number */
static int remote_instream=0;      

/* status information */
static int tag, old_tag;                     /* hold the sequence nos of current block and last block */
static int blocks_received;                  /* number pf blocks read in */
static int blocks_missed;                    /* calculated number of missed blocks */
static int delta_missed;                     /* number missed for DELTA_BLOCKS received */
static double fraction;                      /* fraction of blocks missed */


/*
 *  control opening and closing of remote stream in spy deamon
 */
#if NeedFunctionPrototype
int
remote_op(int operation)
#else
int
remote_op(operation)
      int operation;
#endif
{
      int  stream, retcode;

      switch (operation) {
	  case OPEN_REMOTE:
	    if (remote_instream != 0) {
		  fprintf(stderr,"remote stream already open! \n");
		  return(-1);
	    }
	    for (stream=1; stream<5; stream++) {
		  if ( (retcode = sortSpyOpen(stream)) == 0) {
			remote_instream = stream;
			break;
		  }
		  else if (retcode == 1) {
			continue;
		  }
		  else {
			return(-1);
		  }
	    }
	    /* zero status parmeters */
	    blocks_received = blocks_missed = 0;
	    delta_missed = tag = old_tag = 0;
	    fraction = 0.0;
	    break;
	    
	  case CLOSE_REMOTE:
	    if (remote_instream == 0) {
		  fprintf(stderr,"no remote stream open! \n");
		  return(-1);
	    }
	    if ( sortSpyClose(remote_instream) != 0 ) {
		  fprintf(stderr,"Error closing remote data source\n");
		  return(-1); 
	    }
	    remote_instream = 0;
	    break;
	    
	  case STATUS_REMOTE:
	    if (remote_instream == 0) {
		  fprintf(stderr,"no remote stream open! \n");
		  return(-1);
	    }
	    fprintf(stderr,"total number of blocks received since last open = %d\n",
		    blocks_received);
	    fprintf(stderr,"total number of blocks missed since last open = %d\n",blocks_missed);
	    fprintf(stderr,"the last %d blocks received represent %.1f%% of those sent\n\n",
		    (int) DELTA_BLOCKS, (double) (fraction*100.0));
	    break;
	    
	  default:
	    fprintf(stderr,"Invalid operation specified to routine remote_op\n");
	    if (DBX_val > 1) 
		  fprintf(stderr,"remote operation = %d\n",operation);
	    return(-1);
      }
      return(0);
}

/*
 *  get a block of data from spy deamon ... if any available
 *  operate in polling mode
 */
#if NeedFunctionPrototype
int
remoteget (int maxlen, char *buffer)
#else
int
remoteget(maxlen, buffer)
      int  maxlen;
      char *buffer;
#endif
{
      int rtcode, missed;
      
/* while there is no data available wait around */      
      while ( (rtcode = sortSpyReadWithSeq(remote_instream, buffer, maxlen, &tag)) == 0) {
	    struct timeval  timeout;
	    timeout.tv_sec = 0;
	    timeout.tv_usec = 10000;
	    /* use select call as a millisecond timer */
	    (void) select(1, NULL, NULL, NULL, &timeout);
	    if (Stop_interupt(0) != 0)
		  break;
      }

/* update status information */
      if (rtcode) {
	    blocks_received++;
	    /* for first block old_tag will be 0 and tag will be an arbitrary number */
	    if (old_tag) {
		  missed = tag - old_tag - 1;
		  blocks_missed += missed;
		  delta_missed += missed;
		  /* calculate fraction of blocks missed during period to acquire DELTA_BLOCKS */
		  if ( (blocks_received % DELTA_BLOCKS) == 0) {
			fraction = (double) DELTA_BLOCKS / ((double) DELTA_BLOCKS + (double) delta_missed);
			delta_missed = 0;
		  }
	    }
	    old_tag = tag;
      }
      
      return(rtcode);
}
