#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <sys/types.h>
#include "sort_def.h"
#include "sort_threadint.h"
#include "r_dev.h"
#include "monDrv.h"
#include "dbufLib.h"

typedef struct mpSem *MP_SEM;

#include "acqDrv.h"

extern int errno;

static R_FD *dfd;
static int bs = 0, skip;
static char *sysfile = NULL;

static char *acqStatus[][2] = {
    " off", " on",
    "", " err",
    "", " stalled",
    " unlock", "",
    "", " ending",
    NULL, NULL,
};

extern char *strErrno();

int demonopen(char *system, int reclen)
{
    if (reclen == 0)
    {
	fprintf(stderr, "Variable length records not supported on Demon "
		"data feed.\n");
	return -1;
    }

    if ((sysfile = malloc(strlen(system)+10)) == NULL)
    {
	fprintf(stderr, "Out of memory.\n");
	return -1;
    }

    sprintf(sysfile, "%s:/dev/mon", system);

    if ((dfd = r_open(sysfile, R_FD_PROT_RPCTCP | O_MONDEV_SAMPLE)) == NULL)
    {
	fprintf(stderr, "Unable to open VME file %s.\n", sysfile);
	return -1;
    }
	
    if (FD(dfd) < 0)
    {
	r_close(dfd);
	fprintf(stderr, "Unable to open VME file %s.\n", sysfile);
	return -1;
    }

    bs = reclen;

    if (CL(dfd) && r_tie(dfd,bs) < 0)
    {
	r_close(dfd);
	fprintf(stderr, "Unable to make TCP/IP connection to VME system.\n");
	return -1;
    }

    if (DBX_val >= 5)
	fprintf(stderr, "Opened %s on fd %d and TCP fds %d and %d.\n", sysfile,
		FD(dfd), SCKCTL(dfd), SCKDAT(dfd));

    sprintf(sysfile, "%s:/dev/acq", system);

    skip = 0;

    return 0;
}

int demonclose(void)
{
    if (r_close(dfd))
	perror("demonclose");

    if (sysfile != NULL)
    {
	free(sysfile);
	sysfile = NULL;
    }

    return 0;
}

int demonread(int buflen, char *buffer)
{
    int n, len, slen;
    fd_set fds;
    struct timeval timeout;

    while(skip)
    {
	len = (skip < buflen) ? skip : buflen;

	if (Stop_interupt(0))
	    return -1;

	FD_ZERO(&fds);
	FD_SET(SCKDAT(dfd), &fds);
	timeout.tv_sec = 0;
	timeout.tv_usec = 100000;
	select(SCKDAT(dfd)+1, &fds, NULL, NULL, &timeout);
	if (FD_ISSET(SCKDAT(dfd), &fds))
	{
	    /* We bypass r_read as we need to be able to abort system calls */
	    if ((n = read(SCKDAT(dfd), buffer, len)) < 0)
	    {
		if (errno == EINTR)
		    continue;
		else
		    break;
	    }
	    skip -= n;
	}
    }
    
    skip = bs;
    slen = len = (bs < buflen) ? bs : buflen;

    while(len > 0)
    {
	if (Stop_interupt(0))
	    return -1;

	FD_ZERO(&fds);
	FD_SET(SCKDAT(dfd), &fds);
	timeout.tv_sec = 0;
	timeout.tv_usec = 100000;
	select(SCKDAT(dfd)+1, &fds, NULL, NULL, &timeout);
	if (FD_ISSET(SCKDAT(dfd), &fds))
	{
	    /* We bypass r_read as we need to be able to abort system calls */
	    if ((n = read(SCKDAT(dfd), buffer, len)) < 0)
	    {
		if (errno == EINTR)
		    continue;
		else
		    break;
	    }
	    buffer += n;
	    len -= n;
	    skip -= n;
	}
    }
    
    if (n == -1)
    {
	perror("demonread");
	return -1;
    }
    if (len == slen)
	return -1;
    return slen - len;
}

void demonstatus(void)
{
    struct acqShDev ret;
    char *(*str)[2];
    int s;
    R_FD *fd;

    fd = r_open(sysfile, R_FD_PROT_RPC | O_MONDEV_SAMPLE);
    if (FD(fd) < 0)
    {
	r_close(fd);
	fprintf(stderr, "Unable to open VME file %s.\n", sysfile);
	return;
    }

    memset(&ret, 0, sizeof(struct acqShDev));
    if( r_ioctl(fd,ACQIO_STATUS,&ret,xdr_acqShDev) < 0 )
    {
	fprintf(stderr,"%s\n",r_error(fd));
        return;
    }
    fprintf(stderr,"Acquisition status:");
    for(s = ret.status, str = acqStatus; (*str)[0] != NULL ; str++, s >>= 1 )
	fprintf(stderr,"%s",(*str)[s & 1]);
    fprintf(stderr,"\n");
    fprintf(stderr,"errno = 0x%08x",ret.errno);
    if( ret.errno )
        fprintf(stderr," (%s)",strErrno(ret.errno));

    fprintf(stderr,"\n");

    r_close(fd);
}

