#ifndef SUNSORT_THREAD_h
#define SUNSORT_THREAD_h

#include <unistd.h>
#include <limits.h>
#include <time.h>
#include <thread.h>
#include <synch.h>

#define SORTING_OFF 0
#define SORTING_ON  1

#define NOS_OF_RBUFS 4
#define NOS_OF_WBUFS 4

#define MAX_DATA_SIZE  16384

#define BAD_BUFFER        0x0
#define END_OF_DATA_BUF   0x1
#define EMPTY_BUF         0x2
#define FILLING_BUF       0x4
#define FULL_BUF          0x8
#define EMPTYING_BUF      0x20

#define TYPE_var 0
#define TYPE_1d  1
#define TYPE_2d  2

#define RTHREAD_WAIT 2
#define WTHREAD_WAIT 2

#define SORT_SERVER_INFD 3
#define SORT_SERVER_OUTFD 4

#define tmp_PAGESIZE 4096


typedef struct data_buf {
      int      state;
      mutex_t  mp;
      cond_t   cv;
      int      data_size;
      char     data[MAX_DATA_SIZE];
} data_buf_t;

typedef struct spec_info_entry {
      char    name[NAME_SIZE];   /* spectrum title */
      int     nos;               /* array position in look up table */
      unsigned int  version;     /* info stating if entry has recently been modified */
      int     size;              /* size in (int) */
      int     win;               /* window number if 2d window ignored if 1d */
      float   value;             /* value if variable */
} spec_entry_t;

typedef struct spec_1d {
	int nos;
	unsigned int  version;
	int *data;		/* pointer to spectrum data */
	spec_entry_t   *sp;     /* pointer to spectrum info entry */
	struct spec_1d *next;	/* pointer to next spectrum structure (smaller nos)*/
} spec_1d_t;

typedef struct spec_2d {
	int nos;
	unsigned int  version;
	int win;                /* window number */
	int *data;
	spec_entry_t   *sp;  
	struct spec_2d *next;
} spec_2d_t;

typedef struct var_str {
	int nos;
	unsigned int  version;
	spec_entry_t   *sp;  
	struct var_str *next;
} var_str_t;

/* define the data structure that will hold the io info */
typedef struct sort_IO_data {
	char	   read_file[MED_SUNSORT_BUFFER+1];	/* opened read file name */
	char	   read_vol[MED_SUNSORT_BUFFER+1];	/* tape name if exabyte */
	char	   write_file[MED_SUNSORT_BUFFER+1];	/* opened write file name */
	char       write_vol[MED_SUNSORT_BUFFER+1];	/* tape name if exabyte */
	unsigned   IO_state;				/* flag indicating i/o status */
	short	   sort_media;				/* present sort medium */
	short      write_media;                         /* present filtering medium */
	short	   sort_drive;				/* present exabyte drive */
	short      write_drive;                         /* present exabyte drive for filtering */
	char       decoder[FORMAT_NAME_LEN];            /* name of decoder passed to sort program */
} sort_IO_t;

typedef struct dirs_IO_data {
	char 	    save_dir[MED_SUNSORT_BUFFER+1];	/* directory to place saved spectra files */
	char	    load_dir[MED_SUNSORT_BUFFER+1];	/* directory to load spectra files from */
	unsigned    IO_state;				/* whether loading or saving */
} dirs_IO_t;

struct shared_data {
      int           version;
      int           sorting;
      mutex_t       mp_sorting;
      cond_t        cv_sorting;
      unsigned long in_records;
      unsigned long out_records;
      data_buf_t    read_buf[NOS_OF_RBUFS];
      data_buf_t    write_buf[NOS_OF_WBUFS];
      char          _pad[tmp_PAGESIZE];       /* pad space to put rest of data on new page */

      /* should be read only data for all processes except server */
      sort_IO_t     sort_io_data;
      dirs_IO_t     dirs_io_data;
      spec_entry_t  spec1d[TAB_SIZE_1D];
      spec_entry_t  spec2d[TAB_SIZE_2D];
      spec_entry_t  var[TAB_SIZE_VAR];
};


#define SHDATA_SIZE sizeof(struct shared_data)

#endif   /* endif ! SUNSORT_THREAD_h */
