#include "soapH.h"
#include "MessageLoggerServer.nsmap"

#include <unistd.h>


const char MessageLoggerServerHost[] = "egmsg";
const char MessageLoggerServerPort[] = "8015";
char MessageLoggerServer[64];

static struct soap MessageLoggerServer__soap;
static int MessageLoggerServer__Initialised = 0;

extern int MessageLoggerServer__DefineMessage (char* Class, char*  Level, char *source, char *message, int *result)
{
  char* Host;
  char* Port;
   int rc;

  struct ns__Get_LastErrorResponse LastError;
  struct ns__Get_InformationResponse Information;

  if (MessageLoggerServer__Initialised == 0) {

      Host = getenv("MessageLoggerServerHost");
      if (Host==0) Host = (char*) &MessageLoggerServerHost[0];

      Port = getenv("MessageLoggerServerPort");
      if (Port==0) Port = (char*) &MessageLoggerServerPort[0];

      sprintf(MessageLoggerServer, "http://%s:%s/MessageLoggerServer", Host, Port);

      soap_init2(&MessageLoggerServer__soap, SOAP_IO_KEEPALIVE, SOAP_IO_KEEPALIVE);
  }
  
  soap_call_ns__DefineMessage(&MessageLoggerServer__soap, (char *)MessageLoggerServer, NULL, Class, Level, (char*)source, (char *)message, &rc);
  
  if (MessageLoggerServer__soap.error)
  {
//      soap_print_fault(&MessageLoggerServer__soap, stderr);

       soap_destroy(&MessageLoggerServer__soap);
       soap_end(&MessageLoggerServer__soap);
       soap_done(&MessageLoggerServer__soap);

  } else {
      MessageLoggerServer__Initialised = 1;
  }

  printf("rc=%d\n",rc);

//  if (rc != 0)
//  {

      soap_call_ns__Get_LastError(&MessageLoggerServer__soap, (char *)MessageLoggerServer, NULL,  &LastError);

    printf("LastError returned: %d %s\n",*LastError.Code,LastError.Reason);

      soap_call_ns__Get_Information(&MessageLoggerServer__soap, (char *)MessageLoggerServer, NULL,  &Information);

    printf("Information returned: %s\n",Information.Reason);

//  }

  return rc;
}

