/*
 * Decompiled with CFR 0.152.
 */
package cvupgradegui;

import java.io.File;
import javax.swing.JFileChooser;

public class AppProperties {
    public static final String OS = System.getProperty("os.name").toLowerCase();
    public static final boolean WindowsOS = OS.indexOf("win") >= 0;
    public static final boolean LinuxOS = !WindowsOS;
    public static final String Newline = System.getProperty("line.separator");
    public static final String FileSep = File.separator;
    public static final String BridgeUpgraderProgram;
    public static final String CvUpgradeProgram;
    public static final String PllTemplatesDir;
    public static final String CvParametersDir;
    public static final String LogFile;
    public static final String FwRevFile;
    public static final String GuiSettingsFile;
    public static final String DefaultSaveDir;
    public static final String SupportEmail;

    static {
        SupportEmail = "support.computing@caen.it";
        if (WindowsOS) {
            GuiSettingsFile = "CAENUpgraderGUI.ini";
            PllTemplatesDir = "templates\\" + FileSep;
            CvParametersDir = "params\\" + FileSep;
            String archDataModel = System.getProperty("sun.arch.data.model");
            BridgeUpgraderProgram = archDataModel.contains("64") ? "./x64/CAENBridgeUpgrade.exe" : "./x32/CAENBridgeUpgrade.exe";
            CvUpgradeProgram = "cvUpgrade.exe";
        } else {
            GuiSettingsFile = "/etc/CAENUpgrader/CAENUpgraderGUI.ini";
            PllTemplatesDir = "/etc/CAENUpgrader/templates/" + FileSep;
            CvParametersDir = "/etc/CAENUpgrader/params/" + FileSep;
            BridgeUpgraderProgram = "CAENBridgeUpgrade";
            CvUpgradeProgram = "cvUpgrade";
        }
        String tempPath = System.getProperty("java.io.tmpdir");
        if (tempPath == null) {
            throw new RuntimeException("Cannot find a suitable location for temp files");
        }
        if (!tempPath.endsWith(FileSep)) {
            tempPath = tempPath + FileSep;
        }
        LogFile = tempPath + "CAENUpgrader_log.txt";
        FwRevFile = tempPath + "CAENUpgrader_fwrev.txt";
        DefaultSaveDir = new JFileChooser().getFileSystemView().getDefaultDirectory().getPath() + FileSep;
    }
}

