/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonListener;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;

public class BaseToggleButtonUI
extends BasicToggleButtonUI {
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    protected static Color[] rolloverPressedColors = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseToggleButtonUI();
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.setOpaque(false);
        Color[] colorArray = AbstractLookAndFeel.getTheme().getPressedColors();
        rolloverPressedColors = new Color[colorArray.length];
        for (int i = 0; i < colorArray.length; ++i) {
            BaseToggleButtonUI.rolloverPressedColors[i] = ColorHelper.brighter(colorArray[i], 20.0);
        }
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        abstractButton.setOpaque(true);
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new BaseButtonListener(abstractButton);
    }

    protected void paintBackground(Graphics graphics, AbstractButton abstractButton) {
        if (!abstractButton.isContentAreaFilled() || abstractButton.getParent() instanceof JMenuBar) {
            return;
        }
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        ButtonModel buttonModel = abstractButton.getModel();
        Color[] colorArray = null;
        colorArray = abstractButton.isEnabled() ? (abstractButton.getBackground() instanceof ColorUIResource ? (buttonModel.isRollover() ? (buttonModel.isSelected() ? rolloverPressedColors : AbstractLookAndFeel.getTheme().getRolloverColors()) : (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected() ? AbstractLookAndFeel.getTheme().getPressedColors() : AbstractLookAndFeel.getTheme().getButtonColors())) : (buttonModel.isRollover() ? ColorHelper.createColorArr(ColorHelper.brighter(abstractButton.getBackground(), 80.0), ColorHelper.brighter(abstractButton.getBackground(), 20.0), 20) : (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected() ? ColorHelper.createColorArr(abstractButton.getBackground(), ColorHelper.darker(abstractButton.getBackground(), 50.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(abstractButton.getBackground(), 40.0), ColorHelper.darker(abstractButton.getBackground(), 20.0), 20)))) : AbstractLookAndFeel.getTheme().getDisabledColors();
        JTattooUtilities.fillHorGradient(graphics, colorArray, 1, 1, n - 2, n2 - 2);
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = -1;
        n = JTattooUtilities.getJavaVersion() >= 1.4 ? abstractButton.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(abstractButton.getText(), buttonModel.getMnemonic());
        if (buttonModel.isEnabled()) {
            int n2 = 0;
            if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                n2 = 1;
            }
            graphics.setColor(abstractButton.getForeground());
            JTattooUtilities.drawStringUnderlineCharAt(abstractButton, graphics, string, n, rectangle.x + n2, rectangle.y + n2 + fontMetrics.getAscent());
        } else {
            graphics.setColor(Color.white);
            JTattooUtilities.drawStringUnderlineCharAt(abstractButton, graphics, string, n, rectangle.x + 1, rectangle.y + 1 + fontMetrics.getAscent());
            graphics.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
            JTattooUtilities.drawStringUnderlineCharAt(abstractButton, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
        }
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        graphics.setColor(AbstractLookAndFeel.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, 4, 3, abstractButton.getWidth() - 8, abstractButton.getHeight() - 6);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        Object object2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        BaseToggleButtonUI.viewRect.x = insets.left;
        BaseToggleButtonUI.viewRect.y = insets.top;
        BaseToggleButtonUI.viewRect.width = abstractButton.getWidth() - (insets.right + BaseToggleButtonUI.viewRect.x);
        BaseToggleButtonUI.viewRect.height = abstractButton.getHeight() - (insets.bottom + BaseToggleButtonUI.viewRect.y);
        BaseToggleButtonUI.textRect.height = 0;
        BaseToggleButtonUI.textRect.width = 0;
        BaseToggleButtonUI.textRect.y = 0;
        BaseToggleButtonUI.textRect.x = 0;
        BaseToggleButtonUI.iconRect.height = 0;
        BaseToggleButtonUI.iconRect.width = 0;
        BaseToggleButtonUI.iconRect.y = 0;
        BaseToggleButtonUI.iconRect.x = 0;
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : this.defaultTextIconGap);
        this.paintBackground(graphics, abstractButton);
        if (abstractButton.getIcon() != null) {
            if (!abstractButton.isEnabled()) {
                object2 = graphics2D.getComposite();
                object = AlphaComposite.getInstance(3, 0.5f);
                graphics2D.setComposite((Composite)object);
                this.paintIcon(graphics, jComponent, iconRect);
                graphics2D.setComposite((Composite)object2);
            } else {
                this.paintIcon(graphics, jComponent, iconRect);
            }
        }
        if (string != null && !string.equals("") && textRect != null) {
            object2 = (View)jComponent.getClientProperty("html");
            if (object2 != null) {
                object = null;
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
                }
                ((View)object2).paint(graphics, textRect);
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                }
            } else {
                this.paintText(graphics, abstractButton, textRect, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, viewRect, textRect, iconRect);
        }
    }
}

