


#variable started 0

if {![info exists started]} {variable started 0}

if {$started != 0} {

    variable JS ""
    variable INFO ""
    variable LogFlag

   if {$LogFlag == 1} {InsertLog "Last Updated: [clock format [clock seconds] -format "%B %d, %Y %H:%M:%S"]"}

    do_click

}

if {$started == 0} {
    set started 1

    variable ShowLogFlag 0

    variable LogText ""
    variable LogFlag 0
    variable LogCount 0

    variable JS ""
    variable INFO ""

    variable AuditText ""

    proc Information {s} {
        variable INFO

        set INFO ""
        append INFO "MyWindow=window.open(\"\",\"MyWindow\",\"toolbar=no,menubar=no,status=no,scrollbars=yes\");"
        append INFO "MyWindow.document.write(\"<html><body>\");"
        append INFO "MyWindow.document.write(\"[string map {\" \\" \n <br>} $s]\\n\");"
        append INFO "MyWindow.document.write(\"</body></html>\");"
        append INFO "MyWindow.document.close();"
    }

   proc  show_variables {} {
        variable DigitizerList
        variable Digitizer
        variable FpgaList
        variable Fpga
        variable LogFlag
        variable LogCount

        InsertLog "Digitizers=$DigitizerList"
        InsertLog "Digitizer=$Digitizer; FpgaList=$FpgaList; Fpga=$Fpga"
        InsertLog "LogFlag=$LogFlag; LogCount=$LogCount"
   }

   proc do_auditALL {} {
        variable Digitizer
        variable DigitizerList
        variable AuditText

      set AuditText ""

       set DigitizerBAK $Digitizer

       foreach Digitizer $DigitizerList {do_audit}

       set Digitizer $DigitizerBAK

       set rc [catch {Information $AuditText} m]

   }

   proc do_auditCURRENT {} {
       variable AuditText

       set AuditText ""

       do_audit

       set rc [catch {Information $AuditText} m]

   }

   proc do_elog {} {
       variable AuditText

       Elog INFORMATION $AuditText
   }


    proc do_audit {} {
        variable Digitizer
        upvar #0 AGATADigitizerAccessServer_XportList XportList
        variable AuditText

         append AuditText "\nxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\n"

            set Address [first [split $XportList($Digitizer) :]]
            set rc1 [catch {exec /bin/ping -c 1 $Address} m1]
            set rc2 [catch {exec /sbin/arp -a $Address} m2]
            if {$rc1 == 0 & $rc2 == 0} {
                append AuditText "\nDigitizer= $Digitizer; Address= $Address; Network info= $m2"
            } else {
                append AuditText "\nDigitizer= $Digitizer; Address= $Address"
                append AuditText "\nNetwork info= ping $m1; arp $m2"
            }
            do_probe
    }

proc do_probe {} {
    variable Digitizer
    variable AuditText

    set ShortTimeOut 5000 

    set CorePresent 0
    set SegmentPresent 0


    set fpga 3     ;# core main board
    set cmd 14     ;# safe read command for test
    set Length 6   ;# returns 6 bytes

    set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_SetTimeOut $Digitizer  $ShortTimeOut} m]

    for {set tries 1} {$tries <= 2} {incr tries} {

#    append AuditText "\nprobing for Core Main Board"

    set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Read $Digitizer $fpga $cmd A16 $Length} m]
    if {$rc == 0} {
#        append AuditText "\nfound: Digitizer $Digitizer - Core: Main Board"
        set CorePresent 1
        break
    } else {
        append AuditText "\nError returned Probing for Core Main Board [first [split $m \n]]"
    }
    }

    if {$CorePresent == 1} {

#       append AuditText "\nprobing for Core ADCs"

       set fpga 2    ;# core ADCs
       set address 15
       set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $address A16} m]
       if {$rc == 0} {
#              append AuditText "\nfound: Digitizer $Digitizer - Core: Virtex for core ADCs"
              set Addr 6
              set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $Addr A16} m]
              if {$rc == 0} {
                  append AuditText "\nCore......: Core ADC ......... fmw: [format "0x%x" $m]"
                  set rc [catch {do_readprom $fpga} m] ;# added this for Core ADC data
              } else {
                  append AuditText "\nDigitizer $Digitizer.$fpga: access error: $m"
              }
       } else {
           append AuditText "\nError returned Probing for Core: Core ADC [first [split $m \n]]"
       }

#       append AuditText "\nprobing for Core segment ADC card #1"

       set fpga 0    ;# core segment ADC card #1
       set address 15
       set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $address A16} m]
       if {$rc == 0} {
#              append AuditText "\nfound: Digitizer $Digitizer - Core: Virtex for Segment ADC card 1"
              set Addr 15
              set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $Addr A16} m]
              if {$rc == 0} {
                  append AuditText "\nCore......: Segment ADC_1 fmw: [format "0x%x" $m]"
                  set rc [catch {do_readprom $fpga} m]
              } else {
                  append AuditText "\nDigitizer $Digitizer.$fpga: access error: $m"
              }
       } else {
           append AuditText "\nError returned Probing for Core: Segment ADC_1 [first [split $m \n]]"
       }

#       append AuditText "\nprobing for Core segment ADC card #2"

       set fpga 1    ;# core segment ADC card #2
       set address 15
       set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $address A16} m]
       if {$rc == 0} {
#              append AuditText "\nfound: Digitizer $Digitizer - Core: Virtex for Segment ADC card 2"
              set Addr 15
              set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $Addr A16} m]
              if {$rc == 0} {
                  append AuditText "\nCore......: Segment ADC_2 fmw: [format "0x%x" $m]"
                  set rc [catch {do_readprom $fpga} m]
              } else {
                  append AuditText "\nDigitizer $Digitizer.$fpga: access error: $m"
              }
       } else {
           append AuditText "\nError returned Probing for Core: Segment ADC_2 [first [split $m \n]]"
       }
    }

#    append AuditText "\nprobing for Segment Main Board"

    set fpga 12    ;# segment main board
    set cmd 14     ;# safe read command for test
    set Length 6   ;# returns 6 bytes
    set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_SetTimeOut $Digitizer  $ShortTimeOut} m]
    set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Read $Digitizer $fpga $cmd A16 $Length} m]
    if {$rc == 0} {
#        append AuditText "\nfound: Digitizer $Digitizer - Segment: Main Board"
        set SegmentPresent 1
    } else {
        append AuditText "\nError returned during Probe for Segment Main Board [first [split $m \n]]"
    }

    if {$SegmentPresent == 1} {

#       append AuditText "\nprobing for Segment ADC card #1"

       set fpga 8    ;# Segment ADC card #1
       set address 15
       set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_SetTimeOut $Digitizer  $ShortTimeOut} m]
       set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $address A16} m]
       if {$rc == 0} {
#           append AuditText "\nfound: Digitizer $Digitizer - Segment: Virtex for Segment ADC card 1"
              set Addr 15
              set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $Addr A16} m]
              if {$rc == 0} {
                  append AuditText "\nSegment: Segment ADC_1 fmw: [format "0x%x" $m]"
                  do_readprom $fpga
              } else {
                  append AuditText "\nDigitizer $Digitizer.$fpga: access error"
              }
       } else {
           append AuditText "\nError returned Probing for Segment: Segment ADC_1 [first [split $m \n]]"
       }

#       append AuditText "\nprobing for Segment ADC card #2"

       set fpga 9    ;# Segment ADC card #2
       set address 15
       set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_SetTimeOut $Digitizer  $ShortTimeOut} m]
       set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $address A16} m]
       if {$rc == 0} {
#              append AuditText "\nfound: Digitizer $Digitizer - Segment: Virtex for Segment ADC card 2"
              set Addr 15
              set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $Addr A16} m]
              if {$rc == 0} {
                  append AuditText "\nSegment: Segment ADC_2 fmw: [format "0x%x" $m]"
                  do_readprom $fpga
              } else {
                  append AuditText "\nDigitizer $Digitizer.$fpga: access error"
              }
       } else {
           append AuditText "\nError returned Probing for Segment: Segment ADC_2 [first [split $m \n]]"
       }

#       append AuditText "\nprobing for Segment ADC card #3"

       set fpga 10    ;# Segment ADC card #3
       set address 15
       set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_SetTimeOut $Digitizer  $ShortTimeOut} m]
       set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $address A16} m]
       if {$rc == 0} {
#              append AuditText "\nfound: Digitizer $Digitizer - Segment: Virtex for Segment ADC card 3"
              set Addr 15
              set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $Addr A16} m]
              if {$rc == 0} {
                  append AuditText "\nSegment: Segment ADC_3 fmw: [format "0x%x" $m]"
                  do_readprom $fpga
              } else {
                  append AuditText "\nDigitizer $Digitizer.$fpga: access error"
              }
       } else {
           append AuditText "\nError returned Probing for Segment: Segment ADC_3 [first [split $m \n]]"
       }

#       append AuditText "\nprobing for Segment ADC card #4"

       set fpga 11    ;# Segment ADC card #4
       set address 15
       set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_SetTimeOut $Digitizer  $ShortTimeOut} m]
       set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $address A16} m]
       if {$rc == 0} {
#              append AuditText "\nfound: Digitizer $Digitizer - Segment: Virtex for Segment ADC card 4"
              set Addr 15
              set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $Addr A16} m]
              if {$rc == 0} {
                  append AuditText "\nSegment: Segment ADC_4 fmw: [format "0x%x" $m]"
                  do_readprom $fpga
              } else {
                  append AuditText "\nDigitizer $Digitizer.$fpga: access error"
              }
       } else {
           append AuditText "\nError returned Probing for Segment: Segment ADC_4 [first [split $m \n]]"
       }

   }

   set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_SetTimeOut $Digitizer 0} m]   ;# reset timeout to default

   if {[expr $CorePresent + $SegmentPresent] == 0} {append AuditText "\nDigitizer not found"}

}


proc do_readprom {fpga} {
        variable AuditText

set Prom_control 0x880
set Prom_status 0x881
set Prom_base 0x800


#    append AuditText "\nReading PROM"

# check to see if it has read in correctly 

        set a [ ReadPromRegister $fpga $Prom_status ]
	if { $a != 4 } {
             append AuditText "\nProm has read back unsuccessfully. Status : $a"
             return
        }

	set a [ format "%c" [ ReadPromRegister $fpga 0x800 ] ]
	
	if { $a == "C" } {
		append AuditText " : Core ADC ..... "
	} elseif { $a == "S" } {
		append AuditText " : Segment ADC" 
	} else {
		append AuditText " : Not recognised -> Hex values =>"
                foreach entry { 0x800 0x801 0x802 0x803 0x804 0x805 0x806 0x807 } {
			set val [ ReadPromRegister $fpga $entry ]
			append AuditText " ,$val"
		}
		append AuditText " <----<--- !"
		return
	}
	set a [ ReadPromRegister $fpga 0x801 ]
	set b [ ReadPromRegister $fpga 0x802 ]
	set c [ ReadPromRegister $fpga 0x803 ]
	set d [ ReadPromRegister $fpga 0x804 ]
	set e [ ReadPromRegister $fpga 0x805 ]
	set f [ ReadPromRegister $fpga 0x806 ]
	set g [ ReadPromRegister $fpga 0x807 ]
	set serial [ format "%c%c%c%c" $d $c $b $a ]
	set revision [ format "%c" $e ]
	set mod_state [ format "%c%c" $g $f ]

	append AuditText " : Serial number => $serial"
	append AuditText " : Revision => $revision"
	append AuditText " : Mod state => $mod_state"

}

    proc ReadPromRegister {fpga Addr} {
        variable  Digitizer 
        global errorCode errorInfo
        variable AuditText

        set rc [catch {interp eval "" ::namespace inscope ::urn:AGATADigitizerAccessServer do_Get $Digitizer $fpga $Addr A16} m]
 
        if {$rc != 0} {
            append AuditText "\nReadPromRegister: $Digitizer $fpga $Addr"
            append AuditText "\nReadPromRegister returned with an error\n$m\n$errorCode\n$errorInfo"
            return -1
        } else {
            return $m
        }
   }



   proc  do_click {}  {
       variable cgidata
       variable started
       variable LogText
       variable ShowLogFlag
       variable LogFlag
       variable Digitizer

       set cgidata [ncgi::nvlist]

       if {$LogFlag == 1} {append AuditText "\ncgidata= ([llength $cgidata]) $cgidata"}

       if {[llength $cgidata] == 0} then {return}

       if {[llength $cgidata] < 2} then {
          InsertLog "CGI data is too short: $cgidata"
       } else {
          if {[lindex $cgidata 0] != "Widget"} then {
             InsertLog "Invalid CGI data: $cgidata"
          } else {

           set w [first [lindex $cgidata 1]]
           set vl [second [lindex $cgidata 1]]

            switch -glob $w {

                RESET    {set started 0}
                   CLEAR    {EmptyLog}
                   ELOG     {PrintLog}
                SELECT   {}
                RELOAD   {}
                VARIABLES {show_variables}

                HIDE     {set ShowLogFlag 0}
                SHOW     {set ShowLogFlag 1}
                   LOGON    {set LogFlag 1}
                   LOGOFF   {set LogFlag 0}

                DIGITIZER  {set Digitizer [second [lindex $cgidata 1]]}
                
                AUDIT      {do_auditCURRENT}
                AUDITALL   {do_auditALL}
                AUDITELOG  {do_elog}

                MainLog {}
                undefined {}
                default {InsertLog "unexpected CGI data:  ($w) ($vl) ($cgidata)"}
            }

            
         }
      }
   }   ;# end of do_click

   EnumerateDigitizers

}   ;# end of if {$started == 0} 

