
   proc WriteSPIRegister {n address value} {


# InsertLog "WriteSPIRegister $n, $address, $value"

         set rc [catch {ReadRegister Ch$n.Status} status]
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $status: SPI bus not available; Cannot continue"
           return -1
         }
         if {[expr ($status >> 2) & 1] != 0} {
           InsertLog "Channel $n Status  = $status: SPI bus busy; Cannot continue at present"
           return -1
         }

         set rc [catch {WriteRegister SPIAddressReg address} status]
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $status: SPI register not accessible; Cannot continue"
           return -1
         }

         set rc [catch {WriteRegister Ch$n.SPIDataReg value} status]
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $status: SPI register not accessible; Cannot continue"
           return -1
         }

        return 0
   }

   proc ReadSPIRegister {n address} {

# InsertLog "ReadSPIRegister $n, $address"

         set rc [catch {ReadRegister Ch$n.Status} status]
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $status: SPI bus not available; Cannot continue"
           return -1
         }
         if {[expr ($status >> 2) & 1] != 0} {
           InsertLog "Channel $n Status  = $status: SPI bus busy; Cannot continue at present"
           return -1
         }

         set rc [catch {WriteRegister SPIAddressReg address} status]
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $status: SPI register not accessible; Cannot continue"
           return -1
         }

         set rc [catch {ReadRegister Ch$n.SPIDataReg} value]
         if {$rc != 0} {
           InsertLog "Channel $n Data  = $value: SPI register not accessible; Cannot continue"
           return -1
         }

# InsertLog "> $value"

        return $value
   }



    proc do_TempCalibration {} {
       global NumChans

       set errflag 0

       InsertLog "Performing lock temperature compensation function"

       for {set n 0} {$n < $NumChans} {incr n} {

         set rc [catch {WriteSPIRegister $n 0x7a 0x59} status]
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $status: SPI bus error"
           incr errflag
         }

         set rc [catch {WriteSPIRegister $n 0x7a 0x1a} status]
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $status: SPI bus error"
           incr errflag
         }

         set rc [catch {WriteSPIRegister $n 0x7a 0x11} status]
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $status: SPI bus error"
           incr errflag
         }

         set rc [catch {WriteSPIRegister $n 0x7a 0xac} status]
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $status: SPI bus error"
           incr errflag
         }

         set rc [catch {ReadSPIRegister $n 0xa7} lock]   ;#  read lock value
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $lock: SPI bus error"
           incr errflag
         }

         set rc [catch {WriteSPIRegister $n 0xa5 $lock} status]
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $status: SPI bus error"
           incr errflag
         }

         set rc [catch {ReadSPIRegister $n 0xa4} ctrl]   ;#  enable lock 
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $ctrl: SPI bus error"
           incr errflag
         }

         set ctrl [expr $ctrl | 0x4]   ;#  set bit 2

         set rc [catch {WriteSPIRegister $n 0xa4 $ctrl} status]
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $status: SPI bus error"
           incr errflag
         }

         set rc [catch {ReadSPIRegister $n 0xa4} ctrl]
         if {$rc != 0} {
           InsertLog "Channel $n Status  = $ctrl: SPI bus error"
           incr errflag
         }

       }
         
       if {$errflag == 0} {InsertLog "completed without error"; return}

    }
 


