

# variable started 0

if {![info exists started]} {variable started 0}

if {$started != 0} {

     variable JS ""
     variable LogFlag

     if {$LogFlag == 1} {InsertLog "Last Updated: [clock format [clock seconds] -format "%B %d, %Y %H:%M:%S"]"}

    do_click
    UpdateModule
}

if {$started == 0} {           ;#  first time load code and define local variables
    set started 1

    variable LogText ""
    variable LogFlag 0
    variable LogCount 0
    variable DebugFlag 0

    variable ShowLogFlag 0

    variable JS ""

    variable allmodules 0
    variable allchannels 0

    variable ModuleName v1725psd
    variable ModuleMenu {}
    variable ModuleAddress {}
    variable ModuleIndex 1

    variable SoftTrigRun 0
    variable SliderDelay 3000

    variable NumChans 16
    variable FamilyCode -1
    variable Name V1725PSD

   set z [catch {ReadRegister BoardInfo} BoardInfo]
   if {$z == 0 && [string range $BoardInfo 6 end] != "dead"} {
       set FamilyCode [expr $BoardInfo & 0xff]
       set NumChans [expr ($BoardInfo >> 16) & 0xff]
   }


#    for the Register Menus each item is a list
#      0) name for menu
#      1) register
#      2) file containing support implementation
#      3) Display procedure  (null if none)
#      4) parameter update procedure   (null if none)
#      5) parameter save procedure (null if none)
#      6) parameter restore procedure (null if none)

    variable ModuleRegMenu { \
       {"Configuration (0x8000)"               Config        Config.tml        GetConfig DrawConfig null null} \
       {"Buffer Organisation (0x800c)"         BufferOrg     BuffOrg.tml       GetBuffOrg DrawBuffOrg null null} \
       {"Acquisition Window (0x8020)"          CustomSize    CustSize.tml      GetCustSize DrawCustSize null null} \
       {"Start/Stop Run Delay (0x8170)"        RunDelay      RunDelay.tml      GetRunDelay DrawRunDelay null null} \
       {"Channel Enable Mask (0x8120)"         Enable        ChEnable.tml      GetChEnable DrawChEnable null null} \
       {"Trigger Source Enable (0x810c)"       TrigSrcEnable TrigSrcEnable.tml GetTrigSrcEnable DrawTrigSrcEnable null null} \
       {"FP Trigger Out Enable (0x8110)"       FPTrigOutEnable  FPTrigEnable.tml  GetFPTrigEnable DrawFPTrigEnable null null} \
       {"FP I/O Control (0x811c)"              FPIOControl   FPIOCtrl.tml      GetFPIO DrawFPIO null null} \
       {"Acquisition Control (0x8100)"         AcqControl    AcqCtrl.tml       GetAcqCtrl DrawAcqCtrl null null} \
       {"Acquisition Status (0x8104)"          AcqStatus     AcqStatus.tml     GetAcqStatus DrawAcqStatus null null} \
       {"VME Control (0xef00)"                 VMECtrl       VMECtrl.tml       GetVMECtrl DrawVMECtrl null null} \
       {"VME Status (0xef04)"                  VMEStatus     VMEStatus.tml     GetVMEStatus DrawVMEStatus null null} \
       {"System Options"                      SystemOpts    SystemOpts.tml    GetSystemOpts DrawSystemOpts null null} \
    }

    variable ChRegMenu { \
       {"Algorithm Control (0x1n80)"   AlgorithmControl AlgorithmControl.tml GetAlgorithmControl DrawAlgorithmControl \
                                    SaveAlgorithmControl RestAlgorithmControl} \
       {"BaseLine (0x1n64)"           BaseLine BaseLine.tml GetBaseLine DrawBaseLine SaveBaseLine RestBaseLine} \
       {"BaseLine Freeze (0x1nd8)"           BaseLineFreeze BaseLineFreeze.tml GetBaseLineFreeze DrawBaseLineFreeze SaveBaseLineFreeze  RestBaseLineFreeze} \
       {"DC Offset (0x1n98)"             DCOffset  DCOffset.tml GetDCOffset DrawDCOffset SaveDCOffset RestDCOffset} \
       {"CFD Params (0x1n3c)"    CFDParams  CFDParams.tml   GetCFDParams DrawCFDParams SaveCFDParams RestCFDParams} \
       {"Dynamic Range (0x1n28)"   DynRnge  DynRnge.tml GetDynRnge DrawDynRnge SaveDynRnge RestDynRnge} \
       {"Events Per Buffer (0x1n34)"     EvtsPerBuf  EvtsPerBuf.tml GetEvtsPerBuf DrawEvtsPerBuf SaveEvtsPerBuf RestEvtsPerBuf} \
       {"Record Length (0x1n20)"          RecLen    RecLen.tml      GetRecLen DrawRecLen SaveRecLen RestRecLen} \
       {"Local Trigger (0x1n84)"  LocalTrigger LocalTrigger.tml GetLocalTrigger DrawLocalTrigger SaveLocalTrigger RestLocalTrigger} \
       {"Long Gate (0x1n58)"             LongGate  LongGate.tml   GetLongGate DrawLongGate SaveLongGate RestLongGate} \
       {"Pre Gate (0x1n5c)"              PreGate  PreGate.tml   GetPreGate DrawPreGate SavePreGate RestPreGate} \
       {"Trig Val Mask (0x81nm)"         TrigValMask  TrigValMask.tml   GetTrigValMask DrawTrigValMask SaveTrigValMask RestTrigValMask} \
       {"Pre Trigger Window (0x1n38)"    PreTrig  PreTrig.tml   GetPreTrig DrawPreTrig SavePreTrig RestPreTrig} \
       {"Short Gate (0x1n54)"            ShortGate ShortGate.tml  GetShortGate DrawShortGate SaveShortGate RestShortGate} \
       {"PSD Threshold (0x1n78)"     PSDThreshold PSDThreshold.tml GetPSDThreshold DrawPSDThreshold SavePSDThreshold RestPSDThreshold} \
       {"PUR-GAP Threshold (0x1n7c)"     PUR-GAPThreshold PUR-GAPThreshold.tml GetPUR-GAPThreshold DrawPUR-GAPThreshold SavePUR-GAPThreshold RestPUR-GAPThreshold} \
       {"Trigger Threshold (0x1n60)"     TrigThreshold TrigThreshold.tml GetThreshold DrawThreshold SaveThreshold RestThreshold} \
       {"Trigger Width (0x1n70)"     TrigWidth TrigWidth.tml GetTrigWidth DrawTrigWidth SaveTrigWidth RestTrigWidth} \
       {"Trigger Hold-Off (0x1n74)"     TrigHoldOff TrigHoldOff.tml GetTrigHoldOff DrawTrigHoldOff SaveTrigHoldOff RestTrigHoldOff} \
       {"Veto Width (0x1nd4)"          VetoWidth VetoWidth.tml GetVetoWidth DrawVetoWidth SaveVetoWidth RestVetoWidth} \
       {"Zero Threshold (0x1n44)"          ZeroThreshold ZeroThreshold.tml GetZeroThreshold DrawZeroThreshold SaveZeroThreshold RestZeroThreshold} \
   }

#   registers for Save/Restore not handled by above (module registers)
    variable SaveRestoreMenu {Enable Config BufferOrg TrigSrcEnable FPTrigOutEnable FPIOControl \
                 AcqControl RecLen EvtsPerBuf BLTEventNum}


    variable ModuleRegItem [lindex $ModuleRegMenu 0]
    variable ModuleReg [lindex $ModuleRegItem 0]

    variable ChRegItem [lindex $ChRegMenu 0]
    variable ChReg [lindex $ChRegItem 0]


#    source all implementation files to load implementation code
  foreach item $ModuleRegMenu  {
     set z [catch {source [file join V1725PSD [lindex $item 2]]} m]
     if {$z != 0} {puts "$m"; continue}
     set updateproc [lindex $item 3]
     if {$updateproc != "null"} {eval $updateproc}
  }

  foreach item $ChRegMenu  {
     set z [catch {source [file join V1725PSD [lindex $item 2]]} m]
     if {$z != 0} {puts "$m"; continue}
     set updateproc [lindex $item 3]
     if {$updateproc != "null"} {eval $updateproc}
  }

   proc show_variables {} {
        variable allchannels
        variable allmodules
        variable LogFlag
        variable DebugFlag
        variable ShowLogFlag
        variable ModuleRegItem
        variable ChRegItem
        variable Rmsg
        variable Wmsg
        variable NumChans

             InsertLog "LogFlag=$LogFlag; ShowLogFlag=$ShowLogFlag; DebugFlag=$DebugFlag "
             InsertLog "allchannels=$allchannels; allmodules=$allmodules"
             InsertLog "ModuleReg=$ModuleRegItem"
             InsertLog "ChannelReg=$ChRegItem"
             InsertLog "Rmsg=$Rmsg"
             InsertLog "Wmsg=$Wmsg"
             InsertLog "NumChans=$NumChans"
   }

   proc do_Select {i} {    ;# select module
        variable ModuleIndex

         set ModuleIndex $i
         UpdateModule
   }

   proc UpdateModule {} {

       do_UpdateModuleRegisters
       do_UpdateChannelRegisters
   }

   proc UpdateChannel {} {

       do_UpdateChannelRegisters
   }

   proc do_UpdateModuleRegisters {} {
        variable ModuleRegMenu

        foreach item $ModuleRegMenu  {
            set updateproc [lindex $item 3]
            if {$updateproc != "null"} {eval $updateproc}
        }
   }

   proc do_UpdateChannelRegisters {} {
       variable ChRegMenu
       foreach item $ChRegMenu  {
           set updateproc [lindex $item 3]
           if {$updateproc != "null"} {eval $updateproc}
       }
   }

   proc do_SelectModuleRegister {w} {
        variable ModuleReg
        variable ModuleRegItem
        variable ModuleRegMenu

      foreach item $ModuleRegMenu  {
         set name [lindex $item 0]
         if {"$w" == "$name"} {
             set ModuleRegItem $item
             set ModuleReg [lindex $item 1]
         }
      }
   }

   proc do_SelectChannelRegister {w} {
        variable ChReg
        variable ChRegItem
        variable ChRegMenu

      foreach item $ChRegMenu  {
         set name [lindex $item 0]
         if {"$w" == "$name"} {
             set ChRegItem $item
             set ChReg [lindex $item 1]
         }
      }
   }

    proc do_SetModuleRegister {w v} {
        variable ModuleIndex
        variable ModuleMenu
        variable DebugFlag
        variable allmodules
        variable $w

        if {$DebugFlag == 1} {InsertLog "do_SetModuleRegister: $w = $v"}

       if {[do_IsAcqIdle] == 0} {do_AcqPause}

       set SAV $ModuleIndex

        foreach ModuleIndex $ModuleMenu  {

          if {$allmodules == 0 && $ModuleIndex != $SAV} {continue}

        switch -glob $w {
            Config.*        {set $w $v; SetConfig}
            BuffOrg         {set $w $v; SetBuffOrg}
            ChEnableMask*   {set $w $v; SetChEnable}
            FPTrigEnable*   {set $w $v; SetFPTrigEnable}
            TrigSrcEnable*  {set $w $v; SetTrigSrcEnable}
            FPIO*           {set $w $v; SetFPIO}
            RecLen -
            CustSize        {set $w $v; SetCustSize}
            PostTrig        {set $w $v; SetPostTrig}
            RunDelay        {set $w $v; SetRunDelay}

            ReConfig        {WriteRegister ConfigReload 0; after 1000}
            Reset           {WriteRegister Reset 0; after 1000}

            AcqControl  -
            Clear -
            ZeroThreshold -
            DataFlush -
            ADCSync -
            EvtsPerBuf -
            BLTEventNum -
            BufferOrg -
            SoftTrig        {WriteRegister $w $v}

            AcqCtrl*        {set $w $v; SetAcqCtrl}
            AcqStatus*      {}
            VMECtrl*        {set $w $v; SetVMECtrl}
            VMEStatus*      {}

            default {set $w $v}
        }
       }

       set ModuleIndex $SAV

       do_AcqResume
   }

    proc do_SetChannelRegister {w i vl} {
        variable ModuleIndex
        variable ModuleMenu
        variable NumChans
        variable allchannels
        variable allmodules
        variable DebugFlag

        if {$DebugFlag == 1} {InsertLog "do_SetChannelRegister: Ch$i.$w = $vl"}

       if {[do_IsAcqIdle] == 0} {do_AcqPause}

        set SAV $ModuleIndex

        foreach ModuleIndex $ModuleMenu  {

          if {$allmodules == 0 && $ModuleIndex != $SAV} {continue}

        for {set j 0} {$j < $NumChans} {incr j} {
           if {$allchannels == 0 && $j != $i} {continue}
           variable Ch$j.$w; set Ch$j.$w $vl
        }

        switch -glob $w {
            TrigValMask* {
                for {set j 0} {$j < $NumChans} {incr j} {
                    if {$allchannels == 0 && $j != $i} {continue}
                    SetTrigValMask $j
#variable Ch$j.TrigValMask
#InsertLog "SetTrigValMask Ch$j [format %08x [set Ch$j.TrigValMask]]"
                }
            }
            AlgorithmControl* {
                for {set j 0} {$j < $NumChans} {incr j} {
                    if {$allchannels == 0 && $j != $i} {continue}
                    SetAlgorithmControl $j
#variable Ch$j.AlgorithmControl
#InsertLog "SetAlgorithmControl Ch$j [format %08x [set Ch$j.AlgorithmControl]]"
                }
            }
            LocalTrigger* {
                for {set j 0} {$j < $NumChans} {incr j} {
                    if {$allchannels == 0 && $j != $i} {continue}
                    SetLocalTrigger $j
#variable Ch$j.LocalTrigger
#InsertLog "SetLocalTrigger Ch$j [format %08x [set Ch$j.LocalTrigger]]"
                }
            }
            VetoWidth* {
                for {set j 0} {$j < $NumChans} {incr j} {
                    if {$allchannels == 0 && $j != $i} {continue}
                    SetVetoWidth Ch$j $w $vl
variable Ch$j.VetoWidth
variable Ch$j.VetoWidthB0015
variable Ch$j.VetoWidthB1617
InsertLog "SetVetoWidth [set Ch$j.VetoWidth] [set Ch$j.VetoWidthB0015] [set Ch$j.VetoWidthB1617]"
                }
            }

            ExtTriggerMode -
            BaseLine -
            CFD_Delay -
            CFD_Fraction -
            Charge -
            CoincMode -
            Polarity -    
            SelfTrig -
            Extras -
            BaseLineMean {
                for {set j 0} {$j < $NumChans} {incr j} {
                    if {$allchannels == 0 && $j != $i} {continue}
                    WriteRegister Ch$j.$w $vl
                }
            }

            ZeroThreshold -
            PUR-GAPThreshold -
            PSDThreshold -
            BaseLineFreeze -
            RecLen -
            DCOffset -
            TrigWidth -
            PreTrig {
                for {set j 0} {$j < $NumChans} {incr j} {
                    if {$allchannels == 0 && $j != $i} {continue}
                    Set$w $j
                }
            }
            default {if {$allchannels == 0} {WriteRegister Ch$i.$w $vl} else {WriteRegister $w $vl}}
       }

       }

      do_AcqResume

       set ModuleIndex $SAV
   }

   proc do_SoftTrig {n} {
      variable SoftTrigRun

      switch $n {
        1   {WriteRegister SoftTrig 1}
        100   {set SoftTrigRun 1; after 100 ::V1725PSD::do_SoftTrig 99}
        99999 {puts "V1725PSD starting SoftTrig run"; set SoftTrigRun 1; after 100 ::V1725PSD::do_SoftTrig 99998}
        99998 {if {$::V1725PSD::SoftTrigRun ==0} return; do_WriteSoftTrig; after 100 ::V1725PSD::do_SoftTrig 99998}
        default  {if {$::V1725PSD::SoftTrigRun ==0} return; WriteRegister SoftTrig 1; if {$n > 0} {after 100 ::V1725PSD::do_SoftTrig [expr $n-1]}}
      }
   }

   proc do_WriteSoftTrig {} {
      global errorCode errorInfo
      variable Wmsg

       set r [set ::V1725PSD::ModuleName]#[set ::V1725PSD::ModuleIndex].SoftTrig
       set z [catch {::namespace inscope ::urn:VMEAccessServer WriteRegister $r 1} Wmsg]
       if {$z != 0} {
           InsertLog "WriteRegister $r failed: Code= $errorCode; Info= [first [split $errorInfo \n]]"
       }
   }

     proc do_click {} {
       variable cgidata
       variable started
       variable LogFlag
       variable DebugFlag
       variable ShowLogFlag
       variable ModuleIndex

       set cgidata [ncgi::nvlist]

       if {$LogFlag == 1} {InsertLog "cgidata= ([llength $cgidata]) $cgidata"}

       if {[llength $cgidata] == 0} then {return}

       if {[llength $cgidata] < 2} then {
           InsertLog "CGI data is too short: $cgidata"
       } else {
           if {[lindex $cgidata 0] != "Widget"} then {
               InsertLog "Invalid CGI data: $cgidata"
           } else {
               set w [lindex $cgidata 1]

               switch -glob [lindex $w 0] {

                   RESET    {set started 0}
                   CLEAR    {EmptyLog}
                   ELOG     {PrintLog}
                   RELOAD   {UpdateModule}
                   VARIABLES {show_variables}

                   HIDE     {set ShowLogFlag 0}
                   SHOW     {set ShowLogFlag 1}
                   LOGON    {set LogFlag 1}
                   LOGOFF   {set LogFlag 0}
                   DEBUGON    {set DebugFlag 1}
                   DEBUGOFF   {set DebugFlag 0}

                   ALLCHANS   {variable allchannels; set allchannels [expr ($allchannels + 1) & 1]}
                   ALLMODULES {variable allmodules; set allmodules [expr ($allmodules + 1) & 1]}

                   MODULE   {do_Select [lindex $w 1]}

                   MREGISTER      {do_SelectModuleRegister [string range $w 10 end]}
                   MREGISTERHELP  {do_RegisterHelp Module}

                   EXPERT {
                      switch [lindex $w 1] {
                        Help      {do_ExpertHelp}
                        FirmwareUpdate {Alert "Start firmware update from VME Control page"}
                        Reset -
                        Clear -
                        ADCSync -
                        DataFlush -
                        ReConfig  {do_SetModuleRegister [lindex $w 1] 0}
                        SoftTrig  {do_SoftTrig [lindex $w 2]}
                        AcqStart  {source [file join V1725PSD AcqStart.tcl]}
                        AcqHalt   {source [file join V1725PSD AcqHalt.tcl]}
                        DataFIFO    {ReadDataFIFO}
                        ROM       {Show_ROM}
                        Scratch     {WriteRegister Scratch 12345}
                        EnableTestMode   {SetTestMode 1}
                        EnableNormalMode {SetTestMode 0}
                        default   {}
                      }
                   }
                   EXPERTHELP    {do_ExpertHelp}

                   CHREGISTER      {do_SelectChannelRegister [string range $w 11 end]}
                   CHREGISTERHELP  {do_RegisterHelp Ch}

                   MSETTING      {do_SetModuleRegister [lindex $w 1] [lindex $w 2]}
                   MSETTINGS     {do_SetModuleRegister [lindex $cgidata 4] [lindex $cgidata 5]}
 
                   CHSETTING     {do_SetChannelRegister [lindex $w 1] [lindex $w 2] [lindex $w 3]}

                   SAVEALL      {do_SaveAll}
                   RESTALL      {do_RestoreAll}
                   SAVE         {do_Save $ModuleIndex}
                   RESTORE      {do_Restore $ModuleIndex}

                   CORRELATION  {do_Correlation}
                   CALIBRATION  {do_Calibration}                   
                   PAUSE        {do_AcqPause}
                   RESUME       {do_AcqResume}

                   REDISPLAY  {} 

                   MainLog {}
                   undefined {}
                   default {InsertLog "unexpected CGI data: [lindex $w 0]: $cgidata"}
               }
           }
       }
       UpdateModule
    }

}   ;# end of if {$started == 0}


     if {$LogFlag == 1} {InsertLog "Started: [clock format [clock seconds] -format "%B %d, %Y %H:%M:%S"]"}

